PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for category
-- ----------------------------
DROP TABLE IF EXISTS "category";
CREATE TABLE "category" (
"id_category"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"category"  varchar(255)
)

;

-- ----------------------------
-- Records of category
-- ----------------------------

INSERT INTO "category" VALUES (2, 'MANUFACTORY');
INSERT INTO "category" VALUES (3, 'COMPUTER');


-- ----------------------------
-- Table structure for loss
-- ----------------------------
DROP TABLE IF EXISTS "loss";
CREATE TABLE "loss" (
"id_loss"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"dateloss"  datetime,
"id_status"  integer NOT NULL,
"total"  double,
FOREIGN KEY ("id_status") REFERENCES "status" ("id_status")
)

;

-- ----------------------------
-- Records of loss
-- ----------------------------



-- ----------------------------
-- Table structure for loss_detail
-- ----------------------------
DROP TABLE IF EXISTS "loss_detail";
CREATE TABLE "loss_detail" (
"id_loss_detail"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"id_loss"  integer,
"unit_cost"  double,
"id_product"  integer,
"quantity"  integer,
FOREIGN KEY ("id_product") REFERENCES "product" ("id_product"),
FOREIGN KEY ("id_loss") REFERENCES "loss" ("id_loss")
)

;

-- ----------------------------
-- Records of loss_detail
-- ----------------------------



-- ----------------------------
-- Table structure for product
-- ----------------------------
DROP TABLE IF EXISTS "product";
CREATE TABLE "product" (
"id_product"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"product_name"  varchar(50),
"product_code"  varchar(50),
"id_status"  integer,
"dateproduct"  datetime,
"product_value"  double,
"product_cost"  double,
"discount"  double DEFAULT 0.00,
"stock"  integer,
"id_category"  integer,
"image"  blob,
FOREIGN KEY ("id_category") REFERENCES "category" ("id_category"),
FOREIGN KEY ("id_status") REFERENCES "status" ("id_status")
)

;

-- ----------------------------
-- Records of product
-- ----------------------------

INSERT INTO "product" VALUES (1, 'S-EXECUTIVE', 'A00001', 1, '2019-09-19 12:01:42', 125.0, 90.0, 0.0, 110, 2, X'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');
INSERT INTO "product" VALUES (2, 'NOTEBOOK HP', 'A00002', 1, '2019-09-19 14:29:25', 950.0, 800.0, 0.0, 51, 3, X'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');
INSERT INTO "product" VALUES (3, 'TABLET', 'A00003', 1, '2019-09-19 14:35:09', 550.0, 425.0, 0.0, 8, 3, X'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');
INSERT INTO "product" VALUES (4, 'EXTERNAL HD', 'A00004', 1, '2019-09-19 14:36:10', 125.0, 75.0, 0.0, 47, 3, X'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');
INSERT INTO "product" VALUES (5, 'PRINTER', 'A00005', 1, '2019-09-19 14:36:37', 125.0, 75.0, 0.0, 183, 3, X'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');
INSERT INTO "product" VALUES (6, 'MULTIFUNCTION', 'A00006', 1, '2019-09-19 14:37:11', 285.0, 200.0, 0.0, 96, 3, X'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');
INSERT INTO "product" VALUES (7, 'CAMERA', 'A00007', 1, '2019-09-19 14:37:28', 205.0, 165.0, 0.0, 98, 3, X'89504E470D0A1A0A0000000D494844520000012C0000012C0806000000797D8E75000020004944415478DAECBD799C645975DFF9BDF7BE25F6C8BD32ABAA6BAF067A835E28F64D80D06A332D2483CC085BB6254B428B65211B7BBCC88C3F88913C32F2C80BF64896C4080B247623400D74D3FBBE557775D75E595559B92FB1BC78CB7DF7CE1FF74556554B9E010B544AEA7D3F9FFE6456766446E68B885F9C73EEEF9C23ACB5949494946C05E495FE054A4A4A4ABE514AC12A2929D9329482555252B2652805ABA4A464CB500A564949C996A114AC9292922D4329582525255B8652B04A4A4AB60CA5609594946C194AC12A2929D9329482555252B2652805ABA4A464CB500A564949C996A114AC9292922D4329582525255B8652B04A4A4AB60CA5609594946C194AC12A2929D9329482555252B2652805ABA4A464CB500A564949C996A114AC9292922D4329582525255B8652B04A4A4AB60CA5609594946C194AC12A2929D9329482555252B2652805ABA4A464CB500A564949C996A114AC9292922D4329582525255B8652B04A4A4AB60CA5609594946C194AC12A2929D9329482555252B2652805ABA4A464CB500A564949C996A114AC9292922D4329582525255B8652B04A4A4AB60CA5609594946C194AC12A2929D9329482555252B2652805ABA4A464CB500A564949C996A114AC9292922D4329582525255B8652B04A4A4AB60CA5609594946C194AC12A2929D9329482555252B2652805ABA4A464CB500A564949C996A114AC9292922D4329582525255B8652B04A4A4AB60CDE377A4321C495FE5D4B4A4ABE03B1D67EC3B72D23AC9292922D4329582525255B8652B04A4A4AB60CA5609594946C194AC12A2929D9329482555252B265F8866D0D25DF79FCDEC73F1DACAFAF357ABD7E9069E38D8E8D6E0F7D6F67A7DBAD757BBDA0DD6A4FF47A7D96579662CFF31AD7CCCCDC2C3CE5CDCD2F1C5E5D5D5BAAD76BC1BE3D7BBC4CA79DB5F54E67FFEEDDB2DBEF9F3B3D7BE674144591529ED93639693C4FC5596EE25FF9E55FD057FA6F2ED9DA886FD40351FAB0BE73F88FBFF7DF6AFD7EFF965AB5FAFAB5F5B5B70E06F1BE3CD78D6EB737164503F23C47007112230528A9C88DA1DBEF93EB9C7AAD865212AD3599761AE42989540ADFF309C2B087605508D11B69B5D77DDF7FCAC0F3AD66F3DCFAFADA69A554A7D56AAFFABED7FB473FFBF7E32B7D3D4AAE2CDF8C0FAB14ACAB8CDFFED81F4F6F74BB3F7BFEFCF97F12F523E224C1981C29243ACB30D6E0290FAD35168B00B22C036B914A211164B9C65A8B310663728410E4798EB52080344B31D6E22B8F4C6B9452789E879492B012D26AB54F562A95876AD5EAF1B1D191B383383E6D0CE76AB5EADC3FFEF99F5ABFD2D7A8E42F9752B04AFE5CFEE8F35FBEE1B963473F74F6FCF9EF8BFB039494789E87C90D3AD778BE22CD7224906B4D9A65784A21A540EB1C630DD680257F8160A9E2F921004B9E6BAC3548E581056334796ED13A23CB32AC3580402A85928A46B3C1487BE48956BBFD4814F59FA9566BCF1D3870E070AFD75D7CFFCFFF747AA5AF5BC9B79752B04AFE0C5FB9F7C11BCECF2DFCCE838F3C7CDBC6DA1AD5B04A9EE74829C94D8ED6194248A49480C558B0C60016A1246992E22B0F9D1B749E628DC018274C5A1BA490E4D6455E81E7612D6893238520CB3294F25112104ED4B4CEC9B52637396992A2738D94925ABD41B55A5D9D9C987CA856AF3D3B88E3470FEEDF7FC7FBDEFB938B57FA1A967C7B2805ABE432FEE4CEBB5B274F9DF94F67CE9C7B67AD5EA5DBE9208440488940E0790A6B412A89A714DAE4E8CC20252825B1D6BADB5A8A28CBFD5BEB8C2C4949B28C2CD3589393651926CFC98DC1E4962C8B4992983C3718639052628CD97C920A218A88CB3D71FBFD3E79E6BEDFF73D1ACD5667FFFEFD77ECDBBFF7D7DEF7333FF9C095BE9625DF7A4AC12AB98C5FFDF06FFDB5FBEEBBFFF72F5CB8D07AD39BDFCCC4D41426D3D4EA7584141863D199A6D7EF11F83E20C97486E77B5482803CCFA9D5EAE4B92BB00741008001A4B0C4B1CBDA8410189DA3F38C34D50804691A338822A24144140D880711C6E40C0603E23826D7069D6728E961B1E45A2385C2D89C344DC9528DCE3593DBA69E7ACDAB5FF5FE7FF1CBBFF8852B7D3D4BBEB57C338255DA1AAE02BEF295AFEE3975E264ABDFEBB2B6BACAF4F61D64B9214953FABD2EDD4E97C1202637967ABD4EAD56210C4324104503363A1D96169FC1F77DAAD51A4280B1161054429F6AAD86148230AC80B578BE22AC86789E4753D411628230AC308863A27E84B586A8DF238A22F23CA7DBEDD0EDF6E8AC6F607203C2899F548A2094880C2ECCCDDD74CFDDF7FE877FFFBB1F7DDF4FBFE7DD1FBFD2D7B4E4CA500AD65540BD5A5D4D9224EEF5FB1557630A589A9FE7F0338709BC80DDBB773133BD8D6B0F1CC060097C8F76B38535867E1C33BFB844B7D725CF7206718C2E6A5F6992906B4D580931C6E279EE74B11206186BB1D6A2A4626C6CCCA59D8014827ABD4658AD83F2A98601DBA667C8B2149D6AA24144A7B341A7D3A1B3B1413C88F194240802161616767DEA939FFAB5CF7CE92B959B5FF6B28FEEDA366EAEF4B52DF9CBA514ACAB80B7BEF5ADCFCE2F2C9C3C3F77F63A29155996717676966D9353BCE8452FA152ADB07FCF2E5E79CBCD2CADAD2284A05DAFE1073E58E847036E7BD94DA4694A9C26E85423A4A4DF8F48D3847E34204E13A2C100AD73A24184CE34DD5E8F4C67ACACAE62724DA60D5A67787EC0AE9D3B989A18A71F0D88E218AD337C3FA0D16A333E3E41A653BABD3E7996D1EB75595E5E0204479F3DBAEB8F3EF1C90FEFDDBB77E799B9C55FDFBD7DAA3C45BC8A2805EB2A60CFEEDD4FDD70FD758F3DFCF043D729A5E87437D8585DE1BB7EE81D6C9B9EE1E4E95360410A10583CA5105252094302CFA356ADD0ACD7904A62014F3A1B436E5CFA96A629B975753063727ABD3E599E33885332AD89A23ED6187AD1805EAF4F14C5ECDDBB8B5D3333F4FA3DCE2F2EB1BEBEC1C64697F9E565FAFD3EDB676618191DA3D7EDD168B76934DB5C387F1EACE1FEFBEF1FF9F29FDEF14FFFFA0FFE60FDB1C3CF7FE0961B5E549A4FAF124AC1BA0AF8FEB7BE51FFF42FBEEFEEA96DDB6E37D6D6B2340340679A7E14A1942B786FF4BA747B7DEA950A4971626803EBC428CF51D60216A3404801164010783E088108422C30DA1AC1D8DCFD5C635DCDCB1857543739799EE32B9F200CB0D6B267D74EB254238464100FF89D8FFD373EFFB9CFB267CF1E262627A9D5EBF8BEC7FE03D7120D2266CFCCF2B18F7DACB667CF9E5F3AB87FFFD8BD8F3CF1FED7DCF6B2D2707A1550363F5F25ECDDBBEFCEBD7BF63CA78440672920C8B4264912B23445494992A6AC75BAF4E398419C120D06F4A388388E31D622A4402A0F2B0408E9AC0E4238B11202210AEBA873976272E7EFD2798ECEB52BA85B10AEAA0E58A41054C20AAD6683B1D1367B77EFE4969B6F6672DB340B17E638F6DC73ACADAC50A954D97FF02093935308E0F9679FE53FFCC7FF189C9E9DFD093F08FEDD57EE7960EC4A5FE3926F3FA5605D25BCEF677FEAE8EB5FFFC6DF6DB65BBD5EAF4750A9E087C1A6374A1B83D6DA590F9284DC38377B96E798DC19409552F89E47E07B844140E0FB84614025AC10863E7E10108421BEEF130421CAF3082A219EA70882002F0808FC00DFF7F13C85107253EC8CB568AD49920CDFF379D52B5FC93B7FF4DDBCF8FAEB585E5EC6F33C66CF9C6675798591D1116AB52A77DFF5353EF2918FC885A5D5772BCFFBE017EFBAA775A5AF73C9B7973225BC8A181D1FFB08881F5A985F78BD1FF828E51EFE2008C873C3204EE8F7FB00482989E3146B0D9EE7916619522AEAF52A81E7532984484985940A4FB9684B4A09029404CF4A9002537CDD5AEB6E932B642154CE1CE16A6708819402010CE2982CCB68B7DAE4794E9A66F47A3D7ADD1EEDE6285A5B9AD6F2B5AFDE41B556E387DEF18E1F1F1B6D2FDFF3D0631F7CEDA15B7A57FA5A977C7B2805EB2AE2E0FE8395D5F5352FEA479BE95B9A5DECEFAB842163632354C39046BD419E6B74663159C6C2F21AD1604010FA049E33942ADF430A89AF1461E0A19487A73CA412AE0751B85E45A99CA04929F03DF7945352B953482131D6608C0591638D134B21045A67E4B9AB7921A056ABD38BFA546A354646DB985C6372CB673EFD29EAF586F7033FF083BF1C8C78FAC1C79FFEC02B6EBEB11C65F31D48295857114992EE4C92644C2949AD56C3F37D92A88F948A95B535A6C6C6D836314E250C1969B5083C771A98649A7ABD06C6E0793E3AD7E4D692EB1CA0101BC8724D9EBBD4524A41961BA4C015ECA52A222F174F35EB75DACD064A293731C25AA400CFF38893049D69D234450841AD5E2F6C0F1E08C3FAFA0A3BB6EF246B3A277C25A8F0C5FFFE79AAB5BA77E8D0CB7FEEE09E5D171E7EF2F0475EFED21B4A9FD67718A5605D4568AD2B719278B9B1F87E80520A81A556AB72667696381A70E30DD7B1DAE9B1D1ED33D66E13042E8A928570341B75272E58B2DC520D42B22CC30F8B513242A17327646996911B439A26180B699281B0AE6D4748ACC5A57B9926CF354240D28DE80F06482930C650A956A9D7EB00349B2DEAB53A2BCBCBACAEAE3132325238F40DEBEB1BFCC9E73E43AD561BC18A0F1ED8B3B3077CF44A5FF3926F2DA5605D4524695C092B154F62DD499EB02014D55A8DA585058E1D3D0AD279ADAA61C8E8C82823ED26AD469D5467F4C384CC583755210C104290E6190610DA2085C2F33DFC220DAC61C88DC5E41A6B2C12095292A4095208FCC0FD8C3008C97486C09D34366A557CDFC3F7038C4DC8B28C7EAF47B3D9A45E6BB0C41251D4A5520999981847EB0C63EA2CCCCF73EFD7EFA4D56E8FA43AFDE0DD0F3DB6FABA43B794BD87DF4194827515D16A8FD4D2B5352FCD5282C02708ABF84946ADD1C0538AA79F7A9A8585455AED168D7A8D46B3C5F4CC34D3535344FD3E9D6E97A9A94902CF676CA44DBD5A472868341A34EA0DAAD580D00F1052500D43402244218E5660302821087C37CC4F4881273D6428900A248A5AAD42B3D12049336A35E386FF4937DD344D538404DFF31052B2B6BEC2D4E434131313CCCF2F90243EC78F1D65E1C21C08B15327E9871F7BFA48E7961B5F72CF95BEF625DF1A4AC1BA8AC8B3B4F6F4E34F78674E9F0603CF1E3E8CD69AD59515AAF506B7BEFCD6A228EEDC2E699AB1BCBCE24E09D394A5C52556D736DC0CAC5CD36CB468D4EBB45A4D7CDF7335A8C2B250AB54B0C612F83EED760BDFF7414A9AD52ABEEFD36C34A8D7AAA8AA24B7394996A184C6CB14D65A922446EB3AB55A8D7ABDCE46B70706678500A452689DB1B6B1CAD8E824ED569B2449489294471E7E90D7BCEE0DF43ADD03956AF81B8F1D3EF29E5B6E78C9B357FAFA97FCC52905EB2AE2ECEC99F8A9271E33E74E9F667EEE3CCF1C791AAF185FDC6CB5191F1F270C028CB148A9509EA2D7DDA0DFED32363ECEE8C8289EEF13843E711C53A9546837DB186B58595F072BF07D0F4F4A32AD9142801454AB557496634D8E90822CD34C4F4E72C3F52FA65A0931B9218A63941404BECFFCE212956AD579B47045FD24890926C609C3904CBB99F36150214963BADD751ACD06493AC2DAEA2ACF3CF934411070E855AFE1C8B113B7057EF81BF73FFEF4DF7BD5CD37CE5EE9C7A0E42F46295857114AAAA3D54A6535D37A7B9C2474FB3DDCEC3C8B541289C40A9042A19444790A0148E911569C39B452A9506F34088390200CA8555D8FA11F84B45A6D1AF53A954A88541EBEEFFC5ADD6E179D1633E2A5243786D58D0D66CF5FC01A373A59158303FBBD3EE7CECF51ADD5D059C646A6D1790658C26AD58DB729C63367A9661027982CA752A9323E3EC66010A1B394C34F3DC5E8C828D75E7F3D4F1F39F2DD16F36B5FB8F3DE9FF9BE37BE66F94A3F0E25FFF394827515618438BDFFDA839F3E7EF2D8B59DF58D00A1F0428F2CCB8A48C6F9A10CCE7F951B03D6620DE44683003706CB453E12E11AA285C5531E411050A9D6A884EE0452F91E95B082EF0704814FADD1A41A566834EAD49B4D8E3EFF1C61584128E784574A114511F55A83464B110F128230A4DEA8130D06844105A53CA410E43A476B43E0FBE4B9A1D3E9313AD26464A48DD6398341C403F7DD47B55E63D79EFD3C7BE4B977DCA0BCD5AFDDFFC8FBDFF4AADBCABEC32D4A29585711EF7BEF4F987FFEC15FFFDD9999ED6F5F5E5CBCA15271C3F8DC1C7757B91280B0162B04C21837A8CF5AA41D3AD5DD478A490DC618749E9398947E3FC22CAF6C6EC9B1AE5DD015D73D0FCFF30041E02B94F44042250C09C30ACAF7F17D277A63A363D41B0D57EB6AB7194411CBCBCBE84CBBC3824A88F2148D6693344989E38434895959CB181B1D27CF35C6187ADD3E0FDE773FB56A8DD1F109F9EC7347FE6EA35A597CFCD9E73F78F375E58487AD483922F92AE467DFF74F7EE3A31FFDFDF7921B4FF93E42C822BA2A22AAE276B618C2376CA9193E57865F739F1BD727E879EE76B8B1333ACFB1C64D7778E1CF18DE0F52BA969CE17E305CBF6271EF78BE8F528A6AA58A940A292DFBF6ED677E7E81381E50ABD7D958DF20495C3D4D6B4DABDDA65AADB2B8B044144544FD3E3B775EC35BBFF77B909E47ABD5326F7BF39B7EEA4DAF7AF947AEF4E350E2F866462497CDCF57217BF7EEF9D8C10307E7FB511F86FD7D4594657151535E983FC5B039D998CD37ADA1F838049EE753AD5669349A8C8D8F53AD86A4F1A058F7E56EEB5A74DC561ECFF3F083004F2997E2290F508570BA26689DE50CFA319D4E8F95E555BA9D0EDD6E9FC5C5259452A43A633088C8524D9A6608E5D2D37EAF4F9224B4475A2E45AD54B930779E871FB89F248E595E5991F73EF0F0BFB9FF9127BFE74A3F0E25DF3CA5605D85D4EBF5A76EB8F1862F046140AE2FEE181C321C19931751D770CBCDA5DB6E366F4731C02F779EA9F58D0E8B73E748BAEB0CBA7DFAD180344DDD9256EDFA025FB83547144DCFAA68A0F6FDC045579E222C3EEADC2D7B5D5F5B47E79A6AAD4292A4F47A3DC230706E7CE9FA12A328C2F33CEAF5BA33B20601479E7D96E79E398C27256766671B8F3CF9D46F7DF64B5FBDEE4A3F1625DF1C654A7895F25F3FF647DFF5A10FFDEAC78E1D3D36353E31892EDA6886699BDBE47C3192B2C66CA68A97A687C638A1AAD5AA180BAF78F9CBB9F9A5373037BFC0F11327585A5A627D6D9DF5B50D8CB15851445CC55453B898620EA3BCE1D7A0A8A915E3673CDF15DCABD52AA3A36DFA7D174D55AA159CDE0AAC75C5F84AA54ABD5665656595388E49D30CDF97BCEA35AF65CFBE03E4D670E8E65BEED8BD6BC77BDEF2BA57CD5DE9C7E36AA6DC9A7385F89D3FFCE35DCF3D77AC62B1666A72C26C9F99E9FCE8FFF2037F258FD14747471FBAE1869BEE3976FCD8ED599AA094B7B938022EBE41B9D2927043FB5E50CBA228D84B29E9767BF8BECFDBFFFA0FF0C3B7BF9DB373173879FA0C478F1EE7C873CF71F4D8313A1B5DA412AC2EAF70FEFC79B79947CA6261AB4B47ED2591DEA66016BF5796656E7657715F8D4613E529B24C43D1D62384406089FA3D02DF63647484E5A525A494F4FB7D9E78F4511AF526F5568B479F78E22DF546ED571E3BFCFCCFDF72C38BA22BFD9894FCFF5346587F41FEF347FFF0BAE595D543D6E81B9757565EB6B4B4D29042E87AA3AEC7464696C7C6279E8DA2E88494EAB9B1B1D1F989C989C5777CDF5BFF4ABC387EFDDFFDA7BFFBE10FFFC68717E6176AED9151329D618DBD2C7ABAF4F9F167D2410BB931586B489398C9C929BEF707BE9F4AADC6C6DABA4BF38A290D028B3606DFF749E384FBEFBE9BB3E7CE1356AAAEA7913F5B1FFB1F7D2E954B15C7C6C7911206F16053489D13DE16BD8992B1B171E241C4CAEA1A5841D4EFB173D735BCF255AF21A8844C4D6DE3CDAF7FEDBF78EB1B5EFDAFAEF4E371B55246587F097CF9DE876F3A77F6ECDF39777EEED5CB4B4BB79D397D8A85F90B6E479F94E83C2F521FEFF656AB45BD5E3FDA6C36E7262626E7FFCF8FFCCEA36B9DDE473FF04B3F3B7F25FF869999E94FDF70C38DEF397BE6EC6B4DAE113801828B623514026BDD386386915721329EA7C80D28E533B37D3BBEEFB1B1B646D4EF33E8474C4C8CBBF9EFC64D85E847038230E425D75DC7E2E23299CEF07DFFCF15A74BDF242F7FC37433E657565698981827A8042403D7506DAC7173B894224D359DCE06AD668B5A35A6DFEF53AD553977F61CCF349EE4E6DB5ECEEADA2A0F3DFEC43FFAFA838F3EF7FA57DC5AEE3BFC2B4E19617D937CFA8EBBA78E1C39F2E3CF3D7BF86FACAD6DBCEC9A6B76D1D958E7F4A913EE08BE5AC3981C6B87298EDB608C74751B8C25A85499DC7ECD17765DB3F383FFFA1FFFC2156DCCFD67FFFB877EEEDFFFE66FFE5A378A8266AB4592A42FB02DB88F7EE1A31AD69D86638F1BCD266151BC9F9A9AC4F37D3A9D0E499C90E76E2244AE5DA15DC88BA78D95B0CAE2C2024B2BCB482190525D76BF2F6433BA2A0AEBC3825AA3516762629C413C4067D9C539F3584C0E5996D168D6A90415969757DCC89BDC00392FB9EE7A0E5EFB62C6A7B7F1B21B6F9CBDE1C5D7FECDDBCA46E9BF74CA55F5DF067EEF535FF0A4E7BDF3F0134FFCE4C7FFE0F70ECD9E3C11DCF2CAD770EB6D87585D59E6DCD933542A5594EF936B8D4160AD1B58E74990C5FCF2DC18E24C83504C4C4E9C9C9A9ABE676272FCFE56ADFAC4F4C4F8FC85C5A5B8DBED9A6A254CD34CC7CD469D4EB7A7C727C64CA356E7EFFCE80F7F4B87D2FD3F7FF499E9FFF25F3EF2B93BBFF6F5DB5ACD36DA68F2223A94526E7E1E06C12562E5110621D57A0DCF93E82C23CB345114D1EDF630262FBC55825C1B90CE9F652CA8A2E6259522F07D92242E2C59170BF0C02529DEC5084F29B5F93CBCD476313232C2E8588B5EAF87C90DB2F072B9C30377B99ACD26C24AFAFD1EDAE4A4490258C6C727D8B67D869B6EBA99B77DF75B1F1B6935FFD7D71DBAB96C94FE4BA414AC6F319FBAE3EB539D7EFF0377DF75CFED7FFCBBFF65A2B3B1C6EBDFF2365E7CFD0DE82C67617E8E85A5256ACDA6DB889CA62EBA2A5CE281942825C82D48E5233D89C90DA9D6F8CAA7D5A8751AF5EAAA945E642D3A0C43A33CB50E9C6E379B6C743A9DB1B1111D04A15E59DD58D9B76797678C5D5D5A5E9E9D9E9E926B1B1B9DF19151BD73FB8C79F8D1C7D6D32C35C698B8566B80945A0AAB775FB393C5E5B5DE3FFD859F8A7EEF139FF1B64D8CF3B637BD5603BCFF5F7DF043FFF6FFF8B55FCE2D546A5517115244334544E466B50B37C7CAF7A8546A849580E5A525FA1B1D8C544091CA219045415EA8613F6221D8B941184B4E8EB1162554E1887782648D410C0BF1C5E28BE189A5526A737CF2504887DB7A262627A8D52AF47AC371EEA2386194E426C758E3FA1EA5406B4D9E59E2346630E8130415A626A778E92DB7F0EA57BEEA8FCE9D3FF781767BE4E8FB7FE1A74B37FC5F02A5607D0BF9BD4FFFC9EB0771F2A13BBFFAD5439FFBC3DF975248BEFFEDB7B373D76EBA1B1DD22C65797D9DB9B9396A453B491217CFF3E2DA4AA5C05A0CEE85AB945BC2E00DD762155EA75AADCEE4E404AB6BEB586BA816A35894907A7965C5284FE1FB9ECE322D41A6BE27D3200C119EA77DA98C928A2CD75A0874AE75C7F37D0D32F63C194D4E8CCB38D1E706D1607EC78E994AABD9E4CCB9736BED567B6EFEC2F9B7FDFEEFFCF6ED499CCA7AB3459AA57FC6F50EEE39A094471078D4EA550651C2CACA8A4BE98AE8C72B5A6626272709C3106B2CCAF7DCE716C0160B290C79E60CA2DD5E874CBBF1CA599A92A62959926085288CA41926CF376D179EE75D566497123CCF677272023F702796A25843C6657B1141790A25144AF9246942BD5661CFBE8324E9806490303A36A647C7C667A7A7A6EE6B8DB4FFB452A93CF6BE9FF989C357FA79F89D4C2958DF02BEF0D5BBBDD54EEFC78E9E38F5CFEEFACA9FEE79E06B5FA2D51EE1FBDEF14EC6272659595A2C56B60B06A966FEC2399278406B6414009DA6E4C58BC5E21A858514488A34D1F35042209440A7396125E4A61BAEA7D96C120F2237BDD353AC753B4C8D4F70FACC2CED5693B1D11196575650BEEF7AFF84E2C8B1A39C9D3DEB229FB08A94922070856C8B20CF35FD5E9F20F04D58A9EA3CD7D222087CCF0441A8E7E6CE7BCF1F792688A384B05A05EB1A9F876777C3F4CB5A8BE779542A152C96F5B50DF25C6F463D4341AB562B341A8DCBEA4EEE13B774D5F73DE78EAF55C1429A262EAAB2061024718CE7FB453F600F29416B6708759EAACBB7D35B5CAA198621939313580C711C3BD11A3E6DAD2DEA8AAEB8A8A4C400BBF7EC65C78E9DE4C6456C8328C222514A9A6AB51A4D4D4ECE8D8F8F7FBE3D3AFAB93008EEF9A9F7BCAB5C6EF12DA614ACBF201FFFDC176B36B7BF78DF230FBFEF4B5FFED3D6C9E78F70E0C07E5EF9C6EFA25AADB3BAB2E2D20C9D630611424AD25CB3BABA466E5C6F9D901293E760DCEC2659A453AE0EC3E63E3E29155249BC62D3B2CE737C3F002B10C29266197ED148EC2917A9082110D6328806ACACAE707EEE1CF16040B55A637C62926D53D38C8C8DE017518F1582388E595C5C248E6394522E821250092B743B1B3C73F830BD8D1E61ADEA22123B5C8A6A2FAB17F9C5B4D05E3F224BD342AC8625AB8BCF1193BB9FEFF91EC216E6502C973EDD86DFAB942BE67B456D0B29A804A16BCC169220F411D243298914B0BEBEC1EAEADAA6486E9A4E85A051AF313E314E5CAC091B4673CE86218B69131A2525BE5F61DFFE03D41B75B22C732D43BE8F9045F3B629DA9694D2D3D3D3F3BBAED9F9854A35FC8D24CD8EBEF76FBFBB5C70F12DA214ACBF001FFBF4E7C6FA51FC4FE7E62EBCF7E9A79F0E56D7D6199F9A62647C9C7830208A224C9EA3A4C01A10B536361D2031E4B9A1BFBE4492A4C8C257644C8E3335BA5A8BBCA470BC3925A1A815E95C238524CFCDE60B5C49B5F9EE0F2E7DEC743AAC2E2DD1EFF5D0794EA3D160647494F6C8289353538C4F4C50ADD6C8F38C6810E14B8F919111ACB51C3F719C5EAFB7590FAAD7EB44519F471F7E84B59515C26A8D2287721156512F1A8A82E729D234238EE3CDDF7FD3642A5CCD68581C1FA6BF43C3A93B25BCBCA86EAD415859CCCA62F374D5E439D6B802BAC009A8F29473C80B411445E479EEEA5E45517E982AD66A355AED16691A5F72FD253677F7AD7C9746361A6D76EEDC851FB868CEF37CC23074870AB50AB54A1D2524CA5798E231191D1B79626474F413517FF09BEFFFF9BF5FEE3FFC16500AD6FF2477DC75EFF48933B3FF7AF6ECF91FB74501D91A8BCE35DD4E9746AD426F102191CC9D3B4B94C3F8AD6FC6765749D62E90AE2D61073D72A9C8335DD44DDC1BB18B52C4652FE64B53A94BAFF1D0FD6D5EE04D9252B2B6BACADCF9B3586BB966D71E2627A6A8B71AB4DA23D8DCD2EB778BDB0AD2346371619E2C49D9BF7F3F8D568B3367CE9024F1E6F6E591D171749671F7D7BFCEFCB9B3F861AE09C679000020004944415405E5799B3EACE149E15010B4D6C51E43771FC5B383A1D3FCD2BF4BB9F0C9DDC2DACD53C6E16D6CF135491125A98B27852E8A2C523821B0584C6ED0B9717E302C711C5F769D945228E94E2347C746A95442E27870F9B55512DFF7D1A966E7AEDD4C4C4C90242961106C0E1D1C1B1BA356AFE3073E4A482A61052105B9C989A2886AB54A10847754AAC17F504ADDF1737FE73D9D2BFDDCDDCA94C6D1FF093EF9F92FEF5C5A59FBE0C2E2D2BB3DCF0DB51B24094A0AAAA1CFF7FEF5EFA35AA9F027777C95B5B5756EBDE5658C8F4F72CF3327A80868573CBC1DDB40EC20292290344DC975E6229DC84567D65A94E76DA65B977A8A9CF5C1BD480517DF20862762D658D7D367616D758D1DD7ECE6756F7A23DBB76FE7CCE9D33CF1C4E39C39798A4EB7C3208A48E20425253BF7EE6190242C9E3C81D61961C5450F41E806EEAD74175C34247D729D17F524BB195D817BC1675976598FA1B5974656171B9937459662C65631F0CF52A48188224D2B422A79712204C575F194E71CF2C56550C24328F08B104C48F7BBC57172D9C9A1B5024F7964694ABD5EDBFCBA541225DDA66A814BC5E3C180200869B74648B5A6520999DAB68D7AB581F22495302C1E0F41ABD94049C9EADA1AFD68401CC76F89A2FEA176BBF5F97FFB91FFFA814EB773FC9FFFC39F2BEB5BDF66CA080BF8D49FDCB16B7979E5C3171697DEAEACC560E90D22068301A11F50AD048C8DB4995F5C4620314272CB2D37D3AA5779E8FEFB698D8C3233B39D46B341AD566574A48D9492A5A565CE9E9F637E61014F49BA9D0D0E3F7384955577B2E66649852E52C80D4118BA6B2D2F4660975E7B899B91DEEB76B970FE1CDD5E9FEBAFBF9E99ED3B3871E204A74E1C274B354125A05AADD168D4999A9EA6D96A12F523A45454C2904AAD4AADD6A052A9104511C79F7F8E33B367585E5844E7395E10B8FA1B6C462E79AEC9325D14C62F3629BBFAD5FFD8992E8ADADD5054DCB69C4B3EDFFCDA50A245F19F05318C72D94CFD36C7E17892417F40AFD7E7126D47088A1E45C5F8F8984B1F077D3CE5D686599C13DE58CBCAF20AA3A3A37CF7DBDEC68BAEBB9E384E083C1F8AC3913008595B5B65BDB3813186248AE8F7FB448388200C1142128415464747CE0541F0EFA4949FFFC0FBFF61E9E1FA262953C26F82CF7CE98EA9D5B5CE6F5D985F7C8754822C4948E29844E724C98034495CC1D70F99989CA45EAD328823CECECEB2BEBEC1353BA6D9B56B0F63EDB67B372EAC0A07F6EEE5C52F3A4814459C9E3DCFE123CF3331DA264D12BE7EEFBD9C3C75826EA783EF05D41B75D657D7B0C6B8E84B4A5760566ECFDFF0A5EC8AD362B3E81EF5FB6C745C3662ADABA155AB559ACDA66B1152CA45455A53AD54A8D6EA8461957AB38E1012AD33CE9C3ACDEACA322B2BCB9C9F9DC558F07D9F4CEBCDC75D14E2EAD6C60F6BCD4E542E6D86BED4FC79592A5B84602F2C925F5AC3539E740710A2987B2A2C9EA790A8A2C97A781250A47EBE248E06ACAE75180E091CDEA7EFFB0801E3E313B4DB2DD63B6B08948BDA30484F92C619EBEBEBF4BB3D765CB39337BFF92D08293977F62CCAF7DDE8659D016EB67D1CC764698AE77B58EB0E138C7153212C16DFF7D9B66DFA7818F8FFB7EFFBF7BDE8DA171DFE5BEFBC7DF54A3FBFB702A5607D837CFC735F68AC6F747E6B6161E5C78404A5A42B280F62FABD2E8D669BD6C80873F30B8CB49BE824E6CC993374363610C0BEFD07B8EDD69B199F98208913BADD2EAB6BEB3CFEE493A469C2DFFBDB7F8B1D3B779026195FBFEF41EE7FE821BEF7CD6FA41A867CEE4FBEC8F1E3C7595D9AE7A5B7DC861F043CF3E453E82C2D4EAA5CC13A28E6A34BA50A177DEEE646158F496ECCA699D35857AC46B0D9C42C84C0F73C6AF506F57A839162F3CDC6C63ACBCB8B9C9F3D8B1082D5D515CECECEBAE2B31FA2757699D35C0867B8B4169472E9E0A54F894B272B88170AD7F018F192E791292C1F179F5FEE7B9492C5A4528A94501673B2280AF820A5C2F31516C3C6460F5B9C480EEFD38D61F668B55A8C8C8D9226034CE101C382F424BD4E443C88A9D5ABF47B3D7A9D2E37BFFC36C6C6C751CAA756AB926519F57A836AB55A4496EEE7673AC7538A388ED0798E4E33D78E551CAEB45BADF51D3B76DC61E06B23EDD6B3E3E3138FFCE48FBDB32CD0FF0F2805EB1BE0CEFB1FAA1D397AFC37E6E7977EA2DD6A162EE93E6B6BEBE446D31E19636A7A272B2B4B3CF2D07DACAFAE16A7518291D1316EBAE9465E76D38D4829B9303FCFF2EA1A2BCB4BACACAC624DCE9933A7F13C8F1F79E7BBD9BE7D86279E7E0625E1F4F1E7B9F1861B585C59E18E2FDFC1ECE993BCE5BBDFC65BDEF63DDCFDF53B79F4A18718F4FBC5244EE7C5F23D1F3F0CDC6EBF4BA2944B5FFC525E1C3F2C95440A8514E00721D56A955ABD41BBDDA2D96C9224291BEBEB9C3A79827810B1B6B6C1D973B354C2D0B5D80CE242600AC102E25E17213D6A8D269E129B85EE614AF742FBC37050DFF0DFC367D9B0606ECC9F4D23378DA0C215B82F1DADBC393E460A302EA294CAD91486168AE1DF2F8428C6362B2627A750BE244B13B02EAA4408BA9D2E9D4E8746A38E40321844BCE486EB3970E05A94E715D73DC00FFCE23452120DAD1CCA593B9274409666C52C2EB329EA4992A27546B3D1646474747E6C6CE4BE5E3F7A747262F2B95DBB763E17F5A3D95F7AEF4F9602565016DDBF01CE9C9BFBA0C9ED4F1CBAF9A58C8DB6E90F063CF8E8634471CCAEDDBBA9D65B1C3EFC14CF3CF5184A4AC626A6D836B58D3DBBAEA13DD266617191AFDDF5757ADD2E511491A519599E51AD565052716E769663879F64E7EE7DBCE4FA1B519EE27BDEF02A7EEE339F6672629244672CCC9FC762D9BB7F1F07F7EDC51380153CF6F0436C6CAC61ADC453E0F9017E1A10040152BA82F166815BB9712A3A751E27E549174D786E3D979402E5F9345B2DEACD26513C60636D9DA817B9D55AB961F6E4097A71CCC4BE49BA9D0E5996BA85AA9B8570C1CE6B76D3ED6ED0595B021432AC10842161E016A48A3CBFAC7DE7D2223A5C9C75E57E6F0998CB26426CDECE1A18FAA0AC054C51DCB7430D2DC6D5B8143237F9A658BD30358D9304A373EAF50A599A62ADC162C9920CAD737496D3EF4728CF43791EDD8D2E8BF317F083A070D02B2AB50AB55A8D5AAD861B9203599662864DED85C9F6A2F543E1FB1E58433FEAB3D1E94C9F3D7BE6F666AB757BD48F56E717E66795528BBFFC2FFFF572B5527D3E0882872CE2A1FFED177FA64C1FBF01AE4AC1FAC3CF7FF1C7E37EF4F75FF9B2EB48724BBDD1E0A923CF73EAF419AEBBFE261AED119E7DE630C78F1E61DFBE03BCF4A5377170DF1EB66FDBC6C4F818CF3C7F94071F79940BE7CF6F4E31082B01CDA0C1F2CA328F3FF000B3A78EF1925B5FCDD8F824E7E6CEB373669A7FF92BFF8A7AA3CEE8D8389FFDCCA7589C9FE3D5AF7D032FB9EE7A96961609838057BFE63578BEE2FEBBEF666D6D0D9D5B94CE48B21811B9FA8DEF05F8BE874022942C7AF086D3158A1A989560059E9793672983411F2905FD5E9F7830A0D7EB902629737373747A3DFC3064617E9E2CCB50C3534240671A93251CFA81EFE7C69B6EE2C8E1A7989BBBC0F2CA0A1B1B1B74363648E20E56E7D8A2777068C01CA670EED413276C72D8547DB1C675A9C859EB4E4229BC698ECB6772B9B69BA2DD46BB9EC421434F5B963973689AA598BC5AA47219D64096660C06315229A4F4D09926ACD568369BA4694A3F8A90080C966A5425AA54092B21F57A9D344D369DF65996B95A60966E1E24C449ECFE16DCDF59A92882B0C2A03F606D79650C25C702CFE7E4891354AA555A8DE6B9B05A9BFBD5DFFC4F4FDC76EBCD1F7ECB6B0E9545FBFF0FAE3AC1FA6F9FFCCCF72CCD9DFF956BAF99094E9D9B2357013BF29C3BEFBA8B1DBBF6D01E1B67697181FDBBAFE14DAF3EC48B0E1E64626C946AE08ADF4BEB1B3C7FEC04711CB36DDB36579C358685F9398E3D7F8C93CF3F4BD45BE7E08DB7F2F677FC30499270F8F1C7F8F8470FB36DDB14EF7AE7DFE0EB77DFC5638F3CC4F4CC0E6E3BF40A4E9F3A4512C78C8C8E323DB98D43875E4977A3CB03F7DDC32019A0730D99DB0FE8B6C70CDCC666E56F6E96F13D9742A6695A9CEA092A42A2534DE667F4BB7D7496936B4D9AA60CA288D3274F72FEEC395410146D2903643157FDD26825B79693278FF38637BF99BFF6C37F838DF5757A9D0D56565758BCB048AFB3C1601013C503BADD1EDD8D75A27E9F3849D0995B1261862650CB66DAE629E9A227C19F497387857921C00A776A371C9A6C8A71352EBA71A7BA4391BD98463AA369BFDFA756AF6D3ADE7566E847115996E1FB1ED61A7CDF63AA782CFB510FAD7397760A4BAE35599AD1EB09FABD1E9EEF2310689D9115353DE7C82FD27357E4435A97F68E4E4DB1B2BCC2D34F3E459625D4AA55666666189B9C241E0CD05AEF1C916227521C924A4EDDFFF8D3FFE05537DF78FA4ABF4EFEAA725509D617BFF8A51B4E9D3EFB01ADD4CEC73B3ECBAAC5ADD51E1FFBC34FD0EDF5B9E9A52F65EEC202F3F3F3BCFED0ADFCE0777F17003ACD88E298384939796696D367CF92C4038CF438BB7C9A93C78E327BEA1449D46772C735BCE9FBFF1AFB5FF4124E9D3AC9FDF7DCCDDA85F3BCF275AFE3756F780377DDF935EEFCEAD7A8562BBCE4FA1B993B3FC773478E506F36191D1F776BDCB74DB367DF3E0E3FF924BD7E6FD311EE52A2A10FCAA29487523E61E8135642C2A0B2390C4F49E536C978C5961A4FA1B38C28EAB1B8B8C4E99327989FBB00C5B03BE70F5317EB60455A65AC41783EFDFE80C71F7994A0168271FB04FD2060DBF6ED4CEFD8813186388E88FA11BD6E977EAF4BAFD723CB327720D1E9628C5B42916529499238736D11810D5FF897D6AC5C58668B084DBA13446BF0020F2CC4694A96E7080BC21B8ADCC5AE82BC689876A6579FDCF4E9177615CFF3365DF8131313349B4D06714C9E1BD7688D851CA23C224D1394F2890731BEEFE17BBE33B216ED4B4A2A746170F594442709420826A7B6D1D9D8E0B1871F667D6D1DA460636595D6489B9930200C02C626263870EDB5CCCCCC608CB9A956AF8F01A7AFF46BE5AF2A578D607DF56B7755CECF5DF807B372F4B6FEC401A41770ADDF63FDDC2CF73EF0003FF4C33F82EFF92CADAC92A519FFF9B77F9B871F7E8037BEE98D1CD8B38F244DD9E8F578F6E8713CBFC25BDEF846FECDAF7F88E3470E1356EBECDA778083D7DFC88E1D3B19C403EEFACA9F72ECF9E7989EDAC6EDEF7A1723236D3EF9894FF0D4E38F536B34D9B3F7004B8B0BCC9E3943ABDD623088E8753BA4F180F5B5553A9D0E485C8375E11B020AE172859C3CCFC066181BB8E50E0CB7CEB87E3863006B4953377DA1D7EB71E1FC39CE9C3A4567750DEBF9284F14A9CD25FE275EB07B1027263AD7E491258D133AB8E9A45A67E82CDD9C3195C69933850208678CF58390464B608C8BB47496A173F7BD988BD34D9D58E645C3768E31F9C5D69A42C074B17927CD32329DB9D46DB3E02F36452BCF2F0A6FAFD76764A44D96E8A2995AE2F93ED618C64647191B1BDB14376D35C66A746EB0B94120C8B4408A64F3FB9452450D4DA0A45B8C21A4407A0A9DB9686F647C948585059E7AE209FAFD3ECA738EFFBD070EB26BD72E2C82A9E96DECDAB59BA9A96DD4AA5540ED41A89FF9CAFD8F9E3879ECF93FF87B3FF6A3A7AFF4EBE6AF1A578D602D2DCCFFE8333DFFF6746C37076B1963668D69DFF2C9E78EB2B4B44C6E0C2FDEBF87D3B36738D55963617995A79F3DC64B6EBA15E1CD61F29C20085959EDD0E975B9EDE53FC82B5FFB7AC24A9D97BDE2D584950A0B17E678F0BE7B3975EA14F54AC05BBFEB4DECDEBB97D3A74EF1D93FFE246BCB8BB4C627989A9CA2D7EBB1B6BE4A18549C186419CD3C677EFE026BC313C7E525675B28F22163F3CDE661637277E42F156992A23C3701C20E0CDD6E97200C69371B689D511782A8DFE7F4A9539C3973061D0FF02B5537BE6533A2B19789A1B34708C80D98DCAD033386C00FC8A5204913D224D93C1DCCB2943C73629565193ACBDC7A2F9DA2758E35EE77CEAD7176062B361DFDA6B0600CDB98860A2984B36F1886A780A6B8DF0C313CC19406F76D454468ECE6D48761B4B5D1E9608AB69AE15C2C7243BD5E67727A126B2D3ACB811CAB0D26B7586DC88BEBED0E3A04565BB44E11D2C3537EF1758D2A1AD885767B18DBA323ACADAF71F8E9A7E84711420AAC311C38782DFBF6EF47798A76ABCDD8F804612544008D468356BB2D9F78F2C9BFF5479FF88479F1C103EBBFFA6FFFAF8FFCE35F786FE99EBF84AB42B03EFEE9CFDFF6CCB1E33FDF9CD839B2A7DA613C4F905290794DE238218E223EF399CFF2E26BAFE55D6FFF7EBEF4D5BB1869B578CF0FBF9DEBAEDDCFEA7A87D4587A510CC2F0C5CF7F9613CF3FC7CE6B7673EDF53771E4F0D35C989BA31FF51869B779F52B5FC1F48C4B073EF7994F73E6C4293CCF63746A1B9530647D7D1D632D4110B8FE389DA2B54B8FE224C1EA9CD9D9597ABD1ED65E120115E9D3B08158298BF444F1EE2DDCAA2E34A3A3635CB36B3720C8748AB1162D2463E313349A2DA4E7B9A9A8798ECE3372ED6A5B799E173B065D1463019365A499FB7F73E7CF516F36F0A4222DFA097DDF77F3EBDD009DCDEFCD327712371C6468B1082591B9ABF398BCD8345DFC3DC6E46E19852D4E1785134D931B8C35789EE77EB6CE379BACAD319BFB2B8C1946750218DA2C2C4238015DB8B008C2D2A8370008EB15765E730D4A2992384508570F53CA77A22735E485552277E396A592686310262B265A0884D118E1218D3B210DC390D59515CE9E99251EB8D6A83CCFD9BB6F1FD3D3D30C0603C627C6A9D71B602C59E20AF8EB1B1D1E7CF021BEF2E52FCA13C74EC846A3BE3FD63A004AC1BA84EF78C1FAF29DF7344E9C99FD5929FD9BF6362413812636158C1454ACE0BAEBAEE3C1FBEFE3E9C71FE5FDFFEC5FF0CBBFF43EDE75FB0FB2B8B0C0F3C74FB2B8BC8CB58633B3733CFCE8A3DCFFE0839C9B3DCBD1C71FA73D3343E0076459CABE7D0778D52B0E51AD56989F9FE7EEAFDFC5A993A71040736404E5FBD83C67A3D37517DEF39C6064197E10901B8BCE344A29BADD0E9D4ED74D2EB0F96691DA4D1CC8D1C3E90DB6180C984B7492925742F6EF3FC8DBDFFE7676EEDECDF1E327DC3BBCB5A4A946E72E02B2C690652959A689E3D84D3EC832D224254E62E22846E7D9C55A93C9190C628E3EFF3CBEEF153E25B7A034F07DA4509BB3A7F25CBBA2356EEEBBCE2C143686A123FDE28C998B1F5DD1FDF24DD314BE2B69E5651B7C2E9BFD2E04521A9C5F7658B01F2E83752779B670EDFB950AC658AAD590ED3BB63B477FA6371BBC61B8D6CC5C9C30210C261FA6CBA6681792EE345549F79848C0D862CE578DF3E7CEB3B6BE8E1412AB353B77EF666A6A8AA81F11D62A080B499210A709236A84E5E565EEBDE75E1E79E841ACC9A9B7EAF89ED752972E6A2C01BEC305EBBFDF71A75C585AFA91C5A595B7CF6C9BA2DE1E21951E52822F255A6BAE3D78901F79E7BBF8C27FFF2C4F3DF114BFF44BBFC8430FDEC7CB6F7D197FF0079FE099271E43F9019D6E8FB4DF83C0A7566F501D1DC5939299E969F61FDC4F250C993B7F8ED3A74EB1B4B484359656AB8DE77BE43A2F0C86F9E669586E73C0CDBFB2455493260979AE49E2148AA2EE70DDBBCDF38B2BB8847BB7273718231122C0188DCE73A667B6D31A1B274D33A62626497546A552A553F8C5ACB5846148AD56C314DE296B2D71EC3634E706E2419F2C49495277CA17457DFADDAE3B01EC76585B5F234D63FADD2E6B4584306C6CF63C85108AE14BCDDAA2FEB479CC278AE2FAC5A1804214934DED0B568B592E13A93F7FED98DDFC99C31A9CB516A33518039E24F03DAA8D26E31313341A756AB53A60190CE2E267B2797F42093CCFC718D03A23CF0B21C5901B8192A288E8DCD8652587F3E39DC72B8E07D46AAE3D2AD739CD7693F6488B4EB74BE007D8DCD0ED7690BE4735ABB1B4B4C4A913273871F418C6189AED261BEB1B4868984C9782F502BEA3056B6E61FEDAE5E5B59F0F82A03539318E2795734A5BC84D8E2E5A2C0EBDFC103B775DC391C3CF70F8E92779E4C18778FA9923F437D6D169446F6315556D30BA6D826AB5BAF9C2AC8655AAA1C7A96347595A5DA2DBE922502EDCC745097996BB1D7997F88CC0B5CEE09EEB9B2FC461717C73D2A7C9C987131260D3DB2394EB6F5352A18A95ECC6B8DE3BA5140FDC772F9DF5756788541EDD7E8F7E7FC0BEDDBBD8B7772FCAE69C3E799CF9C5256A950AA32323C4454B50350C514A12349A8C552650CA8D94098B16A17EAF47AFDF673018D0ED6CD0EFF6585D5BA5DBD9A0B3D1A1D7EFA175469264454D4A6ECE69175C34BC32DC2A541CFF1BEB0ADC4EBA36FFA7BB5697D815E0F2AE0B17B099C2F19E439EB9C9A64140A55263647C9CE999195AC5BCFD3C370C0603067184B1B9BB6F0C9E52F8458A8E75E9B6D6390283B0EE3131D6829548EB667789E28D27CF8D4BFD8C6623EB10060133DBA771E3A015BD7E174FB9EB9765197192504D52D6D7D6585A9867F6CC197C3FA0DEAC2387D19B948D89C98952B05EC077AC607DF1CEBBBDA79E79F65DFD28BA69EFAE3D045E809212CF2F360517ED2C499A90E51933D3D35CB37307AF7BDDEBD8D8E8D08D229238E6E9A79EE4D9670E338822749661AC1BBFA2A4426BCDD2F2226996A1B5A1566D02C3B448FFB92FB0E1BF2F5D07EF4E990A1F11AED5244F538633B9C4B0A83BECD52BD2278A91C4C6E4284F313D3343AFD76561E10259EA52CD2449F07D9FBFF9233FC49B5EFF5A76CCCCF0D8934F73EC649D7A18F0C53BBE8A004646DA68AD19C40340323E3E5AD81DDC9CF6A052A156A916F3A4DC8BAFD96A313E3ECECC8E19AC75E385933421496296169788A21EDDCE06F1206130880A4176ED4D528AC2AC00A1EF13C5313AD7F89E5F248F1707081A73B92BFEE2A92280F34AA1736425A4DE6AD16AB7D9BE7D07AD56CB591A7C377D627D7D832C4B9DB8D9FCE24451EB1AB17DCF271739560AB4718FB519BE595CD2046E0C085B8C5F162E4ACDCDC55138499214B6104B9AF511487C0F72AD898D5BA611457D565796595E5A746F7EB5AAB34B14B5CDC5E5E5DA2D875E5E0AD60BF88E15AC281A1C5A5C5AF9F16BB66F6766668A4A58A156732341D2C4A560DA1897EA651949B24E96A624A9C61A43AFB3CEFA7A072104A3A3A384414892241872726D105660F2A8C83A7C900A9DBB42F6B086324C63E0E2069D4B173B0C8BD1C6583006632CB9CE307911910C87FD6D46178567BC103BA53C84B018AB09BD00DFF3E8757B64598A544E50B5CEF9BB3FF66EDEF3EE7701F0C9CF7E8E4F7FFE4B0821D9BFEFFF65EFCDA32C4BEEFACE4F44DCED6DB95756D65EDDD55DBDD06AB5D4EAD646B73624D4423260830D234B5E06612C8C4098C58C30189BF176CED860E3B1608C07642C84005912480C68DF500B6DBDA9D7DAB32AAB2AB7976FBF5B44CC1F11F7BEACEAC6C7E778CE914E4DC539DD59955999F9DE7D2F7EF717DFDF7739C24FBCFDEFF1D18F7D9CF58D2DE666E768B73B6C6E6EB176F112AD4683D1784C9AE5247144BBDD626BAB0B58F6EDDDEB8FBB0E5F6BB5DBC449441425349A4D0E1C3C8492C25B15E7F40703B6B737C9C61346E33183C100531694461037620E2D1D6063638BE170E03A9D5DDDD56E32E9EE23629917C840D2EEB469B75A2C2C2DB267CF327112A30B4D9E1764594A9A6EB937BB0A00E13B2B6AAB6A295CB10A94E358F5063BEC747B94658912BB5E0729BD277C35301008E9E443151E3765DA17F5EBDB4822F75A41ED8536194DE8F7761042D1E9B41CF89FE58E2D9FA60441B8B27F656519B82ED9D9B5AEC982F5E907BF3CF7C8379E7CDBC2FCC2C183070E608D653C1E311C0FC9D3DC69FF4A77A71D8DC78CC61326E389233C8E478C462386A3A1638D0B451086C48D04A124599A519A0959519217597D9CB1DE88AF32ABDB7DFCE3B9FE2E9D795D5194535F60AD1DC81C06E0BF7E45C1AB7DA2447D07774930A18B80F75898AF69F4FA3D16E717B8F7EE1702F0D43327F8F7EFFE4D36B6B669B69ABCF89E17F0D7FECA1B79ECC9A7D8EAEE70DF4B5FCC77BCFA95ECF47AFCC67F7E0FA757CF71FFCB5FC6D2E2020F3DFA38EB9B9B1CBFE918A3D198AC7051661B5B5B349284F36B179052B277CF1EB4D68C27197951B0B277996623210A23F62EAF20A5F4B6383B0C0603FABD01E3F18499CE0C870F1FE2F4E9D38CC6E3691A3402ED070FD6E222BAB42689231616E7999F9D63617191F64C1B5D68CAB2A4BFD3673299A0B526508E206ABC59A2D8D5B308A1BC9B85F2094511BDDE0EDB5B5B9E2A1281148ED2A16C1D7681900E773316AB9DEB0DD2777FDAD48C7C21054A48E238210A6327D5693689C290F168441846345B6EFAB9B5B9CDF6F61673F3F3C45184D67AE9F499B34BDFECBDF4ADB6AEC9825514C5BD274F9DFE3EAC61676BD38964ADF16F42071C4561E428043EDA5C2AF76F8AB2A4284B1A499324491008779C499D862C9D4C3CF1B1F28B921853BAA285939154B6BDDED609EBB119E173F74C5962CBB276109552A2C2001BA83A8F8FAB00E667B965D46930DE4FCA1F518BBC74184EA8287347941C4F9C4DF0FAFA868B6B4F228E1E3A88148277FDD37FCE835FFD2A599AF3A9CF7D81ADEE363FF3133FC68FFEF0DFE5DFFEDA7FE4FE97BD84373EF09D7CEA735FE0A1871FE54D6F781D5BDB3BFCAB7FF3AB3C75E224F7BCE005DCF3C2BB1042F089CF7E8EC71F7F924307F7B3B43847516A56CF9F27CF7C8CBC312C2D2DD16C24B49A6DDA9D59E6E646E469CE60D84708387CF808274E9C20CB32B7717DD1AE0225E617E6E9B4DBCCCECD32373F8F30EE58DFEF0F28F3C251409044510491E357597F4330D69141950AB0C27548611812C71149B30958C228E2D84DC701C3E6E636A3E110AB85BF41154461481004CE04506AAC115351B675E26829BC105D29DACD36AD660BE5F595411038EE9B74BEF2EBEBEB6CAE6FA03D6DBE5964B45B6D068301ABE756AFC9FDF93FB3AEB90BF2FE3FFA93B93F7FF04B7FE78B9FFF7CBBD974D3B0CECC1C49D2400A4910878441403A49D1D6382A817462DA2CCDEB29DA643C41978E0A301A0E7D6E9E97C528012558E3889718E1D018617C0E9EC3A4A40B6A81B2C416A5939108A709741EE601818FE3321E68BE72ECFF97AF0A80574180920A6B214D27CE7219280A45180574BB3B7CE2339FE5EE17DEC5F39F7707CBCB7BF8FAD71F6261768EDFFFE08738B77A9EFD2B2BFCBDBFF3B73872F8000F3FF60DCEAEAE72D79D772024FCF67F7D1FAFF8F69773CBB163FCE1073FCC649272CF0BEF626E6E9697DC7337EFF8E1B7F15BEFFD5DFECA773DC01BBEF33BF897FFF6DFF3D4D34FF3B6BFF516BEEDF6DBF8E01FFF0967CFAFF2DD0FBC9E6F3CF124FFD76FFD17868381BB1908499AA51B2365610000200049444154743A6D8EDE78234F3EF938C696DC78EC28CF9C38C9703044859266B3C9FE7D2B345B2D92B841ABD5A6287386FD0165A17D87EB3CE1950A3DA74ABB6BA42ACA42E5BFE58E6CC65A022950FE1A4651C4CCEC3C878FDCC0D6E606A74E9C643C1E3B2CD218E6E6E630DA3018F629CBC2DF64DC20C1BD0FF4F475F3A07F1446CCCECCD068B75C68AC944451ECC0F68DCB6C6F7519F47A58211CB5A52C1C2C600CDAE89963371E5DF866EFA76FB575CD817A5B9B9B2FF9C8473EFA3D2E88B48940301E0D190EFA4C262326C321BD6E979DFE0E835E8F2C4D190CFA6C6F6D33998CC8D209593AA12C73D26CC278347618536D97E2C7E6D66270054805CEB7AAB2FCC51AC76B9AA464A3113ACDD06589301629038238264812A49A6E1E078D5C991C75F508FFEA8E4B2A4914FA50D0346530EC93A663269331A3D1106B35611CF0DBFFF5BDFCC99F7D8299990E3FFF33EF64717189871E7E98F3E72FB0B3D3E38DAF7F1D6FF9C1EF67A6DDE62FFEE2CB3CF9E4D3482979E15D7771F6FC792EACAD11273127CF9CE5C12F7F85B228B9E9D88D3CF0DAD770FBEDB770E1E245DEF3DEDFE3E891C3FCF22FFC1C8D469347BFF104478F1CE6B5AFBA9FC5B9395E7CCF8BF85B6FFE01EEB8FD56D63737298ADC0F324AD6CE9FA7D16CF2EDF7DD4F77A78BB570FBADB771CBADB770D34D3771E3B19BD8BFFF0073B3739465C9D6D616FDDE803CCF11923A50C31AEBE8145E93A88DEB829554156085F2D75C78067BF5F976BBC3FCFC02E7CF9EE1D31FFF044F3DFE04C3FE8034CB190C87F47B3D92246266668646A3097EAA190402A4F1F894402A67FFA3A403D29BED366114D16AB769B73B5861397F7E9573CF9CA0DFEF230327AACF87435ACD26F3F30B247183B228E4438F3C1A7DB3F7D3B7DABAA60AD66FBEF70F171E7EF8D1B7ED747792793FF5B2FECDEBD8E40569EAB00DED1386A19AD619C77ED7AEF587CAFAC41DDBB4271F4EA755504DA826C331C3FEA0B66E29522753C1FB23A930204812C246E212608CA9D39EFD2FFA4B4DCCEC737CAD9A5805CAD11894921446936519D9C4510AF2BC60381C604CC9C5B58BFCF08FFE03DEFD1BFF895B8F1FE70FDFF7DBBCF3277E8C377DE7EBF8ABDFF50647BF309AADED2D3EF8FBEFE3FDBFF73E00BEF335AFE286C307E9F7FB3492845692B0B9B585B586A5F939261397BEF38AFB5ECEE7FFFC411E79EC71961616B8F7EEBBF8FAC38FB0B9B5455114BCEF0F3EC017BFF4178451C4FE7DFBD0A526CD1C39B50AD778FAC9C7595E5EE1D0E1A36C6D6E51949AA53D4BCCCDCD634A773CEB7677DC6B8AE33C559169D5757480B7F5A11DD41C338B754EA638AA823B423BF33F210549A38145F3C52F7C864FFDE99F321C0E6976DA3EA9471386013BBD1E274E9E6267A74714852C2E2E517AD269140508E9313221084385548256AB4D7BA6C3DCFC3C9DCE0CED4E87617FC8FAE575B4854029B4D6349B0D6EBDE30E9EFF8217D06EB530A6446B2DB5B5D7DC09E87F765D53056BD0EFBFECECB973AF9F9DED388D9A368E980980A823AAB42E298D41050EF7A998CEC3E1903C4BC9D38CEEF6B6731BC80A26E309FD9D2E9B1B1B6C6F6EB3BDB1496F6B8BC14E8F3CCB9D8FBB1404817477CC20204A12E256933089A1C2AE76897CA7F484E9D46BF7C7FFEE8BE63DDF95928451441C272451035D5AB23C47979A3CD38C8729BD9D018D6683ADCD2DDEF9E3EFE0FE57BF96F7BFEFF738BC6F1F470E1F62ABBBCDFFF12BFF8E5FF9D55FE3AE3BEFE4E31FFF042FB8FB5E3EF5E9CF72CBCD37F3AAFBEFA33F18D06C366824319BEB9B2E4127CFF96F1FFE6386A331F7BDF4259445C61F7CE003002CCCCD716EF53C83C1909999591A8D26A7CF9E450A41A7D522CB73E74D650D599611C409ABE756397DEA24F7DDFF0AA2386234EA7369FD225BDBDB94A6248A423FA91348E17022E5C9BF8E2A018EF7245132A87DB36A7F2D5339A83A6CC979C80BA2D039933EF18DC779E4A1872934CCEF596265DF5E5AAD1652BA637F12C748A5D8EE76B974E932E3F1C46161C6323B334F2369637575A417C451449224445144183968426BF77CA50BA82469343872E408CF7FE15DAC1CD8CF703864321E53382954F0BCDB6FBB0EBA5FB5AEA90A7E79FDF21DA3D1A8198511599E3920BD2831A506CFEE1652926799B35AF105C4E892D168EC27768622CFD1C6053A18635DF840101027B1730228155A17885280925823D0A5E75FE52945E934705697046148D46CD69BFCEA317DF5F1EA6C42FF8529B9C77FAD0A2755CA6154CA078DB6DB2D261347178069CA8CB5169319666667D19D0E4F7EE309FEC923BF808C1A10854491B339F9855FF8453EFBB9CFF2CAFBEFE3031FFC30FFE1DDBFCE4FBFF31D5C58BBC885F36B2815309A8C397DEE1C97D637D8B3B4878FFFD9C7F88FEF7E373FF18E1FE3CDDFFFBD5C5EBB4059963CF9C4936C6F6D02B0B4B4C06CA7C3EAF90B0441C0FE7D7B298B9CE16048A7D3425B8B12AE4B7CECD14778E9CB5ECEDDF7DECB673FF909E617175132F40269ED592112709218ADAB300B5131465C9785C196DE83DEF39E10D38EA6720615DE567A637D9D4B172FB99B8D97D91C3B768CEDED6D9E78E24937F5F57857E4B96D9BDB5BCE614108A230A6DD164C26C33A0C448A80388EBCB58FB3549E8C479445C1F2BE15ACB52C2F2D933462D22CA3BBBD8340902431CAAB1B9E3971E29A6A28FEBF58D754C15A5C98BB25CF728C71962C9152349A4D8CD16479CA6432C6684B966594458E290D064BB39120953371EBB4DBA4694A9667A4E984F1704421202F357996924D52F2B2A4C8738C17F72204D2871BA82040854E405B1439D9704499E7B46666B03E88D4FA89D0D5C4D22A58948AC2E00355771733C7BD7253C5300A7DCA0C048164EFDEBD044140BFDF77E266FC181E6AA1F0FCF23ECFF6D73E5A4B11442E51E6237FFC277CE48F3E44D29E23081BFCE8DBDF4E6776812069F26BBFF11BCCCECE104AC58FFEE88F2283907623E4977EE99FB0D3EBF1D217BF944BEBEBFCF2BFFCD7BCFF0F3FC0DCEC2CABABABB4DB2DE23060676787B2D41CDABF1F655D371BC711C61AB41404A1E2ECD9D3FCC5830FF28637BE89A79F7C92EDCD6D66E7E7FC35083CD343FB095CA55DA4164A833FB27B8753A5940F46DC25EDC11FC9ADA5D56C319E8C190E7A4471C4CADE65FABD3E4A492E5FBE44B7DB732939BBC2642B603DCF72A230F4C38E9456AB49103826BBB11A8B2508431A8DA6C3BC84F07CBF94A5C525A23842EB825E6F07AD6DDD41BA246C27FDD9D8BA4EC1BA7A5D53056B3299A44EAB2FEA11F2A0D7279B8CC98B82344B89C398C5A53D2C2C1D464A45AFD7653276C6731B972FB3B9BECE6838A6D7EF31190D513E9926CF72C238C458413349687766D0BAA4D2B239C70183D1A573C1B496208A9041483A1A31ECF7897DA7551DC40502EB3132BC199CD1D36993D51A153ACF748C937F04FE18D8881B48A128CA1C2925A5864085EC59DE43A7D3667BBB4BEE3B3A3725533EA9D9DBA7D4CC4927849652B072E888E791B90DDFE9DC445114E479469AA54461C8C458FEF8A31F41850D0EDF7813A550FCF37FF6CBDC70FC36E6666778E489C7595898470BC33B7FF2A7397AE430AB6BAB8CC623FECDAFFE1AE7CE9D256924945A906725A529904278A991E0139FF8338E1C3DC2EB1E78031FF9A30F32198D481A0D843048194C45D1FE68277C6085AAF1ACDD054DD62C796335522A4FFC745FCFB28C2CCFD0C6B2B8B4879B6F3ECE673EF9498683016B172F32E8F5FD98774AF605DFC559E3AEBD92685DD06AB788E2842CCF0885B3CA31DA87C50AA716A8B8645A6BC6C3117991D7941437773198D2516B9070DBF19BE7BFD97BEA5B6D5D53056B34CE4E865144993B9CEAD2E935F22C636E618E3DCBCB343B6DCABC64A7BBCD89A79E724E04654159960441084014C74451C4F2DEBD84F141E230A42C1DB76734769CA676ABC57834663499388695B6CEFFA928C01AA741F331EE8152345A2DF23C274B9D13A50A94E3467B275161A6267966574765B41BA937DA2D6CE0138B95224962E2387263FC40A18D21B08E386AAC65766E8E66AB8D2E0B46A331C3E1902C4BFDB1A9F29EC23B930A4FC8D43E7DC6135F7D6EA00A148DA049ABDD76C522808337DE02064683215198B0FF869BB9B0B6C6B9D55596579669365A4CB29447CF3CCED7BEFA15F6DD70844B972EF3998F7D0CD56EB36FEF3EA4B2B537BAC1A24B4B10256C6F6DF35BFFF76FF2836F792BAFFDCE07EA029224891F8C4CF5A0D5B592427A10DE7D54A2F2C5AA8E91A6D6319AD2F8C20D7991E34CFFA0D168B067792F0B0B0B3CFDD49334DB2DC230663C1E03CF26FE6241971695282C2E9D280C23EFAD5F25FBF8646F01D2BB9B82C50AA74B94DEFCCF629C550DEE3995BA446985B0B6FDCDDE53DF6AEB9A2A5879916D2AA5989423D62E5C4609C9CDB7DF4698446C5C5E67EDFC05B234234DC7B45B4EBD3FB7B4C0D2D232B37373CEB120CB902A603219B96955912103493A49E9ED7489E306DDEE0ED9247524514F4634567BBF3B5B6323E0368BD19A200CD1955C6797D44658EA00034755706F6829143249C82713749AD19E9FA7D0CE404F06C2934323A228A42C8DE76505609CBB421C27444903150454E67C65697C51DCE5EEE971322104062FE83506AB3502678383EF5CA47053B8C2FB4149E91C0D84102CEFDD0758CAB26430181128C5BE8347405A4C594020993F7000611D73DCB81DED37AE74989FB5341A4D2E5F5EE70F7EF777B9EF15AFE2CEE7DFC533CF3CEDF84AC612442178FB63777C9A4E094DE9749E962AC8A24AD071EEABC658C228F447725BDF20A4145CBCB0C691239B3CFFEE1770F6F4097ADD1D3A9D59B038FA84A0761BADAC68607722B5A33638F340EBF130E985F2EE35287CD663451696026FE1ECBADA6A7820910461C0EAC54BD7BDB0AE5AD754C11A0E07B99098CB172FCA46B3C94DC78FD3DBE9B2F6D41A20D9B3B4C4CAFEFD2C2D2FB377EF0A6118D0EBF7198D866C6F6DBA234296319E4C9CCEAD741E51DA38E16C9234B016F234278C2317B05068E74BEEB3F2AACD330577A5EBA6CAD28995A5446391669AF947C58AF7D1D116671F13AA00D95694E3314912234B4D18299238F14458E53A236331C210061149D272010979416E320AED5C3FAB095910380C2CCFF3A937820F4EB053E4BA16FD9645E9EC9785B3E883AAFBF2AE0B5278E3BED207433880DA62C952C7B0B7384BAC4694D41BB62A945827713118D09E1DDE6AB3BABACA1F7DE8BF71C79D77B2B4B4442369301A0C5D7497D1B5AEAF8E3B930AEB3B52BC65B1311A235C62B694AE304821B18A3A51BBDFDFA12C0B46C33EA74F9DE4D0A103CC7466D9DCDCA268B6489A0DA4B5A4BED800F554390843D7E54A41184675872A03C70B0B94F25635CEB5A22A7CD518C5A06B970AACC01A279C76050E46A3F1377B4B7DCBAD6BAA60DD76CB2DE5230F3D5266451E1D3F721B972F5FA6DFDD61FF8103EC59596161DE7977632DFD5E8FD1688800C613476034DEDCAE2C4BE22872AE0452B1B1BE4114852815D0EB7691CA5980E8423B3E8FD6CE0AC6D83AA70EAA40D1A930D6DD812D62F783AE3D8F5D678575C6774A086410908D86CCCCCEA35440200CED76C7B1B9F1FB1D81B5CE8FDCB92B0475175068C7CDCAFD73D35A13C74ED396655792542B2E58F59F546A8AFFE88ADCBA3B09DAE14020EBC965557495955EA9622B37763FE0982634CBEAE7F85F5F79B65713D34E6786C964C257BFF265F6ADACB067658546AB819082F1784451E680CB6D44086701E3AF9F928252431846358E05CECB4A28E1E45246D3489A94BA60636313A11467CF9C6663FD12462AAC540C7A3D3A331D8E7FDB6D14A5E6CCC9935788B21B49E26C8AB446EB92A274FC3D6727ED9E479665349A0DA2287298A57547506D9CCDB3F4C4556B218A42C052EA9CA228988C47DFEC2DF52DB7AEA98275F8F0A127E7E766CF6FCFCEDE38198F3046F36D773E8FD9F9797A3B5D3637D65DECBB90A820643299902431AD561B6BDDF4B0D7DDA1D16A20BD6A7E3276B627A52EC9D2419D685C81BD566BB222F78F405C6189E2D634BDF8CA24E36773AFAAC99614823849188F46C42A60717989DEA04FABD5A4D9689265CE2D348E958BFD0A0394296B305809C74F2ACADC873E688ABC442845A391906619552A4D35852C3D3976B793A7D8F5677687A25A8BD6AEB057C10F95C3A7148A40F969A907BE2B1A461D278FF30313BECBAABCBE76BB8D2AA568B73B1445C6A58BEB74BB5D666667999D9DA5D16850969A349B9066294A29A220A8F57B2E04D5D681B3D2F3B5A44F742EF2A2C696F62CAF20A4E2F489D314654E96E5180D6114511639BD6E9F8DCBEB2E48553A07D13CCFEBA35E51944451CCE5CB97198FC7481938A2B131E44581D605914F8FAEBA5247689575FAB552AE531602A23824ED8F49A290F178F2CDDE52DF72EB9A2A588F3EF6F89999B9F9279552371665C9A1A34701D8DAD8708C731FED5416052A0868B45A0C7B3D9ACD26325018A369B69B24CD26E9784CBFDF6330E883941493C21BBA595F044A0A5D788E10F86D784597F26C77CC29785BB3B0AF22900AE5F00BAD4B7496B2EFC851F222A3D14868242DB436CE3E65D798DD1506551FB190A226291645E13650A169440971DC20CB0AA404ADA7F1F2BB539AABC75B1FAFB81274963E10D54DC19C8F7BE99500D696E454B89C2B2055A86AD58939E01CAFBF1488CA981DDF79A9E9342F8E1382C0A0754977AB4B7FA74FABD5A2DD6E3BDA8017A897BAAC0B16B8408E0A980FC3B0B67D71B89CC2E27E87948A43870E536439274F9E623C9AD06A3769060DC643E7A671FED429084367B1ECAFFBFCFCBCF31C0B43DAED365B9ED51F452161347DBE524A0717F81B4245AB7385CA71C98CD64EAD5096A4E9046BC43441FAFABA625D53576473738B288C77A22866716989C14E1715382E8C54532D99B5AA3659934A911739D93047494514470C0703B637D6E9F57AA4998F38F71895CBAEABC0EAE946BFDAABE9BFC758DFDD6D556BF7660EC388FEF626F38B8BC42DD76975DA336E44EE9D38A57086704A05BEA858940C30A6643299F810888222D73530BEB0B040148514455E879B1AE3BC24AE284C5884758563EA6D5E097C45ED7E504DBEAA0EAA32D5AB8E925518459ABA3006E98BB1931405BB9EBB7B6DAAC72195440907540B291D41562BA7D1D42E5E7E3C991047219D4E8756BB43236A1086A1C721539AAD1681774BAD321729ACF762778FC1184396A62825B9E1D831C228E2ECA9B34CD2312A50447148ABDDA2D1DCCB643C613C4909828046A38192AEC0CC2DCC321C0E190C0648E16E7A6551FA6E59120461E5A14A51EA9A3757915C95D23E54C4E17F499450C8126D4B16E6E7AE33DDAF5AD754C1DAB3674F29059B41181285A1BB7305AAC69CA4D408095114A394264D5327BDD0866C923A6E4D37777E48FE9867B47636347E0356010BAA36C82BAF60955FBDAE2085EE2280569BBBBAE34ABFE9E328249BA48441E08255F39C24693842292EDAAB069B9542A82AA0C1108411C2B8E38F367E646F347956D0E9B40943C5767793349BF8A39A4029BCFBA77391D8154D583FEEFACFC64B8CA04E5EAE113A3B8D0B73B2218510A14FD1F1E684B9B3BF0902E545C215917B7A84AE8E96CA1FE782C001D7CAEBFF8230AC0B625E946C77B7E80D76E874E6D8B367997D070F311C0E18ECEC3857D98A9FE501716B20D7292A081DDE1506F5CFDBB3BC8C14924B172F32180E115210C511911FB08445E94238FCFBA9D56923A560A7DBC5688314608CF020BF7B6193C415D2AA63D45A13C5713DA57538967F8CD680ACE8180A6BED75F1F355EB9A2A580853AA405E4E1A09A3F19856AB8DB18641BF4F14C6040DC7A9AAFCCF8DD1A493943CCBD8E9759142D2DBE9311E8DB07EFA55E4B917DCFA638B0796ABA3943B823CB7CC06A67856855DEC0E52A88B55CD6E87200A190C06CC76DA3E894692C409E02813C61802EF32E0241F82BC28095588B59AD2946853321A8FC9B38C208858DEBB4C18450C4703B0B03037EF3A4EDFB1399A45591796EA7346973ECCD4D6B40063B4CB93B0EE2823AD45574EAABB0C07AB6B10A880209872CE5C7A8FC696D4C2ED209057D005A407CA9DFB6689B50EA7AAAC60C238F4134B8135823CD36C659BEC6C6F638CE6B63B9EC7CE7697D3274F7892A97B0DAAEE460851C302A674C1AEDA7A09561872E8F02146A321DD6E9F2C4BE975FBF5D1320A031092388E889390F138653249FD0DC5917DAD757C396BAC7BBF59471391C2855CECBE4E08E9E919AE0375C9469585F6558391EBEBDA2A58BFF8D33F99FFFC2FFFAB33A17774345A13270D67B85679A223C9D2949DF188D170889092F164C47830A6F01D13C2E90DB5D118ED0A95F222D8AAE8E85D8933706527F55CC07A350A9F4ED9C4154743292551183ACC4917349B2DEFE9246B0FF44049940AD0BA709B5E3A53BA40850461C0789CBAEE62D827CF0BF6EC7196C15114539625E9644296E55784B35A03C26834AA0EB190DEC9C04D3C751DDD55962E17D05D1753175AE5AF47959C73051EB66BF2276540A3E13A1AF7F34A4FCB704C7547DEBDF27ABA4E45D6E9D73ACFEB88AD288A90F5E3B5E465C1D34F3D85909297BEFCDB491A090F7EE10B0821481A09DA3B35042A44284B99B9687AA1044A2A4CA931DA990096DAD0486292247452ADACF00E1981CB579482C970E249C7AACE8A14CADD0875E926B32A745E5BFD5E8FA22C9142EDEA5A05BE5F751C382331A5ADB1AF222FBED95BEA5B6E5D53050B2069B576A4942449038041BF47B3D54448E1EC5F4663F2C281D13B3B3B6EDAA50BB06E2A586D18638C17CE4A4FF6BC12987E76B7F46C30BDFAFCEEC9D7EEEFA98E44D283D33208188F4748A948DA2D00C220026110D2B95C0AE1E2D1853024494C9E15CE076BA2C8F212A9042FBAFB6E6E3C769C208AB974F102972F5D24CB52FA831EFDDE802CCFBD04C755ADDDA74029154A55D1F00EF38BE398300809C300A31D01D21883F145CC918BDCCFAA3AA3EA98585117EA2DEAA762523A1B16E74C505296AEA3080207D24FC326A64747E19F7FD57DA4A9733E08C290200891C2D90D3FF18D47E9743ABCEEF56F20CF323EF3A94F50944DA22846684BA98BDA6941971AAD0B1A8DA687078567A0FB205963BDC8DA3D6683411A4BAE6D4D5DD0D6222B57596151CA8979A22822542E7FB2BA26AE63ADDE2BAE4B34FEE6E0E443A2CE58B4F67A8775F5BAE60A5656143B8D4693344D89C2C059984C9CF7FA7834229DA44471C8783C224B533CD791B274776EE359C8556080AD13856D8D4B1853C1A85CD131B9AF99676155405DCC9EEB6B52057EACEFE438711413A880429728E58E0A959FB9DBECA073CDE6C6164658A23062FFFE7DBCF2FEFB78D18B5E44A3DDE1DCF935BEFEF043A4E9C447720DC9B2DC81DE7EFA5481E7B5AB83753AC3329FBA785A60349A784991200C2282C0757B5648AF633475427375F4AD58EC9541A1D88D857971B7F39292581B5014D3C468638CE32DF9E256AD69D725EB22E6F21C73CA52FB205385D6F0E09F7F8156ABCD7DF7DF4FBFDFE54B5F7C9076BB431879305F04C491C39274A9D145898AA22901D53F1763A7529E0A0B2B6CB90B77F21361E154D6D5B0567855406F678776A7E3C4CD5220ACF085D70F2E44A5DC14DE50D01554632DA59932EAAF2FB7AEB982654A3D6C341AC38B6B6BEDBDCBCB44514459BA8D907B96F4645C301A8F9D6CC58FFF75E9AC928320A88B4EE5D3EED6943029A570129CAB0AD27379B05740B494BB309A0AEFA8276C0E0037C61DD1C2C4D9264B21095480C181C261E4526A36B776C88B82D9CE0CAF7DCDABF8DEEF7E23C78EDD888A123636BB7CF5A18778E89147B9B8769EF16888F062706DA29A65AE4D591F63AA4E064009815153BD219584C758F24C93A50542B8E21B84812B12A1C44A41A1A7C75CE3A53D8E218F03BC771D85EA9E4B08A450C4B1C25A4D51B8C795E739E12E798BBF60EE0353733E07EEBB096E5938B67D10849445C99F7EF423CCCF2FF0C01BBF9BEDAD6D9E7EFA29666666FDF719F2C27D7F123A7540A90B5410F9D7DD12780B6407969B9ABA1148F7B8B4D69E004BDD3109E33486D2DB6E0751E81FABC06ABB8B9DEF88B55E1A402025DABA63B2F0E9D2E63A86F5AC75CD15ACC978943692F852599637A5694A9A4D88A298288E49C380B228D1A5268A2226136776673C4B5C54F88B702E0A58E39D2945DD79013509D03EC71BEAEA8EEB6A9ED5EECFD5844AF0533BC09AE99B9D0083250C230265E976BB6C75B759D9BBC2F77DE76BF9FEBFFA3DBCE88577319A649CBBB0C6634F3CC48953A7B8B4BECEB03FC09425455E5064CE30CFDDE125DA8B88A57077746D0CD66830022B41FA7D642C68EB1E9B0C044AB9AE496BE38F7119599A239570E10C2AC4483CEEE77489CFE5965A1126819A410F958426409745ED7821FC315CF9D767F7404349591375A9B578963CCF508124CF0B3EFCA1FF46BBD3E675AF7F035B9B9B74BB5DDA9D364EF75800963C4B1DD52194486B88C2D8858FA4638C770645387F2DD71839A75959FD7EA5C0138A9112E9E3C430D06CB66AFA87B52EEADEBDC7DC0DC96A5BA723B91C444FA395CF113C727D5D7B050B44692D3B51E846EA61E854F4459EBB37B8B094D6780F7630421084CE602DCF0B4C51B863970A50425294D3B6BCC667AC756C72FFF9DD40F3D596BDCF353DDCFD6FA7F15D4E4FE6BE4FA144506FE6344DD9D8D824CF33DEF88607F8A1BFF3565EFEE27BC9F282C79E3AC133A7CEB2B9B945AFDF67301C92A529B9B780CEF28242977E4266B00AC7711266CA33352E86DD96DA056954F88901A884C953EC2D08028240A24B67AD5C160653A604AA44FA6BB9BB8BACD401F52B54779D92A02E5C2EA0340C2549149297A61638577296CA37BFFAB9AEE04E37B594D38EB12C4BA228A1BBB5C507FEE0FDFC8D1FF89BDCFB9297F2677FFA51B22C737896A852A74B3020758016DA4B9E2C71DC20171959560006A5041685C615D25A380E75E848C5EC771C32E5DD1B20CF3310CE0DD5B998E22922FEC8699C379950C6756256509AEBDAE7ABD73557B0A23028A552436D0C711C239463655B01CA681AAD167192904D52D7E21B27F62DF3D245BF47A2762BB0FE8E2D94F09B773AF5AB46CEBB9388ABAFFF6578D6EE3505E9A7A0B263444F730795146C6C6CB2B1B5C96DB7DECADF7FDBFFCA5B7EF0FB09A39867CEAC72E2D4192E6D6C311C0CE80F060C4643D289739C180D5D361F5EA3162849A115A5D6AEF3A918FAC6BA3876BCF3809EC62456F5C06D30DF31FAFF5B2F720E54809286527B1F273F3DDDDD414ADF9D787F0AAAEC872AF15A004AA83A164D2A452B9694467BABA0CA47CA4C758B5033F1AF9ED456E261AD0D8D668BF3E7CFF3F18FFD292FBBEF7E6EBDF5769E7CE28B17AF2F00002000494441547197F4EC6F6AEEB13A6C32F154128C331534D6C99A0A6D5161801616A1751D4A22715C3DE9D32F84744270EDD9EBB5B38377F6A87CBB3C84853582125DF3012B775321201DA7DFECEDF42DB7AEB982B5B2B292A693C9BAF67EE1DA2BFB1DF01951E485D3CC19678DA24BE3A9010A210C0885C91D13BC9EF0F974E34A86525114E0B93BA7AB3B2BB81264AF8B18D3887A212552091F621031180EB8B076919999197EE487FE2E6F7DCBFFC2F19B6E66F5E23ACF9C3ECB56B7C7703464301C31198E986429E3C998D1704C776787CBEBEBF4BB5D1757E6377AA3999024B10B702D4B8CC9D146541E0CB8AA3CC5972A36BF50204D35FDF451EDEE89D48F5D09C789AA8A77E59F1F86016118793991411BEB747EA2029FA59B7E2A2F31729E306ED8209C90384D33F2BC70BC265F2CC22070A4D56775ABD30147D5293693268F3FFE0D161617B9F9F8ADACADAD3118F43DDBDEEC3AA24BCAD2E158553C984BC671CEA2084361324F929D4E3FA7934B8B349A280C08C2C8290CA4A0D168380991E7AC495B09BFDD4FB0C62294F57229E9AC8AACDD2DDFBCBEFCBAE60A56BBDDCEDB9DF6B0D170CAFE40BA08725D9684714CABE92688491283E703A5695A6F3EE3EFE64118F80992A337587925BFAA5A579344AF2E4CD59F2B0C6C37070BE93B2AE9CE66611412868AF54BAB181572CF3DF7F0633FF2C37CEF9BDE481885AC6D6ED31D8E481A4D568200BD384B51141479495EE44C2663D249CA6030E0D2A54B5CB870819D6E973473467E3BDD1D2E5FBE4C9E17B4DB6DE6E63AC47188D602A1B5B3E6F5DC2BAC334675CF7B4A7EA8DC17BCF5C4B4531402BBFBB82625C63810DD5A5CEA4EAB81B6066B354A7AE13681CB850C842F520AE4748A868524D10C477DD22C2530EE88AA85762C762AB5D2B35506520AC73CF79DD4230F7F9DD9D9198EDD74138F3EF4901B0C78AB1CFF0A620C28016114A24B4D0984A1210C12D234F5DDE9AEEB518B997DC418EE86158701619438678C3425CD528CA0BEE155E116F8018644A2AD755901AAB2E8B95EB1AE5ED75CC16A349BE3308C4E67E309910A985B58A8DF50C61A5410D0F6EE994551922489B3AC2DD37A0CBFDB3DA1D2B719A68937D5D72B498E9BEC5C49047DAEBFC3749AE846FF0E2B515291345A64E984DED66566E616F9997FF48F78F30FFC0D8E1E3904C0CE60CCA0DF67B0D3E5CC99336C6CAC331A8D988C1D19B4D465E5D64C184484A1E2F0C103DC7EDB2D2CCE2F20A5627B7B8BD3E7CEB176F1226B17D638BF7A812CCF999F9F65767ED64D4CF3C29BDB090CDA1348F102E5EA28E837EC551D23D6BA2392DFC4BB691C69EA80F0C5A525A4541445EE63E4C35A24AD02E7DE89F11E591E37AB940983519F7432C17AFFADDD148AE71A6A4CAFB32569240C06431E7BE461EEBCEB05EC59DECBC54B6B2449B3EE0CA12488E3DAF72B080390CEAEC6185045E17CD072ED48A04AD6407F7509945294BA24CFBCF79567D51745E1AFA3A32F94A5997667C2A0AD73041138A63F565C9F123EC7BAE60AD69BBFF78DF9BFFD8FFFF9840C9CC0B9C873AC31B4DA1DE266822E4A8484388E49D30999C732549653EEF20BD735D8EEA75557F9355585ADC2A99E65A1CB55C589E790EDE02C99A50AB878EE246536E6CD6F792B3FFCB61FE2FEFBEE03E0CB5F7F98AF7CF56B7CFDA147387DF62CC37E9FA228C9F28C499A5670BD17696BE238414AE1537542221F54D16834D8BF7F1FC78EDEC8DD2FBC0B019C397D96A74F9EE299674EF0F4D327683412F6AD2C236DE418F77E4A279CA5BCEBAF7C9D12F64AFCC83D21811562EA75B50BA3D2DA301EA784BD21070E1EA0D968384F73E5B49E02F77DC667011AED4077536AF2A2248E63A083B1867492A2AC2B0481A73EEC5E424C8BA9C5778A42120621172EACB167792F070E1C646363C3799949E18AA4B5E83220505E8224157114395271963942AB52A466520BDFA574540553FACA2E2D8175B6D5E9648C319A386E78E1FAD48DD618EDC332A651F74A851038BB6823CA5D9DDFF555AD6BAE60013CFDCC53DBF373F3A6D7DB9193C904259D2343682254A068B53A4461EC134BB437A2C3873D38ED5CC54A2FCA0AE3A8F46DD323CFD59854B5FE4762BCA45484714C3A1A31DA59E7452F7E29EFFAB99FE381D7BF8ED5B5CBFCBB77FF265FFAF2573879EA34D964EC1E8BD66E83E22800339D0EE3C99834CDE8B43B1853D01B0C6A42A85292DE60402005411CF2CCA993FCF9171F24169285BD7BB9E3DB6EE5AEE7DFC1FDF7BD9C8DCD4DBEF0E75FE48B0F7E89308A5CE112D29BD31984D04804C61F05ABE9D8EEE7299872CC1C3E353D265721136936E2D2A5358EDD748C7D7BF67BACD00D1C0C8E5E5175AD6996A3A5D37E16D6D13BDA491BAB2DB9CD903E824D45515D2477BD08AE40D47F77DD4F9EE79C397D8A3BEE781EFBF71FE0C2DA2AA115E8522002E1BB20BC0BAA45084510BA341CA914D21AF77E1181C7D5BC67BB94F58D4D2A491487349ACECB1F096118EC9266ED12C00B90B8C961A92BE33F00E9CDFDAEAFDDEB9A2C587373F3FDD9B9B9F5D5D5D595300C89A3C84DE37080B6D625C65A3A9D0EA3E190F138230814A59614BA9247E85A4E536DA06A335E2DF0BDBAB3AA8ADD6EDCEA8A63A617C6762FAF313B3FCB3FFEA57FC6DBDEF6439C3D779E1FFFD97FCC371E7F1CA420491A743A6D1616E75142BA682E6B9D7B8485500ABABD80513861AEDD218A43CA52B3B4304F96659C38758643070F309E4C188DC7E85C53D89C89B5EC8C879C3A7D0AF2929583FBF98EEF780D6FFE81BFCE773DF07A3EFD99CFF099CF7E9E300C989F5FF09214DCE8DF8F0E8DDDE5A45A150B216AC6BEE319559E50B882E5CDF58CD15C387F9E66D266EFBE156F74E7366B51B8E36D10684090FBE2E1348DCE573D8E9D2ED0FA637091178481AA071857AC7AC0E168114118BA5CC5F5CB1C387090F5CDCB14794E1CC78E5F659D3D4C18458EB8EA5D63A3280261C987998B57D3257991D5589E956E8860BDCEB2221A4761E48AA69B5F50961A3FC474D7CD3858C0FA7F548BB4C5D4B9F6FA9AAE6BB260CDCE76D65BADC69381522B6110124631A5D64CD209164B18862EB0328808E308E13F8F2F4C2EFBAF0255652DD3B8FAD8F75C329CAB05CDD5D7EA6324504CC6D8BCE0FE57BD9AB7BEF52D4471C24FFFDC2F7266F51C07F71FE0F8ADB7914D5CEAB4364EB48C0AD0798E294B42A5C8F38273EB9B2CCDCDB267619E479E7A0AA30D371C3A441247A461C8D2D21277DC769CAF3FFC18A3D1989B6EBC81F168CCF64E1785C4941A15845CBABCCEAFFF9FBFCEDCEC2CAF78F52B79CD2B5FC95F79D31BF9E89FFC3F7CF2139FA4D16892341B9E226270E8B1DB6C407DB4A99C119C9C48D49C23A9248152481512051151121184211B9B1B448D84BD2B2B4E9693E54471C4649252E4EE085614859B1A4A4589ACF9586114634A8BB216EB13BE4339D51A4EBDBD98162DE108AE699A72EEEC3996169739B8FF10274F9DA829055A68B432449EA16FB5268C220803A4126EC091E714BAF029D45EECACCDD4E154C92925464A2F1D2A7D87560D24F0AA03E331BC4A2E55E5024C71B1EB6BBAAEC98225A4DA09C3E87C10060E5FF0F61E499C303B3BE7E43A5A23A5CB300CAA24E530745A3A5D81E8F20A39CD159EE7152E85230D629C1FBCD8A57D83E974B0F202CFD30933ED98577ECF9B78D94B5FC6E7BFF4659E39799ADB6FBF8D571FBB91CBE75729C603F22CE3F2F973B4669C158C63493B1C649C6644A162A6ED720EC76946A7D9427BE780AD6E1725036EBFE52636D6B7188EC7341A31F3B33374B777505272F79DCF63301EF3C4534F61B465666191C2187EFFFD7FC81F7FF8C3BCEE81D7F3D7BEFBBB79E0F50FF09EDFF91D1E7BF4311A494C9424A8C021677AF70022709A47292B9B62E5A54E0A25438230248C02E2A449BBDD66766E9EA53D4B64E984EED6264B7B9689E398F168849212A302A42C3C703FA50F54C07F104ACA503A5E971514A5F6941017D7F65C53C34ACA93C431DDEE0E172FAE71C38D3772E9D245C6E331CD56524FE684573BA820248C1DF1B82C5C1C5C5116281910A8982CCF1CF541294A2FDE0E944205AEC83A53C8CAFF6A3A9C115E301E04B226E51A6BD0A692FF8475F4DCF5355DD764C18AE3385DD9B76F3B6934C85217336F82802CCB198F8658D32069B6989D9B676B730B102E1DC6999283AEBC9FAC37B703ABCD956F362AF1B0BD0260AE3FCFB4031352A28B82324D3972E4102F7BE52B989B5FE02B5F7B9883870EF3BDB7DF417FD8E7F4D34F22C30825638AFE80853D7B9DE8399B10264D5081CFB483719691841183E1908DEE36CD28218A63CEACAE62B425899D78B8284B02A588A2165114321C0E3974703F33331DBEF1F433EC5B59E1E0CA0A7FFEE5AF21052C2E2DA10D7CE0F7FE804F7EEC13FCB5EFFB5E7EECED3FC2B933ABBCF777FE0BA72FACD16836889304B028BC47BE5220054A7AA6BE74A11D611810C5317114D39EE930373FC7DCFC12B39D0EF30B0BAC2C2F73EAE4339C3D7F9EF9C525DA9D8EF7A32F76F9BC4B7FCCF4F167FEC8A48200A305426408696B867B1004530D687554F57404E7E4E1280AE7CE9DE3E80D473972F4061E7DF411EFCAE09C5CF322278AE35A5B1A042165E88EA9C6C48E13264B0496B2D4AE2BA702D3DD3132CF3347BD90C2E37B155450E1A45E8768A8B59D02055E3B9A5FB79779D6BA360B5614A541A0CE1AA3513E0ACB5AC71A763E4A317996914E26349A0D06839E1B4F9B2AABCF67CB49A7A417DAA5D2505BA338C7C9E73A265E6D7B2C80B228B065C9ADB7DFCA0BEE791149A3C5FCFC1277DF7D0FABA74FB17AEE345B9B5BA4E331FB8EEC050B659E11C63193C98454294683213BFD3EBD6E97F168C4703CA2C88BDA02189CC19F35A5F7300FB0F602CD464C690C339D8E8B8A3F74803D4B8B5CDCD8606BBBCBADC78E1129C9F2C21CCD6683F5CD6DE22864E5C851C6E311FFE9DDBFCEC73FF671DEFEF6B7F30BFFF49FF0FBEFFF433EF5E94FD3EB76999D9B73492F168467AA2BE5A67141E032131B8D26ED9936339D39E6E6E799999DA5D399617E6E86248E88E390FB5FF10ABEFAD5AFF2CC8953CCCECFB963FA685CF3ABAA0EA4EA42DC912F4048830A04DA28841768EFC60E2B5DA8A8E44FC2B9792AA568361AF4767A5CBA74895B6EBD8DD3A74E90E62961D8C6A06B3F7863B5CB090C0212919091A2754918054C5253BFA76A99BC777FA8290BC6F1DB84921EC792BBA0046F0B8D03DEAD346853788FF7E7EE12FFFFBEAEC982F5F7FFF69BCD3B7EE6E7D7C32060381A1127099DCE8C0BC20C42A224460A416766A6B6B70DC3C08DCBA5026530A6C0333BDD21E12A5FABDD7E58574F0C77F3B04A4FC8DC77E800478F1D6361710F371DBB8976A34951146CACAFB3BE7E89288A989B5F405ACDCE7617A1149BDB5D4E3CFD34DB9B9BF47A3BA4698633B3A33624744753A7130C94440431DA18CA3C030BDB9331411830994CD85ADF607E76D64DE6B01C3EB09F7EBFCFB9EE36DF76EB7136B6BB2C2C2CB0DDED72EEC21A5648F61C3EC685B58BFCCC3FFC49BEFB7BBE87BFFE833FC83DF7BE88DF7ACFEF70F2F46996F72CD36A36B1D62045401004C44942D24C68B5DB74DA6D3AB3B3CCCDCC33333BC3DCEC2C339D368D66C3A5396B57605EF3EA57A3A4E291C7BF41ABD54685012213DEB56077B087A9A7A09574285081C391ACAEB58B1507EC2AE9B5FF6889E398200A397DEA3437DE7023070F1FE6C9271F77163906EF5FEFB039A514CA5B235736D922CB5C4250E0061DCAEB0F85975A595D154DF778D249EA5F26EBD9FDFEBD218C0BC63516AB4BC721F6C30B79155DE3FABA460B16808AC2E1C2E2D2706B73BB9D3752B22C467BDF736B2D7192A0B523924A29C8B3DCF95F95A527033EB7815AB521FE326751984E0FCBD279804B01499270E4E80D7CFBCB5E4EABD5E2A31FFE10C6C2C2E22273B3B37466E7184D46ECF4069C3C7B8167BEF1301BEB97D1069791D848985B9827495C56A2D68EBC63005DE89A6EE1266A8E4DAE4DC569D2683F5D5C1B5E808B976824313373B35C585DE5E0A183341A0D56CF7E8D9B6EBA19632DA3C1082B24C258F6AC1C20CD267CE8831FE4CB5FFD1AEFF8B177F0CF7EE91FF39EFFFA3E3EFEF14F23102C2E2EA0A4226E24B43B1D5AED16CD5687CECC0C0B73F3CC766668B59A7466679869B78823A7405081F236D405CFBFEB2E4E9C3E49BFBB4392244C844BD4B1551A91995AD258AB3DB065910A421B81C928FD74D71A830C823A1056548301CF7B5241403349D8DEDE62F5C2798E1EBD9133A74F934E26CE5ADBD3152A6CD3116625719C9067394118912445CDC5ABB20F2B533FE57FB7D60541141086A19F1006BB8C0D3DEDC53856BB1016A3AB49EC95CE14D7975BD76CC15A5A5ADA39A5D4B610B4C328224B338AA2A4D968501405FDA2603C1A13C5116114D709CDA52F5855C8C4D51E56BB5372AEB603DEFD06731EE011593A62766E96EF7AE39BB8F38E6F23CF330CAEBB1BF4BA2C2D2E30BFBCCCDA85353EF7D9CFF3E8D7BF426F38A6D36A72D3F19BE9CC2D1237128C8532CF31C679AF977941516AB429D16549E11FABD606A501E19C2D8DD60E24B606A2C8496F8A8234CB986C6C8015AC5DBA4C6F7B9B38498892185D6AE250B177651F2B2B7B190C86AC9EDD6176F9201B5B5DFEB777BD8BBFFDD6BFC95B7EE06F70FCE6E37CE0431F222F4A0E1DDA4B943468355BCCCECED2E9CCD299ED30D39961A6E3BAAD4623218A42923072244A63504942BF3FA0DBEB73C3D11BF9FAD7BFC6683CF21EE7DA2B97AA23A1C5A2EB2226AC03C78594F5F0A3BAFED23A613B9EFF24BC2BA8F5C67B4992301A8D583D73965B6FBD9D95957D9C39739276DBDF708AD2DF9C70EE145A13C7215914F9C4A210A51C8FAC66A5091F3F0F8471EC49AC0EBF727227E9FCCDBCC58F83415DFAB333012C9D9D9177C8B8BEAE5CD76CC19AE9B4369BCDE67AB3D53E1C4591B3DF0D03F22CA7C80B6666666BA3B8288E89E288D1687C859CA42A48BBE90B153E52E7DC3D078665011586A4FD1D9AB31D7EE2277F8A17DF7B2F9FFDD427B9F3EE7BD0BA244962EE7DC91B5051C27FF8F7BFC25F7CE1735821387AEC265E7DEB6D2C2EEF75DDA0D6E4454E9EE6A4E9B8B68EC9F2D43933A48EB75494B9E333952545517A61B7454B596B152B505A86A193C1786788FE60443F9BB0B86F3F274F9DE5C2853516969678C1F3EF4048F8D2B9B3C451446BC6650116F984FFFC9BBFC9534F3CCE8FFFD44F71FC96E3FCDE1F7C006D058B8B4B4EA73833C7FCC23C9D990ECD4642A391D069B5692631083755D3DA501A8B5482B107C1B3A2607E7189D3A74E11C791E7364D0340F0393D156DC13025884AA55038D0DCF81C40150498EAC8EE83452AC1B4548A288AD9B87489EEF606371F3FCE85F3AB0EB8578E5251F8897192349CC6D2E89A5356C302089776A3AD37E6ABA2D5F03743B7CDDC31B0ACDF630E6270C5D409BD1D77CD815E2EC8E2FABA725DB305ABDDE96C278DC6663A99301947244DB7D94A9F4537090327AFB05300D4052104BECB3257F08B769345FF32267BFD6F54C8A4B745BBD5E6677FF65DBCEE8107583B7F1E103CF9E8C3EC595EE696DB6EE3B1C71EE177DEF31E36D73778F1CBBE9D17DDFB629656F6F9C750B8C2E48703E938259D3839D17832464D5C306C1C954EBE52E6A4598A2E5D6A4E9E3BFD5A5114E85261B4A6D40E7FD37E331BE1A655711263A290ED6E97AD8D4D6418B2BDB9C9C54B97595A9A67D0EF32B7B0CCF19B8FF38507BF841182E58337F0C5BFF80A977FFAA7F8899FFE197EFC1FBC9D8F7FFAF364938CFDFBF7D36EB7E9743AAEB36AB5084345201551142055E0DD41355249B22C637D7D9D5E7F406FD073E93541C0A0DF270C823A821E2A17546A974FFC91B11A92482B315E22541726E13A2B8441E0DC212AFB9C388EE88D065CBABCCEBDF7BE8499D95986A301CD86C3E584A52E2C611892E76E3A290367B208104885A63A926BE77A682DC3E180C5720F711C7AC0DF4E397DBB13B371EEA3D3CF79275A79BD605DBDAED98225A41A2BA5368DD5846144A3D120CF3392861BFF07618CB58646A351E717069EFA50D9235745CB29E99F7D34BCDA5DD481E08AC9608B461CF1533FF72E5EF31DAFE5CC993300DCF6BCE731EAF530D6F2DEDF7D1F5FFCC2E778FEF35FC03B7EEA67397AF428E964C276778B8B972EB2B3D3633C183218F419FBC82E6DDC58BDF24B574A11262179AA11A520542161E0021C2632454AE76B6FB4262B0B82D2A7D5149AD0C7A3BBC4648B06441862026F6698657CF5AB5FE1F0E143BCFCE5F7D3EBEFF0CC538F93A72E164D09CBD2FEC39C5DBBCC2FBCEBE7F9C97FF84E7EE0FBBE87279E3AC9643266CFD222ED568B6612BB108B28F080B30063EAA8F8526B36B7BB6C6C6E33EC0FE975BB0C077D04CE02C71A8364CA55128E094AF57F61FD714C5AAC16DE56DAD9513BBB2FF75CAD95FEC683B372B1EE2615C61122083977F62C77DE7927070E1CE4F1C71FC5E28E6C465B6F9F1CB888B12822C8B2DA1E278A024A6531A99BD0BA901F37558C82080C4CC6E33AB8A3CA49AC6E8695BDB331DE7DD5236EC6D8EB05EB39D6355BB026E374DC6AB5D7C330C4609D10D5BAB050974757D06CB5692431674F9D220C02CAA0C44C5C1842A5ACAFBAB0DD53C1DD8CF62B720795221DF610BAE047FEC1CFF2AAD7BC9673E75729B28C200CD8B3670F699AF2DEDFFE2F0481E297FFC5BFE696DB6E63736B8BAF7CF94B9C78FA197AFD1E83DE0EC3A10BC9288A82B22830DEA15329E5CCEEF06E11D215AF384A1C61D34782C5914BB949B30C5D14C830446B17645A06DA5BAB689471CEA1A2B60076C79A2889C9C663CE9C5E656E76817196D11F0C79C98B5EC0B98B9759BB7809AD87249D39C6E9847FF1BFFF4BB6B7B679FB3BDEC9766FC06830A0DD6E127AD58014121138CFA8DC77B008C1703CF97FD97BD3584DCFF3BEEF772FCFF62E679B3367CE0CC9E150144991A26CC99614DBB59DC8591A3441622780DBA6418B164911340DD0E4430C046AE2D445501468D2B448D038483FB44801C74EDB248E1D27B1947891BC482229525C248AFBCC9CFD9C777DB67BE987EB7EDF33A4F3A1C9171143DEC081484233E4BCE73CD773DDD7F5FFFFFE1C9D9C727171C1F9E49CE94C880CAE77B4CB25B3BE4FA9D78AE02146CDFA06BE268E268A441A8CAB6852EC98C018AD36EB0C46ADD22F16D03CC648C2F3D9D131D3E98C876F3DC2375F7989B6EBC8B22A0DF03D99CD1854436208D47A81D212DFA518329B4FF15182239436582D61B6C66614A5B82C7C2FC11E56D904F0134A434C211D2278D004650938740C29ADFCC373EFB96F0BD6CB2FBEE8261717A7D666CCA733B6B67728CA9218234D5D538C37180C072C170B86A3311793F3F57034B2F2034682BA04F5C1A56CE15E9FE14A1CDAD60DA1ABF9F13FF127F9F7FFD01FE2CEDDBBB4CD923CCF0921F0D65B6FF1D28B2FF1A33FF6A33CFEC4E3BCFCCA2BFCBD9FFEBB7CF3951739393EC639CF7834A62C4B94D66C6E6DA18D910CC0C4055F2551776D4BDFB52C9742156D8B56B687C1634C4635A8305A51E63994056DDBD003B6B238EF70BD47DB0EEF34CE78742F63639736A00A28AA21DEF53CF3EC7328A578E0E6433CF8E04378346FDD39C0350D43A32806155DA3F95BFFEBDFA2ED1D7FE5AFFC244D7F958B8B334CDA768520C93A9115133ED0740D17E7174C2633E6F3397DD725B283E7E2FC94A3E363DABA473D2010BCA66DD773A2D57917F140C9752A6A2E79EB5EFE5E1995E2D2128A3A217414A27C9F9D5D707A7CCC777FEA5388E0B86134188B7C441BDAAEA10AC3B530A21A0C707D4FD334F2592A85D12283F129155B3A33475196A9234B5D940F18ABF189F0A0954ECCB108F8D4790980F0C3F3EE73DF16ACBFF93FFC77E18FFD89FF6C3E1A8DD3F6CCB15C2ED8D8DCC0F53DCB7A813A55B46D4B96E71445C57C3667A5675A8947FF4D1286CB816942B929255151F584EFFFF77E983FF61FFD49A6B339F572419659EAA6E1DAD5AB5CDDDD452BC5F35F7F9E9FFB073FC3ED776E63139FEB91471E456719CD7249DBB689D7D513BB4EE66C2BFE94D6A014D560C0783CE6EA7E46F081F97C465BD7C418E89A9A663927CB0B8A4A14E983C180AA1CB05C2E5151638B980CDF29D0545B195A3BBF46FCCA9F35C3A3F0C171F7CE5D7EE54B5FA20B01D5CE78F2A94F901739CF3EF7026535C08E36F93B7FFB7FA3C8337EF2277F12A3B6B938BF58DB976290641B1F3C6DDF717E31E3CEC10167A727B44D8DEB3B96F305C707871C9F1C52D7B2D93D3A3CE4FA03373016E8FDBB3ADDD51135BC6C0F25C4C380EF91B0D2884DD4C1D5F57155B4B4D1E47989070E6EDFE6939FFE3457AF5EE3EDB7DE486113B26595305A21886E6C6C309D4EF1C97C9DAD88A438B124194B56E46479B6D65CAD14EEC6582289DAAAC07BD611723E7640C49A82102279F6A135E7BDE7BE2D580079592DBDEFBBBE73F96038901955D3E27AC7EEDE558ABC643E9F331A8F25CF2E04ACB569CB26035B6B8D90271355F35E19438C411E44A09B9DB3BF7F831FFDF1FF0463732ECE4E64B8EC02371F7C90A66DF8999FF919FED517BF48BD5C72FDFA0D9E7AFAE374CE717176C1D1F191CC5D62229E9AEC127BA3E401BBF4D25DE6FAADBABCBCC8188D4768A5592E169234DCF5CC2733308ABAEE185603C6E321BD7332ABD30A63451BE44C8F6A14463BA156F482242642B4128AD13BC79DBB0744E778F4A38FB3BDBDC5D9F9053FFC833FC0B75F7F8393F30976B8C1FFFC37FE1746A3313FF1137F91B6ED98CD666823A1A94DDBB16C1A4ECF2EB873F72E0707079C9D9D717E7ECAD9499ADF9D9D4BC14CCE82D97C4E7576CE7873C4BD5DC7BB30D42A0A5E395D698DD1B82857E7F58B4527A70E88CE09F95C6D9661F38CBB47875C9C9F71FDC675EEDC7E07D73B9C9564A52CCBD65A2E9133A42D61B26C05123F2D2A828FC9402F1A2E9B65747D0F51A7B83797424004052DE25297BEC726E9003DC67E281C7DEFB9AF0BD6F56B7BF3B7DE787DB9AC97F9C6D6E63A5EBDAA06441F69DB9A6BD7AF73747848888A3CCF59CE976B93AC772E753461CD7ABA1735A31213AA6D6AACB5FCFE3FFC8779F8D18F70767A42F481AACA180D87FCAB2F7E919FFBD99FE5FCF49C471F7B94BD6BFB9C9F9FF3DA6BAFB35CD6382701A75559312807223948F15A9799C92BABC72ADB4E1EBE55B7D1773D7DDF41546479CEB51BD7E9DA96C9F945B2F0F49C4FCE592CE76C6C6C301A0DE9BA9EAEEFB03A607586311D2E25ED28A571DEC9EC2C15C9CC5AFA084A5B868321DF7EED3536466329D85D47089EB22C716DC94FFDD44FB17D65873FF5A7FE3475D3D234354DDB72319D737C7CC29DC3434E8E8E383B3BE3ECF48483833B1C1F1D339F2FD61AB715533DC6C874324D70428352C6E81DE3000020004944415497B4D17711624D2406B9F249B8472478875671CDA052F7E4028AB9304A406C9E339F4C984EA76C6FED40A29A9A4C0081C2C0929717D625201FC2D07212A221DF1911F1FACED1368DCC138B422C4CA9CB93970CC9D00E97E869713184E0E4DFA9EFEBC7F3DFE9DCD79FC8D6F6F6726B6BBB99CD66CC6773F23C67946C21F3F98CACC80921B298CF93BB5EAE45F61E54729F584D266D9E56C56C7545F421109A9A4F7EE6D37CE6077E88E3E3237CD7737D7F9FC562CADFFCBB3FCD577FEBB779E2C98FF1E4531FE76232E199679E653E9FA28D62341AB3BB7555E6560AFADEAF1FD87BB55E6B51EA3AAF2E791F8D587314A45CBB40D77534758DB11957F6F670AE67369D52CF17746DC3E151CD6030E0EAEE1E6559D2750D5D27A9D23ECBD0B645372DBA97DFB707C1BC201D670881E79E7B9E9B371FE0A38F3DCEE1C11D0E0FEF500C36E8BB8E6A386231E9F8FC5FFA3C0F3D7493DFFD7B3EC7375E7A85F38B2987C7C7DCB97D87A3E313A6D30B8E0EEE72F7EE6DCECE4EE93A2F3A24C29A6E11111941D3B5CC6653461BA3774D7656115B9720BD44D3008C46C4B3444416AC2FE7F49086F632AF2CF382E9D91917E7675C7DFC0944BB17B1C6628DA1EB0524381C8E12CD034C66A98A8ABEEB89B127229F91361A6505B1B3C21CAFE4242B59837456E0420F5E16362B73B477E29134F6BE7E3CFF9DCE7DFD89186B8FA2E2C27BBF6F8D21CB2C5DD7717171C1D5AB7B5CBDBA87564A502E4707945545D334344DBBE61269A5D70114BF13810CAE69A846233EF1E9CF52D735EDB2E1FA8DEBBCF0FCB3FCFDFFE3FF6431AFF93DBFF7F7D27BCF0B2FBCC0F1F131DE3B76AEECB0BBBB4B9EA5B8741F2065D4697D99BFA7D58A3375C9D68AE9DA88166FFFEAA868D12A90A96C3D039BCDA66479C6CEEE15DAE190D9644ABD5CB298CD68EA866BFBD7D8DADAC6F5C2DD72BE172C8AD1E27F5BAFDF13D430F9F44C9E733E99F1E6EBDFE6CEF1093A1FAEBD7BCEF50C3677989F1DF0DF7EFEF3FC9D9FFE69FA6078E5D557994CA61C1F1D71727CC8E1C15D0E0FEE329FCF0981347C0EBFE3732615F0A6A9294ABBFE2C04C9BC8A525C29CDD3E03D263CB38A408AD48E9A35F621FD7A9D20CAC65A426851C1B1776D9FB2AC582EE6A2174B2F2A6B0D4591A39DA65E2E288A12D7F764C6D2698D4B8C30D1974A58AF369AA669E8DA8ECC98B5A66F35D3125FA82144D18D4502DACACBCADA0F650DEF3DF775C19A2FEB132227D68897CB18435116EB6B5DDBB664D692E7055B1B5B9C9F9E26A7BCC6F55E660AE22B06B8BCA6AC8CCD2E10BCE789279E62EFDA0D0EEF1EF2E04337F8CD2FFD3A3FFB7FFD7D1EBA7993EFF9ECF771FBF63BBCF48D6FB0AC978C37C63CF4D04D06C30DD9242525B5CCABCC7A6E1513C95227209C527ACD3E17385C580720B8C4828A4482BF945BE4794608961802B3C9942CCFD9B97A957AB9607A3661D9D4BCFDD65B346DCDC3376F311C0D994E2EE8DA1426AB91875AA9F533BE42EAE455C9B26D78FEF96751F9887238946E22FD5FBD736C5EBBC1CBAF7C8BBFFE3FFD0DFED49FF9331C1C1C71F7F63B4CA717BCFDE65B9C9D9DD2B6ED3AD1F9770ED2D3922331B19C0FF49DA7282F73093562CDB9FC652BBFE06ADEA4F13E0590DCD35EADB13589D96F324BD4392727672C974BC6E30D968B392178BAAE93A090B292F009ADA5C8244C0C5A4932B6D72863658A0010A1AE6BA19D6619ABA1BFD2AC757DD20B82C48D09D54125EB4EDB361F0613BEE7DCD7056B38182C373736966FBA5EE06B89C8A0B5A6EF3A2617E70C872381B0194D911762BB088E1074C200A7373FFF860E2BF40C87150F7FF46378D7B3BDB5C96FFCDAAFF18BFFE4E779FABBBF8BEB0F3EC8D79F7B86375F7F83A8E0DAFE35F6F6F6C86C960895AB874656E2CA68E15DE151468B242088ACC1F74ED025E9AAAA3429C75002574D66092E88C89A55A27112B326B85EDFF52CDA8E6A3860672F279F4E58CCE71CDCB94BDBB43CF9E4533C78F3614E8E8F99CFE6420ED586A5AE59E515AEF45A2104B2BCC0D8AB090BECD633B6958C2133969DDDEBFCC22FFE129FF8EEEFE6816BBBFC8B7FFE0BD48B05F3F902DF4BD003C07BF56DAB73AF550AADE87A41BB28AD509773EE7729C7D729365A0A520AFC21AC98F829B926C55360B470DA95C9383E3D63B958B0B5BDC1D1E15D29D85606E531CAF769959214BCC73B2781BC51A1A2C60787B5C2B0D75A0B15C2187CB2F9E4AA48DA2ED05A585B3E06792968C1D1AC746547C72767DFE967E8FD76EEEB82B5391A759B5B5B4BC9DA7312E20964658E3162C1198D465483011717E729C1C6405469439692615201583DB04012A106AEEEDF60E7EA2E1B1B635E78EE19FEF9CFFF029FFAF4F7B279E50ABFF1A52F73E79D7728AA92876E3EC0CED615541AA41A236F7B83E051BC81860E030C6389ED4B5C1769968E7AD1B058CE99370BEAAEA58F3D512BB2D20A736A5832284BCA22A3CC338C96548718825854A214B62CCF71CEB19C2FB199616B675BB469A78AB3E3539E6B9EE57B3EF3BDDCFAC823DCBE7D9BD9C5443E0FA5811A99524B5C95438A96D10A1758C30E61E5F68BCC6673B63637514AF1733FFB0FF8B37FF6BFC22878EDD5D7D8DFBF4E3432788E210AB3EA3D74827B8B954A7AAE981275B45662C1898929A5DE9348B41AB403262251F0EB6BE3EAF75F59AC344689C2BF691B427094D54050C7519C0EBD73B44D4D9E6FC8E7389D1221CDBA7ABAB695978DF72855608CC587C0A01AACF1DCABF830599644B4096893B230A55724226E04C587315FFFA6735F17ACA66B3BA5D4BC2CAB3550CD66199148DDD46C6E6C02E227DB186F70C09D946715D7A9CCAB413BF774582A0968148A076EDEE2C1076FF0CD97BEC12FFDD35FE0E94F7D8ACD9D2BFCD697BECCE1ED3B541B636E3C709DEDCD1D1928C798AE1312739E15394BDD133BCF8E1FB0193728FB92591D98B42DA1AB09AD069FA1428E8A6E9DEC534F7B96BAE56C32C75A43392AD8180E189625656E28AC4E6244B386E1596B65B5EE1CCBBA26CF73F6AE5DA3C80B4E4E4FF88D5FFF323FF0833FC8934F3EC59B6FBCCEF1D1F16A7F258AA6C4A25A39F8882BB28517D1AA36EB80551F02F3D98CADAD6D5E7EE55BFCEB7FFD6BFCBECFFD08AFBCF032F3C592C1A04A2F8275A4E2BB5862EFB63CC9D5D8A44C3F63933F10991B8964413AAB2CCB64F68413C37182F741B2564942ACFCBDD2783CDA26037227D1616559A59792E8D2CA424251BB5EAE87799E090267B14C10C540443A381F65F101A923B419653590CF2C0859C22A08C1CB4B510B464747850E394175C4E02517F1C3F3AE735F7F2277EFDCE9BAA6B9504AB1A8976C6C6CA6E0548731A2248F110E0F0E25563D3DCC11E41AE064BE217979F75C5B10844851553CFEC4132C2653FEE53FFB451E7BF2636CEF5DE5B7BFFC1B1CDEBE4B351E70FD817DB6B7B6B1C62644AF0C57ADB6E8CA70D24EA996F05DE661F6CC2E4BA7B8F03DCE3668324A1388C68333E8BCC03A4BEF5B21530605B942E5063B28C8F20265357D96A173112E6A57836BD1D1109549AB74114C062F8CACAAACB8BABF8752707878C8AFFDCAAF90E5394F3CF9718C7E99E3A323B9BA29D9BAC5D8101363D3BBCB19DC8A45A5D2DCCB684DD7F7345DC77038E60B5FFC227FF12FFE057EEFEFFF1CBFF0F3BF4855EDA76BA4E8D956C3F5DF118996422D24F4411322A22A27109C63EDBD4B2F82D3B33306D5803CCFC476844EA1B049598E95A6312AD01AAD225A4B92B4EF7A4290E4E7E0A5208A30D8614739C10789164B7E416DB4CC32839016560126DE3BAC5634CD92BA5EA6C8AE15545078659164C65EFDF3B8C2E068820A0C0683EFF423F4BE3BF775C152D069ADDEB6D63AA5B56D6AD1026D6C8C01383A3E627B6B0BEF3C655532DEDCE4E0E080B22C59D68D0C7557D4CA7B94EE21045CD7F1D1C71FE7EAEE2EFFE41FFE1C57AEEE73ED818778F6AB5FE5E0F61DB2B26077EF2A5B1B5B64365F0FA3438814B92558CD5B877779A01FF143DB9F60A7D8E1D477D4B1A15760C92875A4559E2C14F4316055C4C48C102408B618E5949B63B2D11033A8305650BD31B04EB696009648E65B0C12271F95115F9B15785CD7B76431637B7717B4E2E0EE1D7EF95FFC126555F25D9FFC245F7FEE594E8E8E8988A5C647476C4474B9BAD2ADB445C254D7AC1201B531344DC37834627271CA17FFF5AFF2FB3EF739BEF29BBFC9C574C6E6C6867CAFD240FC777656327F43C9A549A7387B15C06064E0AE2256CB15ECE8E49422858F903685F292587D1FA59BB94C45922DA14A85CB3BD14FAD36A53E8AACC207A183C624E0AD970B9ABA96A05AD94EA490D440614B8AA222A66545DBF5746D8F35828E91B41CD6DBD7182E97193E7A4294EB765594DFE947E87D77EE6B29ED5FFF6B7F35E82C9B1BAD5C5BD7B45D8B56A2295A2E1634CB05C65AF61FB8CE683C5ECF36E487F3775E4D401E221F2355A6F8FEEFFF3EBEF1EC334C2E263CFAF813BCFC8D17B9FBF66D8CD16CEFEEB0B9B5439E17ABCB1321048A3C4395192FBDFE1A0F5D54FCF8F51F627FF301CE8DA351014C86351919995C21B5C11A4B9E1254AC2EB972E52A376EDD62FF231F61F7E62D36AEDD60B4B185AD06D8A244E7169D67D83C271B8CD1E36DDA6A83DE5A540C98204366ADE4CB26467D089EDDDD5DF6F7AFD3B61DFFEC9FFE3C8707873CFDDD9F64BCB54559960C0743AAAA20B356703CC6AE2518D69AD45DC4F5556F151CDAB62DA38D4D7EF3D77E15E71C7FE447FF28DD7C261DEC7A107E897DD649AC698CE8A9B214656F338BCD250E1EA4505A2D2AFCC562C17FF8633FC6DFFFDFFF1E4F3EFE38770E0F3046A14C0A8188ABFCBF140CAD81343DD2ACC4BA60F38CA22864639B0A725114F21945118D86A4ECEABA6E9D14E47B7949F8E0C9B34C7C8B2886C32179915DCA51D2F05E912C3B4AE40D0179194806A3174CF387E75DE7BE2E5800A3E168A98DE942B8E47DD7759D92933799CD662CA633CE4ECF709D23CFF2754ACA65C182F50C4B297CBBE489A73E4199673CF3CC57F9D8D3DFC5C1E101776EBF43F481F1D688ED2B5B0CAA0AEE2956799E416179F6C59778ACDDE14F7EFC0F6246438EFA057D34289DA355465019516BAC3694DA905B8D51914151F2F0F53D6E3D7C839D1BFB943BBB501678D7D2CC262CCE272C4ECF69CE27B4D329AEAD09AE432BC8CA0171B4831F8DC11A21902AD0C61295C473F59D30B8B6AF5CE5DADE3596F305FFF8FFFD8734CB054F3DFD3483E198B21C5016F200DA2C152C7309A4CBB26C8D4C5929F195D174CEA1302CEA962FFECAAFF2233FF2391EFDE8A3CC265349C159FD40EA54488D9142932404665520B526CFB2948CB30A05512C964BAEEE5EE573BFE787A906037EF0FB7E174596315F2CB0265B07C02697F45AA91E834A62D29804A891B66DA510A5849E55BC7CD7F764364F31666A8DBA8931E27C87478AA8F32236D648428F04F33A5CB854EE8BC34B28A4429948A89954E8B5520C86C3EFF4E3F3BE3BF77DC17AF0C68DA62CCBAEAC2A46E3712A1C052083DAB6A9892130A82A424422A9CA2289462F832756DE3DEF03B9B57CEAD39FE6CBBFFE6BEC5CD9232B0BDE7CE30DBABA262B2D5B3B3B0CAB118A4B148AB5967C50F1ECF3CFF3D0BCE2BFF8DE3F84CB0D779633BC32A02D514B3B618CA1D49A91D6945A1354A4CC731EBB7185476FEEB2B33BA6A80CAE6DA84FCFA84FCF584CA7B4B329EDB2162A695DD32E17348B19F56C4A339DD02D96D4DE5217237C966393A0523A1AA168BADEE35CC7D5BD3DAEEEEE717478C4CFFFA37F4455943CFCC8239455C1A0AA28CA428A8815D0DCBD5DD6A5F524755929ED4666591B7CED377F9DF97CCE1FFFE33F46BF9C27C284491D964619D9A29A154E27C1ECACC9502A27B315836AB8D6B1196BF9A37FF00F92DB8CBFFCF9CFF353FFFD4FB1BFBFCF23B76E268AACE087D7282D45FADEDACBA08A846156D6CA56B0EBD23C2E251F3987D646E68246D1D44B7C7A098678A9F38A5166595189D6CFF53D6A2585882B5BD54A5FA652249A5D030A4184B72E38B6D252E8C37379EEFB8265B2EC9D3C2FA65DD71192899518699B86E3E363F94132966B376EB0BB7795B66FF1AE97787B25960FAD4DCA97D374F3739EFAAE4F727272C4F1E1310F3DF2115E7FED3516938974571B5B8CAA8D94E4BB32292BCAC180AFBFF022E373C79FFEFE3F4A309AE3C514AD2D9D52B4823420A6A16DA93543ADB040A10B1EDFDFE5D6033B54C312DDB6C4D9049A1A56436F6D255A2BCBC5D291AC1E44BD0EA670AEC5D573EAA665162DBDCEB06A254EB5D2D9688DEB3A5C705CD9DBE5CA952B7CFB5BAFF2857FF14B6C6F6DB3B5B3439667E4B624CFB294F26CD65D16B0EE40563694B0F206BA1E65349359C7FFFDFFFC633EFBD9CFF0E4D34F339DCE306956A58DD837B556586B31C6627486369900F4324D51E4548381140B1F124FFE21AEEF5FE393DFF3BD381F78F99597D9D8D8C058BDAA51B2ED4CBAB715717425D28A917524FDE6F616208543F0325248F3AC60B1100C4E9EE522EF70122F66D5255921220668A5154DD3B05C2CA430599B801BF2670D4136ABE22A9217A3A06934448D5DBBDF3F3CAB73DF7F20CEF5175AEBF92A465CB8E6FDFA6D5E551575BD24F8C0B0AA4413E5535B6ECCDA7BA69350D06639B71EB9C5ABAF7C93076F3ECC6432E5F4F898BE6D298603C69B9BE4452E6F7019B3331C8D78E3ED77E8EEDCE63FFFCC7F40558DB83B3F036DE894A68F2AE9BD92BE0B910DF808262A9E78608B471FD9A1280CAEE9C03B3220338AAC2CD055811994E4E50093E5686DC9B34C58F56549510D288A12633379609D13DB4ECC68944509194F7C8A5A7C6D6DD3A08D61FFDA75C6E331CF7CED6BBCF88DE779E08107290AF99C742609C7D648BCD76A2E23A8E94B63F26500840CA0CBC18067BFF21B9C9D5FF0B9DFFD8344DFA2B4C21AD936DA946B686D46662D5966287243910B2956294D3918500D066436E3E27CCAF964C25FFBAB7F99BFF0DFFC3906C331F5B29197C6EABA95E4E7D2F4A560D6958521CAF59018317946D7362CEB459AD19935B226462F048CF97CED2975AE4FB336917648686A5C3B0FB4569465297AAD10D6D7655098D4E185E8A45025653EA9D88F8643F79D7E7EDE6FE7BEDE1202DC7EE79DA535661E63C005992B8418E95DCF7863233D1C96BBB76F73717EC6786383BEEB393F3BA34FD4C8AEEBD0C6B29C9DF0D4C73FC16C3AA36D1B76F7F678E9E517E9DA868862B83166505612E5A444F8371C555C4C16BCFDD2F3FC918F7E3FB7AE3ECC5BD35350861ACD32B07ECBF7E9CA605281EC7ACF8DDD111FF9C8151ADF43DF30CA053D43D47421D2752D2C5A9AE994D96C4ADDB6345D470C0E34D83C67500DA906238AC1101583104883A7F781A9B66C68C87C87528655CAB2D1917AB960341CB3BB7B95BB07B779E6AB5F61341CB1BDB3C364724ED6197A6D84538525DA484CC1AEABBCBE90903DABC2E57A872D2B4E27537EF997BFC01FF8037F80877EF90B4C26133637B6200DB0E59A6A2FE3EEADC1980CAB3536B30C860306D59066591382673818F0DC735FE74BBFF515FED3FFF8C779EBED77F8C2AFFE2A599E03AB39E40AD120C1112A619359F1AAA2A7AA06781F99CFE6325C8F111520CBCC5AD86AAD65D12E68BB763DDB5AA5E0C86C6A05F35BF5757274FA6C451E23693C462717C56AECA0144A8BECE5F917BE71FC9D7E7EDE6FE7BEEFB0B2226FCA41D5E4798ED68ABCB0EBAB415DD7CCA653DAAEE5DAFE3E7BFBFB545585B51A93365EC17B2116B81E6B2C0F3CF800770F0EB8BA7F9DB38B0BEA6543DB34D83C67341A9225B19FF79E2C37289DF1C2F3CF71BDD8E6FB3EFA59DE5E4CE8A2A241D1C440489D5413220E19FE66CAD3B63DC351CE134FEC9297D2E955838CE128231F66949926EB97F8D919DDE48CFAE29C8BD3234E0F6F737EF71D2EEEDC6672F72EA76FBECE5B2F7F9D6F3DF735DE7CF1792E4E4F5136A7AC469499A4CC2C634E67328C4AE44C2301A1A0982F178CB736D8D9BEC2C5F905CF7CEDAB841824EC546B8C51728D334997B4326DA72BDD8ACE0A97C66D94A06A9EFDEA6F73FDFA757ED7A73F43D3D4984CA7799818D5F3CC62B35CBA2D939359435E966445C670346477EFAAFC5E5946DD34FCB37FF9055EFEE6B7F8AEA73FCEAF7EF9B7B87B78C8EEF6F6BB1034F75E5D4972584902F3F8BE677B6B833CCF98CFE6979A3005DE47BCEBC9322B61AA6B5E986C06BBDE2506BD085743F0EBDCC1BA69E85758E824B520E51012352A7948954A21B04A9359CBC1D1D18752F7F79CFBBE60B54DDB10997AEFE953A7949785240F57A580E5BA1E1454554551E429DA5E5A7E006B0CCBD99C6B0F3E84F39EE9E482CDAD6D4E8F8FE8BA16E71CE54006D13A0D9C35301C8E78E7ADDBD41747FCD063DF83579649DFD345452F7006142119610326066C90908810E0B147B6D9DCAA880A06A38CC1B8221B0E884ACB5524782AA09E4D3839BACB6C3AA16F5BD44ABC49C4444992897DCBE4EE3BBCF9F5AFF1DAF35F6372764A560CA94A5936D4B1C4EB0CC52512DA189B103B0DDBDB3B8C86238E8F8E38BC7B973C2FD0C626D0A0113FE33D26738592E27D0FF37E454CEDFB9EAC2878E3ED439E79EE397EE0077F80CDED2BF4BD5B17276B8A3493CBC8B28CACC828AA92A22CA8CA8A6135647BFB0A592699920787877CE2E92739393DE3BFFCAFFF3C5F7DF6196E5CBF9EAE57F718AAEFD1ED4B48ABF45CCE3BF081CDCD2D8CCD241751AB244D0094A086BAAE65B15848916ADBB5F23F7887D21194C3BB4EFC054958DA75DD25D52C6D02BD13DB97D2E9BF208AB0342A85EF033E4436B73E1CBABFF7DCF705AB5ED65D8CF12846686A1980D68B254DD3AC87B17DDF7370F72EB3D98CA2A892B239618995A8A121B0B5B1C1D9D9291B1B1BD4CB9A101DAE6B5169056D4D86B5C2CA2ACB82BAF5BCFDC6AB5C1FEEF0E8EE4D4EEBD95A1CE843C023C6571B0379F0A8D0A3F12C9B9E9D9D82071FD8A00F9017967258A007037A6D2432AB2844457E7A46383B23F40DDACA3F37452E09380A3C1EB4C6E4057A34C20E862C4E4F79EDD9DFE09D6FBD045886D59010601906A00D24ADD14A67D5342DD1C0D6D6360077EFDC4EA2C91248D7B7B41D5C7D5D766A76BD315CD96FBAAEC3E639CEF7FCCA177F994F3CFD711EB9F5084DDD93E7F714A94C481A45595056255555510D0654D580B21C301A0DB136A72C0ADE7EE736AFBFFE26B3C59C975EFDF6DA76E5834F0AF9A4F34AD734C95D0ED20505707D27F2076BB9383FA3EF7B744AC99114676976DAB625CF73620C38D7D1F51D7DDF5D2636C7B0E6A71123AE73B44D8B46BA4E216C4876804604B101971C1462788F4AD033A3D1E83BFDF8BCEFCE7D3FC3DADBDB7321F86951C8AC4A7ED8446B737A7A4A51960CAA01E3F188AC28198D470C060366F904E75769329EC1604859944C26673CF8D04DCE2753F97D9635595E500D7219D046215DDA2CE7CD37EF502F2EF891C73E8BD686AEEF406544AD700A89D60A976A7105D45E9848D7AF56F27657115364C44CD3372DB1CA09BEA73F3DC7B73DC11A06BB57D81B0E389BCF99CC97F856B687E2F90B408757A0B441E515C57803DFB71CBFF14DDAE5925B1FFF34A3C106F3794D936D50E8F3445F306BC943DBB60CC74366B392D96CC6747A41595632D8561EA51C9E00316157BC48428A3CC7F76E0D255C3906FAAEA7AC4A5EF9E6AB9C9F9DF3C4138FF3CE5B6FA7CDA0144A11894AF1CAF38C3C2FC8F3822CCBC5C0AE0A8ADCD01596A393536EDF3E4029180E0729064DE643AEF7EBF95354E933892BCE9822444FD37498B260381A319F4EE44A9F86FE21047AEF29DE93D4AC9484C12A054A070942D546D27AD6611E8ABC28E40A79AF1755C94C4C61B0293CD5F7ED9AB2AAB56138FCB060BDF7DCF71D96B1B6CBB27C4654AE6D3B9CF7E479C1206D988A2267341AC9DB2C78FABE272FC5970732006E9B9ACDCD4D8C358028B385EE096DD75154D5FA2AE4BDA8A2BBDE7370E76D8636E7D6957D165D8DF7C2390A5154CC2138899E8F0EF0A01CB3A621AF0CBB9B399DEBC128C8331A223EB7046398372D9DB664C30DCAED2BD8F106CE7BBAF902DFB7C4E065881B3D84400C8EE87B42DFD22FCEE9E767285D526C5F677A7297D79EFD4D5C0F83E188A6CB718CD14A30272B546FF0011F3C3B577631DA30B9B820384F51D8A4E1B2E9EA6645F16EE4819402A4D7A116A438B4B66DA94643EE9E9EF295AF7E8DDFF5994F33DED8109D5C9693173979555296A9B32AE5AB2CA5CBB2D6321C8DD8DCDE160C500C2CEA058F3FFA289F78F209326BF8C8C30F133D745D7F39BB4ABA2AA5E2BA6879EFE99A8E8DCD2D76AEC8AC6E05E00B297C961064A9B1AC592C966B357A4C4CB295B9DE7B49D736DA26DD9E93F0D8CC26F9C9652E40440CD0EBCD70945421314EC3FEFEFE77FAF179DF9DFBBE60FDE44FFCF9A08DB9083174AB749B7A290EFBF1E62683328532741DA3F1986A301003ABD669AD9EE1BDA748AAF5C16044DF39729BD1370DA028AB0A63B294982243D7D3D33396F3331ED8B842955534BEA7F591C6477A2FE03F292C3D3AF498D8135D870E1D3B438B31D013085AD0C77D942D62BD58E0334B1855E861892E0AEAA6A56B5A8256049D90C9CAA437BA100B4C9663B20265728273F4B3237CBD241FDF603E39E58D177F1BB0E47949EDC76046A8D0A5CE4814DF6DDB6132435994745DCFA2AE410519BE63C94CEA80F25CE89AC8CCC866D9BBE07C2B4FA5D516EF7A5EFEE637F9F8934FB1B3BB4B0C81A22C284A2956EBAF42527FCA6A40511664C6A68DE52EAE0F744DCBDEEE2E4F3FF9243FF2BB7F98EFFBCCA7F1DEB36C9664F69220B152BCAF823C6220F9075BAEEEED321C8D383E3E0684C57EAF2D2BCFC56EE37A2F14D1AE16344C10DDD52AA64B6B28CA22F918A558AF241FEBD9E86A19A16242A6CA1631B89070D4912B3B9B1FCA1ADE73EEFB8205301A8FE6599E3BD1D2C81BB06F3B16B3298BC51CEF1CB3E92C5146E5EA5256E5FA8735CF72CAB224AAC868BC41DF77D82CA75ECC315A5114194619612F19458870717642741DDB832D6AE7A97D471B7B3A1FE87DC07B87F23D3A0A6224784FDB76144476868ADE3B7AE77178DAAEC7BBC872BEC0C780B2169F5B7CA2111814CA1A5C52E6EB2C27E250F40C37AF30DABFC960F706E5D61ED5E63EC5E63E261FE0EA33FAE519C3CD1B2C2E8EB9F3EAF314E510AD0B3ABF05CA107C27D7D294D3E8BD63381EC943DBD66B428136C2C3CF6C465914D85C06F192C42CDD46BC675B688CA2EF3A86830D8E8F4E1894394F3CF118595990570565555195225DA8AA21C5B0A418549455415996724D2CA45376BD07ADF87D9FFB215EF9D6B778FEC59778E2B1C7A410B59DC00DC36AEC2DB42E80880715699A16146CEF6CB39CCDA9974BCAB214790AE0FA5ED8FD210591044F19BC9AE80000200049444154DBD432BFF27D9ACDA975AEA5D636E5154A88C5CA149EFEF0EB4D6A0C31D16592EC422BB4B514458531D67DE52B5FFD10E0F79EF38128581B1B1BF33CCF9DF75E54E0899AD9751D75FAC18A11CE4E2581D824BF9A733D4D5B9315C23E6A9A06A5257C20CB32EABA415B2DC92A2BD2A536B46DCF623E0714A36CC0C2F52C7A07A183D8ADA0DFE01DCA7BA20FF421507B4FB41A9BC97F9F0F82716E7BCFA26D24AF10451B222E699A88C2008F5A2783B0257887D19ADD071FA5DCB94EDFF6D4D305CD7C49DF364465C8467B14A37D62BFA0AB2FC8AA5D4EDF7E95F3BBEF5095037A5FE1D4265AFB24844C2A78DF9315F91AD3E3D2ACCB5A9B6C391945515296C93CBCD65589691C584B1DDAAEE3DAB56BCC974B8E4FCFF99E4F7D4A0A85C9A8AA816C6D0715E540AE835996916719455992E5D9BA103AD7B3B5B5C1959D6DCECECE79E59BDFE2E8F8988F7CE423A0144DD3AE0DD5AB3C49D18589CE6AB15C32180CB871E3012ECE2FA8EB9A2CCF050794AEB6CEC986B06F3BFABE972E288A3038C6404C66F918C007B1EA7827998FC6ACB045310997FDDABF18D376D0279FABD586AA1A608C0E8BE5B2FB4E3F3BEFB7F3812858BBBB5796799E77AE77F8DE253EBABC3D87C32159211B296D3457AFEE31188E582E1649F5EE138954D1D40D7DE7A8CA019935347583C90A8C366B58A6B5197DDFD1360B4A936133CBBCEF69DB4EE648A14D5F1D3E3A5CE8856D151D7D0C6015CE41DB39FAE0A9EB9659D3305B2C093ED2F58E2EB8B46217F1A7F38122A9D89DF318D773E5FA43900F39BFF316F5F9196ED9E0EB25FD62463799D0CD27285B516D3C886BE6F8BE4565630EDEFC3AAE6BC88B217DDCC2DA011053982B0417D01AC69B639AA57C1E4591633351D717794E511494C5400074316232C9E723515BA5D395D9D2E6D6065951727C7AC2D34F7D8CD1789322972EAA4C33ACA228D6FF9BE78544CF47A428784FEFA5782C16350F3DF420459EF3ECD79FE785175F6458956BFCCB2AA60D48C37370BDA79E2FD9DADE667BFB0A47C787282DCB82B66DF121905983EB1CDE3BBABEA76D5B617FA5EB600C1E82780A7DF41823917159914BA1CDF375871AA320B09DEF53F79911920CC66843C4D3B44B8CB5FA539FFC9E0FC4F3F96F733E101F48550D2EAAB26ADAAEA36D5B88410252BDA749E6E7AE6D652B652D6559321A8F3156AE90623B3142728891AAAAE4ED1C0236CBD06A6564155B46D7F404D761B5A1733D4DD7E07C4FE31DBDEFE97C4B1B9C708FA25B0FC555F4181DE8BCA3F6B2B9F22152372DEDA2A6778EC679BACE11961DC1F574AEC70441B834C1A19A86D1F62EBA283979FB4D4234A8F115C82B923311C8099DA79D9EA3754E31BA866F27E47941532F38BBF336799EA318E1C2163174291043AE3B5D2B54CECCCAE761AD446199D465599B33180CA9AA528CC6E82444BD3CA27AEFD151B3B77F9DD9B2667F6F8FAB7B7BA2B71A5414C9D222C3FC5C0CD75A27BDBA5C4FBD0BD48B251F7BEC519EFAD8C7F8EC673ECD931F7B82D7DE7C93B7EFDC25CB2CD65CF2E8E588084EA92026E6DEB177E3066D279B63C11ECBE2C23B977200146DDD522F17F8646592EBA0129062BAD6ADB6A14669F109C695CE2AA4ABF58A6C6111798568F088B2A0702E309D4C31DA84471FB9F5A170F43DE7BE9735002CA6F3B3D17074B1A22FF44E84A2C3E1881023B3E98CE1784C9CCD514059960C06032ECECFD1C6AED357CA4185369AED2BDB34CB39C4B0BE62CAA648F43D8BF954A2AEB2017D5B539361738FD29E2C94046541FB4B357D4AC2B1C1916171BEA7730AD5F510A4D3EA011763CA0874F8A626B635DA4977366B1A7A272897D1D626CEC1C6D63EBA2CA5F8F5E708644E185B90119DA79E4EA9B6AF60BB86BEADC9B231E7A76FB2F3E0636465856B3730F118ADA2CCB4A2C2879E3C2B180C87D4F33961738BAA28F1AC68A362A7195443168B86E08274A15A528E9592875A080E2D0FDFBA25C3F43CE7C68DEB1C1E1C51E439D658B2DC626C26403DA5851915E4FAD4F73D3E38F2B260365BF0FA1BAF737472CAE9F939D7AE5DE3F4E4641D18015C6EE756AA7705F3E99C6A30E0C6F57D6EBFFD26AEEBD9DCDC2404217E6A6368BB0EAD7ABAAEA1EF3BBC8B789F08F7AE17CF601441AAD136252B09B9A25E2E691A09F1588D0DACB64848B56C5E63EABCA4EB52E9BAEDA75FFEADDF3AF94E3F3BEFB7F3812858DF7AEDD5A6ED9AA6AA2AB242DEF4468BDE8784E8757D479E5B068331CBC54286B5C69259214AF67D4F70E235DBBE72858377DE413642AB0468BD46F83A274CEE8861E63D6D5B330A11153D6411AD73509E2E6882167B4C8811173D3E88A0B2F51ADF06582CE980BECA70C64A91EC7ADAAEA36E5B7AE7E9EA1AD7B644E7C8F382DDED3D94DEA2E93D6D3FC7CC97F47681D71DCA64C2D551A07441E83B42D7530C77A8277731C506ED72C1ECFC90DD1BB7706E448C5B687F48482864DF0B69C01A43BDACF1C1CBE7EA5D4AA5D1F8DE511415459EB3F4CD9A7AB0E2AE6B93A1C2928BD363F676AE301C8C083E707D7F8FB3D373729B5DFA078DC12845487ED0E003AE77745987F38E8D8D0DBEFADCD799CEE6ECEE5E216ACDDED5AB1C1CDC153D5576C9360311935A6B592E5B16CB250FDF7A98AAAC78FDB55725EDC65AB4922B6B8C2DC668BADEAF4375BBAEA56BC586A38555B3BE638ADA1DEAA6C5F72E599412CC2F5E162D95F46031A4105C3ABC77C9E06D31C6B8E974F661CCD77BCE07E24A08B1CBF26CD9F53D6DD352E49580F8D29BD0182331E84AD3770D75BDA0AC4A06830A9BDCF37DDFD3351DDA5AF6AEEE25E85C14436BBC1CE8A257065B70C133F32DB55FB26C972CDA96AE6D70ED82AE6F58760D755BD3B896D6B534CEB1741DCBBEA7EE03D3BA67B958D22F9774CB96AE6E084D47EC6486B56C1B9ABEA359D6B4AE27F63D99360CCB2D9419D0752D312A863B3BE41B63B09698E5449B1195056B20CB699D47E505E82A25D264CC4EEE12019B57A047886DEE325CB6EF7B4C2664CEAEEB5066A5C5CAC973C1BF54838A3CCF316933261CF64BE48E5291B65E887F331595EBD7AEA1AD592BCC57C9363E465CEAAA7AD7E383A7695ABAB68318A8AA822B57AE70E5CA2ED179DEB97DFB5D71F646C9DCCB7B2F6AF7A8383F9FA0893CFAD847592E6B9ABA232F72FAAEC5FBCB94E65591724972B0FAF787C412BB37EB27C680D5465E70C8F820F84066B3649A10A1B0F78291D19A943A9EA394A2E91AE6F305A3D190CF7EF6331F8886E2DFE67C203E90AA1C76992DE62BA44CDF372834CE0B0520CB85B9BE5C2C25AD571B068321938B093E448645416673DAD0A0956667678722CFE537576ACDE95EE5F2AD44922E46165D4FCCC169C3A853A89814E4B6A730421675C1E2A3A20B01BA0CDB3ACAA247AB16DB36B8E0A963C0659680A6F68E65D7E2DB06D5754CFA8EA577E24D8C9AB6731C5DDCA59E5F509505E5FE3E4315894DC025A32F49FDAD8CACFCA336649548364C9151D7735C8CD8B2A4F75B847E40F075625D69FADE931796BCC8994E263C7CEB110908F541BA14A5A87C4559962C167302AC712C32D391D94ED7B684E0D61DD8D59D1DD92A1A93E2DCA5487A2F424DE75C529143DB762C170B9CF7DCBCFE00DA18EE1EDCA5CC732E2E2E707E459095AE2710090916D8D40DB3E984071F7C90CD8D4DBEFDED6FCB96539BF516D35843F491CEF5522C5D2BE384A0D69C789F52965691604449F5C9F29CDC8A297B2385EF8695F62AAEFC952BDCCC3D9EC518A8DB868D8D8DF0F4C73FF6E196F03DE70352B08A2ECFF30B522EA1F31E6324430E44E4478C540959329B4C65D6A2354A47A2921F5E128160341A510DD3F62C85628A3032DCC3ED8E381599054FD769064610243E5A8CB258D7A3AC25688BC7E2A2C24585CF326257D3758A4C7962DD425FE35C4F9D674465A460CDE774F385D02CB55AC793F55DCB13D7F6D8D6477C6972CAEECDA7704D8D99F56C6CEF336BCE09CEA132C4B71621F41D7996118B0287232B06F49DA30F3D793E826E8C3243547F81B223518BABB4E9D286D96C469EE71465CE6CB620CF0A19271721D977529763F47A3B27ACA88CD9A2E6FCFC54049621B0311A92659974734AD2897C2A52ABC2E592BECAB5320457CA500D2A1451B67D9B9B3CF3FC0BF8DE13ED2A72CCDF135EAB44BE82E2634F3EC5C5C584F3F373C6A3519221646B05BC4B5BC19860F0C147712C048F908162CA7E9448B0959DCA1A83F39E665903D0F5DDBADB1384CF0A1C28174201F90540331E0E995C5CDC39BC7378E73BFDECBCDFCE07A2604D66B369DB35776C66035A6BA3ADF8F59395A2AD9B356DC1798FB69A2CB35465495554496B2805C1F53D6551304E692F712D48943914EB4466798BD6C1E36344078FC102391A4786A1771EAB7B40A2AB3CE033856A14A132281F70D319D135E03AFAC4316FBC673E9F319B4E198C37C9F302D53979E3BB195DBB64ACC1B52DD9CDA788EF7C93FAE86BF8C110B466980FB046689E3ACA1262341CE323F818186DED72323BA16E976C6CEE624D46CC37E9BB43824FC526D117B23C4729E95C8AA264B1A8C932E93E8BA864B3672CAE5F8946D38715415B4BD7345C9C5FA0A220858BB2C05A2B16A65EAC4CAE9782E582C73B4FD734344DCD7C3163B19893651967E7673C78E30636CF79F19BAFE07D2F9AB4B0E25449B4963105F3F992D964C2238F7E942CB3BCF1C69BE459B156BF87E0D141895C22756742AC75293528599F94A0622EF31413083045246599958D72323D2798CDFA2AB92ADC8270909F19173C459ED3B5FDC9D75F7861FA9D7E76DE6FE70351B0FEC79FFC4BE1CFFDC4E717C668177C9F476B1267C98A1A5B6B729BA3A2A6731D83D1109B6578E7984E262290EC5DD2DD048A3C677FFF1A6044C1ACC2A521362ACCEAA9F48EE87A3A6B59288F76A26AD74AD329431B8CACE995A8E37D08940DE865240E0A428C4C2717F47D43B6CC0846E1B5C2F9C0B45E723A9D33568AF1788B0B6DE843878B967FF9D5DF6630DCA49F9DF2D6177E96A21AC068884253D982A21CC99F3FA51D472362C53E42510C294723747B8153919065E8AC87B0895B16091B2C1B3F42C4E696BC28383F3B63776F8F41F2F98500DA7A6C9EA1B505D5AF75506BDE7B3243CF673366F33975D350661926D9594208B8BE079270B3EF1371634ED7B5CCA633292478C683115DD7F1C28B2F72747C4296E93487924E26F880B19ADE3B4E8F4E188DC6DCBCF93047C747B45D4D960A96044E487715100656D7B738DF1393483E86CB94EA15FB5F2B2582D1202D64F042E4188C8689719F36CA70C9114C9F838F3E99A9E523592C97ECDFD8D7770F0F3F2033E6FFFFE70351B0001E79E4913B2F3CFF7C777470981785244137754D59A5BF5E2E994C27C41098DB8CB6A9393D3D613E9BA2B462381C9115597A3B2AAEECEE029ABE6B0931AC9395E5877E657C0DE05A99B75843540E1F20571AAD7AB1F3E8151257E63F1DA0AD827608C6326F1B26F369DAEA29BC1666D2C20B8FE9FCEE01C3E126E3DD6B9CBDFD6D622CB9383FC58EAF30DEB9C6F4ED17980F76A936B71914155531468F46987248A6E4CF331C0CC9F28CB6EB453F64152C4EF199C565865064E46613332BE8DA5AD8E4015C0AE4F021727E76CAEEF6164AE914FC20315D99CD2457907B4805C8D5472738DE643AE5F4F48CC974C6687F0F62EA6852D715BCA76F3B9ABA66592F582C96F47D2B881F2F9D8BD19A575F7B9D83A323CA3C4BFA27F9CC82F7925F88E5ECF814E71D4F7DF4299CEF994EA7643623468FF7A052F1704E48A1BDEF083EE2BA2042521FC4ED90823756B99512A8A43136A4599EA76D84BEE0BC5F7779CA8A753044B91A6AA5205CA6F8C8E7B7E0CAF636376FDDFA4E3F36EFBBF38129581717E7AF1A6BCE6264D4F73D6DDB4044F2ECE67341AF28455914B2965ED6B8567C625DDBA195A2C80B9A1401351E6F884FCCB544BF0AE9942F6333F901C44BA47DEC8831A3351AA71D5641862157111D200145F03140DF103A835FCC198CC704A598360D1D245225042DB202FA48E86B4EDE799DBD5B1FA36F5A66C7C71060717EC6EE238FA1F3928BA343DAD98C3C6A623522D719B92909DA909505E3AD2DEAE9826AB4456E73EA4CA1BB73E26040D08690191C43822A12E04F984D4A0BC3C9F79EE96C8AD6C25D9FCFE6E8CCA0FC8A4375194801F716769DBE3713EE1C1E72EBE603DCBCB12F0F7BDB02AC6D30CDB2A6AE172C13CBCCF58EBA6E08448A22E7F6C11DBADE3318942253E97AF1F7A534789B5BA6B319B3C9849B0F3FCC7873CCD9F9191AE958AD3122080D4267F009EF1C914276767286CDA423766D4F83CCA3767776982D16A01483AA4C345BD9981A63A8EB9AE168844905CB620884741DF492A2B3A2FF0789B21F8F461C1C1F5FB8103F343FBFE77C600AD6375E78FE647A7E7E1682BF192389E52E914D36CB190E45993D188DD8DADCA25E2E393E39C6BC91717C7C40E75A0CB25D3A3B3B67EFEA5576AFEE727A72BCBE7A382F185C21995A70BD00E26240F99E1835DE68BCD674446AADD12900C1E8800AA2C09E7416BD5C908F47F4454E13842745503253D1823B51AEE7FF6BEFBDA3343DEBFBEECF75F7FBE9D37776B6EF6A77A55DAD2A36C19862EA8B4BDCF02138310E84406C5E03EF093836E1C539B10C46540301CC6B07628CC198127A31C5204A8430480869256D2FD3E799A7DDBD5CEF1FD73DB342C40935AB41D7E79C957666E7CCCE3ECF3CDFB9AE5FF97E251661BF4BF7C269A6761FC2F29B0C9657888201EB6B8BCCED3C40AB31CE7A6F0D69AAE96A07131B13BBD1A63135A19289AD14BBD9C1B46D8C32A5E535A9F90DB00C646153081B2C1BCA52A5E054231C6ADADF244D527ABD1E86A53CD4A52C370735A10AD7D8FCA5DE27501E5D83E1800B172FD23BB88F524A9234214BD440661287C4494A148644614014C5E4794A96E58471089494A5DA09342DE5A35F54539D02754DB36D8B2888E9AE74E98C8D3133BB8D417F401AC755B9C9A84220CAAA43A8C2028B322749734683213FFDF01BF8D9473C8246A3C6EDB7DFC9C5F979A230E4B6AFDDC6F65D7B18EBB4585E5D5321BC55028EEA38579D4E596256057FD57050A7B2A22CB08445A9BE6010E0BA0E6551C67192E949F707F09011ACC73EF6E74E7CEE739FFDF217FFE10BC70CC3301A8DBAFA495C99ACA99CB98CACC82973E5051585316521715C97AC289094A459C1C58579F6EED9CBF4F4344B8BF3E4A55A0236842AA8FABE8FED79A44954D52B94299F121C03AA6B5D81A0100608835C56C38725E499899504F86982F06B605990C450168812A4211086AD526E0A009FC1DA1A657192891D7B688C4DD11F8E889390D5956576CCED657AEF21F2B2440813A7D6C469B530FD1A4996132010631D445952581651D8A36C3631DA1D72CBA490120B0BD3F6302A012E367A0D86B25D499398244DF06DA79A33528578B9F142DCE07E039C1B36CC499CB0BCB8C0703020CFD5527412C71465A14E55614818446A872FCB489384248B9155F1BAA8DC4037DC0F8A42FDBD1B41AB711CB3B2BC4CBD5E63E7AE9D8451481C459B3161A64935E8AB3A8A6565518D30180D03F2B2E4F9BFF35C96575678F77BDE8B6D9BECD831C7CF3CFC61ACAFADF1EC673F9BBBEF39CE3BDEF96EC626C6286551B98BAA05E822AF96C40D1364B5D358356B946F965D059128F10CA2849D3B77943B76EEE40397FB85F320E32153D47BDEB39E913EEA671FFDD69999997B2F9C3FCF7034228C47C471441C478461C8A81F100C462C2F2FB1B8B0C068D023CF338ABCC4C0C0AFD5298B82C5F979F23C67626A1ACA42797B17977E183AAEBB39A72537C233A56A816FBA34E439E4A9FA9525C824461629324BC9D29820CB188C0678B53ACD461BB28CCDA34951546520B72AFE9A60D419F57A5C38718251BF8FD76A3131B313AFDE603D1C1065198EDBC06D4F9077C6881D97419A319425A25947346BC8661DA3D1A0B44C6836299B0D02D726F46D52C7A2304DA0448ACA8C4FAAA179C3504576A4DCBCFAE479B9D9FE97655975D2D4F56CF37191255228FB96EEDA8A1A80CD528220200C478C823E83E180517F481C84A469449244C4494492C670FF535BE5F09917AA93670855434BD39895E5152CC762FBDC764A2989C251659EA8AAE81BC2AA46260AB23C539DC9ACA4D168100F87BCF635AF21188DB02D93CF7FE6EFF9C4873FC4ECEC76DEF0C6D7F1AD3B6FE7231FFF24B54603D7B191129C6AB5C8340DEC6AC07663DA7EE33150A73BA11274AA936B96E7346A3596969707274F9DD227AC07F0903961013CFF39CFBCE33FFCD11FBFE87D7FFBDE379D397572577BBC43CD575D1C0335B86808813095A77B966594454910860861D2A8D5314C93A5A52586C190B99DBB008882904EA7B56929A20CE87CF50DB931A753050D54670B405613D71B3521108580A250A1086E4A1885B4C626684F4D3258BEA0046FA36D5E6648D34198DE6698AAB46B1442B0DE5D41A411BEDFA1EDB7313009A288425A605A94B689213D0CDF05CF51439A12706C8414E47D41EC8F91BA2E5612236C87D8568573B304E4863B45B969A953BDF4304DA1021DA424CB5215A851282703F95D2F3FB13949DE5BEB511405511C2B4FF524228953E5909165CA0E288B37433FCA42222DAA39B8A272EF544269DBCA40308E6356D6BA98B6C5CE5D3B705C97D16870E95A2A4BF5509652CDD949437582AB61833C4D29253CFCA71FC6F90B17F8E4673EC32B5FFE273CE7F7423C53ADDC1479C1A73EF949FAFD01B3BBF7912521B66D92A629799E61554EB49EEB5154F5B18DF51C50A742C3345510899494658EE3DA94056112E75AB01EC0434AB0005EF147FFF123CF78CEF37AB77FE31B375DBC78F1FAE5C18A27A5B4645160DACA933D8A222CCB523F2D85200ED4DC8E530566F67B7D965756D936BB1DC3540E07792171A4B2B7755C87667B8C95858BCAFBA8CABF931BD92952A50383DAD79794D58D408021A14828E290C4B309463D5AD3D3B45666182C9E43B92D5471594582709B48CB416619C2007C07697B18D818525060E0D81E7EBD85EBD5C97D8FCCF5C173495D87D2B5710D032C9BD2B10893889E09C1C4388567D3AEAE3205060E6016204B014651BDF0542B5E08E503052A4146CA92344D2F15AF4BAAC96E7969160BE53755E4AA806E1AAA43D6ED761165419A6614794E96A7CA8B2ACBC8B38C2C2DB02CB3FABB8ACD627596E778BE83ED380CD787ACAD75B16C9B6DB3D338B64D1406C8B2DCECC86E848C94A53AA119A60A85A05465F0384988E38843573E8EA73DED69ACAEADF1E9CF7E8EA3478E70E3B557F3CA57BE82C73DF1C93CEB99CFE21537BF967014623B6AA6CE766C55BBBADFC0AB696EEC528ACDE1625185D78A528DC620218A238E1C396CEDD8B1D378FF5FFFC5E57EC93CA878C80916C03BDEFAC65B7EEDE9BFFDAF76EFDEF37341183E2C188DB6A569BC2788A2F1288C0DC771AC2C4D4892B89402C3779CB2D96AE68D66735B1004DEA0DFE7DCB9F3F88D061393E3ACAD7549930CAFCA3E1418B4DA1D1CDF231F8E2AB17A201BAE97A212ADAA8C21044216C82424C93CE230A2954966F61D22585B53BE55C251EB1C45814C2344A383E179AA7D5FD5C12CDBC2753C2CDFC5725C0CDB465A16C2B0286D8BDC563EE3866311BB2EC2B4F06C9BD5DE0AA35A1DA3D5262E7292BA03A6831D66B4B314434AA4A1F2F4A8E6CED4CA9372D554572A35B3A63A7C69151A2A292AB1B87F2542204833B5C8EDFB3ECB2B2BF4BAEB6A34A12C49F3842C4D944345AE4E50A504CB36D5384975B52C4A49ABA53205171616595FEBE1FB3ED33353588EC52818A9D3935427AA8D9D4835055F62A00477434CE328240E021CC7E1631FF9285FB9E58B8C8D4F71E79D7770E55547B9E7EEE3DCF2C52F63B8750EEEDB8BDF6E93E629AE575727E77223395C9024EA846859367996555743551D504BD0853241B46D35C19F964C4C4C5C9C9DDDA657731EC04352B000DEF7AEB79F03DEFEEF5EF0A277F57ABD5A1485ADB5B56E6DEFEE3DD6939EF4A4DAB7EEFC5679C7B7EEA0D96C71FAECB9FC86EBAF898561DEF4B10F7FE49765298D93F7DDC7AEDDBB199F9C64656981380A69361B08045996E0781EF5468B703862A3EE2C1F205CAA83B8F946756D4415868A94320C09BC94A0D7A7333BCBF6C3C7B8F0EDAF2BC338AA6E5C5E401860742655424D9C926F74E184C010CACBCBC0A0B01C32C722B32D52C7C2736D1CDF27B24C6A7E8D2818B21286C89969B04DA0401A161816858828648E400D541A98D5DB540390822CCB499288AC7291C8D354BD0073F500E445C1863781AC1E0C41B52A6518B88EC3A953A7C8E21853C8CD6B6096E714B9547EE77986EFD7300C9BBC48AB09F692E9A9295CCFE5E43D27E8AEADD31A6B3336DED9F4B1CAB3A24A271255EEB372C7A0F258DF98A313C2A0D7EDD26CD4F885A73C99F985455CD7228C42EEBCE31B1C3A7C84FB4E9CA0371CD19E9AE5ABB7DCC2AD5FFE128D71258C1B316261AC66C52CC751735BA60A894D8B04D3362A770F5437B2EA6ABAAEC7E2FC3C1313D3A1407CF95FFCCA2FEAB18607F09015AC0DDEFCBA9B5320057A005F04FEDB5FBCF9BB3EEED67FF834AF7CC39B3F2A84F1F83CCB5BABAB2BB43A2D26A767B9E7DB77120523D2AC8D692A1BE146B3C5F8F436D65757AA9829B3FA4CD598F3C6ED50C8CD30F34B3E0F557F3B0C89FC1143DFC70D07CCECBD82324A993FF18DEA4AE9AB4F929514C110C3EAE0B53A18A683340D0CC74638168665611916A96592B80EA56363BB2ED2F7080D93BA5F63C2B7B9EBFC32C5581B3A2D75C5B46CD4BE9BC41025962C54974B80AC5EEC524A8A420555A4694A1084A4794E91A6E469AE4E5D4555C72AD524B9C050839C5225316F64F059A6C9A95367540250969265CAD933CF24B228C9F30C59962A36BE2A929BA6C1D8F80CA6B0387ED77D8C867D26A727D5EA94A1AEE8695A4251AA21522AC709E3D229EFD235AD64381C31B77D1BBFFE2BBFC4B5D75DCB073EF821A66766B8EE9A6BB8E3CE6FD35B5FE5AAA357F1B14F7D866B8E5CC59E9D73CC2F2F110409274E9F26CE13EAAD3A8630088390A03FC09F99C6713DB5205D45A16D3CCD1B274EC33008C380A0DBE5E10FFF67EF1A06A3BB2EF76BE3C1C843A64BF8A3606262EA9689C9A9419A670C077D56979768B63BD4EA4DA260441CC51445A672ECD28CB1B149EACD16506E76F6C566F58ACD2E1154D7415985A8805A30963972D8234A639251481A85EC3A721DB307AE050A241942989B2B2E6938248A87188689D71EC3ED4C62375A08DFA7F03DD29A87E93AEAEA6A9A8C00D9A833D1F058BA7086AE2110B3DB3677E4B06D355221C02D129C342237ADCD8876E5032650BE60CA3B3D0843B234234FD53528CBB2AA6E545256A2714999D5F06814854C4F4DD16A373979FA14799E5405FB5C15EDF36273795144FDAE00001EC149444154D91446552FCB4140BBD5214F32EEBEFB2EE238606A668646BBA996AFF3425D21CB8202F5392E89937A1E8C8DC5E56AFE2ACF723A9D0EF546937E6FC0F5D75DC3B0DFE7962F7D8989B136F7DC739C037BF750AFD578E2E31FCB9E7DFBB8E1BA1BB04C8360145443A7196AD6CF214A62D22CDB4CCA5103C56C2E414B099EEB63981627EFFE36078F1CB9F7913FFBE8D7BEFCFFFDC3D1E5FE7E7F30F2903F617D3F3CEBE9BF7EEFBFFC37CFBDEBF4E9933BE220627D6D1DBF5167627A86F3A74F128621B59A87655A24494CB3D5627C6A9A61BF4B59C8FB9DA3D8BC4A6D96E245F59F8DEC743555894822926E97C86BE2ACF7B12D9F3DD7FC0C8E3FC6B9BBBE4E598440A3AA29A9D3DD70D8A3699AD896879002699A14A689340CB51F5714248681D16ED1F64DCE9F3EC1B92882B91D55B82748C756FFCF0AB02DBC788819F4492C4B7554C586A77AAE4E5BA870DA524AD238DE9C3D4AD374D372A72CCACD62F986158F6D99F4D707CCCE6CA32C25674F9F22CB12A480A2EA304A2445A95C1ABC7A5DFD5951D0A837284BC9C5F98BD8B6CDE4E404B6A322C5B2CA3E59E695B19EA01ABABDB4AC7C7FA49418A6A0DD6973EACC59DEF4E76F63766686B9ED731465CE99D367397DE634070F1EE6339FFB229661B0B4B8C4C2D232D71E3B86EFFB44514CADA64EBDAAC05E8D2AA4296551603B16793FDFEC141665A966FCB2947BEEB987A3D75E77EF0B5FF4A2E73CEBE9BFA14F57FF045AB0BE4FAE3E76ECBF7FEA939F7A4C9AA64E9AA6104067629CF973A7088643EACD06B6AD5C37D3346562728695F98B8C8603BEFBE1BEF4A21155A8A7AC4E1F2AE7B36AFB0FD658B72C3CBF863D1C80E1B0FBE88DD4DA539CBDFBEB046B2B900A84D7469A168521C9B384248D30529FD2F3B1CB1C9167E4661DEA355CDF450ED6B978668D75CB446E9F439816521608D300D342E6999A196BB471475D087A18AD31F5E29700CA9239CF4B8469929725451855EE0AA58A2ACBD2CD68B5AAAB50EDDDA97FB765185048B6CDCC7071FE226B6BEB95695F796991B8EA3882C0742D1012CFF348E28433F36741A056A52CB30A4895CA2BBD72CE90A55A3E16A6D8FC596008950AFD40E1428065590451C45DF7DCCBF17B4FD2E9B4288A92E5D555CE5F5C606D759D5ADDE7EF3EF0615A9D36A74E9F65ADDB656C6CAC72E950867F4992502B8AAA1902AEE75156E26E1806C21084C180E5E5558E1C3972DB1FFCC797BCF0A93FFFC45B2EF7F7F883192D58DF27D75F7FC3DF1DBDFAEA17FEE3D76F3BD0AA66AF5CAF46BDD561D01B124709BE6763088B388A68349ACCCCED22BCEFDBD529EB524F5F8A4B8567F58EEF1C0A57EFAA822DD65759756AB87B6A5851CC88752676EEA53135C7F2E9132CCD9F220A433072BC460DDBF5C071108E8D61DBA4351F59F39046491EF609D79719953949A7035393208C4B62B591029425D5B4B881BF324F9997202C35086AA8AFCC346C352D6E1B08244996906669D5CACFD475AC2C55FAF2C66A8ABC54CFCACB82FA5887E99969FEF19BB757B34AAEF29B2A550730CB72B234A7D56A623B16C1704851CD5BEDDDBB7739CD53A3288AC9B8DA0FB56DBBBA4E66C451429C24D8B6A3AC9BAB7C40D775375D270C7169FABCACAE8CBEEB53F36BAA539956573AC36471790DDFF3C8F282388AE90701459EE3B92E7EADA6C43529180D478C8D4F526429EBBD1EAEE3D26834B12D9BB214388E49777D8DA2CCB9F2AAABDE7EC38D0FBBE9A93FFFC41397FBFBFBC18E16ACEF93273CF2A7975FF6F29BDFFFC57FF8C28B8320A4DD6953E405E393D30C7B3DC2419F9AEF619B4535CB1333B56D96D59545FA6B2B48E154D7C16A7074F3673E9B9DC28D99AC8D2153294C8494044BE799170673571CA3511644FD3EAEDF60F7D537327DE0082BF3E78846951D8E10C82426B403F06CEC50208A84303218790E45AB8DEC4C835F15EE2994E7BAA5A2B94412AB1356678AC6A8877FFE24B9E7570B2FC6A62BA794A5F284DAB0124E52B22C05D45CD446747B59969B6E9EB011A66A321A061C3A7C90E9E9493EF2A10F536639385E2558E5661DCCF73DFC9ACBDAEA1AD353D3F181FD073E78DD0DD7BFE7D4C953277CBF66B4DAAD1D4B0B8B9D208C1AAEE78C1B421C3A7BEE6CCB755DAF516FB4D65657F334CB9C7ABD363E1C0EF7F4FB032F8E6365571346084354B353EAEB736CBB0ACA507B93A554F5AE7ACDDFFC5EF0EBFEA593306C0ECC1AC2A2282451A40C16EB18B8B64BADDEC0F76A8C8211DDEE0A8D56F3DC810357FD27C330FFEE0DAFFC63ED7DF53DA005EB07A03936FEB6BDFBF6FDCEE2FC42A351B954BA7E837ABD4530EC336A36705C1BCF35C9B314DBB699DBB59751AF4751E480EABEDDFF4A2805DF39F3C0FDDE166A904048C168F122E74BC9CE8357D36ECFAA41CAE100C3F5D97EF018024118040C8A90C890A48681E93818AECFA05167D46E203D1F6C1B61A95315C2449826D23454313D51EB42783E4CCFD0B8FB568CE58B94AD71D5A5111B9D360B4398D46A2E0893300C89A3449D8C28368DF7D234452255FD4A5CAA1F59964D990E981E1FA3D7EBB1BCB404559CFB86C815458E6599F8BECBEACA32D75D7FE39DC78E5DF3C295D5D5DBFEE4A57FD0BBDFA375C7C66F9EF3821759B665D5D67B3DABD96C18131393962CCB328A63C3F73DEBD18F794C2B88A2C941AF3F5E64F9D1F98B17AE9C5F981F1F8D826921C4A42CCAF1E1686885A3A1210CC3313692A3259B7166EA79513F56D4F5CEC0D8CC3C54FFE6D170845185680CAAC7A3A4248EA374DFFEFD1F9B989C78D907FFE6AFEE40F33DA305EB07C0769C734FF9F9A7BCEBF5AF79F5BF0D46B3D49A75A238A43D314E707E48D01F50F394ABA763D9C45144BB33C68EBDFB397BE21E3528C8A54006D8DC7DAD10DFF5676A0C40BD68C2E5454EA7393B0E644C6DDF8361AAAB4E118E284D0BA3E633EE8E31AA3BC4A6852D0443CF24B62DE446465F597D7EC342D8960ACF280A44964059203D0F2666F09288FA9DB79109036CB53328C4253B9D2451AB32AD569D388E09E3404971E50E9AE7EAC56B3E40AC4075CAEAED363333DBB8EDB66F102429B6E3A8FDCDA2D89C8B721C87EEFA3A571E3A74D7D39EF6B4DF7DDEBFF9ED2FFCAF9E9FB7BEEEE61CF8274F2C1FFFC07B377FFFFCDF7FE9C746A3A1B3DE5B378220B4E6E6E6AC473EEA51DB4F9E3879204B92E9C170B8F7E2C58BFB2CD3D86E18C6E468346A0C0603474AE995925A96E750ADF6287F2F812CD5227859E61479411C8414324796924EBBF3CDFDFBF7BDBADB5DFFE007FFE6AF7427F0FB440BD60FC0F39FF9AFD20F7EF2B36FFBF8273EFEF433674E378E5D732D966962FB3EF54693D170C0A8D6C0B12D4CC3C0ACE2D267E6E6180EFB749716D818FCBC244CF79B20FD9F1CB584146C241F222CD260C8E9FB6EA7371AB06DEE00B5D624266A1C219392328D11E448D726B22DA2CC411ACA194258269802691A55F72C47A6391499FA985A5D5D15C7C619BFF57378F7DE41526B208550F98485329A733D97416F5DB9820A4151A8351A519D920A599244CAF4CEDF08EDA0BA0E1A267114303737C7AE3DBBF8D8873F461CC5F88D3A79AA7223379289E23866FFBEFDB7FEEAAFFDDAEFFFEFC4EAFBE5F57FFA9F37E6F0003873CF9D7CE9B39F5C06BEF92F9EF16C23CD32C3344DA32C0BE3094F7E72CB807DC78F1F1F8FE2787B9EE547B23CDF6159E6E47038F4A230ACC571321E4751ABC8732F0A034B0891E779DE755CE7CC81FDFB6FD9B96BF7ABCF9E3DB3FC998F7E50EF09FE0068C1FA0169773A77FCF23FFFE597BFEAA69B6E5A5D59627C728A308C69742688C311A3C13A9EEFA9B8F6EA6461991EBBF6EC270E02C2D10081CDA532FBFD8BF1EA6DB1E90A78FF527C812C5384F4912574D71648C280D6C42CAD8959FCE638D2F3293D57F932190623CB203005B9A80652AB214991C4A81A19600884EB22FDBABA1EB6C6A80DFB743EF721B22C46B6C694BD8DA176E54CB372DC34058EE193246AD073C3C1A12854AA4D9C2458D52C972CE5E65A8A3055A0C7F6B959161616585A59D93C298AAA389F6529B66D95D75D77DDDF5F7BFDF5CF7FE98BFF9FE3FF279FE3BF79C7DB944956C5F13BBE1E03CB0FFCB85F7DFA338C273FE989DEC2C2D264108507D7BBDD5D835EAF83108EEBBA69ABD3BAB7D56C7FF62FDEF4BAF0FFE4D7FF9388F8AEB6EE3FF581427C4F1FF750E2BD1FFBF4AE57BDE2A64FDEF6E5AF1CBEE6A77E86348EE80D068C7A6BF4D656A97726199F9AA0D1F0B14D074398B8BE4B108CB8EFDB7790442182CA86A66AF97FE7D5F0D2A94B6ECE6919084C2416B8358C760BC76F52736A18F53A76AD855F6B221A6DA29A4F5C73496D97D8B5291C0BE95860AA9A159689B46D84E781E7213D4FB94BD80E62663BBB3EFA2EDA7FFD2692CE04F84D64A92C6E0CC0F57C9224224F331AAD0EA360481485957F392471C67038248E635CF7D26952E5F8094C43E0D66A1C3AB89F858B0B5C985FC0A94E618669104731A629D283870EBDFB718F7BC24B5F7DD3CBCE5DEEE75BF3E3E17BD520D093EE3F144F7DCA13CE3DEAB18FBFA93536969E3B7137CD761BDB32F11A2D6AB51AC1608DE1704492A4D594B5B2FE6DB4DAEC3F7C04D7F791A4CA5A06E37E272A7949A0C4036A5CA244992A178824A11C0E49F290DC9478A68BE17814C2A04C5560AB0846B8A311328E90458A28733004D27190B53A34DB48BF0EB653D9D74898DAC6C4E9BB697FFC3DA48E8BA83730648E815AA39142E27A1E59AA6C5EF2B2A8F61B2BC7CE4292A631719C5449D002A332C70315266AD9368E6D73EAC4092ECC2FA84010D3549DC3C1805AAD36BAEEFAEBDFD8E98C3D478B9566032D583F24478F1EF9C82FFEF35F7AFFDACA22BDB515C62726310C417D6C1CDB80516F8DE130224D130A0ACA32271E05B4DAE3EC3B7414CFAF8354C395DFC9252B9A8DD5422165E5EC20513795029166C851C0205C6710AC23D318699B64AD0666B385687588C63AC876478953BD85A8359593A9EBAAB92B54A61E45869CDC4673D467F65D6FA6585DA1E84CC2A647941A35701D9F244E54E06CB341301A90651942A86E5A9EE784618C40625782250C6333B44120304C0B839251106154C9DB4208FAEBEB4C4F4FAF3EE6713FF7B26DB3B32FF9FC273EACE3DA359B68C1FA2179C6537FA5F7F0473CEAE60387AE3A73FCCE6F6208E8743A08D3A6393E431E470CD6D788A2B41A5A546B2A7114D11E1F67DFE123345A6D204392AB01CEEF386D55C88D64E0FBFF4F898C4853486206E13ADDF54506832EA3244026296E9253202985441465758A2A9145812894FBA972302D9093B37886C9DC5FBF11F18D2F934C6F53D3E1A532E92BAA28B35AAD46188CD4F4BA6A039015B9FA1A4B41300A489314DBB12F251A5753FB86A14E8D869014590ED2C0AFAC71D61717D9B973EEC2539FFAD4177EE0AFDFFE9AF7BDF3ED5AAC34DF8116AC1F01BFF3CC7FF98FBFF4ABBF7E93EF7BA3FBBE7D3BE3E3E3D47C1FD3F569B4C749863DD6D7BA8461ACFCC70D415164C4A39056BBCDFE2B8F3231338BBA52A5084A255CE23B17856143B7AA6BE3C6492B8911C3189284380B18C6EB04419F2C0CB082006F14421C21F3149967C83C4794B90A03A504DB80E9395C29D9F1CED7E37CE1234453DB301D57ADE618AA605E16059D4E872449C8D29446BD4E188EC8B31C615848208C428220C0B62D2CCBDC5C3616C2A8527224A66DE23A16595962D916491C33E8AD73E5B1ABEF78CA2FFCE2B3FFEC552F7FE7E57E4E350F4E7497F047C4939EFCA47706C1F0C85BDFF0BA179C3D711F3BF7EEE7EC99B394B53A32CF09D657D544B861E27BAEDAEA2F73C220C2F35CF65C71885AA3C9C2F973E4695C15D7ED4AB42A774C596E4E565F3A7C49253C6184C8D5FDB128D5A4D760D220AA5948CB570119A6A1C4C936908E85304AA4E5C2D80CF5F535B6BFFFFFC3FFEAA7493A93887A1399E79BDDC0384CF0FD1AB57A93850BE7F15C0F69409A669B36BF5114D1EFF555E7D07536BF3E35D56E405992959296EFE27A2EA32863D8EB619A26DBE7B67FE8671FF3E897BEE5F5AFD283949A7F122D583F229EF8A847C47FFF955BFFF4E2850B873FFCBEBF7DB257AB31B7730767CF9EC16BB529A564B4B68261198C8D8D51F35C0CCB429405719C60DB36B33B7751AB375999BF407775094902D202612A531A61A8D39754574B70AA5DC36A08354D91BD212248218CC9A2902C0F308A29AC24A6CC9BC8A246E944C8D844FA6D281CC64F7E89992F7E08EBE49DC49D29A835202FAA24628B34CBC865C1C4C438FD619F2CCF69B73BACF5BAE479816DDB244942BFDF474A89EF799B6B2DE646ED0AC88A12D77569D4EAAC0F46AC2F2F31313E111FBBEE9A3FEB0F06AFFEF33F7BCDF20FF72C687ED2D182F523E4F1FFECA716DFFA57EFFA83C5C5C5C96FDCFA3F6EB46C9B9DBB7670F6EC79DC661B8964B0B28451C56A796E8969D9955B67469617D41B4DEA571CA63339C9CAE202C35EB71228030C1769B91848649622650480C4013C10F625D7873485B5554412532EAD82D740FA1E85EDC2F80C6CDB41CD8A983A73178DBBBE8A8CFA241393EAF397B9AA331906799E11C711733B7652C892D5C565A6A6A609E290A412DA344D58EF76298A02BFE6631826820D974D95BB98A52918065393E30461C4D2B933CCCC6E5FFCBF7EE9179F8F303EF4F6B7BC41D7AB34FF5BF41CD68F8117BEE48F1EF9FE77BFF3ADE74F9FBAEAF03537E0D71A9C3B7B962CCF488643E230A43539CDD8441BC771B02DF77EC10C06A66D6299166559D0EB76595B5E60D8EB2365AE9C4BAD1AA6DF543636794E328A288B08A8F614850BA64AC8C1B6C1F6A03589BBFF4AB6EDD98F610BE82F513F733B72F53CB96122BD3A425808CA6AF5C60059100443B6CDCE313139C53D77DD856DD9F8F506AB6B2BCA8F3D4DE976D729F20CBF565343A250A50F5527AB24232972A6272710145C387B81A3D75CF3D9473EE6D1BFFF5F5EFDA7B75DEEE74B7379F97EE6B0B460FD98F8F5DFFAD74FF9D6D76E7DD3A95327F6EC3F748C7AB3C1D973E7C8D2942C0C894643FC7687CEE414755F65D819C24418A20A25106A71D6B09048A230A0BFBECA60BD471406CA06C56CE04FED6472DB1E8465511425499C91C902D3B1A9D53A38E393B4A767999C6C53B773F2EE3CDDE3FFC8FAC533E4008E8B306D44B5AB28D870C42C08462366B6CDB273D76EEEBEFB2EF224656A7A9AA5E545F22C274E53BA2BEB20A056F7B137BCD1ABF82EDB34D4884392D06E36B04D835EAF9F5F7BE30D7F39B77DEE657FFB577FB978B99F27CDE5E7FB112C7D25FC31611AE6271EF38427BD50FC83FBDA1377DDBE67F7FEC3ECDEBD8B858BF304553D2AECF729F30239354EAD565396266A231004CA4FAAC8314D0BCFAB51DFB9976D73255134220D0386BD3EF1689E2270681FB80E7F662F6EA38DE1B9D44C13CF901865880CBBC4E78E73F6E45D745716315C1FDBAD5DDAD793861AA9A8FEDE3CCB89A390B95D3BD9BB671F77DF7537C160C0EEBD7B585DED12C509699CD0EFF511A641ADD1C014F733C733541C5A9E674449826BDB08596298CEEA6FFED66FFDA9EBB96F7CC3CD2FD75740CDF78D3E61FD9879C6737EF7F19FFFF4DFBFFEC2B9D3576DDFB59FED73DB59595BA5D7EB93C609F1601D6998B4C72769761A38B6F25BB7EE976127AA1D40E5012E318489E3DA601864494C1A8D1086058E8B6198D886A0CC32D224A48C43B224A5101656BDA1761BAB527D59CDAA2A9701F5BE384EC8F29CC3870FB36BF72E6EFBDAD7585E58E2E0E143ACAF77595C5A261C8E0887016EA346AD5653FEE9E5467C86EA109665497F30A0C833C6DB6DC6A6268F3FE1F18F7F2186F9A937BDEAE57AF157B389BE123EC8F885DFF8CD472DCDCFBFFAEB5FF9F28D9D8949F65F7190284A585E5D260E23E2D19034CDA8351A34DB6D6A4D1FC7B610C2C4348CCAA5A1122E43D929CBB2726FA88238294BA8DC12CAB232FD13060813D350D6C1A52CABD41651392A08356345A18223B29C5AADCE91A357333D33CD976EF9020B172F72F8D0550CA390B3674E138E426496526F3610B65BE5CFCBEA0A6B62D916799E33180CC99384B1F14E7AEC9A6B3ED21A1B7FE907DFF50EED55AEF92EB4603D0879C91FBFE2D8C73EF1F19BEFBCED1B4FB40C93BD87AEC0AFD7595F5F67D0EF130E03A2D110C3B468B65BD49A355CD7C5B2CCAA902D2EA5D454BB87EA37E5258F74A13279CA428D24C8F23BE3E155EAB2A42C8DCA5BBCA4C825599E62590E73733B397AEC6AC260C4E73FF719F238E1F05547595A5EE1DE7BEF21CB325CDBE1C8912B49B3945367CEE25836A66D639BEAEB8CD398F5B52E459AB0FF8A03DDEB6EF8A9FFF2DE77FEE54B2FF7E3AF79F0A205EB41CA73FFFDEF6FBBF7EE7B6EBEEDAB5FF98DE160E0ECD8B59B6DDB674992947E7FC0683864D0EF91C5299EE7E2D7EB78351FDFF7306D95B4625685F98DA89D0DCB62610875822AAB015303B58283BAA695524DC52B6B63415E9DC41CC7656C6C8C7DFBF7D3191BE7C285737CFDABB7E23A36070F1F66797595FBEEBD0FCB3248928C4EA7C3F5C78ED2EBF7595E5D51BB809689E3D8048311EB6B6B78B6C5DE2B0EDC79C38D37DEFC8EB7BDE5BF5DEEC75DF3E0460BD68398E7BEE0C5CEAD5FFB1F2FE976D7FEED99FB4E6CAB7935E676EDA435DE21493246C311C37E9F61BFAF86321D07D775F11B1E7ECDC7B6EC2ADB6EC31BDD002990A2B8DF9EA1ACAE7D1B16C895A15E9151E6258669D36CB5F06B3ED3D3D3CC4C6F63381A70E71D77B0303FCF9E5DBB99989AE4D4D9339C3A799A4307F6D169B5B8F7D459A238E2D081FDECDEB5833CCB387DFE02FDE180617FC8A0DBA5DD6A0C8E5D7FFDBB0F5F75E4CD6F7BC36BBF79B91F6FCD831F2D585B805FF9AD7FFDCB6BCBCBBF7BF7ED773C667579D5EA8C8F31BD6D1B8D669BA22818052382E190617F401886D8B68DEBBA389EA37ED91696E55669C245156EBA614753B2917128AA0150D334711C07D3B2701C9FD9D9599AAD3ADDEE3ACB8B8B9C3F771ECF7599DB3147099C38711FBDF51E866172FD3557D369B5B9B8B8C8FCF212BEE372C51507905272CF3DF7B270F122B669B2FF8A2B6E9D9E9DF9AF52F2E79FFFE44775615DF33DA1056B8BF07FBFF80F772C2E2D3EFD9EBB8FFFDA9913277F2A8E535CD7636A6A82B1C9492492244949131568301CF4AB50060BD332B02D17C354E93396ED609A46F5671B752F89C0C4722C6CCBA6E6D7989A99A62872169716C99294B5952E5912B16DFB1CAEE71206016110B03E506B36D39353388EC5ECCC0CAD669385955516161719F4074451046549C3F78EEF3B74E8FDD75E73DD3BFEEC557F72EFE57E5C355B0B2D585B8C673CF7F70EAEAC2CFDE6E2FCD2A3CE9D3EF5987EBF87252C3A93634C4E4D61BB4E15CAA09EDC388E09475195C023557CBB69605A0696ED60DB0E966560D936B6E5D06EB700E8F7FB1479819425BDFE3A655EB26D6616BFE6D31BF4397FFE3C799671E5A12BA8D7EBF47A7D2492B4C8E8B42768D46A9CBCEF5ECE5FB88800EA8DC69D47AF3EFAF9BDFBF6FDCD7F7DCB1BBF7CB91F47CDD6440BD616E4E9CF7AAEE1F9FE8EE1A0FF94EEDADACF9CBAEFE453BA6BABE369968294349A2D26A7A6A8D5EA94A8D8762925A6A94E5640150A0A79A6926A4A94CB8363D940499C24C46184EFD599989A208A2206A321599E51773D9580234B9A8D0607F7EF434AC1DD274E10460141AF47BFBB86302CAE3878F096F6D8D8E70D213E3C313575C77FFFDB77E92150CD0F8C16AC2DCE339FF782CEEACAEA235CC7B97669E1E263E7E7178F65693EBDBEDE258D6390257EA34EB3D5A25E6F625A6A56CB32ADEAC95799F7799692A63152A296AAEB754CDB22188E08C200C7B608A31084C1D5575D4914A78C8211699A92E739AB8B4B2CAF75016837FCEEDEBD7B3F32BB73CF5726C6C73EBBB2B27CE2C3EF7B8FAE53697E68B460FD84F0BC17FFA155A6E98EBB8E1FDF669AD676DFF31EB6BEBEFEF0D1707874341A4DE6794E122755CD4AE51F3A8E85EB7A94409C24EABA289423689E669494341B4D0C435016254559600803D771585BEB124723A4303084C5F8F8D8B989F1894F7426C6BFD85B5F3FF1D30F7FF8BD6F79FDABBA97FB71D1FC64A105EB279467FDBBDFF3C2389E1C0E87AD5D3B778C4751BCABBBD6DD1104A3E6CADA6AA3DDEE1C0CC3D04B93346F341BB9E779D6E2E2C2B1288CB62549429E659BEB3EA594B12104B66D1B966397699C84966575F7ECD97362FBDCDCE7CE9C3E73EB6838983F78E8D0F207DEF3CEDE0FFFD56B34FF73B4603D84F8EDE73CCFEA76BBD66034706EBCFE867DF30B4BCE3008F29D3B77E4DBA6A6AD13A74E3C72BDDB7D58300A9C308C72D7B1AD284A462BABCBCBB6EDB07BF76E6BC7CE1DACACAEAE349BCD0B87AEB8E28EB5B5B5E36F78D5CBF3CBFD6FD33C34D082A5D168B60C3A9750A3D1FC44F23D9FB0341A8DE672A34F581A8D66CBA0054BA3D16C19B46069349A2D83162C8D46B365D082A5D168B60C5AB0341ACD96410B9646A3D93268C1D268345B062D581A8D66CBA0054BA3D16C19B46069349A2D83162C8D46B365D082A5D168B60C5AB0341ACD96410B9646A3D93268C1D268345B062D581A8D66CBA0054BA3D16C19B46069349A2D83162C8D46B365D082A5D168B60C5AB0341ACD96410B9646A3D93268C1D268345B062D581A8D66CBA0054BA3D16C19B46069349A2D83162C8D46B365D082A5D168B60C5AB0341ACD96410B9646A3D93268C1D268345B062D581A8D66CBA0054BA3D16C19B46069349A2D83162C8D46B365D082A5D168B60C5AB0341ACD96410B9646A3D93268C1D268345B062D581A8D66CBA0054BA3D16C19B46069349A2D83162C8D46B365D082A5D168B60C5AB0341ACD96410B9646A3D93268C1D268345B062D581A8D66CBA0054BA3D16C19B46069349A2D83162C8D46B365D082A5D168B60C5AB0341ACD96410B9646A3D93268C1D268345B86FF1F068183B8CB329AD10000000049454E44AE426082');
INSERT INTO "product" VALUES (8, 'IPHONE', 'A00008', 1, '2019-09-19 14:37:47', 1025.0, 750.0, 0.0, 99, 3, X'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');
INSERT INTO "product" VALUES (10, 'MOUSE', 'A00010', 1, '2019-09-26 20:32:59', 50.0, 35.0, 0.0, 91, 3, X'89504E470D0A1A0A0000000D49484452000001000000010008060000005C72A8660000200049444154789CECBD79B46567751FF8FB8673EEF8A69A4B5525A934834048488008898D190CA641608C41CCA34C1812B0F0EC84EECE6AAFD8716775C771D6F2721277DADD49BB3BB6DB6D33196384D04C9554924A25D080D050A51A5EBDE9CEE79C6FE83FBEBDBFF3DDA7C276304212DCBD56D57BEFDE73CF3DD39E7EFBB7F707CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC64263399C94C66329399CC642633F9AE229EE90398C9734FDEF5FEF78951BFAFAD750D78DF34D6B49D752D2944C37BDFACCA52E946A3E98C151EDE49210AA1948575A57376A21B8DB1F09878EFC7BA91174ACAEACFFEF44FDD337D5E3F8A3233003339A35CFFEBFF4C9AB2685665B9381CF4F717E3F145E3D1E80263CCC5CED88BAD35FBBCF70BD63A001EDE7B00883F8510F0FCB7078400A494F0DEC343C4BF015148294E2AA5BFADB47E586BF5ED46ABF5EDEEFCFC23AD4EF7E8DCFC426FFB966DE52FFCD34FCC0CC4D3203303301300C0273FF30B2D78B76F321EBF60341CFCE47030F889B2282EB4C608E71CBCB50080A8851E703EBCEE01400808087867E13D0029E09D8790022023A09482F30E42484000DE39780F2825E9F3BCA987808094125229D36C351F995F5CBC65C7AEDD372E2D6DBDB7D59D7B3CD37AFDFA8F7FD43E2317EB87486606E047547EFED77EBD5115930BD7564EFFC4783878635994AFB1D648E7823797223C1ADE87BF9D7341E9AD8107E0BC87770E8E94DC7B00DE4140C0390B475EDF879D400241C983D70FEFF91029400052C8A0F86408C236E1376B0D8CB5F0CE434A8146A38976A77DAC3B3FFF65A5F54DCEDA3BACB58FFC3FFFD71F4D7EF057F2B92D3303F023221FFEF8C785776E69321EFDB829CBF79665F93A634C9B5434FEB0D64208410A1F94DF7A0F38074B5180770E36BE0F781F7E0782618010C138785F3F60DE2791022BBE208517D1584821117306FA5B5034E143D801EB1C9C350004A452C8F20C52C852697DABD6EA738D66F3F34AEB47FFF4BFFEF1CC20FC2D3233003FC472DD273E2926E3D1AEB298BCA62ACB4F1B635E4C6E97F5ABCEDD49C19CB5A4D41E9CDB7B1722008E04387477CE4EE5FEACF4316AB016823D3B1B00163A004146001E20CB40D18700BF2825190ADE57F842B63910221882F031090090429410F89294EAFF904ADEE69D3BF195BFFACA2C65D8243303F04328EFFEC0FBB7DACABCD998F293C6982B00404A158139A0564EE75D507E17B27BEF2C2971D8977316D6D47AE3013863E0BC87B30EDEBB296F6FAD83675030890EBCF7F0A2C603C4268CC0D36B10022231061C1D04A9D302C609200021643412FC192983B1F0CE9361108F4A21FF444AF18742C807BEFAD5AF164FFB8D780EC8CC00FC90C87B3FF8C1A631D5D5C6985F31A67A9D14921427280387EF00A22717529047F7B59226DB78EF618D097F3B17D20284342162021405380203BD731052C1DAF039672C82BA862883BDBA0FD601420858E711745FD0BBB59223FEEDA3824711825286FA650618059D3FC711E13DC195879190E23F0988FF24A4B8F7C6AFDDF8236B0C6606E0392EEFF9C007769AAAFCB9B22C7F11F07352AAF090A7201EC28D76CE86DF92D7EA103E1802EB5D4CC19DF33055150D88B7213AE00F3BE7608DA508C0D54683F0016B2DA50B9ED1C0784C8C02B2D1E0D01D9E2211D40F271B069928BF8F5ACDE7C10A1ED207061753118427703A115E431FC07F1042FCEF5288FB6EBEE5D61FA9346166009EA3F2BE0F7FF8DCF168F0596BCC07A59410529D713B31A534B5B2A70A17813C524A47110103827525C0C25626EECB5154608D8D0621BECE5182F3B0CE4605E6EAC194F2D3713AAA3E58E7E28399E8796D38D273AB818078AC0C2CF24E380A48B1053606C1D279082921A4F88E94F27720C47FBEFDB6DB97FF1EB7E739233303F01C930F5C77DDC5E3E1E0378D316F915226687A783F7A4690178DA05AAD403E86FF7E4A81E2E79C8B11010485FC44F80100535129D05A1863A272B241F0643C6C652065506800358048DFE112030350050175FA31F57026DB093E390E55285C983200F17CEA92239FA6784AA561DAA8780F4829BE0021FE9510E2960307EF34FFCD37EA39223303F01C9177BDEFBDE799AAFAD7D6DAB74825C1CA2FC08A23A2479C42DBE109109BBED5531E35F1AC9CE747A5A45CDEDAD428085863222EC00A0F00D6185495011C4500BC5F6BEB7D24150397787BFE9B0E201E1B7B703E5E494A1ACB8F31A4E7EB80A97382F7C43F4822A2803AC68B514707E19A452C42E09800FE7B08F17F1FBAFB9EC1F770EB9ED5323300CF7279DF873FBCBB2CC6FF93ADCC8704E5F632297781D1752094DA9848236A300D52D60AEFA7C1340FA2E85A0BA154AD9C6955C005F69EB52694FF9817604C547253552165406D2CAC31E4CD83B25AF2FAC1FBD71462FE2E2E21C2B9784EDEB9A9282175E7F1B56804A68D191BC83A8D1080144F892CA26CBE36DEA7DFE585109F554AFDDEDDF71E3EFDBDDECF679BCC0CC0B3543EF0D18F2E4E86835FAACAF257A594505AC7F73CD369F96FC4AA19D80332E30EFC1EF1F081A7E2021E645480BA9C479E59481914DD3B2203B9243AB0213D201CC192119052A22ACB48184AB707044C55C6309FF904FC7E8826428A22F8338901F008864E4819D30941694D2A75C9B33EDFF81322E4FFE9B649E4B4592998CDE8C9D869AD7F5B2AF5AF0FDD7DCFC9EF7E079F1B323300CF32F9D0C73ED62C46C3EBCAC9E4771C3C147B7DA9223927FAF6E4C19652C22184B262D3EB530D3AE4E522CACEAF51698EEBE6ECE905E5CA9CBF1B63A25734940618F2FC005016457C0FDE279461020C2B03EF93F05F88F01A6A23E1E97348F00208118D18938AA28726AF9D1A8114204C0D1E9F5C5A2911531E1FD19AA6511383879EA8CE0020A5FC2DADF5BFBAE7F07DAB7FEF1BFF0CC9CC003C4BE4831FFDA89C8C476FB665F1FBDEFB6D42D5A8BE942A3EE8ACC00079F980584125E52F19BD1F35D430298694075201F09042868799084153793785FC91160C84CA005182D93B3BE75055159519C3EF9C46586382420B01672DA41030C6A0320648F003903160A58E06230102390D89C4223A9ECDE5CCA7443A092ACAD18288E748006AC23AACB90700A4048821198053499781A2916098BC92EA5352ABDFBFF7F07DCF393EC1CC003C0BE4BD1FFAE015C568F807CEFBCB43794A4EE5B2ECC5A564C45B005252D8CEADB53A86F1FCA0D25FB1F60D4FF01623E7A87F75D6D5B8811001ACA3F0DB1151C724E1B8654547CD0CB4C6C05A13F6455EBC2C0A28A5509525A494841550FE0F4423E188410870AA503BE3681C9C0F06000980C969009F0CEAD222A40C060F350E501B4776F43527A0060C88702C301D6DD04F3622F17BC23539A9B57E8FD6FAAF0FDD73EF340EFB2C9699017806E59DEF7DCF5EE7ECFF6AABEA672004A4D2481FCF08D0B1F2476596F5EB14E633085697C0385A483D5FEA1D11C1B9E83529270FA5F110265B636B728EF770FC9300400F849660CAE9ABAA82B506B6321052C219137180725200F0914C14F27D13BF9BC14336002E1E939F32005CF98829CCA6FC3F3DC13A789FF6FE539114A7081C0DC8FAB3E9B67C8E53A063F279EF1C84529FD34AFDDC3D87EF3BFE7D7A4C9E569919806740DEFDFEF72F94E5E49F7B6B3F0320E6B79268ACA98B1242422A19E13C41DB2A02C1A4D6B4217B34F66635A196437C6EB99509A650F3F679A887885E76738D3EF6FE83598026A60782C27B6B6D507A6382B1B0165559864A41591226E0614D050053A41F173106C4B09B15DCF277D7313F982B90E20451FCB41366654EC3F8B8F5A6AA019384D272E5148E803A22909BD232FE2E25E5C7A5CE7EFF9E7BEF7D56330B6706E007289FBCFEFA6C341CBC737D65E57F0B3AA812CC89B8FBC98324A58A68B522A65FEAE58510104A4D817BF173A4248E10FED04907C03B380F28593FE41C2DA4A53F66E671C6605D9D073B0AF3193434A622443E1892AAAAE02C57001CBC75A12A80A038A6AAA8C3D052946043EA902875E83708A98763DC211E136DC7CA4C11C6546480DA560049C9301AC6C4C0891405082954044AD30884F6CD295A1A5DA492600FB7375BADB7DD79E8EE63DFE323F3B4CBCC00FC00E4E77FE557C5A0B7F10F57974FFD81B5F6029D6700C2C3C5DE1F84C383403CA9148599128CD907CAAF9C0E3D85A04A818C0A121ED2BAE4C5E16F886C3DAC9B46C7A594B19EEF4CB5096C143044060287BF3EE0018C860B004551104017BC3AC89BB3E25A6B61D808580B634397A12080D0C34756A11022460D9152CCC2A138B114194CE44A00926D53E5E6CFD691CE747560CA88F2673679FDF43822BB12530A3F657458B23C7F57DE68FCD1370E1C7CD661033303F034CBC73EF5A93DCBC79FFCBDCA546FD44A4328495E95F34E9E8D573F54A1B73D28B494FC60CADA2820F9BC5261DA0E2944F45ED1430603119FBCC4A3F17ED2D2203FC8967F52392F28B189A53B63C2400E6B2A48A9505525E5E741690DA5085325406B6149C9ABB2028717A6AC623311505717B8CE0F606A404988426CDDC29C1C77CA179812FADC14792839FFCD862235009B9564AAAC9ABC7F26E567A3A3B4FEC34EB7FBD1DB6EBFE35935A46466009E2679FF473EDC2D26937F3E190D7F89737600B169A7F6D094E74B9134F47848A982C20391F60BB0270FFB72403D2C83D17BD4357D25556CB0F1BEAE7D7B2AFDF1F747EEBD10B06C0C22C3AF8C9140A0FBFAD00B400CC1D82948809E40F0DE9EF611C2FD30228CF9FF1C1900547D00C2F74819F001C7CACDDC0417BF838F3996104959D960C44A409AE393C41482CF3B39FF7ACE0092FB327DDDD232E9E66DFF26FC81DF534A3FDA68B55E7DE0C08147BECB63F303979901F83ECB1BDEF006D9ECB4DFE29DFD3F01B42487E754C2E38785996EA9F273F829292D605C802304F6744AAA40691535A0A554D83E9266421E00AEE37314A0A40CE53C202AAFE408210D8F399248BC77504433159E476FECC34C80B86F21501645280F5655DCBFA902F85755558C0C5861B85F00A859825CF74FC9462E51B050727454B3AF8943A90AA61E3A7D2D6D8E92820D28120E400D7032EA7FC62625E6082491553408FC5A926E75BADDD7DE7EC7C1BF0E61DB332B67EE219DC9F724AFFCB11F7B7EABDBFE0BC05F2FA4CCA4540028C717FC20D5CA25C2D45B4825A1948AB9BF903244005CBF4778702495FF206B10504A014540E054D89A440D2C52E9604094AA959D2A021CCE2A29A19486294BF4D6D7301E0DA1A44496E7B1AC2894AE437163A85C68E27102881E3EB4F7DA1885F036D65A48A5E0AD83D22A9605596269CF23463131870762E542509583CB832CF1F724AFE7BFA7B44EA4B100BF249EEA191345DE1C35A420226FCBFB990218E91A386BDF77FEF9E79D3AFAE4F183F04CEE7866646600BE0F72F9A5972E5CFEE2CB7FABBBB8F08752AA3D4A4AD4E3AA44EDF1453DDF4E4909A9F494E2033E180442F159C995D6B41F99D4FCEBEE363600A07055290945A8BF8C2061480C226DD88731DDFC20F37139E7F0C803F7E3C85D77E1F16F3F828DB535645A61D7597BB0FBAC3DA82A1369BE3EC9DBBD7731ED306414384C4F79F9DC34A4B50EE9412C45BA70DEA0CE421FAE455A839F522C9F1072365700384CDF1CDA27C792AA3DA7542C536CC24DF73A2A7A927EA411021FDF66B3124B8C04E61A63FFBB0BCF3F6FB1D5CCBFB2B2BAE601F58C18829901F87BC8D9BB76CB4B2EBAE89DDBF7ECBEBDD96EBF5C290DC0D71E3EC4EFD17B0B2948E935202434470009DF9FC37E45887FF0B40A12B5D7E7A72A3CA3FCD0D5A42141DBCAA91221D17D511B96188548F6A002C78F3D81FBEEBC0BE56412B7DD73EEB978C10B5F84EDDB77420038BD723A9915485383948A653DCED759F558A1C33113F017478D7990FB8FC79886F8228928385549413849B8015F93CD255124DBC77D6253FECE17506C56F7BF39474EA30C8EA852A661DC26D92F5FF32CCF514CC657773BDDCBBB9DCE9F8C867D5FD960B27F9086606600BE4779F165975D78D6DE3D9F9BDFB2F8A966AB2515D7F4A50A209C4720F0508E2F49F90190975644E7E5FC1FD193C77C94BCA014129E1F70296295405387A0A09C3FD25A49F9391C0FF92962B4C13883B53646178A3807A79E3C8A9553A760AD45BFDF477F7D1DE3E110F35BB7A0D16C6279F914C6E3118C317026F4007821281548520BD4613CB7F402884340D82048C55D8B0C4E32371F11D390497ECD5385385A011BC458F598AEF947E51329408AFA3AB36C4AA16847F57E70866880A30B9F18FDF4FDB89B1A3760B0564A892CCB31292617773A9D97EB46F3BF0A6B6D654AB81F605AA0FFF64D6692CA85E79EDBDEB173E7679B9DD62F375A2D345BADF81E5BFFE07DC3100E2959A1655DEE93B57746F2B023196489F46112800487A5617F0C737108CAFB067D6700E9425BAD14125E05904E2A0DEEC653645C20806232C1C3DF3C82134F1C85730EABCBCBD8BE7B371ACD265AED36D65657E0BCC7703020408E145229F8A280CA323813BAFAA414B0C6452515224C058ACC3EEFEBDE7F0008494032529C3EEB8989C7384AEA65D9C8D89A8F0F9F62077E3A04E7FF8508FC0B4FB313B8AD98CB8474BC6CD88069C5DF5CF68BAFA7E9C9A6CF4C6331E1BBAD31C8B33C94459BADD76CDFB6F5AFAD31AFF15A15663CF6BDD1188004609F564B30AB02FC1D65FFDE7D62FB8EEDAFEC743B7F22955AEA2CCC23CBB2843C22A37715A2EE375742422802F43834E79C9E24F5D49B813B2EE9C984090820A2FA9E1499434B164FD58200C0C9C8D20B0AC8CE31A41DCB278FE3A1FB8E6075791983411FC5648217BDF425B8ECAA97623C1E13B3AF46FF99936FAA0A3ACB22B20F84E5C29C75F54C00EF634AC0FD03C61828A5880C147801D63A18A20733392832002968B74933101B83543B1CA71AE2A960215F1340B0AD98E2534CA5099B42F6081C26797FBCCED89446C4FB861AFB488048116E38A410F4FC00837E0FE75F720986BDFED71F7EE43BAF1B8EC795B2D6AFF77BDE3981A7D308CC5280BF835C75C515BB76ECDEF1474288DF6875DAADB9A54570638D4C944E4811E9BB1CDA2BAD09600B397DAAFC71AC575272AB11EBC440241C7EC87A7847A82028528AFA0113111444EC0108FB6020320090CE597CE7C16FE1F0C183585F5DC1F2C993E8CECDE1B5D75C83FD173F0FC37E1F5555A12A0A52DC8A708950CF572A007EEC9D8552B174E612AF1A4B88C6508454731022A988A2851AC760E50DE7FA546F8E3A35F01EA06BC7515854BC787352A59EDE0F7006EC204953A25149B67DCA319D013F4825E2378C8C38AE8808F47A1B505261CBAE5DE7B41B8D2B373636FE78628DEBB4DB42DA0A011B787A6CC0CC00FC0D72E58B2E57973CEF928F68256E74D65DB4B47D1B5A9D4E04A9246A0498953194E57400EEA48CB93F2BBB26369F9275475F0D66D53DE7752829E267EB284246855154324C81BDE0FD65CC9503A948122D5722CB32F437D671E4CE83F8F6B7BE858DF5750C363670D94BAEC22B7FEA0D68B43AE8F5365094052AA6F8729E1D67EF858825360329059F8C0C4B670B725D9E6BFE82DA8281A008D63A8A8CEBD25F301675F75E1C6C92A43BBCA68190AC58C9E8B03384E4F177321C51A272222A7A0A124EA1FB09C8F737AAFC19BE773A42A8EFD7683084D61A02C0FCE2C285739DCEDEB5F5F5CF1755E5B3564BB4B4C2A4ACF074540A6606E0BBC8AB5FFDEA0B5AEDE697071B1B3FD76836B175D7CE4D7936291EA3FC8A7FAA905B53EECDCACA8A28921A3E501B10565AEF11230649518652F5D8EFF0B1F059AD75AC9173DECAA9420D94F1525A80A2B2E3934F3C86BB6EBD15278E1EC3DACA69B4DA6DBCE6CD6FC6F32EBB02A3F108E3D108CE1A1822EBC45263521E335519CF9F231766F5313808606AC110061F2359C7874622D25D48F05C40071E882228E54895283217EB4B11239E5A49639E335DFB4F42F8CDA0619A4245C5FD2EC05E9A0E4C1984334510A9818987511B93C968049D65504AC3598BF67CF7F24EA359ACACACDEE69C85D719BA8D068A620CFF7D3602330C6093BCFEA77E2AD75AFEF2DAA953FFA2280AECDCB307CD761BD6BAD0559730FB64C2D797B2F6EC692E9FF6EA0388A90180D075271590027F42C69B22E5F4A3C7E13E2B398B52293E101E494FA8BFA145349552B0D6E2C1C3F7E0E16F7E0B1B1B1B18F57BB8E0F9CFC32B5EFD5A089D61D8DB8031158D01AF47764BA542AE2E42F7A1631E003DE4DCBF5F96057496815718B65515971E73D64ECD07B4650933B5E4186D632CB845990D8BA5BE0316473464CEF1191464A312B10121626A107BF953454C38060CDE225E41DEA436B0538B9D6E92CD2421C4FB99187AFACEF077701A5559A2DFEBA13B378766BB8DBCD140236FA0D5ED606D79E59A071EF9F65FC279EF047C43293F585FF78585FF7EE102330390C84FBFEDAD578D7ABD3F3EFEC413E7CC2D2E62E79E3DE10127AFCCA1BE56C4F013210F5752C59B1D73EC84BE1B72771943D934DF640FEEBC87A6FD00C113AA607122298625A60CF43029A20D33439069B4808FECC1D3CB2771E4AEBB70EAF871F4D6D72195C23F7AED6B70C1F35E807EBF87D1A01FC67D39874C295444E661EA302BB9A43CDF832604D179545505AD541C09C6E3C4A552A8CA2A180384E94142A9401B2E4B801481BD2003873C2E9C71837031939E854DCD4248528D74DBF41E6C6E154EEBF622310E53C05E72CDEBB50DFDE63763AAC2110A905485924DE3DF84FDF4D6D6208440ABDD469665D0798E2CCBD16CB5D0683571E2D8F1E73F7EECE823F070D67B9F6BE58B7EDF0F4BFB7D3102B3322080B7BFFBDDADAA98FCC6C9C71FFFF9F5D555ECDD7F2EE6161703C0C5F93D81788278FB9AEAD7298F7F2A574CB8FCEC99B97D96B7F1E0797FC1AB5B8A08B452109E67E0A57DFED3212BA721C61A28E1217C283F1A63A074065EF5E789C71EC13D777C031BEBEBE8ADAD61F7BE7D78D51BDF84EEFC02D6D6D7508C4775181C0E2E1A18E779151D1F4137EBEB558223590981DF1F15D1D7009F33261A0E996535090880B761168014D4020C108FA20ECB85AF270503880B8D30700ACECB39DC67254DC2779FFE3C039A3F9D9FD7AF713490EE33BE2DA7EF0F7FF64C730937A709424A14E331ACB568349BF1BC045545C6C40ADDBE63FB5757D7D72E1D0C872309E14A635C363787F9F118BDD1047FDF7E821F790CE01DEF7ED7CB07EB6BDFF8F69123AFF6DEE3BC4B2E41D6C82322AD7506A935B45244DF55D05A436915587D3AE4D58A40C02CCB6204109F1791504611867B707EA9083BD05242A8D0FB1F813F292393307E96D9869497875497E6091076A0B30C5A294C26631C3974100FDC732F564E9FC67063032F7AE94BF19A6BDE0C210436D6D7E2541F4B73FDD8EB7BD4B3F9D88F398A0462384DC70A90878D3304134F9C3E9F541214405C3F309427E96D62F4C5B15F9617200D834562884D4D441193E16A012B292B65E2A953F02E7D2D9C1FA6157BB3E7E6E82E82B1F229FB6023983A02FE6C343AF46D522994930946C32194D6C8B20CDCFECDC2694DABD3E9B6F2C6B9CB2B2B7F21045F6707D5C8D190024515D898DFABFCC8A600D7BEF73D1D67CD6F3EFEE0439F3C75FC38F69C7B0EB6EFDE1D1F4206F33C002D1524293A2B63E4DF83C262F21569881F424C1967CC45402B5D938E0C0B7BDB70E3C30ABB4C651140AC9B6B8A468C73D0CC34241AAE94649C94C6A993C771F7EDB7E1F8D1A3D8585D45ABD3C18FBDEE7538EF92E7A3BFB18EC924781F06FABCF781154867C221B6A0861D630DB452B1832F20F925A49061C10F0ED913A3C1A988A92A7884366280A6079765D009EFE34AC271D561BA07DC6D688C89ACBDD841C8F8431292C71420C9C1C39FD3A17F3410A8D383CD74E1681068DBA95162895717A801D774FB34D2E0CF314FA42C0A8C86430829D16834A6781C8270249DE5C8F21CCD760BAD560BC78F1EBBF689E3273EEFBDB780B7CE7927B5F2B22CFD5A7F7086BCE4EF263F9206E0DDEF7FDF2B7AAB2B7FF1D07DF72D4148ECBFF8223498D12704B4D6359A2F646CB5D559169B75D80BA7A537ADB3E001AD8177BE5ECC839F0D567E472C34CF14D2F0CC3F256724008C2B0D59964525514A41139184230E4514E1C71E7908076FB9056BA74FA3BFB181B3CFDB8F9F7CCB5BD168B5B1B1B64A833B2DE5EB75AB705A5E73D64128096F1DACABB9FCFC707B57AF13E05D68C7F5BCFA30BD1F094009A9C75907A524CAB20C6B1302112C8447EC1CB4D6C5A5C723A5982E0E8F17E70A4504F77C5D7E8CA13690442CF575E57389E26B2A31FF3E85110053C685BF935F8FB84EF2DE54F581B6998CC728C66328A590E50D285D47837CCC8AEEA5CE32647903ED4E0742A0FAF6238F9EB7D1EBAD2746C02BAD1C8AC2AF0F46FE7B49077EA430806BDFFB9E26BCFB9F1F7BF0C14F3CF6F0C3D8B9670FF69EB71F4CE89184C867791E91F62CCB6A8E3EA701E49D6B03101E1C451E92155F091967E20B21004560A2AA67F0F167206A0F1C734E005E4DE30B6904C240A4A66D9CB5B8FB1BB7E05B870FA3B7B1816234C2D5AFFC71BCE2275E8BFE7080B5D5155853A12A4B5817404621B358AA6363133C7C78208DB3F1C1E46362A04ECABA179EDB7B8510B0551553013EEEB4EFDFF07C3F534603982A7F2C05F2B5E01B4851812385417A9DECA6D99BAC801C91517A32B549B2EFC8BF081779EAB5D4DB7B263D2529463442A9C2274647CA10250D0703546589BCD1084E860CAF403810666B3A3A7E41584E3199A03B3F97ED3D6BF7BFD9E8F53E12BE0F9012D61A2B64A38179E7BE274CE047260278DBB5EF7891ABCA2F1EB9F3AEDDC3E110175D7A29E6971623275E698D2CCF91E9D0EB2E950E1E5FD60D3DA116AE686D3E9ACC13BD787D2959B9B9CD3722FE2E0CBB7010C8781DBED43BF14345DF175EAA15A9A60C730412BE37CF32F4067DDC75F34D78E4C107D15B5F47DE68E0F56F7D2B9E77D915583E75024551A02826C1DB724D5EAA80D6275E1DF493CB7D41D1152A532FFE01D4A17E9665B0267006844C093A36F1E201652F8A92F66F61681028EF4B298D8AA60F71F410C04017F10221682A115F274E01F83B3701727CFD4288E5A6A32BBADEACF082342A7A70FEAC4F133184A6AC2405898668F334A224322C8B02E3F108DEF9A8FCE16BA72B42F198444D14CB1A8D501568B7A094C6DADAFAABBFF3F8D9052F0000200049444154E8A387BCF715008A049C535A7B3B1CFAFEA4FA6FAA0EFCD047003FF38EB7675AEB5F593E76F45F7CEBF01174BB1D5C7EF5CBA2F5CDB22C027999E6109F0760848740D36B4AABD8F1B699B1C7B45729655D3293614D3FEEBC63643DA7921E87F369FB70FA300820D07A697B25446CC49110D12B1F3F7E0C77DE74139E3C760CBDD5359CB56F2FDEF2EEF76069CB369C3E7512555986B09F28B7820849CED818EA72B8CB08BD1212500A2579FB0870251E301A03325055558606176B60CB0A52EB80DE23785AA5248AA2A0FD0868A1619D8302AD0FE83CBCAC39FDDCBE4C17BA6E334E51F52432890AC57C00BE862294F024DDA7D41078202E1E12FFDE04E2B1870600E1119B84A68CC026000F08D8C7683884352684F38D8C2A49F2294B924FB19A50573A2C5550CAB244A79BA3DDC8FF9D52F227EA351A8363B0C6B8ACD341D3F630A980BFAB11F8A1AE02FCCCDB7FF67C017FEB43870FBFEDC1234770F679E7E2FC4B9F1FDE14A11923CBF308B86459069D65C8F33C0CD2D00A5916A20266C2090102DBB200CE651940009AA4878F2B055996D3C314228A10BAEBB85C16BC87CE72006968AF63B4A17578601487C94244A3C4C6E3F4A913B8FD861B70ECF1C731E8F570E5D557E3DA0F5D07A13536D6D75196052A63504E26148D500BAE0BFD031CF2EB24EC8D462109DBD312643A1D37E6E1CE416B1D4782EB2C0B2B0E03B16CC8C41F9E0110EBF29ED70A30F1A116926AFDFCFE26443F02ADE9D82E9C01B9170900BB691B992CB81A2A0CE15E71FB346F9C1A9998F6D1DB9B737C01C0188BF128302AA59475C8CFD39ECE1029C08B54FFE3361C0DF0E9371A8D6DCDBC71C7DAC6C6D1A9D233048CB368B65A28276378C84D477766F9A18C005EFF86378876BBF9E16234FCF7870F1CC4683CC60BAFBA0AF35BB6048FA33495F234B4CE086CC92108F00BA17BC8D198BB2F958A88AF8A94DE603F1B8D06AC75B07091B0A39285378224545FCAFBF3462320FF2A7855C5464286E19CCE3A0C077D946511F10240A0D168C23A8BB595D3B8EBE69B71F4B1C7203C70CD3BDE8E57BCF2B538BD7A1AFD5E0FCE5954B45C975475F352A4D28A30AE0BA8BD789816442BF6B0012005305585748EA09402555142D2C36DAA2A360931F30FC943AAA480A5BE25EBC24223CEA35E4E8C42054FEC41A00EC7D9DBA66DC151287C8773A0DD4F8180297EC1E7C38607A91282427D4FC8438AFC472437F9C1068CF65796258A4981AA2AA1B546DE6884941249C7E7A61425BE26926A054714A21EACAA1196606F341A6836F27F29047E82E10F3E100589D258B7B8B8E857D6D6FE4EBAF24367007EFA6D3FB32885F82FCB4F3EF953470E1DC2C2E222AEFC072F47DE6800F0C8F23CA2AC79A3118D81940A99568054D05A4178240F2E8DE4F6C1AE4208480838111E18EBA68741325018CB579463BBF036B4D4509984711699D2504C2A520AE3C918A7975770FCD813E8AFAFC37B206F36D1ED76D16835D1EECEA1D16862D0DBC0A15B6FC5C30F3D8C1DDBB7E1DA0F7F04E75D70314E9D3A81D16000EF83C7ADC13701EF2D8450B42028014974CC5CBB7789A270B8ECA91CA7B32C301609BF08F3066400D848E939E78EEBFB51BD9EC78419042F1F5719F26E7A692F2240396768EE01EA5E0320462E9BD70AE0BC3C65F4A5E01CF72CB0B2C6F4800C0A2F3E0A76C48C07F0FE235F214104921C7F426DD352CA10415215899F9FE4606334974611698411A31E7A2F3457850A8A3106AD6EE7822D8B4BCF5B595BBD1F80A74553BD17F012400560CBFC9C5BED0DF0B781823F5406E06DEF78FBAB9C359FFBE6A143ADA38F3E86732EBC00E75C7001E59C0A4A49CAF32532AD91E70D289D414901A93328F204924138212815D094C3AA08A005C5F0509A2DBB8CCD3FD63B381FEAF4E011DEBECEE9BC0C405E2635F2BC09A5157ABD1EBE73FF613CF1E8A3E8AD6F00005AED36E616E68327C97374BA73985F58843116870F1CC0830F3C888B2FBA101FF9A79F46D668E2F4E965146519B9F481331F56D811221C3FF7DF1BEBE8350DEF6CFD58D3EF3E790023C24D4C455EB91720A72D42294F90616085E39CDD53D9D17B1FB8FE349024E55C300B3080913622E753788A103004A4866B5E7BC9988F2389A4133C654AC13825E088081C35D4E840341EA13E5BA71C08951CE73C8AC904E3D12846448D4683DABFA7C95B218DA8177C4DD394789C1CD96C3A7EDE86A3325355C8F21C8BF3F3D7ADACADFD325F322184E7ED9DB3DE6599E834348685858485FB2EF9C00F850178D39BDFAC75AEFFE5B0DFFB85FB0E1C447F6303975EF9626CDBB58BCA540A3A0FECB898D733F847CA9F11D0C7E52D21556CEC5182824A81386B5F08812C0FD3758490144A0B52FC1AE10F39B0A3FE0120D3594481B5D6E8F57AF8F643DFC24347EE476F63035996236F34D06C35D16CB59037C2CFEEFC023A73F3D0598EBBBF7113EE3974372E38FF3CFCE3CFFC12264581623080A3E5BC056A243D784F9AAC8BF0201A1BE6FA4BAD8108B485453E440094029E41A53D2845CB823B288F58F27354FF17CE91C1E4D57F0D8C0DFC0243EB04B2920B216A9F2452E250109E0AC42DC56975828515372E1602D49EDFFB9A98932856ACD62051EE3442E0D1EDF597506A4106840ED2BB3015693C1AC1B9D0A9C98A1F093D0CEAC5EC8FB085043C9CAA1AF1F7F17548C045E73D8473113332C6C094253ADDF65BF32CFB8DB2AA36E2C50C17C30B21BD31C637BB7318956B705E790D2B00C06C3204CF7903F0C637BD7157A3997F71F9D89397DF7BE000B2460357BCE215985B984760B76551F983C70F21BFA6FABE8E169BE6F2491D69B89EF37DBAF1326C00E9286F07E05C083B352FD2E903F14513020ED4A3B6438E1F3CF16834C2BD870EE2C8A1BB31ECF7219526B048A1D16C20CB32B4BA1D74E6E7B0B8B4842DDBB623CF72DC73E701DCF1B5AF61D78EEDB8EE53D7633499C01983AD5BB7611540D95B8FABEC70175BE869080337D9D3A71E8A67F9AB2C0B9E9C229C140C1452427A17AA10E4356368EEEAD5829C354CE4A3C8DC216B345011FAEF11BC6AE4D6878B487844B2468073539E32527F59B9132010980EE9A7B26CF6BAC9F63105E0F708F43B131B905982C6188C87235455197A2DA444A399871432CB906561B9B7A9D58AA671BD294C223578539141A2FC9E0CD3E672B1B51659DE500B73DD2B9757D76EA6AF734208E7E1BD0020BDF0A5756E69AEEB577B0361007F26657F4E1B8037FFF45B5E9369F5E56FDFFF4DF1C0E1FBB063D74E5C72F98B28DF475072ADA178320FA3F3791E99753C4C432A05E17D44FB799C765C26DBD768B7E0509F5A6DC3C344FFD1BE20256C65A09544DE6885F423CB50198307EEBF0F87EEB803CBA74E5154A2C91829648D06F24603AD4E07ED6E1773F30BD8BA6D07DA9D2EEE3B7400377DE94B68B6DBB8EE533F1F4A84C6A0DB9DC3DCDC1C9CB3585B5FA3397F41D9EA1C362847A0D70AC0CBA870ECA9EB872E94F41ACD802883002801C46BC239BC31E11C9D73F13541C87959864543C350114F3D07555C74140081863AAC49887A9DC280978829859FAAB527A53E007535C16FF2B4C9F94F3556211E68DC411A7EF3764531C16838423129C8418461AC5A6B74E7E731B7B08056BB1D718F386390A2178E2AADA1A948CE46DE84B554FA74094989D313D49580E934C086A8400A2CCCCFBF637975ED001021262784F09E39E8CE799F65A2956B3F2E2D3C2C3420D228E03969007EF275AFD3CD56E37F74D6FCDA3D77DE89C71E7F02E75F703ECEBDF8A208B8D44A153C6F2CF36946F7758DE653071E3F204A241E325ADE30938E17EBF48ED6C1E39E7E000CE409042BDD6A36C3BEB58654124F3CF138EEBCE5663CF6C82370D60643446051966568345B81FBDD6EA3DDED6261710BB66FDF89B9B9797CF3C8BDB8E10B5F425956F827D75F8FC52DDB3029C658980B0F60BBD9C2603088E05804B5403308001425CFDC9B56062EC755550545ADC04A06541F92C67CF9405F66CFCC145F290237210EE744DD34C4537F52C0CE3A17D2283898CA9087735181D20A050F18E1D5815829D2B6DE344AD8EC4141C75997F5D2303B4C5A8E510121FD828C59311E63341CA22CAB509695A142D4EC74B0B4650B76EED983C56DDBD06A778201733545BBA654FB48E832C6A0AA4A544581C9708841BF8FC96482C96814BB027908EA53CE4BF2D264A0D16AE1FA76E6BAAF544A766CB0E4CE7BEF8410211A001C84F095B1BEDDED62BCBA060BE1F52628E03967005EF7FAD76D69B55B9F1F0F06571FBAFD0EF47B7DBCE0452FC459679F1D2A37E45143471C117CF28C6E4CA8AD07D20FAF6EA3A2D1D0B1D64FC411A9A029E78775840DD4641F1ECEA1B32CAE73CFB5E0A0FC61018EC978843BEFB815F7DD7508C5A4409653C720F1BD95526850FF77DE6CA2DDED607E7111DBB7EFC0DCC2221E7FEC11DCF0852F60A3D7C3473EF171EC39E73C6CF436B075710B3ADD2E3AAD36A400C693715C66DB3180E699861BCA70CEB9109910CBB162DA2E297496E7D0E45DA3A7778E2A154059543520461880AD4CF47C15450AD672C4148CA6A94A5208192301F6EC61FDC07AD82787FA21E7AEE9C4401D323340990266B1BF22F1EC89DED7910419740EFB397530C6A0180D31198F515655581149876AD1E2D6ADD8B5770FB6EEDC85F98525349ACDE02410005DA918040E38118F8663899180B528AB0AE3D110E3F108BDF5356CACAEA0BFBE81C964025396A8B8BF0248CA9234DFD1855E13630CF23CCF5BCDE6BEC170F430209C088512FEE7218417DE7923849D6B35D11F974F89029E5306E00D6FF8A92B5AEDD64D278F1DEBDC7BE020A49478F1CBAFC6961DDB01EFA1B30C90025A879C2CACC61B403F1EB9A4330D2DEB305F08115B7863C94C84321F8BB7063AD301E997F552DA4A2AA2BBBAE8789410C8F31C40A8B13FF6C8C3B8ED6B5FC3C9E327A09584CEA84F201AA9D014A2B31C4A6BB43B6D2C2C6DC1CE5DBB31BFB888271E7F145FFEB33FC3A953CB78E7FBDE83175C7E15D6D65731DF9D0BCADFEE20A726A1F16804A0E6DD1B6362230F77E60929A1F33C282B21EFB181861E52C35EDE85B500037E00CAD511D7E9934A8625BE65BD34794C2710FAD92B53D6D7D185D583D28E4247CCC3B4A32EDE07CEEF37797C4E6B22D525CDDD85980EE5A73EB4695B126B0CC69309C6A3319CB3505221D71AED6E173BCE3A0BFBF6EFC7961D3B91657938AF646A133B041D917F19A3800022D3CA4F32347A07E3E680C5255867519625FA833ED6D756B1767A191B2B2BA18F633C0ED88C639E425D4A64630D08B49BCDAB07C3D113084A6F01582184F3DE5B014821A5B3C68A46AB058C274F89029E3306E04DD7BCF19D79B3F95F1EF9E63771E4F011CCCF7571D95557A23D37175868590EA955AC576BCAEF730AFB9961A7A582CEF2E0BD958A0C388040248A14E2C30F6E0DE63E7C446F0801888403A0293F74CE613C1EE3E06D37E3DE8377C218832CD375C79E945064748221D0C81A39E6E6E6B0B8652BB66EDF81C5A5AD38FEE4517CF5CFFF3F1C3D7A0C6FFAE96BF063AF7E3D8E9F7812DD4E078B0B8B98EFCE412949DD7D06A371284999B2445595A1F4E8A67368A6FAB24E30A2CE687C5596B1B79FDF1332940F99A95787E1758FBDB3166551067094AC6145DC7F6B2A1A1346537F45CD40B48987E7EF33B4E250AAACACE86C7C850F8D3E4012C6A3CEDD394A0010AA1932702D1C951821044C5962341CA228CA5015510A8D4603DDF979EC39E76C9C75CE7E2C2C2E51B5A4AEEA78112A3882A2445E70253039A7DBC423074008287220825680CA8540B3D144BBD3C5C2FC029696B6606569192BA74E62F5D429F47BBD7AE4BA403C079E870001341AF94B04F0E71EB0E4D82D8221306408BC14F016C2761B0D0C8AD042C051C0B3DE005CF396372B21C46F0AF85FB8EF1B07F09D471FC3D2E23C9E7FC58BD199EB0200741EBC67F4EA0874DD3CCF69508786D60A5AE9C8D4637EBFF7818E2B6520C630A22D94820497F35CF4FCBC0D9704A102AA9F677964D59D38711C5FFBE2E7F1E4D163C8F33CA934F01260C436940A2ACB90379BE874BB98DFB205DB76ECC4D296AD387D7A19377CFE7378F4B1C7F1AAD7BE0AAFBFE66D38B57C12F373F358985F40A7D38594124559424060301C6030180403604D9CB40B7838E7E379116FBC06065314BFAAA068D0A8A76942A13C6812D4DDC13A0F38079B78ECAA2CA154A80E84BE7FE62270330F6A24DB27C7C3E90429978DD114550C12943F0282F4B74C727D916C5323FFB4E4593C576A25AE0C46A321269309A5370AAD6E175BB76FC7EE7DFBB07DD72E74E616EAE6263A7F25EB8120ACFCCCDC04EAF490B7091C031E112F621AAA047773D62555253B8405E568349BA12274F224FA1B1B289265DAF8275FC756AB7DBE14A265BD370846C002DE082134282A1010C2582B1BED961B142552C57F561B80B7FEECDB3A80FFFCB83FF8F1FBEEBC1327974F63D7AE9DB8E4B21722A7314A8CF44B22FA28A5C35C359D25E53719C114BE613CEC8323031E641981220AE90388C3B3F701AEE71A53416622DC2846C6BDC7E14377E2F61B6FC46030088CB04D0F0D4F0E524AA1D10835FFEEDC1C16B76EC5F61D3BB16DFB0EF4D6D7F1D5CFFD391E7CF0215CFDF297E1DAF77D04274F9D44A7DDC5C2FC3CE6E717902985D2188CC763E4598E93CBA7605D0092EA75F70217C01A83ACD18863BC784621F72D946519E7F97B048FE95C3DB3901177479C0A5F4DE06C40EA95AC67161A1A09C640A131153DA881EEABB30CA62C6347DF14E8C757372DA3F16BE4F199E6CB805F64CD21C103D8F37B0F0F57CF5C40886E46C3A0F8DCB6DD9D9FC7AEB3CEC29EFDE7627ECBB6309D87C15D42DBEB25DC937B2878CC7BDD0ACEB80E13C9185B60E629F34AE21467917403C223CB32B4DB9D60A8C859655A637D751593C924184032B27CADB456BB94565B6C650A0006400608E3BD2383107AAD04BC7752416B89F07884EBFCAC3500D7BEF73D7BABC9E4D68D95957D771F38885E7F80B3CFDE870B5FF882D8FFAEB3308083952AA0ED617C172FB9AD936A801002595C4F2FA0F901C809FE83F9ED01AC0A5374B96F3E389530A8C27B8766A3191882DEC33A87C170805BBEF2657CEBC8FD00041A793ED5E5C7A546FEA7B446D668A0DDED606E71115BB76FC7D6ADDBD0DFD8C0D7BEFC25DC7FE47EBCE0D2E7E3831FFB2738757A19CD4603737373989B9B879212A3A2C060D0871002A3F1186B6B6BA1E1A60A03380307212897CE73EACAF37145E0800F3880907F4721A6E78E3B41945588381F402919002AAAF5D9AA8A61B8352694C120E04C45683F0D147561C0884115C93DF0F5349F14FD66896C3DF6F86404E8CD98EB7384907202C25133E81700C8E170886252C4D46F7E6E0E67EDDB87B3CE3D17F38B4BB17F81E9CC617976D4393DDF43E68C24393F502B7A6C1F17F48C719A47068253CAFA3855BC6E119C6E343137570F5675DEC3AEACC47480CFD505032E339D6D2F2B731A4016FEF98A7E37F05010B0C20B6FBC7773AD965FEB8FE00168403C2B0DC0BBDEFFBE9716A3E16D278F1E93F71D3C88516570C14517E2DC8B2E242B1BCA6A7C71E30556A1034F69456395326454FF975221CB34792B4DA12F0D91A05034A0E7E1A5902B0A68A1422E2D08DCF20E390176961A5F4E1E7F127FF5177F1E80BED839582B7EE41650B92FE49A81E137B7B0886DDB7760EBD6ED28AB125FFFABBFC4DD07EFC4FE73CEC6CF7DFA33585D5F47A635E61716D16EB59069857151A2D7DBA0A6930CC74F9EC0B898A02C4B98AA4459559462C81AA916A12C25622DD9716529A10B07320E83565565A852C2393AE91B796D1EF469130E81358112ACA50CA980202AB5A77664DA512C5792F7E79FCCD0E3ED9E92D38B691EFE54E4C0AFD175B7C660341A613C1EC7EA42ABD5C5AE7DFB70F679FBD1995F4C5220CECDEB305B485EDF216028BC286B340414552A29697294A2B4A1BEEF4C61E6C9CD61F5286E32029849AA54A8365965A1758666C3C1CF2FD2350DCBB20D7ABD2923E73C608D459E674BC3F13803902344019510A20284F670061E1242385827649609C0C3521AF0AC3300EFFBD007DF35ECF7FEF3771E78000F1CBE0FDE03975EF642ECDD7F6ECCD7945675C84535FC80F2D71181D65930145A430A191A7C10D6E5E3B29614B44C17D5A1C3604E45A494BA46CEBC7AAD1494CA438D9C0669DC7FEFDDB8E9AFFE0A83C1105946FBABD924B5121240C89CF166A78DF92D4BD8B1FB2C6CDBB90B9531B8ED86BFC63D070E60F78EEDF8C42FFE3226650901849CBFDD4123CF319E14E8F57B188D47C8B31CC3411FC3D1105559A22C8B48D8E194C3708B2D294EE0F1537E4F2940503C9AC76F2D9C1430C6C5AA019C87E16A405511D947404B81CA5A54A4E8B157C01AA20E9B785FB97FC0278ACE137F5D12F6A773169C7391AD37456822638D743FA4FC6CC807C321C6A35104169BAD1676EEDD8BB3F7EF47777E21A42044510E9FB5902A8BE41BA9184FAA3D7F506A4911E8F418B68C968063A43F86FC31F5A489D2E0B663C4B4926D9C205CC94907AD33341A0E0B0B4B1163A9CA1293F1384623DEF1C835B784A0FC158263CF00AFBD770A21059002101E5E3A21BCCEB40F388D7BF618808F7CEC63A2B7BEF63F0C7B1B9F7DE0DEC378F0C187904B81E75F7139769F7D36AC35D17BA633F094D6903AA3904D44524DBC3908F56F9EF02B02120440C4365CC4240054EA92503A8B11827788CAEDBD4755853CF6C06D37E3E0ADB7C1598B3CCFA6260309B6FA0CFC51DE9F371A683483F7DFB67D0776ECDA0D630CEEB8F1061CBAED362C2C2EE293BFFC2BF042C2980A4B0B4BE876E790671AC3D11083E100237AB027CEE3D4E96594458192A6FD58EEC84320F6706EECAC85204E3FF83C19E47296D21D872CD3211A9002B62C21296280F728CB713C1F9E005496259456310A708443302EE0AC8D9F672FCCB3FE1D35107147616CD8A1BF53249FAFA94F141F746E4C551622CCDC1B0E86E021A979AEB165DB36ECBFE4122C6ED90A2182D76440367C9F80943AE9C1AF87ADB20273930F7BF288E54819EBFEC1F968685997020132C672BA94475F44D154F8D3BA30721D1481C5717452C094054634528CA12A8647AD356D04679E032841D1BD1042015E7978E5031868AD07DA79865E159EED678501F8F8673E93AD1C7FF20FCB6272ED913BEFC2638F3D8E769EE1D22B5F8CAD3B7742C4B24BB0B4AC503CB29B4775058310409CBAFEAAE2B04E80AE79088A01CADF431F4B98CF0F30F79BE7DEA9907F8ABA0575381EE1A62FFF251E38727F4813A80211F64FC6855300201AA52CCF91379B985F5CC4AEBD7BB1EF9CFDF0000EDE7213EEBEE30EE4798E4FFEE22FA2D999C7783CC4D2E216CC75E790698D4951624843268AB240BBD3C5FAFA1A26C50493F108A3D1385C4CAA117BCAF5C34BE167559684F207024FA825071361AA1259DE006176342730E4E71CBA4BADE09DAFD7F5B3A16FDF8BBA6DD826DEDC3987AA32713153A01E351ED1FD64C1119E04C4F3FB38944F813D20E913A0F7A49428AB0A835E2F9E639665985F58C0B9175E88ED679D1528CC843F08CA89789D072935787D418ED6A41031C467C59767527ECEED45BD4D8C4E53F010015389AE8619A5BE36C09E5BA3691E228F9B574AA158DA8AD5D3A7D15FDFA012AFA0B22CE09D5308BAAC11727FFADD6BD41180048474CEBA3CCF81E1180ECF0203F0F1EBAFEF9C7EF2E857C6C3E1D587BF7110C74E9CC07CBB85E75D710596B66D0D483DA3AB14A24B2190359AF182C7619DD4DB1FE6AC0B0ACB82A5D75A1165D3D5A83FEA7A2E40A527CE6D518FA0CE893823A4C489E3C7F0D5CF7D0E4F1E3D8A3C6F3CE57CB8FB903D88520A8D66337A10670CFA1B1B103450F3F4F2291CBEF34E64798E8F7EFAD3D8B66B2F3636D6B165710B16E617A0B5425116E80F06180C07288B022ACB301E0ED0EFF782F72F03B8E588A0530FF60C483F2B710C771D42F8AF159CB171D1D0E069AA08CA49C10B8A12AD554850CB7C6CEF05C2FC7E979416E377D2D4610F5133F8229087B03D01110C8EF1B42056EE74CA2FA71E6949D0FBD09DD7EFF7C1A3DCB22CC3DEFDE7E2ECF32F40DE6C821720F50CF4AAD0B813D66408CACFD39FC342AA35A29FE6F2ACFC716A13DF6741E3E2440DFA32062368BBA8F754E2840FEDD0F15AB9BA61378D7A1C19BF3C6FA0D96EA3D16A860131865767AE609C3B89DA0024FF44507E01E1BD0FA442075AD32EA8C0336A00AEFBC427769F7CE2F15BC683FEFEBBBF7110A75756B0B8308F17BEF80A74171602824D801F2FC9258498525A19ADA4AEC72E89BA461B3BD73C2268C74620865E49D80CD480D2947100F09D871EC0D7BEF845AC9E5E41460D471CFAF1AAB9D639B8AA82740EA22A618D45592EA3988C51552696B224C25AAF4A6B4C2A8337BEE51A3CEF0557E0D4C9E3D8B6751BBAED0EB456188EC7188FC7180C7A28CA9296FA1658A5FAF078320E083CAFBEC3213B7D4718C56DE2E8316B6D587548A988DC6BAD6110883BEC71014C2D0EEA5D28FB596342BA40D74C08DAA7546116A0B561F29175D178A72BF9C4DF93C73CB9F410A8390269CE1FDB77693B29C37CC17EAF0F63AA30DC454A74E6E670FE251763DBCEDDA1F1A63275080E2ABD81727C2A1D3339478ABAA22469F8AB942A2ABACEB20890326DBC56FE3AE553D178D4253F3A393A769003AA0D22155CC03CC634DD1142A0D16A6171690BD6575630E8F54295AA3270C63E6A9C3B8AA0F4EA0C3F230EE04324E03C45D0CEF8672E02F8C0CF5D77E9E9E3C7EE2C2793C6815B6EC546AF8FA5C505BCF0AA2BD1EA76A3A2438888F007AB1C3CBD227499AD7360DAA958220A8B66D4E40B200196A8440350371C710242BD3B787045A0E0847AD8EF3F7C376EF9CA5F63D01F206BE404B48507DA5887664362717101BBF6ECC6652FBA1C4B8B8B68361A68341A984C26B0CEE1D4C913B8FBD0211C7DEC711C3B7A0CA5F35095810670FB4D37E3852FBE0AE79E7721E63B5D0829311E8F311C0E311CF6319A4C2021D09EEB60F9F43286C301C6CC1DA7493440683AE174A42C0A9A809487B21DF1000252EE6394606934173FA0B11F9F51782ED55179D1D5E05324DAF0DC7F1E2CCA2B00B111A88C01A88DDAD12A442261CDB177771051D1854F5987D3D2EBF5301A0EA1758676BB0D0F60FBCE9DB8F0052F40B3D582A5F9831193A1FDC667883DBF94E4D11392964C702699827D82806022F4E8F05C4921A7D381580AE434263E964F9158D243A06238EE0E2451A407CDBC01B77D2746C321365656301A8D30ECF5D05EDA7233B59D4B4C470012ACF8DE0B11BE480010CE0379A63131CF1008F881EBAEFB87EBA74FDF34190E71F096DBD01B0CB065CB122EBBEA4AB43A9D70E2E47D63FD9C8018418A1F41406820B6FA0000200049444154A56B86964A2C710AE8C8B06805CF990B055EAAF1D2FCBDA0D00A52EAC869AF28CCBDFBC0EDB8ED861B519A0A592307BC47652D1A8D1CFBCFDB8F97BCEC65B8E69AB7E0FC0B2EC0E2962D68B6DA9052046AAC9431041722AC7F37180C70EFDD87F0077FF0EF71F30D3762BD3FC0F2CA2AFEE3BFFD1D7CEAD73F8B85B939F487030C06A1638C7BFEDBDD39AC6FACA39F7492F1EC3E8F9A55560F3691B15B8F0D44E8F89310AE6E8AE18A00BC87E5C945BCCE9FF7715E80B12E2E4DC5C347B873D0D2F535DE46B291E7FD5048ECE062D7E0D4645C7ADF182A4FFA9ABC93E6FE528445487BEBEB30360CC0D4C4C5D87BCE3938E7820BA0089864FC872389C8C9A09C9F177BE109C991B0A5EAA5DE98E157CF8DA0A61F9A1E9586FC4AA50BC44E837D9ED29DA93166409C9B688C41C5B314C8900AA9D0C833CCCDCDA3D3EEC4D6ED8727636CACAF63B0D18352121B1BBDE308A63B7AFA4DBF4B1100AE70329471E54A89099E8114E0BD1FFED05BD64E2FFFBFC570800337DD8CFE7882A5C58529E5D73A8350B5F5658BFCD49A2B87FFB22E4D45C311423388A4875F0271AD794FC316E87D5604297524CA14C6E01B5FBF0177DE763BB57A6A9465854EBB8557FCF8D578F7BBDF8F57BEEA55E874DAA8AC85A9429FF789E32742579C90188D46016894E1F766A301EB3C2EBEF432FCF6FFF2EF70F8DE7BF0FBBFF76F71EB0D37E2E4F269DC71EBD7B177EF3EF4FB7D8CC6434C8A12DE1AB43B1D144581B5B5551493318AC918A62AA70657B281E41400080A1FBA121D4C59456502887CA3544238E1B165D39F0F5B87F8B12C0A6A1A021951110790F03E530661DD1ACB63C492219C7CED9D8341300A1A2AAE36C4868CBF7F381C623018400A8976BB038800949D7BE185D8B9674F3D5D2851F898122A19C1E134D7E77491AF9D1492BC7C42F811A184ABA4845034458A5206C65C000EE345ACEDF37D21A2035D93B04E4245EDC1C65461CA0F019F52863E114D84B6134F1EC5EACA3256964FE1D4891378E23B8F623C1A03F0985B5C2A8F1E3FB18AE0F12D48E1CFF02FE653A148EDEB0ED8EF4D8DBF37F9D9775E7BDD707DEDF7C7833E0E7CFD260C8B12DBB66EC10BAFBA129DB939586BA97ECF5C790ACF28DF521405643112A851D208FAD10DF5C481CF75CDF1D75A43A860063D214FB5550E40A147A0A84E8A02B7DEF015DC7BF0AE009639079D49BCE675AFC1273FF9695CF5B29701F0188DC6E8F50307BFDF1FA03F18422B85F1A4407FD047236F60380AB3E19552383999A091E73876EC18B23C43676E019FBAFE5771F52BFE11FEC3EFFE2E968F1FC7683CC170344449B5FDB94E07C658ACACADA0984C5014937ABC164DE071D640F89A61E6AC890FB9878729EB34C17B84DA3D424ECFB88194BC24575068FE8EB0DAB0AEFB24409D80B15F9FC0AC044B61702B1D81CD8D52C1E08A18B9083A28BE46DC6ECD8BAB78EF63FF7C9E8711EEDE39E48D26CEBFE4622C6DDB8174E5E5B89A73822148A963CBEE14D84711254F740A797F2803339817955F48D226C175A418BDA4A13FE8BD383F92AE4D652A4C8A12D61A545505631D8C29519615AAB240391963321EA12A0A6499467F7D1D93F118A3E10883C1002BCBCB988CC758DAB60D73F3F3184D8A5B6C585F2D55765EA832A600F4B70008084C52AA1F980178FB3BAFFDA5B2287E6B3CE8E31B5FBF09A3A2C4F66D5B71D94B5F8246B309EB5CBD124FCCBBF454930F8330CCD28A4B764939759398FB2F059FBB8F0F1280C0111712BC6A4D1810126AE4DE3B8CC663DCF495BFC491BBEF09B3EECB0A175D72317EED9F7D16AFFEC99F84F71EA3D1103CF9776D6D03C3E11052290C07430C47C3C8B1DFD85887563A8478549B5E5B5F4746ABF9781F98747BF69D8B777EE8435859398D9595E53062BA2CD06A36A1B5C6F11327301A8D501605AAB28C4A6A8DA1CA082D30CA642919700D4BA4A6A00B09E844A530E94270289C404503431C4F9D49AE99B361351F296B72913115329DA1A29269FAFD000DEF702E22FB965A58415183C0745D9FC1C618B2136760637D1DCE3AB4DAED1015388776B78BF39F7709DADDB938CB904B6F71E41945013ACB6AC08E3024993E531465AA64166424FB7048CF8A9DA42D3C2F522A0D5E3322E021E15C2B53A1AAAA50AA2D8A80E90C7A180D06180D0728C66378471391C8607BEF501605564FAF60757999D89D06EDF939ECDEBB175B76EE84540AA78E1EC3F2CACA4144E59EFAC7468045C40BCF375FFC807A01DEFAF6B70B01FF1BC564FCABC568843BBE76234665153CFF4BAE42A3D5022FA1A589A5C7DD7B7CC195080CBE145D5511C5254066CA02537E46F97782EF430A855010E25740F973580177341EE1A6BFFC12EEBFF75E000259DEC0473EF68FF1A94F7F06F30B0B98141358EB301E17180E87F0DEA3284B0C47630C870328AD83F21605794D8F713942A3D9C2643241B3A9505625008FC1A08746DE40AFDF43559568B55AD87BCE79188DC761959D3C47B3D1C08953A7301CF6511625CA2A30C2B8162FB54E3C2F85F53A2CB325A914C9E3BE245D4FC7C342892B501693B09007BD06D06AC45CAA22E5564A62321E078E7F1506879665196AE894B77B9E6C03F280442A725CFEF01416D336531C7E02C32871455114E8AD6F404A8176A70D20442C0B4B4B6119F73C0F53896298AF08EC238C819AC342F4580FE9882DD911430A0C3FA5B324F254D31A24035EC411263B0D26A0391F00D8B22C311A8F3018F4D1EFF5D0DB58C7C6FA1A46FD1ECAA284004D4C3616C6844554AAAA447FA387F17018C7A7B73A1D9C75CED958DABE1D73F38B6875BA188D8658397902A71F7F0295318F0E07C301CE6C007086BF13A92B304FAB0178C39BDE249C297FC759FB495B55B89D947FFBD6ADB8EC652F45AB1D56E4E53ABEA330310C4D409C9813699409AACF44897023EAD1DC2194A346092F621E19B8D6B4E8258D96731ED02A4CF635D660381CE2C62F7D010FDC771F9C07F69DB317BFF19BBF8DD7BCFE75180D47585D59A14EB6103D8C4663ACD2020CD6394C8A0276340ACB687B876A3246BBDD415585505E4A81B5F55538EBB0B6B682B2AC501413F4FB7D8C474364798EB9C52D188F86C8B30CED561B27979731E86FA02A2B4C262398CAC476E42CCB426B2EC26423CBEDBCD6C4F3E6C9C03CC59789388CEA0B01289DC1181ADB4DE09FE5293D8C52DBE9B5F784AC0D49ADBF0187882B0693F2F3AAC8530B74D24F1EFEC1F57DCEA927E331363636D06C3491E5598C76B6EEDC8973CF3F3FAEC8B479759FD8AC2378BC3B23FA75AECFA4B2A8C4CC2361E20E0FFC20AFAF75880EA4D2343D9A815687D2541893C2AFAEAE6265F92436565730EC0F301907729640305C2175AB504C42DF8692610D81BCD9C4D66DDBB078C925D8BEFB2CE83C479E658054A88A0936D6D771EAC4718C07430CFA3D0CFB7D58A5BF8E3AD4DFACE8FC3BFB37FEB3C654E9A63D6D06E04DD75C238514FFD159FB0101E0F61BBE86515106B4FF652F45BBD3A6765C45EDA90A19596120DCCC2C0FB56B4133D9A4D27493644C0DF846F239F343AA7516F37B45C08FF04CCD0CDB663A0FF9B1F1180C07B8F18B5FC083478EC07AE065FFE065F837BFFB7BD8B36F1FFABD4032F142A0D71F60301CC7D157CE7BF4FBFD709C00AAAA445102DD4E0723A2EE4A21B0B1B10108111E82AAC46030C47812987DA74F06D0F0ECF32FC4A428A094C2962D5BB1B2B28C7E6F036551D2E72A38632054E87AACA8EFDE5A07E7EBC53B3DA553C19B08388B38DC8425D6FF696A90B361F4B4E309C28EAB0186D20562FEF9301B118971E1EBCE2900D7BC7C9C464FF442E24A281D6AD851D8A820287FBFDFC7783844B7DBAD9BB4ACC58EB37663DFFEFD10142A47AE0723F210F1F9E0813029659C31A4346AE428C0C3C7107EAA7F83F8275AFDFFBCBD699064D9751EF6DDB7E552B95465ADBDEFD333D3B30F0603102408103417701369931445894185C30A8B61FBAFC211543814A1B0A9306DD9B222140AD9062952A400921041D204090C02186230C06CE8597BA6A77B7AADAEAE2DF7F52DF75EFF38E7DCF7B27A400224C48CA8AEEAAAACACCC97F76CDFF9CE7748E895323EC277BADD3676B7EFA2B3B78B41B7E7CAB2E9788C344B91B1B10B76B250AB6169B985A5E515527CAE371095CA10E5DF344B618CC67838407736C36C3643329D623299224B0927988EC7F07D7FBAB3B7B759783BA561F27E863FEF042CE0794AD9FF9C0EE0877FF4473DCFF7FE7D9626BF1845119EFBE233184E67682D2DE2F10F7D080BF51A6470A388F23B24D6CB37F14846900FD3B040231B7FC84060B1C9EA6A41DF63265A7E8DE460070C8EA55986D9648CAFFEF99FE1DD37DF84B6C04FFD573F8D5FFF3FFE35A23044AFDBA55DF6D2BEE2B6DA683C429A2680A53A3B4E5344618852A98C31B3F47CCFC37432A13E301BAAB516499260369B62369960D0EB61341860E3D871F84188344B7168E310DA9D7D743A6DC4B31833D6FAD399ACD5CE18C02CA4E7CACB5B664AB9DA5F6B16DC2C20FB922EA7A21BA08D3B21247C62F355E1961881D658684363ABDA68DEFBA79C50A863F915B284C21FE49240BB1A595A666E0C987F6738182099C56830114CB296F5C38771E4D429C8BA325AE55E307E21F4F8B9CEA2648442160BC210A120FB5C7202F4DEF84ADACD2CD21A907294AFA84D3C4B53F4FB3D6C6F6F6177EB0EBAFBFB18F47A741ED214D3E914090B77C87EC9FA6213C75BA7516F3651AA56114625CA3CB5462AD4E5B4EDBA4E0298127E9061361E13D9C7182469029DA648E218A57AE3CBC6589730F155B6102DC07B3FDB3CEE5BABE0D9EC3F9703F8C0134F7AA552F4DB6912FF42B55AC5735F7C06FDE108F55A158F7EF0292CD46B74A0946584DF7354C9E2D495902E3C3F800258C5D7A34514E210A4C56445982227A550FDE7C15A92EF4E92CC113E3C2E290451FFEA335FC0E5B7DE82F57DFCFCDFFD39FCF35FFB750020B18D28823106BB5D225F48ED6A8CC1783C060084DC99184F262897CBF0FC00C361DF31174514C31A8D248E99DD37C1783442677F1751B98C4AAD812CCBB0BEBA8E7EAF8BBDDD5D37DD6774462D3C31146194F1E114741FC877FC696B89F6A5C5E834A7D90A1EAC5396750B38182B49E2D8755D8CE6515F3F40962679CD6E683F805B86CA7FAF1882F8C9CEF5BE25537392DE3677CDB016837E1F5A6B2C2EB710C7B193195F3F7204878E1F772DC61C0BCA23BEE7F93C172225402EDF4DE3E281FBBF6B11AA5CC7300802526FF2E9BECAA3052AFBDD0EEEDEBD83BB9BB7D1DED941B7DD463A9BD1CE45E638942B15D4EB75543636B050AFA15AAB03E07D0BD6204E624C67B37C56C2E6222B64953C9DE2FB4EF5374D62126AE14CCB688D34491095CA7A776FEFEDC2451643972C4023D7076481502B42A1940128D8699202F82E3301EF3B7356ADAEAF7C2A8E67BFB0B4B888AF7FF92BE8F4FAA846211EFFD087D16C2DB36A8DC96B7B41A8A556735ED873B2DD826AE7938079CD46683FFD7DDF0F5CDBC5AA9CD20BCBD1CB5308F825D3F86C82AF7DE98B78F3E2AB3016F8857FF0F7F03FFF8BFF0D711C6332996216C72EBA455184E97486FEB047F51B3F97F16482198046A389B231E8763B90259E44F73430A0FA37491292EE1AF4311A0ED1DED986D61AAD8DC3002C0EAD6F603C9D6067771B493C738CBA344909B694B71A7029B682A4F7BE4B8D7D3F84C9526696F1E08C450ED2F14364BC268C02B771190501A9DA612759967247218329A4EB72788B6D25B7E8A268E0DEBC56BE38FA629BAFDFED42790AAD95654CC65397B96D1C39828DA3475D6623CE9F1C411ECD3DD18428B0436507848075920DB8915FCF43A072E31731D7F16482ED9D2DDCBA76059BD76FA0BDB787C968E464D0C372194BAD166A4D4AE14BA5929B8C4C920469AF07054BB2E75E5E4E09FE224141DAA7502424ABD314691CB3E3A08CC91A43222C9ABA03E57AE3C53411A140002EC2431480E4C380F4018DA5B963A9FCAD672D922CB5DF550770F6D46975F4C4B1FF535BFB4BAB6BEB78E9D96771777B0725DFC3C34F3D85A59515EA05BBC18A1C6D0550E060CB46DE5C6A49167B08C14726EDA0880B20DF13E3779FBD7C28C6037976285A7A91A4095E7AEE2FF0C6372FC258E0A77FEEBFC43FFBE7BF46405E96A15C2EC15A8BDDBD3D8C46E3FC8D3396C6718D41B95C467DA186D17884BDFD5DCA64AC6589708A8A6414ACFECAA8F0703040676F07C3411F474E9F45A954C2FADA3AA6F10C77EE6C32C9274592263C9C63DCA191E51344A9A535E34110C2B5D92CDC0192434E034EACDCC387D0192E8359192FAE08C208D6E4CA38A424440C3A1955959A96662A08F0CC9790C2198A9BFD2F32E054CE13504A019E87FEFE3EFC2040637111E3D1C83DB78D2347B071E488BBAF0C8239E28D5079C5E839D23B91982040C4812608F3BE7E71743C8A4A88821006169D6E17B76E5EC77B6FBF859BD7AEA1CF2A4BE572198D66130BF53AAAB59A7B2CEAA0C4180F4780CAAFB5D1A485E0B398A8DC3763D6A45279A666AD451895880BC0674F7A54F27E2A6B91B0F8CBEEFEFE4B070C5FC24231EA670069045ADE156089E5652C98F16600F5DD7400274F9FFC5FBC30F8EF979797F1D62B2FE3C6CD5BF0005C78E2096C1C3B0A0BDE2A4B3D9A9C372D640C375CC1B1C41A28A65F16C51603EEF1138B6D7E04B7383CE1298FD25263DC4210582049626863F0C6C557F0CA37BE812CD3F8C14FFE30FEC5FFFA2F91651A93C984DA332C0556AD5631994CD0EE74485B2F2A218A4A984CC6E8F67B58A89298639666880DB1E47C4B5C03CAFC697C76341A62D0EF62341AA1DBDE43B7DDC6D2EA1ACA0B35ACADADC35860F3CE26E2D9CC893F689D395D3D5FA4CC3C8F117801383D9EBA23E30C4302073D1EF60147223FF09D8166BCFECBF77DD20CB00480696B183B002B1987042CC222E37D0046F4FC8C487B17CA0C3EEC84DF000AB9E1DF830FF0E7EEFE3EC230C4D2720B7D5E8A6A8CC1EAC606D68F1C71EFA99BCD2F90C204D517E30F9DE1932C7CC83B20F24132CF65965114B13C9CC27EA78D2BEFBC85CB6FBE81AD5BB731190D114525B49697B1BCB68A72B54A8E35CB90CC668E0D6978D12900B7414AF4185128ADA8AB5528B5C439F275B4310185DAB12E89AA2692E95AD39295A85A7D2DE92431EE05FB8A697FCA9F2523C8ACB51A0AC61A6B3DDFB759125B306DECBBE2003EF2F4D3FFC40FC37FD25C6C62F3DA75BCFD1695280F3EFC108E9F3B0B6B2C023FAFD56440C219BF30FB5C6DE6C10B7CDEE45B54FEF1DC618025B085221A9129E4505B0BD7EE8BA2C839883899415B8B772FBD8117BEF22CD234C585872FE0D7FFF77FC5875AA35A29A33F48D1EEF5914C73018C3008311C0EA0C76354CA6534EA0D8CC62374BA9DFC0D451EDD04544BB94D34180C301C0ED1EF12C123AA54505F5AC6C6FA067CDFC78D1BD7311D8F9069C20948CC3365569C44573632CDBD646BA053E34A27928BCE853800E42BBCC1D37D2C0C22241D51F005087349E2043E4B98A769EA70002FF0796FA0AC44E36DC386907E2D1843A1A72FD7021C7565888838480ADD6E175129C2526B19BD6E97DE03ADB1BCB6868D63C720FB0029E28226F63C8FE4B525E207814BFFC5F88320744B58E75A7D7EC0402D4D7276BA5D5CB97C09AFBDF802366FDC80B116CD66131BF7DD87C6D21221F3698A617FE0D275DF27AD4899E6736427B14A2E39A114503060096C26CDE0F99EBB0B0064098D4D8BD4BAB1B943159D47A53CB47BFDE791575F406EFC62F0FC613388E18B73B0B4842C54B08338710FF13776001F7AEAA9BF5F5F5EFAB5C0F7311D8D70F1851760019C3C7902672E3C085F79301E69EAE5EAAA84E016A7A70246F5FD20EFF3CB21CB573BB177541EC8A9E6AC33574FF1E182A1769F4CB665698A4C6B6CDEBA81BFF8C217309D4CB0BAB6867FF9AFFF0DCAE5327ADD1EC986713DD6ACD7B03D1EA1D7EDD032C63042B95CC5783246B7D7A58DB0FCB765D0C72A0FCAC2118D8CD698CDA618F4FB180DFA18F43AD8DFDE4196693416EA585D5B47B55AC5B5EBD7309D4E90A42992D98C14877DAAE9018EAA1E6FE3E569452202599721C96B379644387CEEBFE7EDBC5CACC36434964CC34374187596426B4BDD05E9EF1B9E9C949EBF059F2506208D941A050D05A973E94DC97904EC20E4F4763B1D94CA652CAF2CA3BDDF76A5C262AB8543859A5F187B725E1483A0D2DA1511D890751AC33044C44B601C43D40F104521AAE50A7C3FC0703CC2DB97DEC02B5F7B0E9B376E22CB52ACAEAF6175E310A25284E984066E846B228A46C24528969A82A6E7346BC63F385392CE8C88CA10A8C7868E0218C80EC1F2F7245B1039B0F242ED52DC1F4C319FF6176BFE14A40694CA87522A1527C0F99755E4F4ED774515F8E1FBCF7FFFCAFADA6FA5698AB58D0D7CEE33BF87C458ACADAEE0A10F3CC935370DD8505D0F47E12D4A7B514498377ED70A84D48B1EF306A4FECB998200750944975F7AC4C6506F5B52A84EB78DBFF8F33FC77838821F45F81F7FF59FE2810B0F623818228A42F47A7D24698A3849618D451495110663F47A3D586B502A95B1D868601204E8743B9CFE713B8B9E28093083F4DA66B32906833EAD7FEAB6D1DEDDC5683442B956C7C9D367B0B2BC42C63F1E23612E78CA829EF47054EF13A35033A0A70AD116AE5D570C0B7EB14460B69FAC9976A8BC00511CBDDCC13506A9D6FC7E09EB9D156B642BB265896E26444928232CD7CF81C642CA5FCC59FBDD2E19FF3219BFD4FCCDA5255AF1C6EFAB807690B282CF855382E214DF0F486D29080217F97D9FF64094CA2594235AB81A27292EBFF3165E79FE395C79EB2D1863B07E68030B8D06C230A4C9CBF138BFB6A2D403D0B4A497EF54200E88681BE4A551F14CCA4212198C3AD81EB580933B87CDA5C11C40C8980F9487EEA0FFF503BF5A4CF9E5233BF035E1008081B5DAF77D9BCEA6165036A01FFEF5A701CF9F3E7DFFF17367BF32994C70E2E4297CE5F37F8AE1688CFA42158F7FF8432855AA2E0D74EC3E69E1789EBBC842FE504CD3949A49B4FE9582E3FFCBA82FD5FBB46412A008A575E60C401E5B64A9B32CC36432C2F3CF3C83BDED6D4079F82F7EE487F0E33FF577B0BFB7EF96772C2E2D6238186267770F53115FF43C2C54AB188C86E8F6BA984EA73C4AAA90A4DA2D8D840549581B036B34A60CFAF57B3D743B64FCBD6E0F060AE71E7C10870E1FC5E6ED9B988C86B42F8EE7FA6101A3140228D78AA37E3E1D449F8DD2D879D92CE9970BFD984E898585F0F1F37AD4FD9F597CC6916A808CD778D3AA6F03E57BC8586FC07A988B866EAA92C12F27076679F6A2D09E1404BFD76E238C42AC1FDAC0CEDD6D39F1586834B071EC98E37FCC69E8F3E350D40F10442119BF20FDA1A4FDF9286F1846A856CA34350860EBEE165EFCDAB378F5859710CFA63874F42896969789AB3F9D61369D3A031540B34823D7C600AEACD2733F7732DF028E4AF95330643997A6F0F541F523195233EC38D22C433C9DA1B6D8BCD4DDDE1DF15329D6FDC5E85FCC0012144A0065610CAC0D156C7B3A153321DBFC36ED7DEE767C6363E9CC03E75F1E0F873871EA34DE78F9656C6E6D2300F0E8079F4273A90559BC50D4C697C84F6F662EE72503170AC8D15A9F4439E462F94CD9359C72FACA739E53121CC72900650ADA1862D065195EFEFAF3B87EF52ABC20406B7919BFFA4FFF19770452743A5D874D1863D0A83710CF666877F6612D50AD56D16C34512E95D1E976902471FE265A62C679CAC2687AB3932CC5683844BFD745B7BD8FF6EE2EBAFBFB98A5191E7DEA033877EE7EDCBE7D13C3E1104942C33D699C4024ABAC31D0DCAB97F7DC1A5A0A2175A1A210C4CF8166CA7DC60114C0D9908231693E1EACF2411EE3223F1B2D8B790ABB51DE9B945B9EC59EBDB1B271D7BA4E4BF1B02BC0E9F9CB7582B51874BB08C210870E1FC1CE3619BF3106D585051C3D71C2CD82B8769D971BBFA0FBB4082674FF0FA308A5A844C2273EE9EA47A5326AD50554CA650CC763BC7AF1253CFFCC17B1B7BD83B5431B58397F1F8C31B47A2BD3AC119BE337B2E8D502CEF1CAA4A49431BA68D43C8F20DA0912ACE4F539C973BE7EF21E17DB809445E6ED53E11978BE8F76A7FB3CBE25DAEF0CBEF851CC02C809F8BE314962613D78C84961DFB103387AE85070DF8507BE14C7F1426B79199DBD5DBCF9DAEB0080330F9CC7C6B1E3054927B8345F505C8075F8C0DB4F14A592B43043DA82F90594410E292584C66B610196A1965DEFA46D4F07485B8B78465CEC77DF7A036F7CF322835616FFE8577E05878F1DC5743241A3D980EF07D8DBDB27A49F65C3C22844A55245A7DBC1783C42A954A655639E729B6D7CCF838185321A1A20418C2CC5783C76CB1EDB7BBBE8B63B984C673877E1413CF8D063B87DFB26FAFD3EB23446328B8951A8E8756659EAC666E51A1A6B5D2D6A01377CC327975B75E0EB02D209A0AB47A213E21C38CA6806E30423A03240B9C32FD8461A2744F40942E8349943F0730AB07CCB0381CD982BDD042F188E28801D3D76143BDB3B14098D41542AE1081BBF3B1B9C2DBAC51AD2EAE39D8F3EF7F443EEDD3BC28FE761A1BA807AAD0E3F0870E3E6757CE5CFFE04975E7B03E54A09E71FBA40139BC361AE540CEBD892CEB901C898A320AFC3C0E3FABDD0F1005C9623E21E744DF2AC485E67DEBAF41C85BAD88A156094C841E418B24C63A1597FA3B7B33FC17CED5F4CF50B51DF3AE3B7B42A2C838531D6985005E88EC71680F5E8012CF0D77000A74E9FFA7741143D9EC409965756F1479FFE340C80C38737F0E0134FC0B1F9C4F0BDBC5527EC3E19EE11A69C13F6F47D3E30C84B01C5FBDDE0B942D218EB0044FA3FA1C53E5F48A30DE294483CB76FDFC437BEF22C516195C2438F3E8C5FFCFBBF849DED5D24718CEAC202C230C0EADA2AA0146EDEBA895EAF07DFF7512E97B1BCBC82783643BFDFC560D887EC07A4762ABD1FD6D2D54C79ED73BFD743676F07EDDD3DF4BB5DF4FB03DCF7D04378F2431FC1D6D626FAFD1E73BB1327AEE9C11276C1429CBEEF233319844E9F695ED221E429A94789EEE7DA7EC29510A92E5D387CD65A5805A614F3B5E4B5E754D7E72D2A8A4C64EC9A894085223547BDDD75C85B80A205209170321E234B539C3C731ABBDB3B4E2ECC0F431C3D710251A9C451D6CB6B7EAFA80415C20F4396C9A694BF542E2362BE7F184528472554AB0B68361A188EC7F8C697BF80E7BEF8454CC7131C3F7512A54A05D3C914A2A53F37BB200E8D5F97301C35F27A5E949105DCE5439DB7FDF826D72565E973EA0C00D0D6650B0E2338703D6DE16BC27694DDEF748BB57F11F82BD6FE31E633802229C8C0F72DD2D458A3E6A23FF01D3A80271F7DF4971BADA55FEE77BAB8FFE187F1D25F3C8B6EAF8F8572098F7FF8C32897CAB9472BA0B612C515A33EAD8800002000494441544F54B9C92CA9110BB5AC14F23EFF9EE66DAE923AB925120CC0191E4CA187A10B9BE914561B0C4723BCF09567319D4C10954A30D6E21FFFCA7F871ACF2274B30C376EDE42188408A310699AA15E6F603CA108DEEB030BD52ACAE50AC2A884C96CE61474F3A596E0BF9939E3DFDFB98BF6EE2E06FD3EDA9D0E4E9C3983279EFE307677B6D1EB7521F300691CE78780D58AE8FA29386F47F93C942F1B67901F5C10B3C358C0E7EF095E6218D91770495BDE1B98D21C41104548A6537E2CEB52D58353844110908C18F7B88BA580D08225BD2DE20B0045BBE964827836C3A9B367B0BFBBE752646B2D368E1EA5EDCED29A2C060B7EFDA20921984010E6801FAD7B0F512E95B0B4D842B552C5F59BD7F0679FFB2CDE79FD75ACADADE1D4B973A41A3C18BAEC51323817C9058297CBCD9996959FA1281C931BAA0082452AB60303250BE05FB0362767B9D7A8723E803CAE5224F71D2729AA8DDA8BFDFD598C79C317704FA23F1BBF1527E0D27F4A408C0E55607BA3B1052C8AD11FF80E1CC085F3E7EFDB3876E453C37E1F1B478FA0DFDEC33B97DE01003CF48127D15C6AB1AA0C1B7F986F59A1F44C5A7FF9049F2377704640C05D5EF779CA73641F781E5F49C3A213251018C843297268B91E8E9304175FF83AB6B7B6104611B24CE3F10F3C8EEFFBF80F607FBF8D4AA582E595167CDFC7D5F7DEA3B15E6B1186112AE50ABCD60A46E3114D7DF5BA80CDA300942353019678F1B3E914835E17FBBBDB68EFED61D0EFA3D3EEE2D0B1E378FAA31F47A7BD8F7EBF07A333C4B3987AEC86671682C0F5E801051F3E529D409486DDF560749F24B80C1FAC3CDD84112D80147EE03B47515CC2298775369950A9E307481322B6285DE812F0E366AC1864E8D43AFEBCC7DD15A737C0462207DAF37CA46982F16884D3E7CEA2DFED61369B41D47ED60E1D426371D1D5CFC596B0E72940B2439FBB434CF411CA6EE00728954A58E0A81F04219EFFFA57F1679FFD7D8C86439CB9FF7E8461884EBBED9C52A6AD735428384C41DBE78CB1C0E5C838B3A2CB92037CE28CDD87946885C7283E96389A837FC365CDFC3D9D66087D5F77BAFDD7308FF81F347CFEB0731980954DC1D427B736498C31800753704174FBB61CC0B14387C243C78E3E93242472B9BE71087FFCBBBF0B03EAF79F3A7FDE1D2E37B5A772CAA562317919D410DD3EC73BE710A20A608C5C24A947252012AD959EB61052080FC88531B5D6B875ED2A2EBFF1A6CB428CB5F887FFF53F42A55CC6F6DD6DC4C90E9A3C71B6B6BA06CFF3B17967137B7B3BF0C3080BD52A9ACD45446188BDFD3DC798F3384B717AF726EFF5EFEF6E637F8722FFFEDE3E0E1F3F8E8F7CE207D1EB76301CD2AEF7248969E08665CB94F268E496D1FA40C6A139065A2B874E39C04E506828E55A54A4B24B8ABBD4AF268D4263692EDF02D40AE3F15489F4D6F0961E56EA15108A2F768E62CBC1E7F74068C145EE8500645E10204D12743B5D9C3C7512A321E9F64B5766A9D5C2CAFABA3338F721659CE3F2872CD249049E282A11E2EF07884A2534EA0D2C3617112709FEE4B3FF115FFDE233585C5CC47D171EC46C32C58837EA7A4AD1A29482510B602765AA942DB690A1B8B2475274FE5AAE9F112397EB73D04914CA8A22494AB006F7FA913B922C4D9164192AB585E7F474268C9DA203C890477A317C7106AEF6B7F4A123A54C7B746FED2FB76FCB011C3A7CE8D7C352746CD8EBE3FC850BB8F2E61BD8DEDD43B514E1A1279F80C86E8BB24FAEAAC2ABB1407A7B326AA98A46CE6D3EF18002C6D005CD0D9F1653C0E9DB5BA3A1B5711B7A83D027DD7DA3D1ED76F0F2735F439A6688421AB13D73E6147EE0133F08630D8E1E398CBBDB3BB87EFD06E224A6659F3ECDE05B6BD1EB77311E8F68A61CA4BBA77917A08507AFC03798CD628C4603B4777738EDEF617FBF8D8DA347F13D3FF009C7FFCF32AAF95316DAB04AF1982DA3F1DCDB77C539A4CF4CF259B0127D3942731453808BC01EB85D25D1D9535096DA77865B8D40CEA4F40342F91558275E260EF9FA8B4328B6C75C3B919DAA738A7CC03DC626BAED0E0E1F3D0C6D0C06FD3E7DDF18D4EA756C1C3D9A9F42CE2A5C09C8A5A3EC79F07D7204515442C0C65F2E97D16C34B0BCB48CEDDD6DFCDE6FFF26AEBC7509C74E9D44BDD9A431DB2C739D266DF2590547C195D49EB507E766198A009DDC576BB752BDD84551AA207452709EAE1B22EF2583BACA5AE8C27B0C4B7D3A8FEFA3B546A55C1AF5FBC3B791A3FEEF97F6CFF8F3943F27D6120868010D638DF27D9BCDA61656C13F50FBCBEDAF7400674F9CF8D0EAA18DFF613C1AA1DE6CA2D16CE295175E04009C7FF8612CAEAC92FE1CD932114840510046566EE7D359C5DA67EEB01B5A27EDF3101001520C588987F63CD78B25961FA5B76114214D335658D578ED1BDFA0E51D510828209E4EF1F7FEC12F214E353A9D2E5ACB2D6CACAF41791EAE5C7D0F77B6369166194AA5322A950ACA958A6B038EA745E008503E47416368BA6F3440A7CD7DFE4E17ED7607EB870FE3239FF8418CC663F4DAFB304623495264ACE55794AEA2832434D300B006F07C8AE44A41291A2E09A390C74273D0CA5ACBD78C0E6992904AB0879C1B901F72EB8041CB2D5A9DA6C838B3A1CC4AB202EB5A6172B0F94D4251F3CF453D25E519BD8E6EBB8DD64A0BE54A0577EF6C396C208A226C1C39720F302C137E1240DCF86E14220C238411A1FF6118A1542EA3D968A2B5D4C2F51BD7F01FFEEF7F8BFDDD5D9CB9FF3C9452E8763A0E10CE78598AB018155F6F41DD259ADB034E4ECA01798E2E1B28645E460842C05C0497FF43AE7FE1FA59B99E053C81D35E5A9F9E2648B5865F2A3DAB29928BF10BE897613EEACF18F917E317E45F1BC094144C7B4CC41F857BA33FF0573880B556AB74ECD489CF25096DB8397DEE3E5C7AF52206A331565A4B38FFF04379CB0ACA8D5D2A51F50D64665BF105D1F0792D9324B98A3300975A1622A1937906132EF87BC668182F9FB53746238E6730D662F3C6755CBB720561447C822449B0B2BA8A9FF9D99F47B91C616B6B84DB77B6D06836E0793E569697E17B0A9B5B77B0B373171EB792C2A8041169746C3028785A435B8B849735F6BA1DB477B6D1EB76B0BFB78F958D0D7CE8631FC77038C4B0DF25CD77D6F0CB7BEE94AEEB2C85E707B08CFA1321C773137F8A4F801F700B50E76CB28C91F424A3FD7E19CFA6FB208A296C9E663AE0D2F799DBAF0B283E1D42AA5F15720115B8F2C20DAD7059C7B6C3119FE8CAB04407EE753AA82E54B1B2BA8ACD5BB79DF17B9E87F52347502A97DD0CBEE3888078214A483D7E003FA455EF6118210842570634EA0D2C2E2EE1EAB52BF89D7FF76F311E0E71F6810710CF66C8325DC81E95EBCDD3EB23F1540B1053915F97C77A8545EAAD601CC5EF3943E7C7170C00AC9E94CB9D29266081CBC51C28065F5B57F74B20E46C2BCD34EA8DFA666730BC89F74FFDC5F825FAC700626B6D0C69FF01DA5A63822030F1686401EF5B46FFBFD2016CACAFFD6AA5565B1B0F875868D451AD5670F1C517A1003CF0E823A8D59BC874C6519F6B385F7AB8795A5F64F941C9FB43C6EF33522A062E1EDADD5C3AEBC1F2A41A4531E2005826CC18439A7CAFBDF822E2598C52B90CCF53180F87F8919FF83194CBB444E2F4E993D8BA731757DEBB4AB4DC72195154C2CAF20AA230C27034C4683C46DAEBC218ED906F6BE8B91B00499A613A62A2CFDE2E7A9D0EDAFB6DAC1E3A8C0F7FFCE398CCA618F67A4CDFD534AFAF1494475157058C21180BEBD1E1CAB28C452E99BBAF73237587980F9FD11ACAE6F306EE5A4B9DAB0D473FCE9CB4861F70C9A0E0D27417A9525987CE205521FD95D4DEFD98E702A40B2041C5F37D8C783FDFA1234770F7CE169F7932A2B58D0DD41A0DE219143200E7083C8FD7C0F1900F1B7EC0EDBF288AD0A837D05A5CC25B97DEC0EFFFC6FF8B2C4D71FCCC198C8643984C3B1E89EBBF179EA308C4165378CFF3204C49C3A21B5282BA6E530114753B24F89C9201E70C54B2F4421920E02C5FE7221E00636099DF221B94C3C037A3D9EC5963DF97E32F065F48FDED9CF183FBFE5629E31B637A716A01F32DA3FF5FEA000EADAC1CD93876F45767D319ACB5387DF61CDE7BE76D74FB43ACAFACE0F4FD0F20D359612B0FF1FE89D31F3803576E7B8A07A5F850713BC62F940212CDA5A637C620E059736192154116E5328A006996421B83AB6FBE4E4B3BCB25571B8761885FFE87FF0DF6DB6D8C47631C3EBC81B5B51518A3F1EED5ABD8DEBE8BE96C8A4AA5826AB58695E5154C67536C6FDF4512C7EE20C99B97A42966933186FD3EB1FCF6F7D1DEDBC7EAA1C3F8E0F77D1F66B329860352F9CDD294D97CD6411A06C462048376798451121A78EB6B3E2EEAFB4409B6425AE1A8220B3D044C4D797720610606B034E8E38839166ED0048053A721E74D9B8CC49988637612E1C8D36157AFB381781E89784EC7139CBFF000B6B7EEBA7565C618B45656B0B4BA9ACFF517A2BFEB00F83EEF79085CAD4F8B3E23944A652C2D2E6271B185D75FBF88DFFBCD4F218C22AC1F3E8CD160004E235D5497369FE333B041CBCF059C736BCA0B1D00C97A5C7D8F3CBD17C728A09F5BB5EE1C0DE6D27E210DCD39017796141463493AD3487586F2C2C273A3E1B88F7B23BF007EE200668CFCCF945289B5568C5F5B6B74140466D0EF03CCF9FFCB6EDFF2E76BEB6BFF97170430C904954A15870F1FC5339FFB1C1480330FDE4FEA2907BC6CE0872EEAE71B5573561FD81958936FAE15E248B1659253277394B470A5DD41127A7096261874BB78E7CDB7084052D4521CF4FB387DE6341E79EC31789EC295C110AF5C7C1515569A5D5D5985E779D8DEBE8B4EB743E3A921AD12274D00E3A209B591324C27138C86430C3A1D74F7F6D1EDF4B076F8089EFABE8F62341A623A9920D392F6679025A4C4F13608C38840C58CB00B5968217AFB52873B070AF0E3902E9F03AA1C16E221CD348CE6197523DAFBDC4254208A327785647185488C113783C9475CCECD1992BCBF0208F2E175F5AF224DBC7EAF87B3F79D43B7D371ED3E9D6558A8D5B076F8B07BDE45C937A70111888807F5F8C32040105239502E97B1D85C446B6919AFBFFE4DFCFE6F7C0A61A984E6E222A6ACBA2B513DF07D571A393E3F730CE4B94AB4F5B81C70F5BE2B270BFD7E07D0CE770F1C4B13802DCC5DB81A41BC3DA473406F8964917C8C09973144FB6D2E35AFF786E3B7300FFC15D97E05E3CF4B0001FE40E21F5A79BEB14962D2CC58D163F856D11FF8160E606D71F1FCCAC6FA4F5344F0B071E408FABD0EEEDCBA8566BD8693E7CED1FA2E502A4B6DB99C9D57AC217D46ABE50D28AAC3145358C756E39F6996D312F1CF8CA39D808C6996210840324C99C6F5772FA3DFED21E4F9FF4C67488DC5473FF1090C06232C361670E6CC2978BE8F77DE791BFD7E0FA55289A7D25650AFD731994C301C0DD1EFF75CDB4F50E22CCB309B4D31190E31E8F5D0D9DB43B7DBC5E1E3C7F1E8D31FC2783464C61B19BECE3216D40C61B2C4B5B6C8D95904A1643A2C59EE166ED21528722A5C49246094A498C6C2A87CD28C8C8EC85F64C0323E4C8EC1F12DF8FB7E183AEC401C6FF1BD71D45F77AE0BB5AF6B535A74DA6D1C3D7E1C699AA1DFED3909F2200CB171F4A83B138E0E2E258BE7E5809F9F0FF504DCF28BC2084BCD452C2E2EE1B5D75EC1EFFFC6A71095CBA8379B48647721039A0AC8A9B87C8DC4F875CA4C4614C7A3D33910BA18B1E5FF45675064F001F3C4201ACE9A5F609A6B43141D437E4DE5BDCFB2140BD5EA6038997D9953FFC25CFF3DA9BF20FEB1B536564ACD4DFE195853F294698F46162CF8F197193FF02D1CC0EADAEABF8ACA65CCA63304618063C74FE2CD6FBE84C402F79D3C81D6F20A834C069E575CD8412F2EF098D3CF07CA0957723415A720597DB1654269AF85C87ED1A1CB051564BB8CCF5B79D234C56434C2F5ABEFD194984F69673C99C003F0433FF4A3F014F0DA1B9770E4C861B45A4B3875F234B6B6EEE0CE9D5BB8B3B589288CB050ABA352AE200C2397DE59AE0BD334C56C36C57432C6A0DB43777F1FFDFE00C74E9FC1038F3E86D19036D5EA2C4396666ECA8E469BAD13B2305946A99FE739E7E2F91E814604113B7E7E1885BC8A9BE7CEB3CC21F072CCADB5AC1ACB20226FEB95A940086F8047893D8F167A8823A148C6926005D10A8986D2027308B7212D02076C2BA0BDBF8FE5D5152CD41670FBE62D97D101C0FAE1C32833E8A70ACE4C043A441ECE13EDBE40843BA9E65F6C36B1B8D4C26BAFBE8C3FFC9DFF8072B58A855ACD0D281980C94A1A50B28ADC3AE0163627E738E729C65700FAE46796453E9482E30414CBCE622437B0F0381392472E66FAA6C8B9297E69ACBBBFC932844190A54A7D3ECDF40CF3A97FB1D73FC57CED3F554AE5D1DF2233D6185F803FFB97037FC5DB3D0E60A5D138D55A5DFD21CD7DD4855A1D1B1B1BF893ABEF01004E9C3D4BE8B831F03D91A9CAD33951A08152C8B48152D6E104D23376CC36A6A78A8BF4396AF9BEE7A28BF859E10164C620F445749322DDE68D6B18F47ADC46A3C33AE3D56367CF9EC3F24A0B93C914972F5F86D62411D66C36E1F92711EDEEA0DDDEC7DEEE36495C6B6AD9196E29A66982D9748AD9989632743B5D0C86231C3B770EE72F3C8441BF87E96402CD7DFE3C8516008880D17CE0440431C9F8A52D48879052429F79FDA6C0CC138394B49C0427A9768F8288FE364731CA28ACDBDD27746A0780B1BCB88BFED6B2C02A3B053658671CFC7AC0C60F4B254BBFD743A55CC6A1234770F3BDEB4EB8C55A8BD6DA1AEA8B8BECFC73CC4082056DD925B0CF17551F9EE58FA2121AB53A5656D670F5EA657CF6DFFFA633FE2CCBDC3E03F1448A81B4244D09082D8C2CE7AAC8B2C0340F344504DE16DBA4B690F6B3E14B0684F7B7EBB95B71FAEF9E9B3C2F6A51DAA052F9FC6832EBE2FD477BC5F00B1F36065471F027B3B01ACA3381D6A6FF6D007FC5DB3D0EA05A29FF4F0B8D3A923445E0FB586CB5608CC5F6D616961A756C1C3DE6D85E92FE4B4D17780AF04307B20481EFEA7D0F0AA2472B0791F4F3F2B456B3D7148495BE96F28138EF9E122FAF9D66DEE6F51BB096DA650A80495364000E1F3B8A59A6311E8E70E8F006A0804B972E61F3CE6DDA6B179550AD5450397A0C466BECEDEF616F7F1F3A4D90A6096F71A1858DA3E110FD4E07A3E118E72E5CC089B3E7D0EBB4412DD28CA9BD94D611625FA80D193DB779D6E8803B6798001B9965FA2DC97B091045069BF158AA765881D69A3A0B9E0F93A54E0F3F4B136A0BFA017C04AE2491B2ED20B5550859A608B6B273F20BC642ED440FA3E1106992E0CC4317B0757B938047066617EA752C33E827ABDC1CF8C79F3D91E9F6459F8F067EA2A8847AAD8ED5D535DCDDDEC27FFA9DDFA2251A0B7564A257C875BBC9323A8705D0CFB05373A5253BCD22A3D12917175EBF75CFDFCC7FBF90C24BA8A2CB958FEF9258CDFC1D6CE1310EB60F4D9641793EAA8DC617FBA3C91DCCA7FD45C04F52FF09C8194C0135B3D6E4BC7F0B6DAC3551E09B5EB78B6F07F82BDEE6EE1B01B5D6EAEA2F42C956D410EB1B8730E875D0E9F571FEFEF3A8D7493D456A98C0CF577A89BFC9298ECA193F0149B8975CC25FCB208A027950630B1750C1BD893EE30D2973E7DB7BBBD8DFDD4514C9320805C3E0D0B1932770F4C861BCF3F63B68B59650AFD771F2E429944A65DCDABC859DBB5B88D304957205A57219D3C904566788E39874D9E31926930926C321FADD2E667182479E7A0A878F1DC7F6DD2D64598A84B7BD5A434AB0010B7258E423BCCA53F9814161A4D44525A9AD7DF77F3F0861B976B51CC93D2F6F5949EAAEB5E1ADC607947F553E15A8595E3C2FA96C8E31F0F59643EB8CC0D069D6BC5E5C3202CF5A477D7EE0E187D0DEDB9FE3F8475184B543875CA63347F3F573D96ED9F91044613EDA1B86041AAEACA2D7EBE1D3BFF1FF2099C5A8359BA4C1503C37A0C59E3290A30B1D1148F922209E336633779F393C45BE77D031F03F8CDBF3F70A8155152CDE3D9C7D5F47618C81CD3454E063818CFF1AE6877C84CF2F69BF7C48FD7FD0F833638DF6FD4067D3A9D1465999F6FB76A23F70C00194C2E0938BCBAD401449C228C2CAF20AB6366FC1023872E2382A950A21D09E07DF876B03511DAF5C6487B590BD70DAE4FD555B688B483A5B9CA61210D5DA793656B155E37ABC9E879D3B5B485392F10E02110DA137208A4815E6CCE95378E3AD4BB4CE8B41A8F5B50D94A2089D4E1BA3D110BD5E17711C239E4D912631E2D90CD3C91893D108835E1FDA004F7EE47BB1B4BC82EDAD3B8859B7BFB81FCFF7598D4781321EBE367268A8064F9DA18AE10352571ACE7E3C1E0E323C190857A7C35A846188CC18988CCA2217594CBE89174AF178309CF14B5DAC3C6F2ECD170CC66906CAF356CAD5FCB002561A74F6DB3871EA14EDEFEBF5E608372B6B6B88A288F01DCCA3FEA2E8A47C9FC67BA3104110C1E39ABFB650C3C6EA1AE224C1677EEB5318F5FB682C2E22894908570048397FC602CA27D6A4E711AD59004DAAE9738317365FB13548AF95CF29009995C93119F72E15BEFF3E76A5F2FB28FED73A2790971726CBE0FB81A9341A5F188CA737F0FE865F04FC26C8A3FFCC5A23384062810CD66AAB9409ACB1EDC914C0FBF3FDFFB29B57FC4FBDD1F8C7A5728523AD8F72A58CC5C525B4F776A100B4565658878D77A9CBE176B5623E5CE1F93E94855BDE68B4A6D48D6B64C7B7461EDDB32C63B02BE7675BE40A341EB779AC96850929B63737DDDFF3B86360D9B118002FBFF40ACAE5121E7EE8024AE532AEDFBC8E6F5E7C19972FBF85F1788C5ABD8143878FA1D168F28C3E2DEC9C4D27180F8718F60728D56AF8E047BF1FF5E622EE6EDD81E616A1CEE8520BEF1EC8537B63445DC7E408BFD4FB10E6195CBB0F4AB9D70580D3443262CD8424AABD3D771D610549D685E59D3C10E5D687997B8C5FBA0642E8F1A464610370462B875BA2A55268EFED616D631D0BB51A76B777E6C440175B2DD41A0D3798648BD19FC13EE5FBACDB47C61F86214A61887289BA31501E7EEFB73F85ED3B77506F3611CF66644A0A841B70162186AC53E28038C296352E9A8B639492D345E1A2C364D094443F2873333607EAA4EECF3B20399E714F19254EA610F1E56F64498252B93C29D56B7F341C4F6FE2DE3EBF388009E60DDF39000089522A0190294BA87FE4FBA6D7EF5BC0B3C1B76FF7EEE6328010A8359ACD8F7941009326A49D5E2AA154A2D438F4149AAD65D2F6570ABEA17D6594E2238FFAC8EB5F6D0D49582BE5FCA3B1705192DDB43B40AEDDC517560415F91C52892529AC31988E294287212BC346914B7F01E0D4E9B3305078F6B9AF61636D03ABCBCBF0CE3F881B37AFE1E6CDEBD8D9DD81CF8212B22988C43967180F87984CA6585ADFC0F9871E469224D8DFDD214796656E3DB7DB790FB0C84948F5BB225AAD2CCE707A6F2EFA28BA5FB11E85644DF47D1F705D13C3144AA3A58E02A7EBF9A82A5DDF9C4EEC290F1AC6097A022027636D0E3C9A5CD8123E03AB908B0D370F0F00DD761B954A19C74F9DC295B7DF71EFB9D11AE56A15CBABABB99C985205710F2F4FFD833CE50F439EE72F97B1B2BC825254C2673FFDDBB871E50A169797DD9A32CBCF5BCE51CA53A95AE72A3C8EB5C89C12CBE502E743CCB0CC8DFA60AA4F2DEAB9E49EDD019DE962F9C4C5ADFB5AEE5BBC153B27499AA25EAFEF6B3FF8C2781A0F712FE077B0D69FCC7FD819A066808A85F46388EEAB93D148527F0B7C67D11F283880007864A14E3BCD64D9A26CEA9D4EA728974AA8D6EA2E6D544A512A9A11DD55193EE4D630A054C80E9C418B6C17037CB6D0AA5085D1524E3F8585468B3752979918F6D2D3F118C65A6A2145342802A510964AC07882ADDB37F1E083F763F3F6265EB9F80AD234C5E2E2226AB53A4E9F3987E16080D178C420DF00599A2089634CC663A4C6E2D899B33874F418C6E331C6A3218C2189E6783605941C728AF604F4E5C8B9589029207F32FB3E87ECD385717BE14DC140858B40113EE3CBA4A03396EB56CA69F31781D3BCDE379C9DF8B0A00CCC75640AA8F8DC18B03180CAA9BA92368BAACFC38F3D8A5BD7AEBB1979C37DF8D5F5F539D92B48F4670710F87E2EE01989B24F8472B98CD6520B8DC622BEF4853FC1A5575FC5CAC60666D3292C8AEBCBF2E8ED9E2BB7FE32196516E3E3733787E40B02534CFF2DB5F24CC121CCDD6CAE9034E7040EB809B9AF7C767FDB1864DA60B1D5BA364DB3AF66493AC5FBCFF58BF14F008C31EF0066809A8225BF38F5CF94E76B2F4DCD284E01D8EF38F5979B73000BF5DA4F86A579765F1884EEB084A5120965404183481D594A3457050A4A6E17BCCAA5ABDD852ED69B725155DE8715F109273BCD380420BCF8BC772D63A9713C8382721165A15E47A952463C9D62D2EFE3EAE5CBF8F3CFFF7FF8B11FFF4994CB65BCF4CA4BB87AF55D0C8743942B152C54ABF079E6DC5A8BE9648CF1688468A186E3E78EA252A9A0DFEBD2AA2E6DDCEA2699E473AD4D49FFB90412255FCF978930AEAB7D62E7158D4F7942D8B1AEA4A089C05CEB3FBF2F1B2F8380DAE411C92914C9FD8002FA9D33E54454D41D56AEDD65A00B6CBC00D7C7B04859E1F891C71FC5FEEE1E46A3D11C6EB3B4B2825299D4A01C355C883EBE8F200CE0B198A7D07BC3304454A2C9BEA5A565BCF2F2D7F1DC335FC2F2DA1AE2E90C73A41CC18FF83A38D9319D979272BE8ABC05E708C4D1B9D78D025A9FB7ECEE89E27C8DE43D2812819CC1173A24C50C44671A7EE063A9B5FCC2603279DDDA7BA27E8ABCBD27515F8C7F8439E41F89B5C6A5FE1A302558D31E0C0128F3D749FDE596970051F4517953F3A10A83344D51ADD5E4B52208598CC31071C480E49A6587BBB5161EF23A572E595E7BD18576CC2ACB3597E8D921078C1C15D5F3088C02002179F09BE1FB1EC25209B54603B566134B2D52F9E9773AA82ED4F0EC579FC56EA7830F3CF604CEDFF70096969671F5BD2BB8BBB589CEFE1E0D14198DC1608034D3583D7214CB2BAB886753F47A5D24718C2C234EBFD6998BE89EF4F9B98E17A61D3928362A6DE60E879135DC5CF79310887F4F8DEAF4FE408F1B4511C9871951ACCDD1709911700E93B3872CE51D73C6C0209756D70520B4D8A6822BD3E08C4D32884EA783D367CFC06883DDEDED391C63A156437371D1457C78B9ECBB6C7DF238ED0FA2C8ADF20AC210B58505ACAEACE2CAD5CBF8D33FF87D2CADB490CC621859F822465CA8E585D528D7563A2DA25C54BC3F0077BDE719A8562C7ECEF05D465634F4C2AD98CD4A47A2584A480695A629166AB591572A7FB93F9E6C633EEA1F8CFC078D7FCC1F62FC45BA6FAA89EBAFBB9D8E053CEB7F87A8FFC15B00003FF0B18F856FBFFEDA0551A9093C1AEBA5C3AC51ABD79DD77569260376326F4D0328D26365245B22371349DC8A6A9BF7FAF082E43000002000494441542DAC7324B02CEBA573E20A6520DC01F07CA6CE52B610964AA8D6EB2857AB68B696D0585AC442A3016D34AAF51A7A9D361E679AEE17BEF445445188A5A5162AE5324E9C3C85C964826EB78B4EA78DF2420D878FAFC00F02F4BA1DC4B319F10CD20C599A709ACDD98B97933D44E5D58DC50A0A5F386E39224FC41DE2801B1A60D1DAA1ECCAF3886D877CCC5929922E07330925AD166111497D45C8520E2831DA148CCA6731DCC4A1C967DE9D9C185F7F805E82E000DD4E172BCBCB586AB570F9ED77E68C3F0C432CAFAECDA5FA42FA119AAFCFBDFE22D597F81755ACB4563018F4F1C79FFE5D54171668269E2727A50C128523A514BC20607116E3CE862840BD6F6BCF956307EBFEE2BB23AF1DAE9E97C7B987CCF33E8EC19515D6F2FA6F8B66AB757DA6F5F3E974360261D1C5A51D45B0AF58F7171D40B1FDE7A4BEB531260A0233E9F7ADB19EF5A0BF6DC2CFB7BA0500B050AFD5B5D60DB7E080DB1AC65AC4718CA5E555186330E5BA4C0E17B5BDC8FB3A12095FC0CCD0CE3953A8470138B149B0D1CF71ACD5BD17DC5ACB2218D4B2F0944292122DB656AB63FDE81128282CADACA0525DC07838C03BAFBD8EBBB73711B75A48B30CB37E1FB5851A66718C6FBEFC223CDFC7FAE123F08310A9D6A83717512E973199CDD0E9B46174863426A3D73ACBB5DE79D5188C8517E48620915B467C291D15E2095CD620D12B4B73E0CE69D0CB01D29AA8ADC8DB9FE264A52527D7D075125841579C8C9B6328B4F8E4566C85CEA5AFFCFCC02D2BAB148683014AA50827CF9EC1B52B575D2623B7A5E56544A528AFF7BD79F1179F17C290AA6FC072EBA4B9D85A6A41791EFEF80F3E03A3352AD52AE2389E7BAEC5A9486B0D3C78AC684C9986CC69CC19B711C1943CA1CF91FCFC8C29148D9F0D5EC9012C0EA0DDCBEA2BFEDF1A037017228A225D6F369FEF8F26EFE25E210F49F9A5D52786FE7E88BF337E8AFE3635C6EA9041BF5966AD82FE6BD7FDC55B0000ADE5E596D145A517015D3426E31156D7D6110401FABD0ED6370EC15AEA4F7B5661329BC1F37C646E4D1290B8892C4A8BE76E7C88945C3CE4832FFC2E00FCBBC4FACBEB366205E6F52B00AC6D1C725257BB77B7F0EE1B6FE0C6F59BA82F54F1F11FFB249A4BCBD8DFDB454C482CEE7FE851184B605EA60D2A950AE23846A7D3461CC78CF0274E4586C02E91D5E67156696D6619EBE813D5D7F314AD61E17455A4B129BAE7241E1248012DA5E0DAD595354AC9B43464D1A76B0DB28390341FCA83D1844948574236CAE66DBC3CD5B740CEF797B783D36AA7C540CD09CCA613C4498CC79E781C9BB76E238E63C7F7B0D6A2DE6CA2D6689222B1A7721C48E50B603C36F8200C11B0B847144568341A68349AF8933FFC3D5CBF7205CBABAB988C46AE6BE0B02343C360523ACA5663571288610B5622C7C209AFE4BC863C36153202E4A62E194F111370BA8C07CEAFE50E4EEEB40D1A8B8BDB9952CFF54713A1F51653FE22BB4F22FF41B49F0DDF0ADA1F033605901A63B41F045A4F266614671630D6C777E71600C0C6FAFA9270D3E9E293BB4C9314A3C9182B2B6B682D2F637B7313A7CFDEE752B0244D202BA544C8C2F085254DC0807AB4FCC639549981317EFF082493DA1A9E435A0DC88834671841103AE0CBB0B3F0798E7CEFEE362E5D7C157BED36CE9E39854FFCC44FA1B9D4C26834A41653B98C300C912409A6D319F108D204A3D1083396FBD66942AF4D5480E48021A7CE2ACF83D5C4411000D2116D6400C432F0E98026C0163202077816868280FCC0422937AB5F5CEA9165298D402397A416DC417E4F548CE4A06B631CD943DA63921528807AF5000A1682344B311C0C70FEC107D0E974311C0C72D0CF5A445184A5E565FE7B2AD7829C9BED2FA6FC11A230421845CCF15FC52B2F7E1DAFBEF00296D7D630198D788E44BBB6A12BFFACBCDF05204F6A7DF05662F9BEBCCE829153D9961F7805CC65AAB2C148EE325FBCD9FCDA2855B846E4C8B33443542EE95AABF1C2703CB96CAD5BCD5D8CFA455AEFF4C047B1CD3705ECCC5ACB69BFCD00A4C6581D0481D6D3A9194C6300D606B07FE3C82FB70000DE79FBD282786FB90804EA65180E07585B5DC7D1532771E7E64DCC6633944A659A966343D599E6C3C9DB72B5C95743A91CA126396B01990448A44517C6E603349A39EBC611537CA7280B77B8A55EB5180F87B874F122F6DB1D7CDF47BF17DFFF239FC4A0DF4796CC505BA891E6BFD648B3CCB1FCC6E331A1FB690A63F2D49B50EF143E8FEB2AA56029943A628EF481FD30C81D9FABBF15ACC9A42DE29C1DB8454A02934C5B15F08FEB7705056D8D2332495D4D18428E8B90C290E764C4A5FB4220616159A8B5AEB54886431D3EE92458101899B72E69D8AAD7E9E0D88913504A61777B3BCF0C41CE6B796D0D6118B92C43485AD2A590A93ECF67651FDFE7D9FE0A965B2BD8DCBC852F7FFE4FB1B4B28264367341413A4EDA6149D63943EBCE9B5C37CEC82089635E52155B85CA059ADC39E72F867EDBF5F2F9F172DE0A0A6780016B6D600DF10F1AADA5BB99C5F3837BA3FEFB68F7B9B4FE40BA6FDD882FA062C0C61696D07E6BB230084C361E9BE12CB162FCDFCD5B00005B9B9B0A2065925259B9E928AD3546E331927886FB2E3C84B72EBE86FDBD5D6C1C3A928F5332022B84187AF389836E746159E20164567004CD692700978252BAAFDD45F73C3FA7A95AB8BE77329B214D12BCF9F22BD86B77F0E37FE727F1B11FFE31EC6C6FC1E73DF0A5520999CE301E8D90260926D30926E33145D4347111224953EA0983D2F58067E5697144CE5990A8E40745220D2FD490169F52509C8F0AE26C04A56647E164B93C0F3A4E60AD41A95C463699C0188AB2B2ED5867198D9F5AE2BC13FD5534E8E9DA8991288F54996551A9B44D01EAE0645A93B8A5387B8B3983E9753A586C2D61797505572FBF3B5732684D92DE155EB8495D43CF199FEF79F0C390A8BE7EC0545F96F52E95B0BABC82593CC31F7FE63FCE1179A44CE20B9C83927273D799CF09408100EE6938B92E89F02AFFD5B95A3F8FF585C7966FA93CE59FABF3C14E476BA4498A6AB592966AB51787E3C9BBC63AA337981FE13D48EB3DF8516C01C6DCE64B2D90286B8DB6C8A22030B3D1C84CE26CCEF8BF5BD11F6007B0B2BEA1DFBBF436E2D9945A7E96BC9CD11AB3E904BD7E1F878F1E4773A9891B57AF6065750D24924152D38A239FA4624E744167F0A45A29443ACD80195D70957B73E5F1DD14C0CB420D2FAD04F3D7C18B4144CEE9DA3B6FE3F6E61D7CCFF77E0F3EFA833F8CEBD7AE60341CBA34B7483FCEB886A63AD7BAE938631504ACA3115BDFD5D428804992EED36BA34D2F4A0144329B97A302A79F16ECF83C0593D1E35B9B670C92FED3F212CA0C7C9F64BD321EC9B616080392379FC723F24942A3350D69C973436E084216D282410851C70AD38DE2E0783C4210043873EE1CAEBF770D005C97C05A8B72A582E6528BEECD137EF0724D3F3F0C39F58F7889277D2E952B586A2EA25AADE23F7DE677301E0EB150AB91A28F44D80307B3A8BDE7B22406368BC144003F5156125E4451C527770A394BD501AF7C36F3F65FC1F4D9395AAD9D4AF3D2EAF2CD599ABDD81F4DFAF8D6B57E51B2FBA003902C202E0CF6C4EE718CD55A4197025F8FFA7DC499B58076137EDF4DE307D8019C3E7F7FF7E2D7BF8EC97084D6DA1A4C661D3095CC66E8F63AA8541770FE9147F0E6CBAFE0FE871FA5039BA6143DE319A252D91D4480DE4011029534D8E9E341523E0FF0A8CD07E914B053287A786B2D3C7ED3B526E337C6E0EEED5BB8F8CA459C3C7E149FF8E44FE0F2E5B731ECF7B9C6E3A93B764C9A117AA528CA3B4A2C1B9844EBC0A7B45E1B0D9F179B182B429AD4D634DA38C2D25CBD69A54DAA907179232F4280CE4CE7ECC72C4DF3F4D358877ACBCC3BF86BA30DB427119D0EB2CCFC8BB311FD7B55B86692520BB7C08DF70AF0687269F1C97482D9748A871E7B145B9B9B8867B3B91ADCF73CB49657DCB83194EC73E051709EF02B527DA390947C9B8D26965756F1B567BF84AB6FBF8D46B38929AFE376D921E0DE1320AFE91D3FC2E6441C37ECC3672B4FE12D3B76C934AD2B37E931735E495E44E63C08D719B0A443613529316746A3D1680C5514BDD8271EBF20FCEFB3A2EB9EF9FD09A0D809581EEAB172BFB9555E461BAD824097AC319D7607169E51D0DF96B2CF5FF71604803A7BF6BE9D4AB5826EBB83A3A74E515DC8E0549224E875BB68349A78E0E1C7F0FA8B2FE1DAE5B771E6FC039C96171A2656D059DE32CB062DDAFED22A2BB6FD648C93D30028A59041CF29040B63501B43866C2D26E3115EF9DAF35888427CF2677F0EDBDB5BE8F7BA8EB0E3A205DF689D38095F4806114621A7CE044C0461C835284757E463C9369501231ABB3596177170E963AC81B28062DAB210850427B1D6222B4433E9E94329E83805AC21F28ECC0FE80271CA1A9854F4FC189854B230A460186248FC7703A590599B63027C2D046014F43F8D630CFB03DCFFD083180E874ED6ABE8441A8B8B28572A80E2B6A392355E44F195411F31FE20201DFF6AB58AE5E5655CBDFA2E9EFFF29751ABD79DF103C879FB989FD32F1C2A17A58B19559ECC2B376C05E4462FE143227F1EE1F3C79C03F88A679825D3883751426B71F98DD164FA7A369ECE8039A0AFB890F360AD2FF3FB311BFE94D07D23429EB9A087B1DAC0EA200CB497A6B63D185A80FAFC077A68DFF55B0000E3C9A457A92E4C76EEDCA9C6B319FC28E4E928529E89A713ECEFEFE1D8D1E378F4E90FE2F5175FC2C6F113888280B4E2993598A5F9AA2E05050D4ACDE4E7CA5350C66330D04299C26E36C1146CAE7C6300A84C539BCD18B73CC1588B375E7A19A3C9143FF3777F16567968EFEF116B8F67E8C598AD3108A388B2873485F1A94696BD019A95753C786E4B0EA5B694B190A00560C11114CA1D9294310BAD3397ED6893CFDDCBB580EB0008294A399C839C5C7E7FCF0FA040998E11792F46D5A50E260216B722AD05B4769377F2F84A3282424B4D4EBD508995A22CA4DD6EE3F8495AD1BD29B25E1289B541B95241BDD9A4E7C7CE44C9645E01FD0F4312F52089AF100BD505AC2CAFA2D369E34FFFE03308B80BE3B8072A9747738B510B464AD72F776C82898843B0859FBB6B51F41FC5F780FF2BABD55DA654E84EA198EE43A1B1B4B8A395F7626F38DEC3FCE8EEFB817C07EBFD99447CFA999A719D2F033D29006D8CD156291DF98189C7633B9E25065036F81B32FCBEDD9BEF01EA992F7E419F3F7FFE27EEDEBE7D74A15E4763B149483E880B6EB8660DC210C78E9FC4CDF7AEA0DF6E63656383BC2D4F9BD1C585EB817B8AC6731D11466A643E88528701F9D74267D5BCF6360708A90D668DC1CDAB57F0DAC5D7F0F4879FC6F9471EC3EEF61666D319537589C948DA003C422A6C3D06A3809C4126D14C803914A229B52EF3E728A9A17014C0CFDC497D38A0D2B8CE06348D995259615C9FDB8265A595BC5EE916D0920FCDD391C280A3B2274F5C8D31AEE76FE9E202C05CAF5E01735B8C953C4787686B74DB1DACACAEE0F0D123B87EF53DF77BF2B89EE76179750D4114519B98A9BEBEF0FC7961A7087986A532C22044A5BA80566B194118E20F3FFDDB18F5FA2895CB90D5E0F21A8A115FFE76B10C984BF7254B04E68DD6FD4C9E7781FC646DF153215B020BB5F0DD0C8975A469864A7561B6B0D87C71348D5F48523DC27C942F4A7515FBF8630043FADA0A9D77622D3901A50A24208BD4C26A6B6DA6FC404780E9F77A8853BA20FF39C0BE6F757319C6EAC6C69F87A532F6EEDE65949D5B635A234D628C8703ECEDEEC0188DA73FFA31DCB97903EDDD1D5A40690C8DD1260934A763BE2CED60E28ACC6ECB704C7E30AD4BD70DA7C9AE33C0293271010891EF76DA78F9B9E771F2F8313CF93DDF8B9DED2D8C87231E0CA29B6CC685E208C1B5B2E729A449CC0A3EB981F19FA174BBD0B68385E33C5059C3F5BB94059CC9B8FE3FF29907C35D106DADEB86287E2E32AF4F99801824818C86C14D8F23BEF4C7E51AC9E49B313430E4223C839DC5369838961C4BC927FD8C31A4E95729E3D49933B8FEDE35071E166BE3C5568B96AC2840292F178065E04FE6F305F80B7C1F255EDCB9B0B08067FEF48FB073670BE56A15B3D98C1EB73035582C5FE4737180C7DAF920E1C040C106C441800C5F6A78FA1D95F31E947BE3DCFF9D364596214B12C053585A5BBDAC03FF73FDD1E46D63DF57A46384DCD8870006F9871D0176006064AD1D5A3BE7080813B0488D359901D23008B49A4D4DBBDBB3DA28E341FFAD1A3FC0198001F0C18F7C4F77EBC68DFF763418A056AFA352ABE5BD57BED0694ABDFE43478EC1188D775E7B1D1BC78ED123155250576BF22C801C7ED19BB3F233A9870B4AA9F249706139FC5A6B64498217BEF22CE2E9043FFA733F8BF1784C88BFA6769A17848E71E72219671D6ECE9EA3A8E7D3CA727A0E6214C2E907048494F54E5A40CB42CBD202852E8175137524AC995F03209F882CAAF6E60E1008C3C0610012D9C431487B310803D73273A21E2607375D06C3ABC724A3124743AF871E7B3818C21A8D479E7C02B76EDC74641CB95963B150AB617169893B234CF30D72B24F18E6D37D4118222C9510954AA8D71B585F5FC7EBAFBE82AF7FF9CB68B69630635051EAEE22BE911B6C7EB3CEB80BE593BB8B758EC25D9F429636F748056772F0F1C15D114D1847DB2F57BE329C4CDF31C64EF1FE7AFC45DEFE18B9331893F1533620511F052EBF0552656DA6ADCDBC20C822C00E07033B89338EFA04E0921AE4DFDE2D9704F383CBCD566B32994CAA776FDDC6224B7F4B142712CA14776EDF861F8478E4034F637F7B1B972E7E130F7DE02917D125B26980A4A991A77294EE8AA61D6BD66961B1D13F02121667045296DEBAFCE61BD8DED9C50F7DF247100421BAED36749AE446C1249A80B1091A5EF2720EBFB54E9F0F8A6B4A0B58F048296BE889780624FDF714D7FE70D7C41994E74119EDD079875E8381546B9D1371F52A3BA52CCD18ABD02C7BC508B5B420B9E41047241D16C8E3C84DCA66FE1D0039D6801CA8546C2893C904B37886C79E7C023BDB3B180E06B9A08BCA790E8DC545061E65832FA58C42F71509EF20A4019F8841BFD5D5356CDFBD8367FFECF3682C2D219ECEF2A7EA797381C545F70319A1FB28663082D0DF53EBBB8B927FBB707DF2315E953B1CEEBA541616D2D242F59BC3F1E48AB1A9B4E30ED6F9C51ABFA0CF3F67E833905A6FAED927209FB599B5561BA54C1404464FA7B63D995A10B3C3D17AFFB6A27EF1E6328037DF7CD33CFEF86327DA3BBB4F4E4623046180DAE262AE236F0CB42145D3248951AD2EE0F47DF7E3D2C56F623A9DA0B5BAE6D25037B70ECCBDC96003752293D648F54C3F1675A08C465965A2D064193AFB7BF8C6B35FC5030FDE8F473EF834F676B6319B4E1D6828125CF9B49ACCE9F3F20D1ED01162CB41ECC111504C0E4E91C149AA993F47FA55D6D193997B66E29103B0B9D3935B2195B51CB5E5B83AE96A6D9CB1BA8D4960BD7BCDC41F9BB7B9E4F9BB9D80121561DDD256E38C9A00D7591C63D0EFE3FE0B0F2289136C6F6DCD516304945B6CB5505D5870CFA518F93DCF431804084B25DEDE4B1940A55AC5DA0AA9027DF6777ECB95726E7DB97474F43C504A7F58CD39AFDCA6EDFC67FEB96401F975507943EAC0EFB8AF0B0369CA53682EB7AE67C057C6D3F896BD57974FC0BC83021DA3C2E7B1B5760260AA9492161F390B8BC42A643036D5B05910042634C6F407033B4DB495A82F033D7F9B51BF78730E009EA77EE6E77EFEE63BFF7F7B6F166CC9755D89AD7D4E4E7778EFDE375515AA089120388004010A94284B16E596BA3BBA3B2CDB6DB9C36E777487C70F3B1CD15FFEF36F7FF787C3FEF07F5B0EC9921C1235461312C151A4088204091240556128D43CBDE9CE9979CEF6C739FBE4C9FB5E81134862C81DF1AADEBBEFDEBC79F3E59ED6DE7BEDEF7EF77F06118E0E0EB0ED576749AE2B240CAB5589D56A89E1C606DEFFA10FE185679F85658BE168142E7AD80AEB27D942EEE5C34C6B8C0BC1FC0D0ADB341035372D3C3D77896F7CF14BC8128D7FF89FFD53ECDFBF8FE57CEE26B0F23C84BA825E4B339230F44ACDDE9D978ED292B5115AF64336684690B54EA24EC6C8B110B5F36BEB7F49BE8539BAF9D6C12EEB9B90B4B4E91A17FEB97D7A1E93F0D781998302C99BC922CB802B84536AC672D7C957C08E49F9707F1F1F78F483C8F202D7DE78E3A4F25B372035DADEF60655412B0AA3BD5ACA7C3EFCCFB21C3A4DD12B7AD8D9DDC370B881BFFAECFF871B57AF62301838C66092829D747B524BB14F4405FEB3C6041EA16417A50FF2907B4A94DFE3A4E180BF772D333636370FD35EFF8B93F9E2BBC6D8194E9FD15F1FD1F5217F93D7039813D19C881AC5F7C76270CD9EB927D79ACBE9948F660B6626AB60F0F3F4FAB188012010D172B1B8B7B335FE17C747873B755D63319D62FBEC99A0C0CE13BA7E7C5772ABB1B5B38B871E7E18DFFEFAD7A11461BCBDD32A3FC5239DD2FAEBA289064917502BE60094D75A302E7EE7BB78E3D5D7F04FFE8BDF8165C664721C3AF51872E3ABD0D90772ADBC92473BEFEC40A1D61D1F80B486C442F006E666AD99F5AF0DD10AB35B5516BC5283F237E90887398198CFCE5D0F840EBF3039681BAE7FAD9366139092790215BA0801B4F2F5701DD0A401ADCA857F8FFDFBF7F1D0850BD8D9DDC595575F0D21738384BB31E7AD9D1DB7A9D78FF64AA92F49D340EBA5D314799623F5BC91A3D10867F6CEE26B5FF902BEF995AF606B67078BF9BCBD6DC88F1ABBF7B2E16F1787FA715EDF7CB658F1A384207A5EAB7AB1F6F9DDFC8441D62BCC703CFEF66C557E795556076877EEAD2B7E9CEBC739BE28FFC2E7FAF27AA1EAAEAC43984D9A6846B9B207C7C75CD51CBCFECF23D77F9068058F573151B998E35FFC37FFDD1BDF7EF6D9FF3ACF731CEDEF4329C2E678CB77ADF9DCD653312D1773186BB07BF61CCE5D388F6F7FEDEB0001E3ADED16C534885A7C013632104DD80A07080A12CD2E54BB7FE736BEF1E5AFE2577EFDD7F0D0FB3FD0541E8CACA8F67BEFE3C11077B0E041C593C94D08F635FE44BBBCDF87930D30E9F90BB95904E914D7DD9C961D80146E60D3AC9F827834E666C2516957794043CE214D51A694F97C9FA533877226FCF1058493EB24D381E251E57DA584DAA80882E21CECEF636B7B1B0F7FE0FD78F5D2E5669A307A2E83311A8F31E80FDCDF4CBBB97EA59AF03F09DEDF017E699661B8B181B3671FC2EBAFBF82CF7DF64FB0BDB78772553640A9FFDB8AB2870820CEFB1187F99153E4E63334C9A2BB56367E5E24A10A0204B2D9D1CEF6554BFA99D962F91A7308F7D7157F1DE59F023C8F1E13C597D748D4508151B143F725DCE7E3C984E7CBDA02600DFBB6F1FAB1680B4003C420F4F314D3E5F2B5BDBD9DFFE5DE9D3BBDBCD7C3FD3B77D11F0E5C0DB7369111704D2CABC512D65AEC9C3983872E5CC0F35FFF3B58B6186FEFB4E8A58D3190CDB544E479EF85EB1F80F7A20E847316BB2A4B7CE30B5FC0CEEE0E7EE5EFFD3DDCBB731B655986A58FE29D04D99706987063FB528FE4872177F46642CB008F91811EBF60C3630AEE984D134D20F4647F2BCAC5600E6ED4797E134A8F00C19A3A6012AE9FA16E3EAF75F928D0E00932627DA207C1B7208788CA9F4F1855A686FA2A3602C70707E80F06F8E8271EC7AB172F3BC0715DF9995DE8BFB515C67B83D2270974DA2CF0CCF2DCE7FF297ABD3E76F7CE60B958E04F7EEF774369B0AACA70FC7099624C243AD7386291F3966B1E93AAB69C4538325A9F59083A8CBF3F071B1BB36238FCCA64B678AEAE434D7F3DD48FC37C09F55B8A2FB93E1A40D01D87513173C560A37462334576359BF1F16CC1D6C2120C128F17BD5DBC7E2CDAFF4316843CCBE8E6ED3BFCA9A77EF1D583FDFDFFB22A4B244982FD7BF730DADA429268BFEF0FE1C6377E60C81A1709FCC2238FE0BBCF3E8BE974EAF24872AD9AA6AE9C12459E0C40E80A64765E571A72988197BEF33C6E5FBB817FF43BFF1493E914F3E934283F3CBE104A5DFE78E1583E17D7CA2921D881656137BD0F158CB14187DD6B9B68C43B29D4B559CB2D394428D2CF2E5D870C8F7FB824D67973AFB856D876189E7BC187AE8141593AE138444EE2CD841908688C82F41784E61F2B7DFF8EE790004C8E8EA0B4C6134FFD225EBB7419F3D9AC851D84DE09ADB1B5BBEB3DBEAB9C683FD62B033E3AF59B7BF3025996B9219FED1DE469863FFBC3DFC7FEBD7B180E8758CEE7C128BA966AF7661419C958C2E70969A64473EDF03E5EB829114B48C3E4FA5B47C899F7FB3CDADEFEEEBCACBEB45895778153BD7EDCC4B39EE3B7C03F228AD97CDCB1986BCB6CA0B54DB5665E2EEDC1F1842BE392BB04FC7307F97E9068007038800229A22CCB70FBE6CD573EF8E807FFAB3BB76EEDE4790E632C8E0EF6B1B9B515107700DE72BBA9C0E57281AAAAB031DAC2871EFB282E7EE7791CECEF63FBCC99E0F924C717F49F7DA75FB34CD131E45A6B70FFCE1D7CF3AB5FC37FF01F7D06A39D5D1CEDEF8712235BE3474E1B8AED1339B13704D2FA298B385D1EEA337A6E9E2BFF3BE28B881D478C822073FE35211A128F2F372FFBD29D2F414AE3935CB75026AD6BC0CA3462BB162EA1AE562A9C5700F722A212295306AA76F828C04743D3C9047555E1C95FFA14AE5EB982C9D171CBEBBBB667F7771C6D6DA1E8F55DBAE1DF4B403F890204F873E05F86D1680BBBDB3BF8CA17FE1A2F7EE73B186F6FBBBCDF137A86869FE86F626D5B15D6CB800124F4F7977C854831FC6EED98EC22395684F1EECE6DABF4DF4C668BCBD6E5E9310F5F1CEA47A83E4735FD96018801BE50E2B3D6D64CCAA689B6AAAAECC1D1B15D556F1F74FF8795C80000355BEA1705CD160B5C78E8FC7360FCF7478707E80F1C5FDBF1C10146DBDB009A061D59676D6A83E56289BAAE50F40778EC8927F1FAC59771E38D37B075660F49E217664439ABD811C72D68439DBAAE6B3CFBA52F633CDAC453BFFEEBD8BF7717A574FA5154EAE3A621062CFC7ADEE3C3F7C458190F6DD861042894E93020567E0EF45E00C2865D70E3A1AD6D8035B122A1ABCD4732010310EFE56BD0522E140573A1AAA40DD2B4D2107548589BF87D8CF03FBB14608DD0939A3DF5B3E914CBC5029FFCE55FC2BDBBF7B07FEF7E540F6FCA666C2D7AFD3E36B7B6007014F6CB2CBF0E841E59E6C2FE34CF31DCD8C4D9336771F1A5EFE18B9FFB1CB67677B1924EBFF01E6D6F2F1147ABFB2FFA4CAD6A49FCBA383D880DA5BCC63A00B63F1C96FD8DCDBF3B9ECDBE5ED5E618A7B3EFAE2BFFACADFC14003E8FEEAF2BBEB5209326DA26D61897E7576FEB3CFFCD2418000102FB454E3503376FDEBCF9F8138F3FB598CD3E323D9E60B031C472B9C4E4E0009BE3310084125A1CA6BAEA40099524F8D8134FE2DEAD1B78EDE58BD8DA07D416190000200049444154DD419AE751CF3B00990CF4FD013222FCEA4B2FE1E6952BF8FBFFE97F82C57C8EA527C920EF4963EFA23D522DCA288347CAB3E484501BF2FAA6ACE9CE012D34FAE47AED28C4A406FB700F46DECB361CF5F27C41F165A79FA443F139887797A45F6AF6428F454018EC91DE7F4993DC29B41502001673B7D6ECE39F7C12B3E9CC51798BD201D212043756AC30DEDD85D649C05464894760F54D5324591640BF5EAF8F3367CEE1DEDDDBF8F33FFC03F4FA7D5F226E66F2F51A3E11AE77930784F391DFC769CFA9A53C8EA2362B6DBC062A4D31DADE7E6565CC33B3C5F21A9FACE59F92E387703F74F0A10D06B6149F998D659824494C0AB6F3D98C27B3857D27E4F96F261A705426894F03524DA034235826C5F89B33E7CEFDEBD9E458576589C160E0B6E5CE66D81C8F1D1818D5758546AC5CAD50AE5630D6E0A34F3E0902E37BDF7CCED1780FFAC15848BD3ED4BC89303B9EE0B9AF7C159FFAB55FC5F699B37E05B71B97556B617E8CE023BA7902C128D0FCDEDFEC42B50D3475660A2DBACDD0523C620A6E520CA912340ADD34FC58FF7B36269A6A8C762106E2556E85C3E17FDF04E448464D3008C2CD404481699701D7F20BA9A9BBF75BCCE7981C1EE2E39F7C126555E3E6B56B51284E41FF2455D81C8D50F4FB8EC3DF1B01AD93D0F823DC7E699EBBED4B7981ED9D5D3080BFF8A3FF17E572895EAF87A51FF1152036E6F40BD70D6B8620365C91C797CF24A1BE7C3E290F8AB1B10C6C8E47C7495E7CF1683AFB8EAFE9C7641C0F68E0613FB473A2C94710FE68036F68DF3519295BCE667C349D716DD80216EF843CFFCD2490BD290F0496D6D0A057C0584BC7D3E9EAC2F9F3AF28A57F677274046B0CFA830116F339E6D369181115761AC9818D3128578EAE6BB958E0C2FB1FC1DE993D7CFFDBDF4655AE30D8DC6CE57ED63AC56000DF7BEE3968ADF04B9FF90DDCBF731BAB55096B6AA469EA435C9F1F6BD992E3917D3F8D2848BE3BB1E6F8B2E720004E7EEB4D18C5653FA4A4553004720C77A28DF7B7A6D9882C868F01B0EF7910849B038AEDC0033976530D69DE4678FDE57CA8D1D4266C961E037F5EA13EEE2B178BD90CC7FBFB78EC894F8094C6B52B574E1C87FD676166E44581CDD118E4D32AAD95E3F14B74CBFBA75986DC97FD5C99B08FA7FFEC8F71F3EA558CB6B702B028EF135D7E7F7F34CA2F69404CF871E27968CAB788B01AEB95DF5435B2A2C0687BFB85C97CF1C5E5AABC8336C077CAA20D9E01B4DEC833F3B5FCD8E357ECFBF62D73CD5A9B5C6B6B970BF6005FE8DD7F272BBE48CB00B80B4FD4CB321872F6FCEEDDBB17DFF7F0855F06E3D1D9640ACB16BDC100CBC502F3D90C838D0D9F1FDBE8C6777FC0AAAC505715968B3936C65BF8F0C73F8ED72F5DC4DD5BB7B1391E87FDEE0CA75CFB77EEE2F2F7BE875FFDADDF84B106B3C9D4D18AA966A437A0DE96A314C22B81D6AD7ABA74FA9112AA31F8565F849B5E700C0AF97F1321C84C8077F800A2EE346A0671C4F005943E34BC48F7A00D37BD20D5E066023206BC4E96BA9A5C59362D8B0520347B056693098E0F0EF0D14F3C0E288D1B57AF86309A7C1524808670A8FF686B0B3AD1BECEEFC3FF4487459EA96FFCC9B20C595E60B8B189DD9D5D7CF599A7F1C273DFC2CE99BDD0E71F4AB02D4FDEC600E4B11610289F39326C728C862D481AAB5C83D6D6EEF6012BFD3747C7D3976D3378735A2D5F90FDE9DA63D2E813D7F3A591A766B63593AAB3445BAA2ABB7F7CCC2BDFBEFB4ECCF3DF4C820188D30022A634CFC95A43160019FBB9E1C6C6FF04B6E97C36030161BC733E99A03F1C3AA58C865500F7C737758DAA7446C0B2C5871F7F02D5628E575F7C09499AA118F461EA1AABD50A2F3DFF1D6C8E47F8F0E38F63FFEEDDC09B2F4AE1F261AFB4F0FDFDEC7BFDB50A8A6A8DDB17DF683DBC87F7D37CD6D7FC99C3301211421F82D2CAD397B501AB00D28937B54268DA3C47B6E906C3122A004D982B25BD8067F863856083C8F702A8608420CF91DC971B9AACD9F131A64747F8C8271E07698DEB6F5C0D9F3D807DD1DE0666C670731345AFE794DF1B01C7E39F06D45F10FF34738B61CF9C3987EFBFF06D7CF9E9BFC1F6EE8EEB7EF4F4E6B10486E418DF686E8A76DE2F8FB53C7E1B389429CE3CCFB1311E3F7F783CFDE2AAACF671926A5B3CFB04AD5CBF517C5FCF8F877BA40DB8B2D6D69660B224318935F6F07862E7CB8AC10DC0F74ECCF3DF4C5AFB05A41A50D52E0DA81950209A2EE6D5CEF6F6D788E85F265A61369D01007ABD1ECAB2C4E4E808BDC1C0013FC6B5BAC6A15E5555A82A170D2C1673BCEF038F60BCBD854B2FBC80E9F104599163FFCE1D5C7FED357CFA373E83B2AA02A22C0AA0932494BBB48CECC25512948083B2288322220F7F638505A5C638F4DC87930837A83B633784E3EBF5AD722787342046D3656F41887E045F8880CA103D788051700A212C15A5888FABB40A0A2F945E08CF69362D4D0E0FB198CDF0B1279F80B18C9BD7AE2352B7C645F9FC1C44C8F31CC38D0D1029E8D4B7FCEAA6EC271B7C120FFA15FD017677F770F7CE4D3CFDA79FC5603840A2B59F5D88943F56FAE8F348D525AE00B8EBC2211272E7DAE4FEF23BD9F0B3B5B3BD5F317FEE6832BBC87CA2836F1DE413643F06F8E2851C8E9907A8C835F2D496513B800F763699F064BE6466F8BEFD7726C0F7C3C80903E054412325406519B1B54444B87F7070E3FC85875055E6338AC8516BFB12923506C78787613E5CF6DDB92CBBF19EB24F703E9DA23F18E2D1C71EC3BD5BB770E3F52BB87DED3AC6BBBB78FF473E8CE9D1114C6D1A220D8FE80BAB0FB38D166388C235205E92A4D1C8B1330CCECBFA915F57FF0A2533A1416F42FFA6CDB7990A4408F72512084B4B3CCD58780E0070D3CDC6D6A2AEAB90C6C84D4FC049B43F42FADD1FA5292F3600BAFB9C47FB0728574B7CE2534F615956B87DFD7A38963F85203120371A8FDDBAAE68C24F6BE557760BEAEFCA7EB9E7F25FAD96F8CB3FFA0358660C36866153901850496362053F4D42B82FF8C9BA11E6C6E8D6D622CB726C6E8D9FDFDF3FFCC2AAAA0F7072526FDDD3AF817C345FF3FA4D238FE5CA02B5D2DA840EBEE99C8D8525DFC8F36E557C91960190B6600B60551B1AF67BA8AD85F2AD6A4747C7CFEEEE6E7FCAD4F6838956582E1630C6A2D7EF0144981C1D014AA1D7EBB9109AB975D30AA36F5DD7582E16A8EB0A8F7CE4C3C88B1C37AEBC81AAAEA1C9ED92B32D020BD775A713098BADE71AA070DFB8BB9E912649B3665C8445F19B70BC09431B0A2F80C39C83FB89C3886EECD5A42419FAF581C09E244A202545F9ECE205DB356D801485F557887C37059C034129A41C5856158EEEEF830878F2977F09C7C7C7B87DF366E8888C153F0614D95AF40703F4FB03905778E5A9BDB46FF7557E8B6F1A75FA25698ACF7DF68FB17FEF1E76F7F61AD02F32367184C21E0F71468DC26F5B9580C8D35374AE126D5906C65BE3490D7EFAE0F0F8453EB95167BD694772FD10EAFB11DDF6C08EA3E372937A3A319956D62C177CF80EEBE07BABE4C48AB1260A504861A13287058048F952D6D38341EF9F81D4A6520AABD512B531C8F31C5A2798CF66A8CAD2450682CE031E88F29180755B78AAB2C47432C1CED9B3F8D82F7E12F3C904AFBCF8126AB75E390CF934D370AAE91E945E7DA542C94E96728210BCAD5380667D16016042F0BECCCD4DEB66D54FFEC975A29BA5A640F05CA414E04B8EC6D44842ABAE7B9D8CED7A64B201BCFC93ACB5483C67BF4C5C0A90E60C5C632CA49458AE5638BC770FC3C1004F7CFA9771E7D62DDCBF73F7A422C627E28D884E126C6E6E3A902F491C5FA26EDA7D9552BEE1C7E5FDA3F1189B9B633CF3577F8ED72E5EC6D9F30F61319FBBFB4429BFE3706DC0073E72420340C60D3FE1FAC55889A458014C4D30DA1E5FBC7F70F4F47255DEC3E9ADBBD3F697283F85A11DAC7B7D8FECC3037C582DEDC1F131AF2A17DABD5B90FD1F454E1880761450D3D06301BE864CCBD5AAEC15BDA709FCDF6AAD759224AEEE5F55485357335EAD5658CEE7287AFD4611D1587BB6AE56EE568AB9AD3DC61A7CE4892771EEC279BC7EF9326E5EBB06AD158AA2E7BD88B4F04AC418513DFB9BA6E9C4530D5847EDFC79DD3BCAAAEEE091A5AA40D20EAB51971540D28ADB5E54411E7484F75AB23148C6A07592B4404096637B1090E19897D32C0D950569C801D0809F44984F2638BC7B17E72E9CC7871E7F1C575E79154707074D6ED0845BF01FA7891E88B0B1B9E9E6F713B71B40FB9ABF5EABF9275986C170033B7B67F1DCD7BF82E7BFFE0D3CF4F0FB509565E8FB68AD15F71286BFA2688999035B945CF338CF8FBDBF65C67034AA48279FBFB77FF89C6D0670E20EBEF5669E10FEBB50BFC5D2B362A024E1E123325992186D6A7BE88839DEB11D7C6F959CBA645439BC1C161A5C5794F57AD2404300683A9F4FB6C6E3BFABABFA9F27890E4ABE5A2EA13D29A43106F3D92CF490AFA3DCCDE0873304ABC512C74787D8D8DAC2C73FF94954AB25AE5CBA8CC96482A2E8212F0A776ECA4DC1C5F5E3C0610F38C43B3216F14D2A63B7AEA4E4B7FEB29B819790D65A67ACB46F0E0AECC1F23AC9EBD1C602180D657655562E3280339CC6B8B447725DED1542B80183D1F1462234D2A029851DEDEF63727888471FFB28CE3DFC302EBF7C118BD9CC1BA213403BE2FB988890E5B98BAA92B529BFD6C08F6BF8C9FB7D9C3D771E975FFA3EBEFECC17B07B760F0485B22C9BF9FEB5EB2AC64CAD1BA3704E4DCE2F9FA929E1BA91E9F1CEF6ADA3C9E42F27B3F9353CD0EBF314A009DA217FECF125E477653DCB32A26B52C04E27139E2E56D6017CF65D0DF0FD3072AA01B0908A00A3B6403F4DC03A21582631024793E98DBDBDDDD756CBE56FA7698AD45350AD3CB79DA3DF0666B319C0EC987B4CD45D476B00A1A961AA1AB3E309CAD5121FF8C847F10B8F7E100777EFE2EAABAF62B158202F0A7F5C971BCB0620062083056124760D7596315A87AC0B2370335A0BC0DF944D17A1357EBFA152A8AB3A5408E095DF4D1572683062668F03B8D706847B5D432325915229F95C5C944840CC6AB5C2FD3B7760ADC5E39F7A0A695EE0B5CB971D8B6DE459FD01FDFF1C8C8D8C470F3737916679A049D77E7F5F127BFF2C435114D83BFB10EEDEBE8967FEF22F51F47BE8F5FB582C22728F58221C409DF619D144221C2BBD7C5946DE2B500C07CFDDBE7DF799AA36473815E40B217ED4CC432DEA6D002B669444A8D8BA709F74721AC0F78E6DDD7DABE5816BC69B28406151AE30E8F7A9369655F4573E9A4C2E9F3D7376BA982F7E533C88F573FCB531C8D214894EB05C2E519725922CF3A5419FEFFAE3AC570A968B258E0E0F9166193EF4F1C7B173E60CEEDDBA859B57AFA2AA2AE479E15FD8E4CC2EEFD74D0B2FB343D0A3634BC84E4AB7C03578A28FB6D744E0F117055F1FC755E4D67C4BD950220089181A6290765429709F288418ADF65C3B63767C8CFD3B77301A8FF0F8534FE1F87882EB57DE68CA97EE4C1F8CBC7B652B8A0283C110CA774AEAC4D1776B29FD69ED187DB31CDB7B67309FCDF0CC5FFC05D832B6B6B7319B4E5BEF11F746D09AA16D10FDE6B9AD9660B97E1C2A12CBD2D8A7EFDDDFFF2E9F04F9A4A6EFBD3E49047042F1E1C37D0035B3AD40CA648936BC3A7D441778EF85FBA7C9030D804401CEC36A685B53D22B608DF14180FBBB1F1E4FBE73EEDC19BD982F7E95C871DB131C1164555548B314699AA2AC6A2C1773EF6D52EF19BDE2451ED87A40CCF872E1623AC5703CC2A31F7D0CA3F108B7AF5FC7AD6BD760AC45D1EF85155C4A5671B394EF2874CAB91B15BE89C8862121F6CB467492402A500E787437B6D07201F0ACB892B35720A55096C2E4DBA63A176C220CEFA0E1F75BEFF40B04AA3238438E2C65FFEE5D2CA7533CFAB18FE17D8F3C82ABAF5FC1C1FDFB7299D0ACB9944BC7A72A2929858DD12862F6917A7FB3D527F5833E5BBB7BB0C6E00B7FF917984C263873EE2C66BEF1CB1FB4A5CC725DE2D46EFD4B803D7083F08319A43546DB5B37EFEEEFFFF97436BF8EB6F24725BDB8C4C7A1779F85673FA0FB5C3173CD843A4D12AB4D6D0F8E8F79B9D6C1271EFFBDECF56379A00100DA8060692CFA6902A3B4EBA1978E14308E279367CF9CDD4B96B3C5AF9022644511965556BE5E9C668EA36FB95AC1D6D2DBAF1ADAAE284C0EDD6ED6BA95DED319CA7285F1CE2E1E7EF483C8F30C776FDDC69D5BB760AA0A795138A030CE4323404F1185451B755587355B0D2DB78CE836EDBDD68FE92AAFDC3207C0C684965CD9B41B506C349E5D7AFB43C5809A411EF1CC4944622A4D4347FB07D8BF7D0B9B9B1B78E2D39F06B4C66B972E39920DA92688C83513655FFBFB315CB356AFDFF7ABBC24F457A112907876DFD1F60EF23CC7979FFE1CEEDCBA85F3172E60B158043E43A0C16E420950BE2046B759F4115721C2F5F1BF4BB31CBDCDE10B37AFDFFCEBAAB6873859DA5B47F843FB2EBB31DD76EFBEE5CA826BEDB7ECCC8E5D9E0F06ABB50EBE37D586F7A0BCA90100D65281D5121B83016ACB502EF90BC5EBC3A3E36F9C39BBC7CBC5F2D708ECD643FB1257559630D622CBB2D0ECB25AADC27AA918AD0EF9219A70D1F8BE81F9D4351F6D9D3983F73DF201F47A3D1CDCBB873B376FA25AAD90E5B95F09D6004ED2A926A941B36C94C3DE3FE3BB072D33AC67FF71C01E37DE19683AFB3C30A87573F9A40C29514CEB1C7C17A32C3C95E3811CBF3E2985F96482BBB76EC1D6353EF2C427F00B1FFE306E5EBF819B57AF86D5D42D0EE048F963E313CE070E941C6E6C22D12ECC170E02A534525F064CB31CC3CD1146A311BEF1A52FE2CAE5CB3877E102AAB24415B5F9B6DE430CABA0FED1FF8209B43AFA448830180CAC053D73F3D69D6FF0A98C3CAD861EC9FBE3669E665ACF97F54869936A6DED62CE8793293B92A7F74623CF4F2A3FD000482A403E15B0D58A8A7ECF2DD59030C02D8F5047C7D3E7CE9CDD5DAE16CBCFC0E7CCA927B2A8AACAEDBBF76413CC0E3034B56FF089D96E10C15992167843B25A2CB05A2E5D7BE8EE0E7EE1914750F47A38DCDFC7ED1B37309B4CA0FD008B7003C811855F5FF6DBB10CE37843617CDD5E9A58B46EEAFFCA939604E545538AACAA3AAC235B571AF1F812E24B535192A6504A61B55CE2CE8D1B984FA738FFF0C3F8C4A79E82B18CD72E5DC2F4E8C8295104B4893CC89585E731A33F18A0D7EBB9A61FD5807D8957FE244D31D8D8C07867172F3CFB7778F1F9E7B177FE3C008456EC70DCB5F25E2B0A109AB508D58FD33AE57FBF391E4FF78F8EFE74FFE0E832DEB4AEBFDED08305394AAE40BD6DADAD2DA84E93C4A8AAB607474727EAF940E7F57F903C003D3A2909406E4D86C6663F5754F4C89A5A935209B94C2103B82052F9FB1E3AFBCFE7C7937F4304253745E94783AD3161C4144018BAC98BDC73FC5BEFDC4E0929E11E97A195DC9707FBC301B2A2C06AB1C0D5575EC5DDDBB7A1B5C67867079BA311F25EAF5557D74982AA2A036597C3009A501D5E5185A527C9B28631D8E7EFC6B8F16141F0E36616C0118152D48CA43DB600208CEE1EEEEFA32E4B9C7DE8213CFCA147618CC1CDABD7303D3E0ECD3FF299D7AB151221ADFF0143394E298CC6636459D6B4FD2629924487B0BF180C70F6A10BB8F8C2F3F8D657BF86DD87CE214B53CC7DB30FF9A88311AD1803DA8640E614A274203019F9EBA19314BD8DC1F5AB57AFFDFBB2AC0F7092A1279ECB5F003C075C98CF6C43EB2E0335FC961DD2894DC1763699F0B26AEAF9723D3AC5FFE1E44732000050FB8C6F7B6348759228B0D544A4014A01A444540028CE9FDDFBC7CBE9ECDF02C85C3728C1541556AB55F02E79AF87344951D7158CEF8A2BBCB2864840C24B44253DAF70A4149234717D02BD02FDE1067A833ECA55893B376EE0F6F5EB98CFE7E8F57A186F6FA13718867E021B29949B2A749C064A39643F94F0E0CE1D7ED02706F6AAAA0AD8025BF6BB0E1A1C4394401675546589E57C8EC9D11108C0B90BE7F1BE0F7C0016C08D6BD7707C70D81A956DE5CE2C8D0D6B7FC0187D8F72EEFE6080E1C60694D2483247E6A9951BF74DF2DC6DF1397F0137AFBC8EBFFDFCE7B1311E6330DCC07C366D8178EB46460CA45A537E897A02F06A1D0F4292E7C88AFCBBAFBFF6FA972C8731DCD8FB9F660096CCBC22A2153387315DCBB24A5B5BBB5CDAC3D99C01C58061D971D729FE8F263FB401006223A00030ED6C8D55C9500456449410A90440062007D03B7766F733E57CFEBFC3F290C0618555E915C11AE3164C78A574D180EB9ECB8B2278BEB8C32C7282E106545A07BA2AE5C3FFC1C606D234C5F4F808776FDDC6FE9D3B58952572DF10D3DFD870EDCB89DBC7AA9324B4E3CA2E441BE5FED618B0F7EC4992A02A4B28BFC0C398BABD002342FC45E9E7B319EAAA429117387BE13C76CF9D0529855BD76FE0E8E0A0D9FEB3268D27753F51A4E8E275E57B444673341A21CB73D7DB1FF8FD14B2BC406F30C099F3E771FBFA55FCED335F40AFDFC7C6E62616F3790BF10F1D95F25E88917EB7A844C95215D5809E523A2D7A7D54D67CF1DAB51BCFE1F48D3BD197787D161EBE30A3CF968D051BAD1393B0E5A3C9C4D67553D673F764A7F83F8EFC480600888D80069155DB5B5BB4325669220D420250424462048ABDEDAD275195FF676DCC595112A5B51B0D9ECF51F98696A228028F9C0CD564791E8C83948EC249AFE5A36224529FFB2BA59064197A3D77C30384C57C86837BF771B4BF1F7ADAB5D6E80F5D64A0A3ED37D6330C054E3F3473FC321D2834DFB200B42ACBB0CF60399F871D0645AF87AD9D6D8CB6B6911539E68B258EF7F7319FCF43CB702CE1A7C8A3CB9F4BCA7FEBB57FF1CC6046D1EB61B0B181C4AFEE4EFC5796E7E86F6C60F7EC395C7DE532BEF5F5AF63301C62E8955F94FCB46B2C918090B3C8350F86A1C50940E80DFAD5FEC1E15FDDBBBF7F11ED90FF01CA2F8D3C1C6FD9F15E5F994C2B5B2F16F6D82FD55430DCE5F93FB9FCC80600704680011868241A6A733CA6B236EB4620873702A38DE12F1489FA3FCA65F951721031B4070757CB2556CB254C5D41276E1045E6F66B3F2ADBEBF5DC98B1CF29E3525A5C8E627624212A69A6DC6451459A24C87B2E5548D2D4751D4E26981E1DE1E8F0008BF9A2C5381426E47CCFBE9B3568587D009702D8DAAD97B6D695099547F6FB830136B7B6D01F0C90F50A94AB1247870798CFE6A856ABA0D481361C0D51A7440FA1E10668BCBEFCE162CFEF7F2FD761B8B9893C2F3CBB4F1A7A31061B1BD83DF7105E7FF9257CF79BDF446F30C0CEDE1E269349732DFDFBA9F8D868F27D09FDB5526E390B2904FD6306E904838DC1F11B57AFFDE9743ABF8193B9FE091E3EEFF5C32A6D345C7C8DD73F3EE6DAC0765EFFAD951FCB0000C21EE4E605320D351C8FA9AA8D52441A440911A568D281A2DFCBF7C6C3C1BF9D4D67BF9248AFBB57CEBA2CB15C95A8AB32806E599ABAA69BDAA0AE2BA4498ADEA0EF893D9BB054064D02F1A5441912198479771D6E70697BCD8BC22FBA4C40A460AA0A65B9C26C32C56236C36AB944555561B987E4E18E65875A114356B8BC3ACD3228A5511B57EA5C4C67582E1D3F621C228BC44332ED325E446A72DA1F4D3A20C38314A2A6E1C64608FB93CCADF11A0C0718EFEEE2B58B1771E9851790F77AD839B387D964DA0CF8449E3E46FDE5BAAE1B00015643A4A034465BA35B2FBF74F1B39EB1E7B4E51BE2F15B0CBC51AE5FC5B97EE4F5AD82E9D0FDB7587E6C0300B42B0379426A301AA9B236144502699C0EA489DE3CBBBBFDBF4D8E8EFF731DB5E90A80545715CAB20C694192664812D7B65B962B18635014856FFC510D4025DE2B02A5C2C38AC2AA2B095FE5269627C561B26B89CD3C36D0F003B4E8BCAD5F924A8EA8A42C4B94AB15AAAA445D568101C9C6E17D5CAF0FE7C701D18FEBEBCD9DEDE202A11515EFFCC0D65F660C363650F4FB6EAACF575B86C30DF48703BC72F122AEBDFA2AB2A2C0DED9B36E0A531A7DFC7BABC80848535550FE28F4173E0679629AE7E80DFBAFBEF4E2CB7F513B4EFE58F1D7FEE7F62A6D87F0571EE1AF49273665B74ABBF3FA3F5DF9890C00D03202946BD0603C56556D4845E90080DCA7040580E27DE7CEFC8FB3C9E45F131CE187E888F22061E3799D9225490AED8779AAB28465C70F97FB8EC3131F8A08F0A169F880A2F84461E105E0106B41FD25F4960D46A779DF40ECE99B856C5D3784A8FE39ADAEC0E822B3440FD1F33802F7881028B0C2E7583BA6FFC5C9CFCC0E3C1D6E6E22F3CB3BF322C77034429AA6B8F4E28BB87BF326D2A2C0F6EE2ECAE512B5DF52D43A4E74FCB8D6AF3DEB91D609C8F32F362956029D26CF5FBA78E9AF3DD2BFEEF5A3C758BAF9561EECAB003FBC039834D1962384BFCBF57FBAF2131B00C0190187616BCA13D060348E2381740D18EC0128CEEDEDFE03B35AFE1B636C4FF95057D0779D24A8ABC893FA5A7A92BA2116EB7BF8ADB5C8F30279AF68EAEC512EBBBE9A0AFE86D651E79AB51633BF42AB81DADCBFBC76BF85E83D7291CED6A8965777D1891B3CE2D60BE534A8E5FD5B7F8C285278A044F8479C06F43CF8E7C67A0B8CC62328AD71E9C5177170EF1ED23CC7F6CE0E56AB156AE1F3E3085414C54733DB1F97FCB4726C4DB23939D10992BC8061F3D5572EBFFA2538206F8D8EBBADFC683C7F2BE427A54D4AB0D3E3635ED50DF536D029FE4F537E6027E00F230DA330C358055BADD0EFF7A8B29695CB973994B07C656B3A9F5F2D8AE2CBBD7EF1C9BA2C7744A1AC3161F4D6B10CE930B857D7959FAB77BC7F4A6B945589D572E9B8FAC9037F40A3182D30AD01B9A4D1C6B116970ED18F4D4063359A5A77941733BBE84514259E07705661CDBAAE7BED533A1E43C9CF3FFF47B1CE4484DE60E0D87CF21C83C100CBF902AFBCFC328E0F0FDDB0CFCE0ECAE532F00EAE6327141D4BFE8FDB7D656928E0BC7FD11F60BE987DEEF5D7DFF85BBCE9104FA8FFC7DC7C25982BC36C922431BAAEEDFED1111B4B4C305DC8FF3392B7C400008D1160306A4BA8CB2506FD3E2A6BD90F0F31C0ECFE77B258AD0E97CBE53393E3D9F749E9419A260F0BB7BFF5E05F9226C8F3C2D7A49BE11A6B0D086EC08640A84D8D6AB5426D8C1B7B15DA6DA0E5815BDD6CDE3868A50271898B0E10425FF18EA729A33CAFF9B9F1A2EBB7ED0FBA8BD74137792C041BC1909DFC6266A45986C16080DCF7431C1D1EE0FA1B57B05C2C50B8251A582D16A17311405BE1A36BA4881CC848040584AA48A00ED3097ABD9E3D383CF8EC8D1BB7BE85070EF1483BAF5D1085AD3B52DBAF2D60B224B1D56C668F660B06C8EAAE8DF7672A6F990100DA46C0B042E58D40CD8E2C5B29C5CEC309879C65CB5852A2AF55D67EA12CEBD7B4521FCCD264EC426184DA7A9A65C8F33CE004327023A1BE284F5D556E90A5AA00F835DC4A469A9C884717150280725582B9690556C1FB45CF8F1434096F8032000014F84944415450912302F5E497A785F0B1315A7FACF5B4D39B7B9AF75947169C0C860364598EDA181C1D1CE0FEDD7B30A64651F430DE1E3B025761528EAE411C89C41D8012F243943F4D41CA954607C3417DEBCE9D3FBA73F7FEF7D128BF9FDB6F949FD9CE8982D75FC2817D255B5B93D22623D8891BD9F5217F37BCF3B396B7D400008D11803702ABE51CC37E9F8D237D971BD04703CA47BDD6129165C2F5B2AE9FA9CABA28F2EC31259034FB197C72D45692EF8768C0F7DA27DE3B115C934E5D55582D57A86B03661B941AB182010033AAAA0C4347D6B8631A6B41114A2F3DFFED1AFC3A52D074EFB5403C9CC422E4BDD70D41C8C93D48D8BCDDA97108B456489304ABB2C46C32C16C3A03B345AFD7C37073038BF922D08F37AF6ACEA595FFFB6B24BC84DAF750904E90260936C6A3C5EB57AEFCDEC1C1D1253C58F9E7CC36E6E2F721BFE3E66B42FE63B621E477D279FD9FADBCE50600687804008685E6C562816191C32805E1D426C08AAAF8B4800162104A0BFAD66236BF9C65D927922419683FB9C640000A8BA2082BB34D5D37F3FB9EEE3A4993A6BCE8F37CA92CC4B9AD8A9511529A43600E16D58D196DE8015E9C236321CF754F69A7102D943F020FD765DD8834B8403C8DE7FA1AA44252AE4A30181B1B1BE80D0658CCE6EDF2A33FC1D800089351ECF925E7D7CA5D7B9DA4D8DC1A1D5FBA74E9772793D915B4F3FD68138F23ED20524B809760AC986474B715F25B8058BF079978DF4EF2533100406304648C78B15CD2304D99FDD20EA7780E8B03605D34C096992D1131B4BEBE982FBE99A5E96F65795648538FCB5FDDED9BA429F23C479226011730751D5888DDF04B02AD7458BA698C71757BDF98031F3D84716069D609A17623EDB29C7C031FCF00A76B79FBB5EB8D40B1C46F2BD97FFC54E53FBB3C265D87803030D52002B6B6B7916599E3636C4EBE7D3EFEB175C0CF45496E539022429265D049868DADCDFB2FBDF8D2BF9BCF97377132D75F63ECA125B375213FA1626B0D48D5B956767274C4CBCA9E08F94FBD209DFCD4E5A7660080C60828302C142F562515044EF21CB5B54C0E0C60AF1AC110484A405A1F2BB60FA759F6D118B012245ACA83699AA2280AC732C408A3BCC61858F6D581443B43402E0590BD76956F3E624F43162BE8835078A9DDE34D9F85B6B2B9935FFBFDE9698073D414BE0FF9BA77DDA2F8448EB6ACAE0D8C35C8D20CBB67CE80E196857A132209BE7FAF709856FFBEE4FE3AEA9C74B3041936B636AFBEF4E24BBFBB5C5577D00EF9E57B51FC3933160087909FD9D64A2775626ABB7F78C496C9120CBA90FFED213F550300348422CE0880579501EA0ABD5E0FB5AF8513C834F1B618029712E834797E3C1EEBBAAA9E6080A4761D0356E2B5B5D6287A05B2220FA5396B5CAFBEF1E543A59523C454D44405D6C2D40652080CC606B1E7964FD47E4EE3ABD7641DABE3F62FE30A45F3B4F8C99E7049C27E5FAD90E61B6B2DAABA0E6DD1A3D126B677B6319FB9C9C3967287538FCA9468529378FE41F27FAD35B2A287FE46FFE5EF7FEFC5DFAB2A731F0F44FAD92BBF0D401F982BCB5CA7496279B9B087D33903CA6ADFCEDB85FC6F0F7913F7F5D64A334508009A14591A6F8EC868ED8845401A8A34010980CC370E15EE8BFABB5BA327FABDE27F9D4DE71FD5E216A3BC391EC1951B1870CC360BCF4A8CC868B8B5588EF0C2B26D482CA28BD284FC6DB0EF94E4E087BB90EB0140741CF2550FACBD8B786AF1F892C61863C16064698AADED6D28AD707C747C72B7E0696F1F631FDEB0A828EF4FD30C5951202DF2675F7EF1A53FB37C62B576C4D16717442A84FC4058B669B244DBC5646217651D427EA0F3FA6F27F9991900A0310232440458B5D92B28E9F7A9344611B3564A69B8C82443AB85987A5AD1E64367CFFC368CF91F56AB72A4D4C9AE39C9EBA54A907AEAADBAAAB05C2EFD886E3381479E2A5B79525137E2CBA1E7E0D4B1DBF8FDD67C77FBC9F8A133055E7B8252E4F5530582555993ED8C9CDBF4D31F0CB05C2EDD921039A738A538CDEBAF7D1F3CBFD648D30CFDE11035DB672E5F7AE573387D0F5FDCD6EBC83939E4FB8EA30F6C0F0F8FD830D98EB0E3ED2B3FF5142016A1636E7001E2556D51AE16181605ACD26E100C0210926D1A87C832C31E4F67976B6B3E3F1A8F888D79949913F1668262039EAE9A1CB5575DD78E2824CF91E76EF1A5107486AFD0C92746C12D0E716F1DE7E7EB9ADC78FFD370C0F54CE04186A009C5296C1B964A85F16BD42C5B68ADB1B1B981F1D61800309D4C3C3D794419FA00AC2106FE9ACEBEB6E7DF1C8F79BE5CFCC96BAFBEFE0C4E25EA9495DB2CBCFC4EF93D4F9F4A1293989AF78F8E2DFB5EFEF7EADAAD7782FC4C238058D6A201022C8D067DD24541656D94226810A50478AA31550028986D4EA4FA007A9BC3FE23E3D1C6BF5CCE97BF49387D7C5636F3D4C6ED21508A409E1557D67E2DFD608C4406A111889AAE40F1A4BE4AE8E5E4770F4C064EC304A8F1C2EBE3B86298C0800523510AC3CD4DF4FA3D98BAC66C3AF3C352680EBA0626C6118C9807699A12C597B98824CD30DADA5ADDB977F7FFB97BF7FE8B38E9F125D78FE6F7A96470498CDAB0ADD324B176B9B447B3B9C36F60B943F9DFDEF2733300226DAE414545AA547F73934A63483112284AC408C0610305330A2214007A00F5B6B7469F1C14F9BF5A2DCB4F6822700B786B9671084620E5BE40934D0DF77F59969EE6CBB4DA80D7C366A03136BCEEEA4F4505DBAF8D1F1309E7E9BF27109234C16038405E14A85625169E58151EBF885F1BBE5F3F8D08488C197D042749B31C5B7B3BF75E7FFDCABF9B4C66577142F15B649D2B97EF53C960D9BD67B244DBE5746AE7AB8A01B65DBEFFCE909FBB01001A232063C58AACDA1A8FA90229B64691529A1A039021108D500170300467F7767E35D3FA5F9565F57EBD860FC8F49DF5DD83D24E0CA0B5B8432B85244B51AE5CAF80AD6BCFF8634FF4E54B6BAE38E178AE3E96D0D9E745B806A3C242F85E29429665BEC7210BEDD0555545ACC568DE1791218AFF91A8027272088D4FA47500FED2BC87CDADCD972F5DBAFCFB6559DFC309F28E30C527C41D617E5FEAFB99227B7478C4B54597EFBFC3E46D610044229621022C6D6F6E904952654DAD15290D82863704380112BA5163ADD4E0EC99BD7FA4817F5696D59E968D4192E33302C017CF14483950943784C85A83C130B5AB544A4931DE72DB28B82FDD0181023C8CFE46E22275A78CB2AA3BCD32A47916D4BAAA5C579FF55C03F1E24D79AF5097583774A794F9C42008BE9024297A8321D222FBE2A58B9704E95F27F188D66DD392D9C623BCB5D289D13EDFEF66F7DF99F2B63200409B6F10B06AD4EF91EAF554551BA50047414E4810A505680C81540C8A34D55B67F676FF3119FE9DAAAA465A370C404CE4B6FA1A131683843260880A5C2540448C81B4C90A53701DB1FE849C9BD9D5E7A9F1FCAEB3CEF104244ABB555D3E14AF3CFE60EA3A1C2F282DA26EC038BA90597E3F10B56E6462A58FBF9452C8B21CA3EDED72329DFEC1B5EB37BE8136479F5FBC6917446A9DA5B76247D45927496211117768982EDF7F07CADBCE00002771813C2135DCDC7429818F0698203D0371DF4064049003D4CBF374F7CCEECE6F93B1BF5D56F5C095D7C8B7F0DAF65091370288BD7BE4E5C304625C4A0B6544A7D089A7190FDB883D75B6F55462A2E0C63A0052DA8845C91BD00E90EEBF166C2046A0054C9ED43941FAE373D55A23EBF5B17B66F7E6EBAF5FF9BF8F8FA75770929ADB7B7D5AF8A51C6EFF1EE0F27D82C97457DF7FB7C8DBD20000271B874096B686434296A9AA368AC05AB99A5F020AD1807010061E42FF95F77BC543BBBBBBFF314CFDDBD5AACA25229094D9421682FA15DD6B3881CB1EDC3E7B44617E4CE6D9CAC5E5456BB24E5EDAFEA54F00D6D38A071516E2D466FD3891C7073CFDF960888DADF1D72EBE7CF18FABDA1CE0043DB76BEC8153FA86B5C795F81C6B0F608F8E8F3C575F97EFBFD3E52D31001F7AF431BAFCCA4B6FF90D2046C0A5040A00549E281A6E6C504D4A19532B0552A42801023E20CB49426AA0880ACB9C01D41BF47BE777B6B77E4B13FEC17259EE69F2E54334DD8456483FADF5B80060590C4183D4FB07C2E3EB1268BED1A0F22740428AEAF7271A8FE2BCFFE4F511E3C56B6D44C2DE2B862049526CEDEE2C668BC5EF5FBF7EF3593414DD0B80679EA34F083BC4EB87909FD91A9524465795DD3F9E709CEF778AFFCE96B7A411E8E34F3C456F5C79F5AD38544B4E360E311B4B582C1748D9725E146C41CCD65A0231132CB99718F922A29A819A4036D18AEBAA3A3E3C3EFEDE6CB178663018DCEAF58B874C6546CC8052DA77DF514B81009C1C9C01B5CC6708B54FFB1F4D25E04449515E1FFF1FC84B9A5A41E811206A52063124FE018717C4B9BF429AE7D839B3FBE2B5EBD7FFAFFBFB872F0298C02DDFF45F34238234F5C406C0B1F6901BE1AD9B115E68D84EF9DF25F2B64D014E93756C00C4341EF449E5B9AA8C25B0756901B5A281D35283F0A5951A6C6F8D9FDC1C6DFE135356BFB85A95892229F7B9B5E22DA0309A39100969820B15DA27ED3D7E200B8D2386A83E2FCA1C9707E3C6A0753951E244638488083ACDB0B5B3BDA88CF9E36B57AF7DC97258CEE1EBF910855FC21175CA02CE0ACCB5B56C94762DBD1D3DF7BB577E2606606F7B8FEEEEDF7D4B6E9893690191D644E3E1806C92A8DA5805B66A0D284C892861E6D4570B523803D03208C341FFC2F6F6F67F986AF59BABC5EABC03FC9AAE3C375D68212BC7ADB56E5BB0F7E8362A23B6528408B88BCB8271A7DEFAF788A203395E1B6B70A62236040EF8730B56B776B7BF75EDDAF53F9CCD97B7109879B8B58C034EF143B80F46C5606319759A688BB2B4079329038AA96BE97D57CA3B2A0288E5E46011539628351C0CC1895695B18A9A8820600444940048BD31C89839F346C14708946B4DFDADD1F8B18DCDE16FC0D84FAF56E5A653ECA662C0820FA041FC81A6E1685D43D877FB88570773DB38002713FD539A8ADCB110DE2BF022FA707F6B77FBCA6432FBEC9DBBF79E47D8C917C27BA1E56EF27C37C45393A7E706299B6965E70EE56700B6A3E77EF7CA3BD60088AC75110260EA65A9EA0FFA64942263AC22B02640315142CE10486A20FF67D4AC3213439001C8F22C196F6F6DFF527F50FC7ABDAA9FACAA3A019B7654606D08FD035808F8E840016C5B9A732AE0C71C3AFC6279105558FCB84E526CEF6EDFAF2DFFD9F5EB37BEE2C37D47C915C27C5A02BC8A94BF02A302A102B331CC75922456D7B5BD7F7CCCE06EEDF67B41DEF10640E444D9104CFD22A35EAF475629AA8D5160684550406826D20012224A993995EF014864E08D823306C341EFDCD678EBD34591FEFDE56CF97055D5CAD8F656A110019CE8FE5BFBB9F9C5893102B47EF6DD8B40B381C81B96344D31DEDEBA5519F3EFEFDCBDFBB5AA32C74EE9698510E607856F6FE2012AF2DB7741CAA65AD96A3EB793C58A01B21A26DC1C9DF2BF7BE55D630080C60800B121B034CC73CAFB3D324A51ED7A089422D24CA4A28860DD18B40C82370229804C11F27EBF7776341A7D3CCFD2A76C557F64B92A77ABAA6AF808AC899A799CAC0380FE07005ED98942F72121C20AACF5BF732DCAFD41AF1C6C6C7C6F3A9D7DFEFEC1C1F78CE139D6941D8DD2CBC65DA9E9D7006AE1E54F126D555DDB83E30933137740DF7B4BDE550640A46D087CC5004CFD3CA55EBF0FAB54000B09A4FC8E6BBD660CC400C46DC7D11749BF41AAB5EA6F0C87EFDB180E1ED389FA982DEB0F2D97ABEDBAAE95A31937ADF4BE490FD653000A60A0D2DA4F1912D22441AFDF9BE834B95455F5B70F0E0FBF335FACEEC02974097089A676DFFA9E992BFFBCDA77F35906D7A4B44D89EC62366537C147DDF6DDF7A0BC2B0D8048BB620038BD6695670906454194A6AA629035212A500F880ABC41A00460011113222538428C29245A51D1EFF776FBFDFEC345913FAA957A18E03D5B99515DD77D634C665D293D5405942268AD6D9265CB244DA64AA90310DD5C2E96AF4E26D357A6F3D9EDAA3213780F8E46F9FDFFA898B924A2D0BD07A066E68A0123E13E13D94C6B6B974B7B389F77B9FE7B5CDED50640E494D400001329A2CD5E41495E902150ED68C988409A88A49F4003702DC7083FA708C64179A34049F49C64EDF91A804AB4CAD334E96BAD73ADB594262D3BBE54186BABAAAA9775552D2DA3F214E9D2D4248A6F001603E0F279EFE589A866E6D840D4000C5BB6B2795719638FA653D47E01A786ED72FDF7B0BC270C402CEDAA81EB2390F4A0287A40A255EDA20222B026528A0005B7264F03505E7135FC7422332770E4C75EE93901487E1F5EB7F6B5DE040878AC0FAEBAC9DE00C49D8D4EA1D98A92D7708A6F22C577CF6318CBD632C82489B69A99E7D329BBD29EA3E6EEEAFA9DBCE70C80C803D2038226DACC734AF39CAC52642C93B596FCF0114194393208682BBA6666FF339DA6F8A2FC6F66008211006099D9006C899401D8B89F1B83107FB988820D13D9443BC55FCDE63C5DAD18E8C2FD4EDAF29E350022717AE09A8A9AA8204D350D8B022A4DC9120563A0BC01F0BD05446B1E9EDC76130D80DCF7EE31B8F7126202611C855B4AAAE47F3F9764D92F4931446499655F02D9C800B8E8806199D932D882944DB46265AD5DCCE798AF4AAFF80DBA0F74CADF8993F7BC0188E5245620C6C05296A534C8F3600C2C3B6300762C5B045220902FF069345EBEE5F529F0863DF0DA0703807634605BDF07A5078360B5D256111855C5B3E5122B1FEA03169DE277F220E90CC003E4648AD0440649A2A9EFE9C5A194B2000C43B135800311951B16744601E13A87280044444DFFBF6FE975510037A3484D4AC08E63CC4AAB119162AD94550490B576B558605A960C0B068811ADDF023AC5EFE474E90CC00F90382A38C518008A284F53EAE599A311D79ADC6C32C0CCC46CC9BAB04009576774F8F64CB14CF873F8C92B3B9840AC9462450031331BC3CBB2C462557AE340EC12180EB57CA053FC4EDE5C3A03F023CA49CC20A4F5C12068AD906B4D599A42270984DA8765DACFBF5E4680E21F4FA083BEBFD8D435CAAAC2B2366C6BE39FDF297D273F997406E0279064EDFA49A21E70BEC0350440818814B456D04A91F29C7DCDF03FC0D6D1961B6B5C73803172C0282D705981800C229DD277F2E3486700DE6239CD2848227F7AE5EF440A107DEF7E161431964EE13B792BA433003F0359370A3F8E740ADF49279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74D249279D74F2B392FF1F0705C457A02DC2080000000049454E44AE426082');
INSERT INTO "product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


-- ----------------------------
-- Table structure for purchase
-- ----------------------------
DROP TABLE IF EXISTS "purchase";
CREATE TABLE "purchase" (
"id_purchase"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"datepurchase"  datetime,
"total"  double,
"id_status"  integer,
"id_supplier"  integer,
FOREIGN KEY ("id_supplier") REFERENCES "supplier" ("id_supplier"),
FOREIGN KEY ("id_status") REFERENCES "status" ("id_status")
)

;

-- ----------------------------
-- Records of purchase
-- ----------------------------
INSERT INTO "purchase" VALUES (1, '2019-09-26 22:19:07', 0.0, 1, 3);
INSERT INTO "purchase" VALUES (2, '2019-09-26 22:21:30', 0.0, 1, 3);
INSERT INTO "purchase" VALUES (3, '2019-09-26 22:22:41', 0.0, 1, 3);
INSERT INTO "purchase" VALUES (4, '2019-09-26 22:29:26', 900.00, 1, 3);
INSERT INTO "purchase" VALUES (5, '2019-09-26 22:30:23', 8750.00, 1, 3);
INSERT INTO "purchase" VALUES (6, '2019-09-27 07:28:05', 7500.00, 1, 3);
INSERT INTO "purchase" VALUES (7, '2019-09-27 07:29:01', 17875.00, 1, 3);
INSERT INTO "purchase" VALUES (8, '2019-09-29 10:59:03', 1875.00, 1, 3);
INSERT INTO "purchase" VALUES (9, '2019-09-30 08:29:57', 300.00, 1, 3);
INSERT INTO "purchase" VALUES (10, '2019-09-30 10:47:55', 90.00, 1, 3);
INSERT INTO "purchase" VALUES (11, '2019-09-30 18:02:44', 100.00, 1, 3);
INSERT INTO "purchase" VALUES (12, '2019-09-30 18:07:19', 475.00, 1, 3);


-- ----------------------------
-- Table structure for purchase_detail
-- ----------------------------
DROP TABLE IF EXISTS "purchase_detail";
CREATE TABLE "purchase_detail" (
"id_purchase_detail"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"id_purchase"  integer,
"unit_cost"  double,
"quantity"  integer,
"id_product"  integer,
FOREIGN KEY ("id_purchase") REFERENCES "purchase" ("id_purchase"),
FOREIGN KEY ("id_product") REFERENCES "product" ("id_product")
)

;

-- ----------------------------
-- Records of purchase_detail
-- ----------------------------

INSERT INTO "purchase_detail" VALUES (3, 4, 90.0, 10, 1);
INSERT INTO "purchase_detail" VALUES (4, 5, 175.0, 50, 5);
INSERT INTO "purchase_detail" VALUES (5, 6, 750.0, 10, 2);
INSERT INTO "purchase_detail" VALUES (6, 7, 750.0, 20, 5);
INSERT INTO "purchase_detail" VALUES (7, 7, 100.0, 10, 4);
INSERT INTO "purchase_detail" VALUES (8, 7, 125.0, 15, 5);
INSERT INTO "purchase_detail" VALUES (9, 8, 75.0, 25, 4);
INSERT INTO "purchase_detail" VALUES (10, 9, 150.0, 2, 8);
INSERT INTO "purchase_detail" VALUES (12, 10, 90.0, 1, 4);
INSERT INTO "purchase_detail" VALUES (13, 11, 50.0, 2, 4);
INSERT INTO "purchase_detail" VALUES (14, 12, 95.0, 5, 1);


-- ----------------------------
-- Table structure for sales
-- ----------------------------
DROP TABLE IF EXISTS "sales";
CREATE TABLE "sales" (
"id_sales"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"sales_price"  double,
"sales_discount"  double,
"total"  double,
"datesales"  datetime,
"id_status"  integer,
FOREIGN KEY ("id_status") REFERENCES "status" ("id_status")
)

;

-- ----------------------------
-- Records of sales
-- ----------------------------

INSERT INTO "sales" VALUES (1, 0.0, 0.0, 0.0, '2019-09-19 22:01:13', 3);
INSERT INTO "sales" VALUES (2, 0.0, 0.0, 0.0, '2019-09-19 22:38:38', 3);
INSERT INTO "sales" VALUES (3, 0.0, 0.0, 0.0, '2019-09-19 22:38:38', 3);
INSERT INTO "sales" VALUES (4, 0.0, 0.0, 0.0, '2019-09-19 22:41:29', 3);
INSERT INTO "sales" VALUES (5, 0.0, 0.0, 0.0, '2019-09-19 22:41:29', 3);
INSERT INTO "sales" VALUES (6, 0.0, 0.0, 0.0, '2019-09-19 22:42:56', 3);
INSERT INTO "sales" VALUES (7, 0.0, 0.0, 0.0, '2019-09-19 22:42:56', 3);
INSERT INTO "sales" VALUES (8, 0.0, 0.0, 0.0, '2019-09-19 22:55:21', 3);
INSERT INTO "sales" VALUES (9, 0.0, 0.0, 0.0, '2019-09-19 23:01:10', 3);
INSERT INTO "sales" VALUES (10, 0.0, 0.0, 0.0, '2019-09-19 23:01:10', 3);
INSERT INTO "sales" VALUES (11, 0.0, 0.0, 0.0, '2019-09-19 23:15:45', 3);
INSERT INTO "sales" VALUES (12, 0.0, 0.0, 0.0, '2019-09-19 23:24:45', 3);
INSERT INTO "sales" VALUES (13, 0.0, 0.0, 0.0, '2019-09-19 23:24:45', 3);
INSERT INTO "sales" VALUES (14, 0.0, 0.0, 0.0, '2019-09-19 23:26:16', 3);
INSERT INTO "sales" VALUES (15, 0.0, 0.0, 0.0, '2019-09-19 23:27:35', 3);
INSERT INTO "sales" VALUES (16, 0.0, 0.0, 0.0, '2019-09-19 23:55:04', 3);
INSERT INTO "sales" VALUES (17, 0.0, 0.0, 0.0, '2019-09-20 00:13:22', 3);
INSERT INTO "sales" VALUES (18, 0.0, 0.0, 0.0, '2019-09-20 00:34:29', 3);
INSERT INTO "sales" VALUES (19, 0.0, 0.0, 0.0, '2019-09-20 00:34:29', 3);
INSERT INTO "sales" VALUES (20, 0.0, 0.0, 0.0, '2019-09-20 00:47:15', 3);
INSERT INTO "sales" VALUES (21, 0.0, 0.0, 0.0, '2019-09-20 00:47:15', 3);
INSERT INTO "sales" VALUES (22, 0.0, 0.0, 0.0, '2019-09-20 00:47:15', 3);
INSERT INTO "sales" VALUES (23, 0.0, 0.0, 0.0, '2019-09-20 00:47:15', 3);
INSERT INTO "sales" VALUES (24, 0.0, 0.0, 0.0, '2019-09-21 09:38:39', 3);
INSERT INTO "sales" VALUES (25, 0.0, 0.0, 0.0, '2019-09-21 09:44:21', 3);
INSERT INTO "sales" VALUES (26, 0.0, 0.0, 0.0, '2019-09-21 09:48:25', 3);
INSERT INTO "sales" VALUES (27, 0.0, 0.0, 0.0, '2019-09-21 09:48:25', 3);
INSERT INTO "sales" VALUES (28, 0.0, 0.0, 0.0, '2019-09-21 09:48:25', 3);
INSERT INTO "sales" VALUES (29, 0.0, 0.0, 0.0, '2019-09-21 09:48:25', 3);
INSERT INTO "sales" VALUES (30, 0.0, 0.0, 0.0, '2019-09-21 09:48:25', 3);
INSERT INTO "sales" VALUES (31, 0.0, 0.0, 0.0, '2019-09-21 09:48:25', 3);
INSERT INTO "sales" VALUES (32, 0.0, 0.0, 0.0, '2019-09-21 09:48:25', 3);
INSERT INTO "sales" VALUES (33, 0.0, 0.0, 0.0, '2019-09-21 09:48:25', 3);
INSERT INTO "sales" VALUES (34, 0.0, 0.0, 0.0, '2019-09-21 09:51:30', 3);
INSERT INTO "sales" VALUES (35, 0.0, 0.0, 0.0, '2019-09-21 09:56:47', 3);
INSERT INTO "sales" VALUES (36, 0.0, 0.0, 0.0, '2019-09-21 10:06:17', 3);
INSERT INTO "sales" VALUES (37, 0.0, 0.0, 0.0, '2019-09-21 10:08:31', 3);
INSERT INTO "sales" VALUES (38, 0.0, 0.0, 0.0, '2019-09-21 10:11:40', 3);
INSERT INTO "sales" VALUES (39, 0.0, 0.0, 0.0, '2019-09-21 10:11:40', 3);
INSERT INTO "sales" VALUES (40, 0.0, 0.0, 0.0, '2019-09-21 10:26:42', 3);
INSERT INTO "sales" VALUES (41, 0.0, 0.0, 0.0, '2019-09-21 10:28:38', 3);
INSERT INTO "sales" VALUES (42, 0.0, 0.0, 0.0, '2019-09-21 18:04:37', 3);
INSERT INTO "sales" VALUES (43, 0.0, 0.0, 0.0, '2019-09-23 11:05:26', 3);
INSERT INTO "sales" VALUES (44, 0.0, 0.0, 0.0, '2019-09-23 11:09:29', 3);
INSERT INTO "sales" VALUES (45, 0.0, 0.0, 0.0, '2019-09-23 15:59:47', 3);
INSERT INTO "sales" VALUES (46, 0.0, 0.0, 0.0, '2019-09-23 16:01:46', 3);
INSERT INTO "sales" VALUES (47, 0.0, 0.0, 0.0, '2019-09-23 16:16:33', 3);
INSERT INTO "sales" VALUES (48, 0.0, 0.0, 0.0, '2019-09-23 20:16:57', 3);
INSERT INTO "sales" VALUES (49, 0.0, 0.0, 0.0, '2019-09-23 23:25:31', 3);
INSERT INTO "sales" VALUES (50, 0.0, 0.0, 0.0, '2019-09-23 23:29:33', 3);
INSERT INTO "sales" VALUES (51, 0.0, 0.0, 0.0, '2019-09-23 20:39:15', 3);
INSERT INTO "sales" VALUES (52, 0.0, 0.0, 0.0, '2019-09-23 22:32:52', 3);
INSERT INTO "sales" VALUES (53, 0.0, 0.0, 0.0, '2019-09-24 15:28:52', 3);
INSERT INTO "sales" VALUES (54, 0.0, 0.0, 0.0, '2019-09-26 15:28:48', 3);
INSERT INTO "sales" VALUES (55, 0.0, 0.0, 0.0, '2019-09-26 16:04:27', 3);
INSERT INTO "sales" VALUES (56, 0.0, 0.0, 0.0, '2019-09-26 16:04:43', 3);
INSERT INTO "sales" VALUES (57, 0.0, 0.0, 0.0, '2019-09-26 16:07:15', 3);
INSERT INTO "sales" VALUES (58, 0.0, 0.0, 0.0, '2019-09-26 16:09:45', 3);
INSERT INTO "sales" VALUES (59, 0.0, 0.0, 0.0, '2019-09-26 16:10:11', 3);
INSERT INTO "sales" VALUES (60, 0.0, 0.0, 0.0, '2019-09-26 16:11:45', 2);
INSERT INTO "sales" VALUES (61, 0.0, 0.0, 0.0, '0001-01-01 00:00:00', 3);
INSERT INTO "sales" VALUES (62, 0.0, 0.0, 0.0, '0001-01-01 00:00:00', 3);
INSERT INTO "sales" VALUES (63, 0.0, 0.0, 0.0, '0001-01-01 00:00:00', 3);
INSERT INTO "sales" VALUES (64, 0.0, 0.0, 0.0, '0001-01-01 00:00:00', 3);
INSERT INTO "sales" VALUES (65, 0.0, 0.0, 0.0, '2019-09-26 20:03:56', 3);
INSERT INTO "sales" VALUES (66, 0.0, 0.0, 0.0, '2019-09-26 20:05:15', 3);
INSERT INTO "sales" VALUES (68, 0.0, 0.0, 0.0, '2019-09-26 20:13:42', 3);
INSERT INTO "sales" VALUES (69, 0.0, 0.0, 0.0, '2019-09-26 20:14:42', 3);
INSERT INTO "sales" VALUES (70, 0.0, 0.0, 0.0, '2019-09-26 20:16:24', 3);
INSERT INTO "sales" VALUES (71, 0.0, 0.0, 0.0, '2019-09-26 20:28:12', 3);
INSERT INTO "sales" VALUES (72, 0.0, 0.0, 0.0, '2019-09-26 20:30:07', 3);
INSERT INTO "sales" VALUES (73, 0.0, 0.0, 0.0, '2019-09-26 20:36:45', 3);
INSERT INTO "sales" VALUES (74, 0.0, 0.0, 0.0, '2019-09-26 23:03:05', 3);
INSERT INTO "sales" VALUES (75, 0.0, 0.0, 0.0, '2019-09-26 23:07:29', 3);
INSERT INTO "sales" VALUES (76, 0.0, 0.0, 0.0, '2019-09-26 23:09:52', 3);
INSERT INTO "sales" VALUES (77, 0.0, 0.0, 0.0, '2019-09-26 23:20:02', 3);
INSERT INTO "sales" VALUES (78, 0.0, 0.0, 0.0, '2019-09-26 23:21:51', 3);
INSERT INTO "sales" VALUES (79, 0.0, 0.0, 0.0, '2019-09-26 23:34:09', 3);
INSERT INTO "sales" VALUES (80, 0.0, 0.0, 0.0, '2019-09-26 23:34:23', 3);
INSERT INTO "sales" VALUES (81, 0.0, 0.0, 0.0, '2019-09-26 23:35:33', 3);
INSERT INTO "sales" VALUES (82, 0.0, 0.0, 0.0, '2019-09-26 23:37:48', 3);
INSERT INTO "sales" VALUES (83, 0.0, 0.0, 0.0, '2019-09-26 23:39:23', 3);
INSERT INTO "sales" VALUES (84, 0.0, 0.0, 0.0, '2019-09-26 23:40:29', 3);
INSERT INTO "sales" VALUES (85, 0.0, 0.0, 0.0, '2019-09-26 23:41:42', 3);
INSERT INTO "sales" VALUES (86, 0.0, 0.0, 0.0, '2019-09-26 23:43:06', 3);
INSERT INTO "sales" VALUES (87, 0.0, 0.0, 0.0, '2019-09-26 23:46:07', 3);
INSERT INTO "sales" VALUES (88, 0.0, 0.0, 0.0, '2019-09-26 23:47:35', 3);
INSERT INTO "sales" VALUES (89, 0.0, 0.0, 0.0, '2019-09-26 23:50:17', 3);
INSERT INTO "sales" VALUES (90, 0.0, 0.0, 0.0, '2019-09-26 23:50:49', 3);
INSERT INTO "sales" VALUES (91, 0.0, 0.0, 0.0, '2019-09-27 00:59:24', 3);
INSERT INTO "sales" VALUES (92, 0.0, 0.0, 0.0, '2019-09-27 01:00:00', 3);
INSERT INTO "sales" VALUES (93, 0.0, 0.0, 0.0, '2019-09-27 01:06:17', 3);
INSERT INTO "sales" VALUES (94, 0.0, 0.0, 0.0, '2019-09-27 01:35:43', 3);
INSERT INTO "sales" VALUES (95, 0.0, 0.0, 0.0, '2019-09-27 09:28:19', 3);
INSERT INTO "sales" VALUES (96, 0.0, 0.0, 0.0, '2019-09-27 09:29:07', 3);
INSERT INTO "sales" VALUES (97, 0.0, 0.0, 0.0, '2019-09-27 09:30:30', 3);
INSERT INTO "sales" VALUES (98, 0.0, 0.0, 0.0, '2019-09-27 09:30:46', 3);
INSERT INTO "sales" VALUES (99, 0.0, 0.0, 0.0, '2019-09-27 10:21:38', 3);
INSERT INTO "sales" VALUES (100, 0.0, 0.0, 0.0, '2019-09-27 10:27:05', 3);
INSERT INTO "sales" VALUES (101, 0.0, 0.0, 0.0, '2019-09-27 10:44:23', 3);
INSERT INTO "sales" VALUES (102, 0.0, 0.0, 0.0, '2019-09-27 11:22:19', 3);
INSERT INTO "sales" VALUES (103, 0.0, 0.0, 0.0, '2019-09-28 16:12:47', 3);
INSERT INTO "sales" VALUES (104, 0.0, 0.0, 0.0, '2019-09-28 16:15:33', 3);
INSERT INTO "sales" VALUES (105, 0.0, 0.0, 0.0, '2019-09-28 16:18:03', 3);
INSERT INTO "sales" VALUES (106, 0.0, 0.0, 0.0, '2019-09-28 16:19:45', 3);
INSERT INTO "sales" VALUES (107, 0.0, 0.0, 0.0, '2019-09-29 13:59:29', 3);
INSERT INTO "sales" VALUES (108, 0.0, 0.0, 0.0, '2019-09-29 14:00:50', 3);
INSERT INTO "sales" VALUES (109, 0.0, 0.0, 0.0, '2019-09-29 14:58:20', 3);
INSERT INTO "sales" VALUES (110, 0.0, 0.0, 0.0, '2019-09-29 15:00:58', 3);
INSERT INTO "sales" VALUES (111, 0.0, 0.0, 0.0, '2019-09-29 15:02:45', 3);
INSERT INTO "sales" VALUES (112, 0.0, 0.0, 0.0, '2019-09-29 15:03:52', 3);
INSERT INTO "sales" VALUES (113, 0.0, 0.0, 0.0, '2019-09-29 15:05:28', 3);
INSERT INTO "sales" VALUES (114, 0.0, 0.0, 0.0, '2019-09-29 15:11:57', 3);
INSERT INTO "sales" VALUES (115, 0.0, 0.0, 0.0, '2019-09-29 15:12:42', 3);
INSERT INTO "sales" VALUES (116, 0.0, 0.0, 0.0, '2019-09-29 15:14:22', 3);
INSERT INTO "sales" VALUES (117, 0.0, 0.0, 0.0, '2019-09-29 15:16:11', 3);
INSERT INTO "sales" VALUES (118, 0.0, 0.0, 0.0, '2019-09-29 15:17:01', 3);
INSERT INTO "sales" VALUES (119, 0.0, 0.0, 0.0, '2019-09-29 15:17:54', 3);
INSERT INTO "sales" VALUES (120, 0.0, 0.0, 0.0, '2019-09-29 15:19:59', 3);
INSERT INTO "sales" VALUES (121, 0.0, 0.0, 0.0, '2019-09-29 15:35:17', 3);
INSERT INTO "sales" VALUES (122, 0.0, 0.0, 0.0, '2019-09-29 15:44:14', 3);
INSERT INTO "sales" VALUES (123, 0.0, 0.0, 0.0, '2019-09-29 15:47:13', 3);
INSERT INTO "sales" VALUES (124, 0.0, 0.0, 0.0, '2019-09-29 15:48:39', 3);
INSERT INTO "sales" VALUES (125, 0.0, 0.0, 0.0, '2019-09-29 15:50:01', 3);
INSERT INTO "sales" VALUES (126, 0.0, 0.0, 0.0, '2019-09-29 15:54:50', 3);
INSERT INTO "sales" VALUES (127, 0.0, 0.0, 0.0, '2019-09-30 11:45:14', 3);
INSERT INTO "sales" VALUES (128, 0.0, 0.0, 0.0, '2019-09-30 11:45:56', 3);
INSERT INTO "sales" VALUES (129, 0.0, 0.0, 0.0, '2019-09-30 12:01:54', 3);
INSERT INTO "sales" VALUES (130, 0.0, 0.0, 0.0, '2019-09-30 12:25:21', 3);
INSERT INTO "sales" VALUES (131, 0.0, 0.0, 0.0, '2019-09-30 12:27:18', 3);
INSERT INTO "sales" VALUES (132, 0.0, 0.0, 0.0, '2019-09-30 12:31:27', 3);
INSERT INTO "sales" VALUES (133, 0.0, 0.0, 0.0, '2019-09-30 12:33:57', 3);
INSERT INTO "sales" VALUES (134, 0.0, 0.0, 0.0, '2019-09-30 13:49:41', 3);
INSERT INTO "sales" VALUES (135, 1130.0, 0.0, 1130.0, '2019-09-30 21:12:22', 3);
INSERT INTO "sales" VALUES (140, 550.0, 0.0, 550.0, '2020-05-20 14:22:56', 3);
INSERT INTO "sales" VALUES (141, 950.0, 0.0, 950.0, '2020-05-22 09:10:37', 3);
INSERT INTO "sales" VALUES (142, 1150.0, 0.0, 1150.0, '2020-05-22 11:08:04', 3);
INSERT INTO "sales" VALUES (143, 330.0, 0.0, 330.0, '2020-05-22 11:17:35', 3);
INSERT INTO "sales" VALUES (144, 2050.0, 0.0, 2050.0, '2020-05-22 11:24:56', 3);
INSERT INTO "sales" VALUES (145, 2850.0, 0.0, 2850.0, '2020-05-25 09:56:14', 3);


-- ----------------------------
-- Table structure for sales_detail
-- ----------------------------
DROP TABLE IF EXISTS "sales_detail";
CREATE TABLE "sales_detail" (
"id_sales_detail"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"id_sales"  integer,
"unit_cost"  double,
"unit_value"  double,
"quantity"  integer,
"discount"  double DEFAULT 0.00,
"item_total"  double DEFAULT 0.00,
"id_product"  integer,
FOREIGN KEY ("id_sales") REFERENCES "sales" ("id_sales"),
FOREIGN KEY ("id_product") REFERENCES "product" ("id_product")
)

;

-- ----------------------------
-- Records of sales_detail
-- ----------------------------

INSERT INTO "sales_detail" VALUES (1, 7, 75.0, 125.0, 12, 0.0, 1500.0, 4);
INSERT INTO "sales_detail" VALUES (2, 7, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (3, 7, 800.0, 950.0, 10, 0.0, 9500.0, 2);
INSERT INTO "sales_detail" VALUES (4, 7, 425.0, 550.0, 20, 0.0, 11000.0, 3);
INSERT INTO "sales_detail" VALUES (8, 7, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (9, 8, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (10, 8, 90.0, 125.0, 2, 0.0, 250.0, 1);
INSERT INTO "sales_detail" VALUES (15, 12, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (16, 14, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (17, 15, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (18, 15, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (19, 15, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (20, 15, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (21, 15, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (22, 15, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (23, 15, 90.0, 125.0, 2, 0.0, 250.0, 1);
INSERT INTO "sales_detail" VALUES (24, 15, 165.0, 205.0, 1, 0.0, 205.0, 7);
INSERT INTO "sales_detail" VALUES (25, 15, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (26, 15, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (27, 15, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (28, 16, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (29, 16, 165.0, 205.0, 1, 0.0, 205.0, 7);
INSERT INTO "sales_detail" VALUES (30, 16, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (31, 16, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (32, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (33, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (34, 17, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (35, 17, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (36, 17, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (37, 17, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (38, 17, 90.0, 125.0, 2, 0.0, 250.0, 1);
INSERT INTO "sales_detail" VALUES (39, 17, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (40, 17, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (41, 17, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (42, 17, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (43, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (44, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (45, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (46, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (47, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (48, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (49, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (50, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (51, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (52, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (53, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (54, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (55, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (56, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (57, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (58, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (59, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (60, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (61, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (62, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (63, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (64, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (65, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (66, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (67, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (68, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (69, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (70, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (71, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (72, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (73, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (74, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (75, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (76, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (77, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (78, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (79, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (80, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (81, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (82, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (83, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (84, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (85, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (86, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (87, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (88, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (89, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (90, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (91, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (92, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (93, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (94, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (95, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (96, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (97, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (98, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (99, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (100, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (101, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (102, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (103, 17, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (104, 17, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (105, 17, 90.0, 125.0, 2, 0.0, 250.0, 1);
INSERT INTO "sales_detail" VALUES (106, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (107, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (108, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (109, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (110, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (111, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (112, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (113, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (114, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (115, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (116, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (117, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (118, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (119, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (120, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (121, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (122, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (123, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (124, 17, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (125, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (126, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (127, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (128, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (129, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (130, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (131, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (132, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (133, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (134, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (135, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (136, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (137, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (138, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (139, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (140, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (141, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (142, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (143, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (144, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (145, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (146, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (147, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (148, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (149, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (150, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (151, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (152, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (153, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (154, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (155, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (156, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (157, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (158, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (159, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (160, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (161, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (162, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (163, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (164, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (165, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (166, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (167, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (168, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (169, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (170, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (171, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (172, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (173, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (174, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (175, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (176, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (177, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (178, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (179, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (180, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (181, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (182, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (183, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (184, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (185, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (186, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (187, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (188, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (189, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (190, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (191, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (192, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (193, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (194, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (195, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (196, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (197, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (198, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (199, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (200, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (201, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (202, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (203, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (204, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (205, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (206, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (207, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (208, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (209, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (210, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (211, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (212, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (213, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (214, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (215, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (216, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (217, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (218, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (219, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (220, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (221, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (222, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (223, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (224, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (225, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (226, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (227, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (228, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (229, 18, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (230, 19, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (231, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (232, 19, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (233, 19, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (234, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (235, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (236, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (237, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (238, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (239, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (240, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (241, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (242, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (243, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (244, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (245, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (246, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (247, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (248, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (249, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (250, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (251, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (252, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (253, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (254, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (255, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (256, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (257, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (258, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (259, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (260, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (261, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (262, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (263, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (264, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (265, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (266, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (267, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (268, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (269, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (270, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (271, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (272, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (273, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (274, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (275, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (276, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (277, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (278, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (279, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (280, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (281, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (282, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (283, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (284, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (285, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (286, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (287, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (288, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (289, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (290, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (291, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (292, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (293, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (294, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (295, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (296, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (297, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (298, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (299, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (300, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (301, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (302, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (303, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (304, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (305, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (306, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (307, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (308, 19, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (309, 20, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (310, 22, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (311, 22, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (312, 22, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (313, 23, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (314, 23, 200.0, 285.0, 1, 0.0, 285.0, 6);
INSERT INTO "sales_detail" VALUES (315, 23, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (316, 23, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (317, 23, 200.0, 285.0, 1, 0.0, 285.0, 6);
INSERT INTO "sales_detail" VALUES (318, 24, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (319, 24, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (320, 34, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (321, 34, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (322, 35, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (323, 36, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (324, 36, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (325, 36, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (326, 37, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (327, 37, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (328, 37, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (329, 38, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (330, 38, 75.0, 125.0, 10, 0.0, 1250.0, 5);
INSERT INTO "sales_detail" VALUES (331, 38, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (332, 39, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (333, 39, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (334, 39, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (335, 39, 90.0, 125.0, 2, 0.0, 250.0, 1);
INSERT INTO "sales_detail" VALUES (336, 39, 75.0, 125.0, 10, 0.0, 1250.0, 4);
INSERT INTO "sales_detail" VALUES (337, 40, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (338, 40, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (339, 40, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (341, 41, 75.0, 125.0, 12, 0.0, 1500.0, 4);
INSERT INTO "sales_detail" VALUES (342, 41, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (343, 41, 800.0, 950.0, 12, 0.0, 11400.0, 2);
INSERT INTO "sales_detail" VALUES (344, 42, 425.0, 550.0, 23, 0.0, 12650.0, 3);
INSERT INTO "sales_detail" VALUES (345, 42, 90.0, 125.0, 11, 0.0, 1375.0, 1);
INSERT INTO "sales_detail" VALUES (351, 42, 200.0, 285.0, 1, 0.0, 285.0, 6);
INSERT INTO "sales_detail" VALUES (361, 7, 165.0, 205.0, 2, 0.0, 410.0, 7);
INSERT INTO "sales_detail" VALUES (429, 6, 10.0, 15.0, 7, 0.0, 105.0, 2);
INSERT INTO "sales_detail" VALUES (431, 6, 10.0, 15.0, 7, 0.0, 105.0, 2);
INSERT INTO "sales_detail" VALUES (432, 6, 10.0, 15.0, 7, 0.0, 105.0, 2);
INSERT INTO "sales_detail" VALUES (433, 6, 10.0, 15.0, 7, 0.0, 105.0, 2);
INSERT INTO "sales_detail" VALUES (434, 6, 10.0, 15.0, 7, 0.0, 105.0, 2);
INSERT INTO "sales_detail" VALUES (435, 46, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (436, 47, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (437, 47, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (456, 10, 425.0, 550.0, 19, 0.0, 10450.0, 3);
INSERT INTO "sales_detail" VALUES (472, 10, 90.0, 125.0, 3, 0.0, 375.0, 1);
INSERT INTO "sales_detail" VALUES (477, 10, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (478, 10, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (479, 48, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (480, 48, 425.0, 550.0, 21, 0.0, 11550.0, 3);
INSERT INTO "sales_detail" VALUES (481, 48, 800.0, 950.0, 10, 0.0, 9500.0, 2);
INSERT INTO "sales_detail" VALUES (483, 48, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (484, 48, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (485, 49, 425.0, 550.0, 19, 0.0, 10450.0, 3);
INSERT INTO "sales_detail" VALUES (486, 50, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (487, 48, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (488, 51, 425.0, 550.0, 18, 0.0, 9900.0, 3);
INSERT INTO "sales_detail" VALUES (489, 51, 800.0, 950.0, 7, 0.0, 6650.0, 2);
INSERT INTO "sales_detail" VALUES (490, 51, 750.0, 1025.0, 24, 0.0, 24600.0, 8);
INSERT INTO "sales_detail" VALUES (501, 52, 425.0, 550.0, 16, 0.0, 8800.0, 3);
INSERT INTO "sales_detail" VALUES (502, 52, 75.0, 125.0, 7, 0.0, 875.0, 4);
INSERT INTO "sales_detail" VALUES (505, 52, 75.0, 125.0, 5, 0.0, 625.0, 5);
INSERT INTO "sales_detail" VALUES (506, 52, 200.0, 285.0, 1, 0.0, 285.0, 6);
INSERT INTO "sales_detail" VALUES (507, 53, 425.0, 550.0, 16, 0.0, 8800.0, 3);
INSERT INTO "sales_detail" VALUES (508, 53, 75.0, 125.0, 7, 0.0, 875.0, 4);
INSERT INTO "sales_detail" VALUES (509, 53, 800.0, 950.0, 8, 0.0, 7600.0, 2);
INSERT INTO "sales_detail" VALUES (510, 53, 75.0, 125.0, 3, 0.0, 375.0, 5);
INSERT INTO "sales_detail" VALUES (511, 53, 750.0, 1025.0, 7, 0.0, 7175.0, 8);
INSERT INTO "sales_detail" VALUES (512, 54, 75.0, 125.0, 8, 0.0, 1000.0, 4);
INSERT INTO "sales_detail" VALUES (513, 55, 425.0, 550.0, 16, 0.0, 8800.0, 3);
INSERT INTO "sales_detail" VALUES (514, 55, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (515, 55, 75.0, 125.0, 3, 0.0, 375.0, 5);
INSERT INTO "sales_detail" VALUES (516, 57, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (517, 57, 425.0, 550.0, 12, 0.0, 6600.0, 3);
INSERT INTO "sales_detail" VALUES (520, 60, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (521, 60, 75.0, 125.0, 3, 0.0, 375.0, 5);
INSERT INTO "sales_detail" VALUES (522, 60, 425.0, 550.0, 12, 0.0, 6600.0, 3);
INSERT INTO "sales_detail" VALUES (523, 60, 800.0, 950.0, 5, 0.0, 4750.0, 2);
INSERT INTO "sales_detail" VALUES (524, 63, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (525, 63, 425.0, 550.0, 12, 0.0, 6600.0, 3);
INSERT INTO "sales_detail" VALUES (526, 63, 75.0, 125.0, 3, 0.0, 375.0, 5);
INSERT INTO "sales_detail" VALUES (527, 64, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (528, 64, 75.0, 125.0, 2, 0.0, 250.0, 5);
INSERT INTO "sales_detail" VALUES (529, 64, 425.0, 550.0, 12, 0.0, 6600.0, 3);
INSERT INTO "sales_detail" VALUES (536, 69, 200.0, 285.0, 1, 0.0, 285.0, 6);
INSERT INTO "sales_detail" VALUES (537, 69, 165.0, 205.0, 1, 0.0, 205.0, 7);
INSERT INTO "sales_detail" VALUES (538, 69, 800.0, 950.0, 4, 0.0, 3800.0, 2);
INSERT INTO "sales_detail" VALUES (539, 69, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (540, 69, 750.0, 1025.0, 1, 0.0, 1025.0, 8);
INSERT INTO "sales_detail" VALUES (541, 71, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (542, 71, 425.0, 550.0, 12, 0.0, 6600.0, 3);
INSERT INTO "sales_detail" VALUES (544, 74, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (547, 74, 75.0, 125.0, 2, 0.0, 250.0, 5);
INSERT INTO "sales_detail" VALUES (548, 75, 90.0, 125.0, 2, 0.0, 250.0, 1);
INSERT INTO "sales_detail" VALUES (549, 75, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (551, 76, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (554, 77, 425.0, 550.0, 9, 0.0, 4950.0, 3);
INSERT INTO "sales_detail" VALUES (555, 77, 800.0, 950.0, 2, 0.0, 1900.0, 2);
INSERT INTO "sales_detail" VALUES (556, 78, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (557, 78, 425.0, 550.0, 9, 0.0, 4950.0, 3);
INSERT INTO "sales_detail" VALUES (558, 80, 35.0, 50.0, 3, 0.0, 150.0, 10);
INSERT INTO "sales_detail" VALUES (559, 80, 75.0, 125.0, 2, 0.0, 250.0, 5);
INSERT INTO "sales_detail" VALUES (560, 80, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (561, 81, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (562, 81, 35.0, 50.0, 3, 0.0, 150.0, 10);
INSERT INTO "sales_detail" VALUES (563, 81, 75.0, 125.0, 2, 0.0, 250.0, 5);
INSERT INTO "sales_detail" VALUES (564, 82, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (565, 82, 425.0, 550.0, 9, 0.0, 4950.0, 3);
INSERT INTO "sales_detail" VALUES (566, 82, 750.0, 1025.0, 1, 0.0, 1025.0, 8);
INSERT INTO "sales_detail" VALUES (567, 83, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (568, 83, 425.0, 550.0, 9, 0.0, 4950.0, 3);
INSERT INTO "sales_detail" VALUES (569, 84, 425.0, 550.0, 9, 0.0, 4950.0, 3);
INSERT INTO "sales_detail" VALUES (570, 84, 800.0, 950.0, 2, 0.0, 1900.0, 2);
INSERT INTO "sales_detail" VALUES (571, 85, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (572, 86, 425.0, 550.0, 9, 0.0, 4950.0, 3);
INSERT INTO "sales_detail" VALUES (573, 86, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (574, 87, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (575, 87, 425.0, 550.0, 9, 0.0, 4950.0, 3);
INSERT INTO "sales_detail" VALUES (576, 88, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (577, 89, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (578, 90, 425.0, 550.0, 9, 0.0, 4950.0, 3);
INSERT INTO "sales_detail" VALUES (579, 90, 800.0, 950.0, 2, 0.0, 1900.0, 2);
INSERT INTO "sales_detail" VALUES (580, 91, 425.0, 550.0, 9, 0.0, 4950.0, 3);
INSERT INTO "sales_detail" VALUES (581, 93, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (583, 94, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (584, 94, 425.0, 550.0, 9, 0.0, 4950.0, 3);
INSERT INTO "sales_detail" VALUES (585, 94, 35.0, 50.0, 3, 0.0, 150.0, 10);
INSERT INTO "sales_detail" VALUES (586, 95, 750.0, 1025.0, 1, 0.0, 1025.0, 8);
INSERT INTO "sales_detail" VALUES (587, 95, 800.0, 950.0, 2, 0.0, 1900.0, 2);
INSERT INTO "sales_detail" VALUES (588, 95, 35.0, 50.0, 3, 0.0, 150.0, 10);
INSERT INTO "sales_detail" VALUES (589, 99, 200.0, 285.0, 1, 0.0, 285.0, 6);
INSERT INTO "sales_detail" VALUES (591, 99, 75.0, 125.0, 1, 0.0, 125.0, 5);
INSERT INTO "sales_detail" VALUES (592, 99, 425.0, 550.0, 6, 0.0, 3300.0, 3);
INSERT INTO "sales_detail" VALUES (593, 100, 800.0, 950.0, 2, 0.0, 1900.0, 2);
INSERT INTO "sales_detail" VALUES (595, 100, 90.0, 125.0, 1, 0.0, 125.0, 1);
INSERT INTO "sales_detail" VALUES (598, 100, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (599, 101, 75.0, 125.0, 5, 0.0, 625.0, 4);
INSERT INTO "sales_detail" VALUES (600, 101, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (601, 101, 800.0, 950.0, 2, 0.0, 1900.0, 2);
INSERT INTO "sales_detail" VALUES (602, 102, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (603, 102, 75.0, 125.0, 1, 0.0, 125.0, 5);
INSERT INTO "sales_detail" VALUES (605, 102, 35.0, 50.0, 5, 0.0, 250.0, 10);
INSERT INTO "sales_detail" VALUES (606, 103, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (607, 103, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (608, 103, 75.0, 125.0, 1, 0.0, 125.0, 4);
INSERT INTO "sales_detail" VALUES (610, 104, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (611, 104, 75.0, 125.0, 1, 0.0, 125.0, 5);
INSERT INTO "sales_detail" VALUES (612, 105, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (613, 105, 75.0, 125.0, 1, 0.0, 125.0, 4);
INSERT INTO "sales_detail" VALUES (614, 106, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (615, 106, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (616, 106, 90.0, 125.0, 1, 0.0, 125.0, 1);
INSERT INTO "sales_detail" VALUES (617, 108, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (618, 108, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (619, 108, 750.0, 1025.0, 1, 0.0, 1025.0, 8);
INSERT INTO "sales_detail" VALUES (620, 109, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (621, 110, 75.0, 125.0, 1, 0.0, 125.0, 4);
INSERT INTO "sales_detail" VALUES (622, 111, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (623, 111, 75.0, 125.0, 1, 0.0, 125.0, 4);
INSERT INTO "sales_detail" VALUES (624, 112, 90.0, 125.0, 1, 0.0, 125.0, 1);
INSERT INTO "sales_detail" VALUES (625, 113, 90.0, 125.0, 1, 0.0, 125.0, 1);
INSERT INTO "sales_detail" VALUES (626, 113, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (627, 76, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (629, 114, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (630, 114, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (631, 116, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (632, 117, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (633, 118, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (634, 119, 200.0, 285.0, 1, 0.0, 285.0, 6);
INSERT INTO "sales_detail" VALUES (635, 120, 75.0, 125.0, 1, 0.0, 125.0, 5);
INSERT INTO "sales_detail" VALUES (636, 121, 800.0, 950.0, 4, 0.0, 3800.0, 2);
INSERT INTO "sales_detail" VALUES (637, 121, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (638, 122, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (639, 122, 750.0, 1025.0, 1, 0.0, 1025.0, 8);
INSERT INTO "sales_detail" VALUES (640, 123, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (641, 123, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (642, 124, 75.0, 125.0, 1, 0.0, 125.0, 4);
INSERT INTO "sales_detail" VALUES (643, 124, 75.0, 125.0, 1, 0.0, 125.0, 5);
INSERT INTO "sales_detail" VALUES (644, 125, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (645, 126, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (646, 126, 750.0, 1025.0, 1, 0.0, 1025.0, 8);
INSERT INTO "sales_detail" VALUES (647, 128, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (648, 128, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (649, 128, 35.0, 50.0, 3, 0.0, 150.0, 10);
INSERT INTO "sales_detail" VALUES (650, 130, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (651, 130, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (652, 130, 35.0, 50.0, 3, 0.0, 150.0, 10);
INSERT INTO "sales_detail" VALUES (653, 131, 165.0, 205.0, 1, 0.0, 205.0, 7);
INSERT INTO "sales_detail" VALUES (654, 131, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (655, 131, 425.0, 550.0, 3, 0.0, 1650.0, 3);
INSERT INTO "sales_detail" VALUES (656, 132, 35.0, 50.0, 5, 0.0, 250.0, 10);
INSERT INTO "sales_detail" VALUES (657, 132, 165.0, 205.0, 1, 0.0, 205.0, 7);
INSERT INTO "sales_detail" VALUES (658, 134, 75.0, 125.0, 1, 0.0, 125.0, 4);
INSERT INTO "sales_detail" VALUES (660, 134, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (667, 135, 90.0, 125.0, 3, 0.0, 375.0, 1);
INSERT INTO "sales_detail" VALUES (669, 135, 425.0, 550.0, 1, 0.0, 550.0, 3);
INSERT INTO "sales_detail" VALUES (672, 135, 165.0, 205.0, 1, 0.0, 205.0, 7);
INSERT INTO "sales_detail" VALUES (673, 140, 425.0, 550.0, 1, 0.0, 550.0, 3);
INSERT INTO "sales_detail" VALUES (674, 141, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (675, 142, 750.0, 1025.0, 1, 0.0, 1025.0, 8);
INSERT INTO "sales_detail" VALUES (676, 142, 90.0, 125.0, 1, 0.0, 125.0, 1);
INSERT INTO "sales_detail" VALUES (678, 143, 165.0, 205.0, 1, 0.0, 205.0, 7);
INSERT INTO "sales_detail" VALUES (679, 143, 90.0, 125.0, 1, 0.0, 125.0, 1);
INSERT INTO "sales_detail" VALUES (680, 144, 800.0, 950.0, 1, 0.0, 950.0, 2);
INSERT INTO "sales_detail" VALUES (681, 144, 425.0, 550.0, 2, 0.0, 1100.0, 3);
INSERT INTO "sales_detail" VALUES (682, 145, 800.0, 950.0, 2, 0.0, 1900.0, 2);
INSERT INTO "sales_detail" VALUES (683, 145, 800.0, 950.0, 1, 0.0, 950.0, 2);


-- ----------------------------
-- Table structure for status
-- ----------------------------
DROP TABLE IF EXISTS "status";
CREATE TABLE "status" (
"id_status"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"status"  varchar(50)
)

;

-- ----------------------------
-- Records of status
-- ----------------------------

INSERT INTO "status" VALUES (1, 'ACTIVE');
INSERT INTO "status" VALUES (2, 'INACTIVE');
INSERT INTO "status" VALUES (3, 'PAID');


-- ----------------------------
-- Table structure for supplier
-- ----------------------------
DROP TABLE IF EXISTS "supplier";
CREATE TABLE "supplier" (
"id_supplier"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"supplier_name"  varchar(75),
"address"  varchar(150),
"telephone"  varchar(15),
"contact"  varchar(75),
"email"  varchar(50),
"website"  varchar(75)
)

;

-- ----------------------------
-- Records of supplier
-- ----------------------------

INSERT INTO "supplier" VALUES (3, 'TICONSULTING', 'Colonia Escalón #533, San Salvador', 23653265, 'CARLOS GUZMÁN', 'cguzman@ticonsulting.biz', 'www.ticonsulting.biz');


-- ----------------------------
-- Table structure for vdetailsales
-- ----------------------------
CREATE VIEW vdetailsales AS SELECT
	product_name AS name,
	sales_detail.unit_value AS unit_value,
	sales_detail.quantity AS quantity,
	sales_detail.id_sales AS id_sales
FROM
	(
		sales_detail
		JOIN product ON (
			sales_detail.id_product = product.id_product
		)
	);


-- ----------------------------
-- Indexes structure for table loss
-- ----------------------------
CREATE INDEX "fk_loss_cstate"
ON "loss" ("id_status" ASC);

-- ----------------------------
-- Indexes structure for table loss_detail
-- ----------------------------
CREATE INDEX "fk_loss_detail_loss"
ON "loss_detail" ("id_product" ASC);
CREATE INDEX "fk_loss_detail_loss1"
ON "loss_detail" ("id_loss" ASC);

-- ----------------------------
-- Indexes structure for table product
-- ----------------------------
CREATE INDEX "fk_product_cstate"
ON "product" ("id_status" ASC);
CREATE INDEX "id_category"
ON "product" ("id_category" ASC);
CREATE INDEX "ix_product"
ON "product" ("product_code" ASC);

-- ----------------------------
-- Indexes structure for table purchase
-- ----------------------------
CREATE INDEX "fk_entrada_cstate"
ON "purchase" ("id_status" ASC);
CREATE INDEX "id_supplier"
ON "purchase" ("id_supplier" ASC);

-- ----------------------------
-- Indexes structure for table purchase_detail
-- ----------------------------
CREATE INDEX "fk_detail_entrada_entrada"
ON "purchase_detail" ("id_purchase" ASC);
CREATE INDEX "fk_detail_entrada_product"
ON "purchase_detail" ("id_product" ASC);

-- ----------------------------
-- Indexes structure for table sales
-- ----------------------------
CREATE INDEX "sales_ibfk_1"
ON "sales" ("id_status" ASC);

-- ----------------------------
-- Indexes structure for table sales_detail
-- ----------------------------
CREATE INDEX "sales_detail_ibfk_1"
ON "sales_detail" ("id_sales" ASC);
CREATE INDEX "sales_detail_id_productfk_1"
ON "sales_detail" ("id_product" ASC);
