PRAGMA foreign_keys = false;

-- ----------------------------
-- Table structure for tbl_asset_sw_request
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_asset_sw_request";
CREATE TABLE "tbl_asset_sw_request" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_department" varchar(100),
  "fld_assetsw" varchar(100) NOT NULL,
  "fld_issue" varchar(100) NOT NULL,
  "fld_notes" text,
  "fld_datereq" date,
  "fld_datelimit" date
);

-- ----------------------------
-- Records of tbl_asset_sw_request
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_assets
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_assets";
CREATE TABLE "tbl_assets" (
  "fld_id" integer primary key autoincrement,
  "fld_descr" varchar(250) NOT NULL
);

-- ----------------------------
-- Records of tbl_assets
-- ----------------------------

INSERT INTO "tbl_assets" VALUES (1, 'Laptop'), (2, 'Desktop'), (3, 'Wireless Keyboard'), (4, 'Wireless Mouse'), (5, 'Software ABC'), (6, 'Software XYZ');


-- ----------------------------
-- Table structure for tbl_bugtracker
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_bugtracker";
CREATE TABLE "tbl_bugtracker" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_bug_title" varchar(100) NOT NULL,
  "fld_issue_descr" text NOT NULL,
  "fld_browser" varchar(20),
  "fld_assigned_to" integer,
  "fld_type" integer,
  "fld_priority" integer,
  "fld_screenshot" blob,
  "fld_status" integer,
  "fld_datetime" datetime
);

-- ----------------------------
-- Records of tbl_bugtracker
-- ----------------------------

INSERT INTO "tbl_bugtracker" VALUES (1, 'Jill', 'McRae', 'JillRMcRae@rhyta.com', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed turpis arcu, suscipit ut fringilla non, pellentesque eget diam. Phasellus ac ligula quis ligula ultrices blandit vel sit amet nisl. Pellentesque aliquam interdum quam, laoreet elementum justo hendrerit sed. Donec mauris libero, convallis quis velit nec, venenatis pharetra odio. Morbi metus eros, sodales sed enim et, consectetur consectetur nunc. Praesent eget mi bibendum, consequat velit quis, dapibus leo. Proin cursus, lorem vitae dictum rhoncus, ex elit molestie massa, ut suscipit sapien enim et odio. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.', 'Chrome', 2, 1, 1, '', 1, NULL), (2, 'Robert', 'J. Jose', 'RobertJJose@teleworm.us', 'Donec sit amet felis sit amet augue sollicitudin convallis.', 'Donec sit amet felis sit amet augue sollicitudin convallis. Suspendisse potenti. Sed rutrum nibh a ornare ultrices. Nullam eu magna ex. Donec vel vehicula nulla, et tincidunt nulla. Phasellus nec dignissim mauris, eu pharetra leo. Etiam nisi urna, congue ut efficitur quis, gravida sed tortor. Nulla ut nisi nunc. Quisque vel vehicula lacus, sit amet molestie magna. Pellentesque vel lacus id ante finibus ultricies.', 'Firefox', 2, 3, 1, '', 1, '2022-11-03T11:01:36'), (3, 'Andrew', 'Fuller', 'andrew@fuller.com', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'Opera', 4, 1, 1, '', 1, '2022-11-03 11:07:42');


-- ----------------------------
-- Table structure for tbl_candidate
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_candidate";
CREATE TABLE "tbl_candidate" (
  "fld_id" integer primary key autoincrement,
  "fld_name" varchar(250) NOT NULL,
  "fld_id_election" integer NOT NULL
);

-- ----------------------------
-- Records of tbl_candidate
-- ----------------------------

INSERT INTO "tbl_candidate" VALUES (1, 'Frank Sinatra', 1), (2, 'Elvis Presley', 1), (3, 'Amy Winehouse', 1);


-- ----------------------------
-- Table structure for tbl_car_rental
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_car_rental";
CREATE TABLE "tbl_car_rental" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100),
  "fld_email" varchar(100),
  "fld_phone" varchar(24),
  "fld_doctype" varchar(20),
  "fld_docnumber" varchar(20),
  "fld_birthdate" date,
  "fld_pickuplocal" integer,
  "fld_pickupdate" datetime,
  "fld_dropofflocal" integer,
  "fld_dropoffdate" datetime,
  "fld_cartype" integer,
  "fld_extras" varchar(200),
  "fld_notes" text
);

-- ----------------------------
-- Records of tbl_car_rental
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_clientdetails
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_clientdetails";
CREATE TABLE "tbl_clientdetails" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_gender" varchar(2),
  "fld_birthdate" date NOT NULL,
  "fld_address1" varchar(100),
  "fld_address2" varchar(100),
  "fld_city" varchar(100),
  "fld_state" varchar(2),
  "fld_postalcode" varchar(10),
  "fld_country" varchar(2),
  "fld_email" varchar(100),
  "fld_phone" varchar(24),
  "fld_phone2" varchar(24),
  "fld_phone3" varchar(24),
  "fld_doctype" varchar(20),
  "fld_docnumber" varchar(20),
  "fld_creditlimit" numeric(16,2),
  "fld_cardtype" varchar(1),
  "fld_cardnumber" varchar(20),
  "fld_notes" text,
  "fld_company" varchar(100),
  "fld_department" varchar(100),
  "fld_title" varchar(100),
  "fld_workingtime" varchar(100)
);

-- ----------------------------
-- Records of tbl_clientdetails
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_complaints
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_complaints";
CREATE TABLE "tbl_complaints" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_phone" varchar(24),
  "fld_notes" text
);

-- ----------------------------
-- Records of tbl_complaints
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_contactus
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_contactus";
CREATE TABLE "tbl_contactus" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_notes" text NOT NULL
);

-- ----------------------------
-- Records of tbl_contactus
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_course
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_course";
CREATE TABLE "tbl_course" (
  "fld_id" integer primary key autoincrement,
  "fld_name" varchar(250) NOT NULL,
  "fld_descr" text NOT NULL
);

-- ----------------------------
-- Records of tbl_course
-- ----------------------------

INSERT INTO "tbl_course" VALUES (1, 'Advanced PHP Course', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.'), (2, 'Fundamentals of Scriptcase', 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.');


-- ----------------------------
-- Table structure for tbl_course_evaluation
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_course_evaluation";
CREATE TABLE "tbl_course_evaluation" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_course" integer NOT NULL,
  "fld_instructor" varchar(100) NOT NULL,
  "fld_rateinstrnmethods" integer NOT NULL,
  "fld_rateinstrattitude" integer NOT NULL,
  "fld_rateusefulness" integer NOT NULL,
  "fld_notes" text
);

-- ----------------------------
-- Records of tbl_course_evaluation
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_course_subscription
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_course_subscription";
CREATE TABLE "tbl_course_subscription" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_birthdate" date NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_phone" varchar(24) NOT NULL,
  "fld_address1" varchar(100),
  "fld_address2" varchar(100),
  "fld_city" varchar(100),
  "fld_state" varchar(2),
  "fld_postalcode" varchar(10),
  "fld_country" varchar(2),
  "fld_education" varchar(100),
  "fld_course_id" integer NOT NULL
);

-- ----------------------------
-- Records of tbl_course_subscription
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_delivery_feedback
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_delivery_feedback";
CREATE TABLE "tbl_delivery_feedback" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100),
  "fld_email" varchar(100) NOT NULL,
  "fld_address1" varchar(100),
  "fld_address2" varchar(100),
  "fld_city" varchar(100),
  "fld_state" varchar(2),
  "fld_postalcode" varchar(10),
  "fld_country" varchar(2),
  "fld_establishment" integer,
  "fld_deliv_service" integer,
  "fld_deliv_sys" integer
);

-- ----------------------------
-- Records of tbl_delivery_feedback
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_doctor
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_doctor";
CREATE TABLE "tbl_doctor" (
  "fld_id" integer primary key autoincrement,
  "fld_name" varchar(250) NOT NULL
);

-- ----------------------------
-- Records of tbl_doctor
-- ----------------------------

INSERT INTO "tbl_doctor" VALUES (1, 'Gina Rodriquez'), (2, 'Becka Wenona'), (3, 'Arlen Tristan'), (4, 'Tommy Rickey');


-- ----------------------------
-- Table structure for tbl_donation
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_donation";
CREATE TABLE "tbl_donation" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_howmuch" decimal(16,2) NOT NULL,
  "fld_howtodonate" integer NOT NULL
);

-- ----------------------------
-- Records of tbl_donation
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_election
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_election";
CREATE TABLE "tbl_election" (
  "fld_id" integer primary key autoincrement,
  "fld_name" varchar(250) NOT NULL,
  "fld_date_start" datetime NOT NULL,
  "fld_date_end" datetime NOT NULL,
  "fld_max_candidates" integer NOT NULL,
  "fld_max_winners" integer NOT NULL
);

-- ----------------------------
-- Records of tbl_election
-- ----------------------------

INSERT INTO "tbl_election" VALUES (1, 'Best Singer Ever', '2022-11-01 00:00:00', '2027-10-31 00:00:00', 5, 1);


-- ----------------------------
-- Table structure for tbl_evaluation
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_evaluation";
CREATE TABLE "tbl_evaluation" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_more1year" integer,
  "fld_rating" integer,
  "fld_alternative" varchar(1)
);

-- ----------------------------
-- Records of tbl_evaluation
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_feedback
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_feedback";
CREATE TABLE "tbl_feedback" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100),
  "fld_email" varchar(100),
  "fld_rating" integer NOT NULL,
  "fld_notes" text,
  "fld_usemytestimonial" varchar(1)
);

-- ----------------------------
-- Records of tbl_feedback
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_freetrial
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_freetrial";
CREATE TABLE "tbl_freetrial" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100),
  "fld_email" varchar(100) NOT NULL,
  "fld_company" varchar(100)
);

-- ----------------------------
-- Records of tbl_freetrial
-- ----------------------------

INSERT INTO "tbl_freetrial" VALUES (1, 'Vitor', 'Jamil', 'vitor@xxx.com', 'selfemployed');


-- ----------------------------
-- Table structure for tbl_getebook
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_getebook";
CREATE TABLE "tbl_getebook" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100),
  "fld_email" varchar(100) NOT NULL,
  "fld_company" varchar(100),
  "fld_title" varchar(100)
);

-- ----------------------------
-- Records of tbl_getebook
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_homeservices
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_homeservices";
CREATE TABLE "tbl_homeservices" (
  "fld_id" integer primary key autoincrement,
  "fld_descr" varchar(100) NOT NULL,
  "fld_price" numeric NOT NULL
);

-- ----------------------------
-- Records of tbl_homeservices
-- ----------------------------

INSERT INTO "tbl_homeservices" VALUES (1, 'Electrician', 22.68), (2, 'Pest control', 20.99), (3, 'Deep cleaning and desinfection', 25.0), (4, 'Cleaning and maintenance', 25.0), (5, 'Painting', 25.0), (6, 'Salon', 25.0), (7, 'Carpentry', 25.0), (8, 'AC repair', 25.0), (9, 'Appliance repair', 25.0), (10, 'Plumbing', 25.0), (11, 'Car repair', 25.0);


-- ----------------------------
-- Table structure for tbl_inquiries
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_inquiries";
CREATE TABLE "tbl_inquiries" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_address1" varchar(100) NOT NULL,
  "fld_address2" varchar(100),
  "fld_city" varchar(100) NOT NULL,
  "fld_state" varchar(2) NOT NULL,
  "fld_postalcode" varchar(100) NOT NULL,
  "fld_country" varchar(2) NOT NULL,
  "fld_progress" integer NOT NULL,
  "fld_morematerials" varchar(1) NOT NULL,
  "fld_materials" varchar(100),
  "fld_notes" text NOT NULL
);

-- ----------------------------
-- Records of tbl_inquiries
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_issue
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_issue";
CREATE TABLE "tbl_issue" (
  "fld_id" integer primary key autoincrement,
  "fld_descr" varchar(250) NOT NULL
);

-- ----------------------------
-- Records of tbl_issue
-- ----------------------------

INSERT INTO "tbl_issue" VALUES (1, 'New asset request'), (2, 'Replacement for broken/faulty device'), (3, 'Replacement for lost device'), (4, 'Other reason');


-- ----------------------------
-- Table structure for tbl_meal_crust
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_meal_crust";
CREATE TABLE "tbl_meal_crust" (
  "fld_id" integer primary key autoincrement,
  "fld_descr" varchar(100) NOT NULL,
  "fld_price" decimal(16,2) NOT NULL
);

-- ----------------------------
-- Records of tbl_meal_crust
-- ----------------------------

INSERT INTO "tbl_meal_crust" VALUES (1, 'thin', 0.0), (2, 'Thick', 0.99), (3, 'Cheese', 2.99);


-- ----------------------------
-- Table structure for tbl_meal_order
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_meal_order";
CREATE TABLE "tbl_meal_order" (
  "fld_id" integer primary key autoincrement,
  "fld_sel_menu" integer NOT NULL,
  "fld_crust" integer,
  "fld_topping" integer NOT NULL,
  "fld_sauce" integer,
  "fld_qty" integer
);

-- ----------------------------
-- Records of tbl_meal_order
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_meal_sauce
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_meal_sauce";
CREATE TABLE "tbl_meal_sauce" (
  "fld_id" integer primary key autoincrement,
  "fld_descr" varchar(100) NOT NULL,
  "fld_price" decimal(16,2) NOT NULL
);

-- ----------------------------
-- Records of tbl_meal_sauce
-- ----------------------------

INSERT INTO "tbl_meal_sauce" VALUES (1, 'Tomato sauce', 1.99), (2, 'Mustard', 3.99), (3, 'Hot sauce', 2.99);


-- ----------------------------
-- Table structure for tbl_meal_sel_menu
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_meal_sel_menu";
CREATE TABLE "tbl_meal_sel_menu" (
  "fld_id" integer primary key autoincrement,
  "fld_descr" varchar(100) NOT NULL,
  "fld_price" decimal(16,2) NOT NULL
);

-- ----------------------------
-- Records of tbl_meal_sel_menu
-- ----------------------------

INSERT INTO "tbl_meal_sel_menu" VALUES (1, 'Margherita', 22.68), (2, 'Muzzarela', 20.99), (3, 'Veggie', 25.0), (4, 'Pepperoni', 25.0);


-- ----------------------------
-- Table structure for tbl_meal_topping
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_meal_topping";
CREATE TABLE "tbl_meal_topping" (
  "fld_id" integer primary key autoincrement,
  "fld_descr" varchar(100) NOT NULL,
  "fld_price" decimal(16,2) NOT NULL
);

-- ----------------------------
-- Records of tbl_meal_topping
-- ----------------------------

INSERT INTO "tbl_meal_topping" VALUES (1, 'Extra cheese', 1.99), (2, 'Pepperoni', 3.99), (3, 'Mushrooms', 2.99);


-- ----------------------------
-- Table structure for tbl_newsletter
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_newsletter";
CREATE TABLE "tbl_newsletter" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_categories" varchar(100) NOT NULL
);

-- ----------------------------
-- Records of tbl_newsletter
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_nurse
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_nurse";
CREATE TABLE "tbl_nurse" (
  "fld_id" integer primary key autoincrement,
  "fld_name" varchar(250) NOT NULL
);

-- ----------------------------
-- Records of tbl_nurse
-- ----------------------------

INSERT INTO "tbl_nurse" VALUES (1, 'Charles F. Hill'), (2, 'David S. Helms'), (3, 'Amanda B. Bain'), (4, 'Kimberly G. Gonzalez');


-- ----------------------------
-- Table structure for tbl_order_items
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_order_items";
CREATE TABLE "tbl_order_items" (
  "fld_id" integer primary key autoincrement,
  "fld_product_id" integer NOT NULL,
  "fld_size" varchar(1) NOT NULL,
  "fld_qty" integer NOT NULL,
  "fld_unit_price" decimal(16,2) NOT NULL,
  "fld_total_price" decimal(16,2) NOT NULL
);

-- ----------------------------
-- Records of tbl_order_items
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_party
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_party";
CREATE TABLE "tbl_party" (
  "fld_id" integer primary key autoincrement,
  "fld_title" varchar(150) NOT NULL,
  "fld_when" datetime NOT NULL,
  "fld_local" varchar(150) NOT NULL,
  "fld_message" text NOT NULL
);

-- ----------------------------
-- Records of tbl_party
-- ----------------------------

INSERT INTO "tbl_party" VALUES (1, 'Chloe Birthday', '2023-06-01T18:00:00', '415 Sinclair St.', '<p style="text-align: center;"><span class="font" style="font-family: serif,times new roman;"><span class="size" style="font-size: 18px;"> <strong>You''re invited! <br />Join us to celebrate this date.</strong></span></span></p>');


-- ----------------------------
-- Table structure for tbl_party_invitation
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_party_invitation";
CREATE TABLE "tbl_party_invitation" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_joinus" varchar(1) NOT NULL,
  "fld_mealpref" varchar(100) NOT NULL,
  "fld_guests" integer NOT NULL,
  "fld_guestsmealpref" varchar(100)
);

-- ----------------------------
-- Records of tbl_party_invitation
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_patient
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_patient";
CREATE TABLE "tbl_patient" (
  "fld_id" integer primary key autoincrement,
  "fld_name" varchar(250) NOT NULL
);

-- ----------------------------
-- Records of tbl_patient
-- ----------------------------

INSERT INTO "tbl_patient" VALUES (1, 'Michele J. Sabo'), (2, 'Kendra P. Wallace'), (3, 'Ann D. Lawson');


-- ----------------------------
-- Table structure for tbl_patient_admission
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_patient_admission";
CREATE TABLE "tbl_patient_admission" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_gender" varchar(2),
  "fld_birthdate" date NOT NULL,
  "fld_weight" integer NOT NULL,
  "fld_height" integer NOT NULL,
  "fld_body_temp" integer NOT NULL,
  "fld_healthissues" text,
  "fld_email" varchar(100),
  "fld_phone" varchar(24),
  "fld_doctype" varchar(20),
  "fld_docnumber" varchar(20),
  "fld_address1" varchar(100),
  "fld_address2" varchar(100),
  "fld_city" varchar(100),
  "fld_state" varchar(2),
  "fld_postalcode" varchar(10),
  "fld_country" varchar(2)
);

-- ----------------------------
-- Records of tbl_patient_admission
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_patient_tracking
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_patient_tracking";
CREATE TABLE "tbl_patient_tracking" (
  "fld_id" integer primary key autoincrement,
  "fld_id_patient" integer NOT NULL,
  "fld_id_nurse" integer NOT NULL,
  "fld_id_doctor" integer NOT NULL,
  "fld_date" datetime NOT NULL,
  "fld_complaints" text,
  "fld_medications" text
);

-- ----------------------------
-- Records of tbl_patient_tracking
-- ----------------------------


-- ----------------------------
-- Table structure for tbl_product_order
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_product_order";
CREATE TABLE "tbl_product_order" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100),
  "fld_email" varchar(100) NOT NULL,
  "fld_address1" varchar(100) NOT NULL,
  "fld_address2" varchar(100),
  "fld_city" varchar(100),
  "fld_state" varchar(2),
  "fld_postalcode" varchar(2),
  "fld_country" varchar(2),
  "fld_notes" text
);

-- ----------------------------
-- Records of tbl_product_order
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_products
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_products";
CREATE TABLE "tbl_products" (
  "fld_id" integer primary key autoincrement,
  "fld_descr" varchar(100) NOT NULL,
  "fld_price" decimal(16,2) NOT NULL,
  "fld_img" blob
);

-- ----------------------------
-- Records of tbl_products
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_resignation
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_resignation";
CREATE TABLE "tbl_resignation" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100),
  "fld_when" date NOT NULL,
  "fld_rating" integer,
  "fld_notes" text,
  "fld_signature" blob
);

-- ----------------------------
-- Records of tbl_resignation
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_room_reservation
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_room_reservation";
CREATE TABLE "tbl_room_reservation" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_phone" varchar(24) NOT NULL,
  "fld_doctype" varchar(20) NOT NULL,
  "fld_docnumber" varchar(20) NOT NULL,
  "fld_address1" varchar(100),
  "fld_address2" varchar(100),
  "fld_city" varchar(100),
  "fld_state" varchar(2),
  "fld_postalcode" varchar(10),
  "fld_country" varchar(2),
  "fld_checkindate" datetime NOT NULL,
  "fld_checkoutdate" datetime NOT NULL,
  "fld_guests" integer NOT NULL,
  "fld_adults" integer NOT NULL,
  "fld_children" integer NOT NULL,
  "fld_pets" integer NOT NULL,
  "fld_chaffeur" integer NOT NULL,
  "fld_airporttrans" integer NOT NULL,
  "fld_breakfastbed" integer NOT NULL
);

-- ----------------------------
-- Records of tbl_room_reservation
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_satisfaction
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_satisfaction";
CREATE TABLE "tbl_satisfaction" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100),
  "fld_ratesupervisor" integer NOT NULL,
  "fld_ratehr" integer NOT NULL,
  "fld_rateteam" integer NOT NULL,
  "fld_notes" text
);

-- ----------------------------
-- Records of tbl_satisfaction
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_service_order
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_service_order";
CREATE TABLE "tbl_service_order" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_address1" varchar(100) NOT NULL,
  "fld_address2" varchar(100),
  "fld_city" varchar(100),
  "fld_state" varchar(2),
  "fld_postalcode" varchar(10),
  "fld_country" varchar(2),
  "fld_homeservices" varchar(50) NOT NULL,
  "fld_notes" text NOT NULL,
  "fld_datereq" date,
  "fld_datelimit" date
);

-- ----------------------------
-- Records of tbl_service_order
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_shows
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_shows";
CREATE TABLE "tbl_shows" (
  "fld_id" integer primary key autoincrement,
  "fld_title" varchar(250) NOT NULL,
  "fld_descr" text NOT NULL,
  "fld_banner" blob
);

-- ----------------------------
-- Records of tbl_shows
-- ----------------------------

INSERT INTO "tbl_shows" VALUES (1, 'Jazz Festival', 'The Jazz Festival is, above all, an initiative born in 2012 by lovers of good music.', NULL), (2, 'Rock in Rio', 'THE LARGEST MUSIC AND ENTERTAINMENT FESTIVAL IN THE WORLD.', NULL);


-- ----------------------------
-- Table structure for tbl_shows_datetime
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_shows_datetime";
CREATE TABLE "tbl_shows_datetime" (
  "fld_id" integer primary key autoincrement,
  "fld_show_id" integer NOT NULL,
  "fld_datetime" datetime NOT NULL,
  "fld_tickets_qty" integer NOT NULL,
  "fld_tickets_sold" integer NOT NULL
);

-- ----------------------------
-- Records of tbl_shows_datetime
-- ----------------------------

INSERT INTO "tbl_shows_datetime" VALUES (1, 1, '2022-11-30 19:00:00', 1000, 0), (2, 1, '2022-12-01 19:00:00', 1000, 0), (3, 2, '2022-12-15 14:00:00', 50000, 0), (4, 2, '2022-12-16 14:00:00', 50000, 0), (5, 2, '2022-12-17 14:00:00', 50000, 0);


-- ----------------------------
-- Table structure for tbl_technician
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_technician";
CREATE TABLE "tbl_technician" (
  "fld_id" integer primary key autoincrement,
  "fld_name" varchar(250) NOT NULL
);

-- ----------------------------
-- Records of tbl_technician
-- ----------------------------

INSERT INTO "tbl_technician" VALUES (1, 'Charles L. Via'), (2, 'Adam K. Belcher'), (3, 'James R. Tiano'), (4, 'Georgia J. Snyder');


-- ----------------------------
-- Table structure for tbl_testimonials
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_testimonials";
CREATE TABLE "tbl_testimonials" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_notes" text NOT NULL
);

-- ----------------------------
-- Records of tbl_testimonials
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_thanksgiving
-- ----------------------------
-- DROP TABLE IF EXISTS "tbl_thanksgiving";
CREATE TABLE "tbl_thanksgiving" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100),
  "fld_email" varchar(100),
  "fld_phone" varchar(100),
  "fld_guests" integer,
  "fld_date" datetime NOT NULL
);

-- ----------------------------
-- Records of tbl_thanksgiving
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_ticket_booking
-- ----------------------------
CREATE TABLE "tbl_ticket_booking" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100),
  "fld_email" varchar(100) NOT NULL,
  "fld_phone" varchar(24),
  "fld_qty_tickets" integer NOT NULL,
  "fld_show_id" integer NOT NULL,
  "fld_show_dttime_id" integer NOT NULL
);

-- ----------------------------
-- Records of tbl_ticket_booking
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_volunteers
-- ----------------------------
CREATE TABLE "tbl_volunteers" (
  "fld_id" integer primary key autoincrement,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100),
  "fld_phone" varchar(24) NOT NULL,
  "fld_address1" varchar(100),
  "fld_address2" varchar(100),
  "fld_city" varchar(100),
  "fld_state" varchar(2),
  "fld_postalcode" varchar(10),
  "fld_country" varchar(2),
  "fld_howtocontribute" varchar(1) NOT NULL,
  "fld_items" text,
  "fld_weekdays" varchar(100),
  "fld_notes" text
);

-- ----------------------------
-- Records of tbl_volunteers
-- ----------------------------



-- ----------------------------
-- Table structure for tbl_votes
-- ----------------------------
CREATE TABLE "tbl_votes" (
  "fld_id" integer primary key autoincrement,
  "fld_id_election" integer NOT NULL,
  "fld_firstname" varchar(100) NOT NULL,
  "fld_lastname" varchar(100) NOT NULL,
  "fld_email" varchar(100) NOT NULL,
  "fld_id_candidate" integer NOT NULL,
  "fld_date" datetime
);