PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for "main"."news_categorias"
-- ----------------------------

CREATE TABLE news_categorias (
  categoria_id INTEGER PRIMARY KEY AUTOINCREMENT,
  categoria_nome varchar(50) DEFAULT NULL,
  categoris_descricao varchar(255) DEFAULT NULL,
  categoria_editor varchar(10) DEFAULT NULL
);

-- ----------------------------
-- Records of news_categorias
-- ----------------------------
INSERT INTO "news_categorias" VALUES (1, 'Sports', 'Sports related news, baseball , basketball, golf amd more', 'editor');
INSERT INTO "news_categorias" VALUES (2, 'Police reports', 'Criminal facts around the country, most comons crimes and more', 'editor');
INSERT INTO "news_categorias" VALUES (3, 'Politics', 'Politics related news, the most important elections facts, politicals analysis', 'editor');
INSERT INTO "news_categorias" VALUES (4, 'Fun', 'Your online guide for having fun in the bigest USA cities, plays , movies, shows, what is hapening in your town', 'editor');

-- ----------------------------
-- Table structure for "main"."news_config_sistema"
-- ----------------------------

CREATE TABLE news_config_sistema (
  news_config_chave_atualizacao INTEGER NOT NULL,
  news_config_pub_req_aut_editor char(1) DEFAULT NULL,
  news_config_noticia_dias_no_ar INTEGER DEFAULT NULL,
  PRIMARY KEY (news_config_chave_atualizacao)
);

-- ----------------------------
-- Records of news_config_sistema
-- ----------------------------
INSERT INTO "news_config_sistema" VALUES (1, 'S', 7);

-- ----------------------------
-- Table structure for "main"."news_noticias"
-- ----------------------------

CREATE TABLE "news_noticias" (
"noticia_id"  INTEGER NOT NULL,
"categoria_id"  INTEGER NOT NULL,
"reporter_id"  varchar(10) NOT NULL DEFAULT '',
"noticia_data_noticia"  datetime DEFAULT NULL,
"noticia_hora_noticia"  time DEFAULT NULL,
"noticia_data_pub"  datetime DEFAULT NULL,
"noticia_hora_pub"  time DEFAULT NULL,
"noticia_titulo"  varchar(255) DEFAULT NULL,
"noticia_corpo"  text,
"noticia_img"  blob,
"noticia_flag_man_editorial"  char(1) DEFAULT NULL,
PRIMARY KEY ("noticia_id" ASC),
CONSTRAINT "news_noticias_ibfk_2" FOREIGN KEY ("reporter_id") REFERENCES "news_usuario" ("usuario_login"),
CONSTRAINT "news_noticias_ibfk_1" FOREIGN KEY ("categoria_id") REFERENCES "news_categorias" ("categoria_id")
);

-- ----------------------------
-- Table structure for "main"."news_usuario"
-- ----------------------------

CREATE TABLE news_usuario (
  usuario_login varchar(10) NOT NULL,
  usuario_nome varchar(50) NOT NULL DEFAULT '',
  usuario_senha varchar(10) NOT NULL DEFAULT '',
  usuario_perfil varchar(10) NOT NULL DEFAULT '',
  usuario_email varchar(100) DEFAULT NULL,
  PRIMARY KEY (usuario_login)
);

-- ----------------------------
-- Records of news_usuario
-- ----------------------------
INSERT INTO "news_usuario" VALUES ('editor', 'News editor', '123456', 'editor', 'wiliam@bonner.com');
INSERT INTO "news_usuario" VALUES ('reporter', 'John Albert', '123456', 'reporter', 'francisco@jose.com.br');
INSERT INTO "news_usuario" VALUES ('somebody', 'John Doe', '123456', 'user', '');

-- ----------------------------
-- Table structure for "main"."news_usuarios_categorias"
-- ----------------------------

CREATE TABLE news_usuarios_categorias (
  usuario_login varchar(10) NOT NULL,
  categoria_id INTEGER NOT NULL,
  PRIMARY KEY (usuario_login,categoria_id),
  CONSTRAINT news_usuarios_categorias_ibfk_2 FOREIGN KEY (categoria_id) REFERENCES news_categorias (categoria_id),
  CONSTRAINT news_usuarios_categorias_ibfk_1 FOREIGN KEY (usuario_login) REFERENCES news_usuario (usuario_login)
);

-- ----------------------------
-- Records of news_usuarios_categorias
-- ----------------------------
INSERT INTO "news_usuarios_categorias" VALUES ('editor', 1);
INSERT INTO "news_usuarios_categorias" VALUES ('reporter', 1);
INSERT INTO "news_usuarios_categorias" VALUES ('editor', 2);
INSERT INTO "news_usuarios_categorias" VALUES ('reporter', 2);
INSERT INTO "news_usuarios_categorias" VALUES ('editor', 3);
INSERT INTO "news_usuarios_categorias" VALUES ('reporter', 3);
INSERT INTO "news_usuarios_categorias" VALUES ('editor', 4);
INSERT INTO "news_usuarios_categorias" VALUES ('reporter', 4);


